/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client.arrow;

import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.spark.sql.connect.client.arrow.ArrowVectorReader;
import org.apache.spark.sql.connect.client.arrow.BigIntVectorReader;
import org.apache.spark.sql.connect.client.arrow.BitVectorReader;
import org.apache.spark.sql.connect.client.arrow.DateDayVectorReader;
import org.apache.spark.sql.connect.client.arrow.DecimalVectorReader;
import org.apache.spark.sql.connect.client.arrow.DurationVectorReader;
import org.apache.spark.sql.connect.client.arrow.Float4VectorReader;
import org.apache.spark.sql.connect.client.arrow.Float8VectorReader;
import org.apache.spark.sql.connect.client.arrow.IntVectorReader;
import org.apache.spark.sql.connect.client.arrow.IntervalYearVectorReader;
import org.apache.spark.sql.connect.client.arrow.NullVectorReader$;
import org.apache.spark.sql.connect.client.arrow.SmallIntVectorReader;
import org.apache.spark.sql.connect.client.arrow.TimeStampMicroTZVectorReader;
import org.apache.spark.sql.connect.client.arrow.TimeStampMicroVectorReader;
import org.apache.spark.sql.connect.client.arrow.TinyIntVectorReader;
import org.apache.spark.sql.connect.client.arrow.VarBinaryVectorReader;
import org.apache.spark.sql.connect.client.arrow.VarCharVectorReader;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.UpCastRule$;
import org.apache.spark.sql.util.ArrowUtils$;

public final class ArrowVectorReader$ {
    public static ArrowVectorReader$ MODULE$;

    static {
        new ArrowVectorReader$();
    }

    public ArrowVectorReader apply(DataType targetDataType, FieldVector vector, String timeZoneId) {
        ArrowVectorReader arrowVectorReader;
        DataType vectorDataType = ArrowUtils$.MODULE$.fromArrowType(vector.getField().getType());
        if (!UpCastRule$.MODULE$.canUpCast(vectorDataType, targetDataType)) {
            throw new RuntimeException(new StringBuilder(52).append("Reading '").append(targetDataType).append("' values from a ").append(vector.getClass()).append(" instance is not supported.").toString());
        }
        FieldVector fieldVector = vector;
        if (fieldVector instanceof BitVector) {
            BitVector bitVector = (BitVector)fieldVector;
            arrowVectorReader = new BitVectorReader(bitVector);
        } else if (fieldVector instanceof TinyIntVector) {
            TinyIntVector tinyIntVector = (TinyIntVector)fieldVector;
            arrowVectorReader = new TinyIntVectorReader(tinyIntVector);
        } else if (fieldVector instanceof SmallIntVector) {
            SmallIntVector smallIntVector = (SmallIntVector)fieldVector;
            arrowVectorReader = new SmallIntVectorReader(smallIntVector);
        } else if (fieldVector instanceof IntVector) {
            IntVector intVector = (IntVector)fieldVector;
            arrowVectorReader = new IntVectorReader(intVector);
        } else if (fieldVector instanceof BigIntVector) {
            BigIntVector bigIntVector = (BigIntVector)fieldVector;
            arrowVectorReader = new BigIntVectorReader(bigIntVector);
        } else if (fieldVector instanceof Float4Vector) {
            Float4Vector float4Vector = (Float4Vector)fieldVector;
            arrowVectorReader = new Float4VectorReader(float4Vector);
        } else if (fieldVector instanceof Float8Vector) {
            Float8Vector float8Vector = (Float8Vector)fieldVector;
            arrowVectorReader = new Float8VectorReader(float8Vector);
        } else if (fieldVector instanceof DecimalVector) {
            DecimalVector decimalVector = (DecimalVector)fieldVector;
            arrowVectorReader = new DecimalVectorReader(decimalVector);
        } else if (fieldVector instanceof VarCharVector) {
            VarCharVector varCharVector = (VarCharVector)fieldVector;
            arrowVectorReader = new VarCharVectorReader(varCharVector);
        } else if (fieldVector instanceof VarBinaryVector) {
            VarBinaryVector varBinaryVector = (VarBinaryVector)fieldVector;
            arrowVectorReader = new VarBinaryVectorReader(varBinaryVector);
        } else if (fieldVector instanceof DurationVector) {
            DurationVector durationVector = (DurationVector)fieldVector;
            arrowVectorReader = new DurationVectorReader(durationVector);
        } else if (fieldVector instanceof IntervalYearVector) {
            IntervalYearVector intervalYearVector = (IntervalYearVector)fieldVector;
            arrowVectorReader = new IntervalYearVectorReader(intervalYearVector);
        } else if (fieldVector instanceof DateDayVector) {
            DateDayVector dateDayVector = (DateDayVector)fieldVector;
            arrowVectorReader = new DateDayVectorReader(dateDayVector, timeZoneId);
        } else if (fieldVector instanceof TimeStampMicroTZVector) {
            TimeStampMicroTZVector timeStampMicroTZVector = (TimeStampMicroTZVector)fieldVector;
            arrowVectorReader = new TimeStampMicroTZVectorReader(timeStampMicroTZVector);
        } else if (fieldVector instanceof TimeStampMicroVector) {
            TimeStampMicroVector timeStampMicroVector = (TimeStampMicroVector)fieldVector;
            arrowVectorReader = new TimeStampMicroVectorReader(timeStampMicroVector, timeZoneId);
        } else if (fieldVector instanceof NullVector) {
            arrowVectorReader = NullVectorReader$.MODULE$;
        } else {
            throw new RuntimeException(new StringBuilder(25).append("Unsupported Vector Type: ").append(vector.getClass()).toString());
        }
        return arrowVectorReader;
    }

    private ArrowVectorReader$() {
        MODULE$ = this;
    }
}

