/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client.arrow;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoder;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.connect.client.CloseableIterator;
import org.apache.spark.sql.connect.client.arrow.AbstractMessageIterator;
import org.apache.spark.sql.connect.client.arrow.ArrowDeserializers;
import org.apache.spark.sql.connect.client.arrow.ArrowDeserializingIterator;
import org.apache.spark.sql.connect.client.arrow.ArrowEncoderUtils$;
import org.apache.spark.sql.connect.client.arrow.ArrowEncoderUtils$Classes$;
import org.apache.spark.sql.connect.client.arrow.ConcatenatingArrowStreamReader;
import org.apache.spark.sql.connect.client.arrow.EmptyDeserializingIterator;
import org.apache.spark.sql.connect.client.arrow.MessageIterator;
import org.apache.spark.sql.connect.client.arrow.ScalaCollectionUtils$;
import org.apache.spark.sql.connect.client.arrow.StructVectors$;
import org.apache.spark.sql.errors.CompilationErrors$;
import org.apache.spark.sql.errors.ExecutionErrors$;
import org.apache.spark.sql.types.Decimal;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenMapFactory;
import scala.collection.generic.GenericCompanion;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.collection.mutable.WrappedArray;
import scala.math.BigInt;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Symbols;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class ArrowDeserializers$ {
    public static ArrowDeserializers$ MODULE$;
    private final MethodHandles.Lookup methodLookup;

    static {
        new ArrowDeserializers$();
    }

    public <T> CloseableIterator<T> deserializeFromArrow(Iterator<byte[]> input, AgnosticEncoder<T> encoder, BufferAllocator allocator, String timeZoneId) {
        CloseableIterator<T> closeableIterator;
        try {
            ConcatenatingArrowStreamReader reader = new ConcatenatingArrowStreamReader(allocator, (Iterator<AbstractMessageIterator>)input.map((Function1 & Serializable & scala.Serializable)bytes -> new MessageIterator(new ByteArrayInputStream((byte[])bytes), allocator)), true);
            closeableIterator = new ArrowDeserializingIterator<T>(encoder, reader, timeZoneId);
        }
        catch (IOException iOException) {
            closeableIterator = new EmptyDeserializingIterator<T>(encoder);
        }
        return closeableIterator;
    }

    public <T> ArrowDeserializers.Deserializer<T> deserializerFor(AgnosticEncoder<T> encoder, VectorSchemaRoot root, String timeZoneId) {
        VectorSchemaRoot data = encoder.isStruct() ? root : root.getVector(0);
        return this.deserializerFor(encoder, (Object)data, timeZoneId);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public ArrowDeserializers.Deserializer<Object> deserializerFor(AgnosticEncoder<?> encoder, Object data, String timeZoneId) {
        AgnosticEncoder agnosticEncoder;
        void var4_40;
        Tuple2 tuple2 = new Tuple2(encoder, data);
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder2 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            boolean bl = AgnosticEncoders.PrimitiveBooleanEncoder$.MODULE$.equals(agnosticEncoder2) ? true : AgnosticEncoders.BoxedBooleanEncoder$.MODULE$.equals(agnosticEncoder2);
            if (bl && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<Object> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<Object>(encoder, fieldVector, timeZoneId){

                    public boolean value(int i) {
                        return this.reader().getBoolean(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder3 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            boolean bl = AgnosticEncoders.PrimitiveByteEncoder$.MODULE$.equals(agnosticEncoder3) ? true : AgnosticEncoders.BoxedByteEncoder$.MODULE$.equals(agnosticEncoder3);
            if (bl && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<Object> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<Object>(encoder, fieldVector, timeZoneId){

                    public byte value(int i) {
                        return this.reader().getByte(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder4 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            boolean bl = AgnosticEncoders.PrimitiveShortEncoder$.MODULE$.equals(agnosticEncoder4) ? true : AgnosticEncoders.BoxedShortEncoder$.MODULE$.equals(agnosticEncoder4);
            if (bl && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<Object> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<Object>(encoder, fieldVector, timeZoneId){

                    public short value(int i) {
                        return this.reader().getShort(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder5 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            boolean bl = AgnosticEncoders.PrimitiveIntEncoder$.MODULE$.equals(agnosticEncoder5) ? true : AgnosticEncoders.BoxedIntEncoder$.MODULE$.equals(agnosticEncoder5);
            if (bl && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<Object> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<Object>(encoder, fieldVector, timeZoneId){

                    public int value(int i) {
                        return this.reader().getInt(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder6 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            boolean bl = AgnosticEncoders.PrimitiveLongEncoder$.MODULE$.equals(agnosticEncoder6) ? true : AgnosticEncoders.BoxedLongEncoder$.MODULE$.equals(agnosticEncoder6);
            if (bl && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<Object> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<Object>(encoder, fieldVector, timeZoneId){

                    public long value(int i) {
                        return this.reader().getLong(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder7 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            boolean bl = AgnosticEncoders.PrimitiveFloatEncoder$.MODULE$.equals(agnosticEncoder7) ? true : AgnosticEncoders.BoxedFloatEncoder$.MODULE$.equals(agnosticEncoder7);
            if (bl && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<Object> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<Object>(encoder, fieldVector, timeZoneId){

                    public float value(int i) {
                        return this.reader().getFloat(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder8 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            boolean bl = AgnosticEncoders.PrimitiveDoubleEncoder$.MODULE$.equals(agnosticEncoder8) ? true : AgnosticEncoders.BoxedDoubleEncoder$.MODULE$.equals(agnosticEncoder8);
            if (bl && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<Object> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<Object>(encoder, fieldVector, timeZoneId){

                    public double value(int i) {
                        return this.reader().getDouble(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null && AgnosticEncoders.NullEncoder$.MODULE$.equals(agnosticEncoder = (AgnosticEncoder)tuple2._1()) && tuple2._2() instanceof FieldVector) {
            ArrowDeserializers.Deserializer<Object> deserializer = new ArrowDeserializers.Deserializer<Object>(){

                public Object get(int i) {
                    return null;
                }
            };
            return var4_40;
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder9 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (AgnosticEncoders.StringEncoder$.MODULE$.equals(agnosticEncoder9) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<String> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<String>(encoder, fieldVector, timeZoneId){

                    public String value(int i) {
                        return this.reader().getString(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder10 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder10 instanceof AgnosticEncoders.JavaEnumEncoder) {
                AgnosticEncoders.JavaEnumEncoder javaEnumEncoder = (AgnosticEncoders.JavaEnumEncoder)agnosticEncoder10;
                ClassTag tag = javaEnumEncoder.clsTag();
                if (v instanceof FieldVector) {
                    FieldVector fieldVector = (FieldVector)v;
                    MethodHandle valueOf = this.methodLookup().findStatic(tag.runtimeClass(), "valueOf", MethodType.methodType(tag.runtimeClass(), String.class));
                    ArrowDeserializers.LeafFieldDeserializer leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<Enum<?>>(encoder, fieldVector, timeZoneId, valueOf){
                        private final MethodHandle valueOf$1;

                        public Enum<?> value(int i) {
                            return (Enum)this.valueOf$1.invoke(this.reader().getString(i));
                        }
                        {
                            this.valueOf$1 = valueOf$1;
                            super(encoder$1, x95$1, timeZoneId$1);
                        }
                    };
                    return var4_40;
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder11 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder11 instanceof AgnosticEncoders.ScalaEnumEncoder) {
                AgnosticEncoders.ScalaEnumEncoder scalaEnumEncoder = (AgnosticEncoders.ScalaEnumEncoder)agnosticEncoder11;
                Class parent = scalaEnumEncoder.parent();
                if (v instanceof FieldVector) {
                    FieldVector fieldVector = (FieldVector)v;
                    JavaUniverse.JavaMirror mirror = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                    Symbols.ModuleSymbolApi module = mirror.classSymbol((Object)parent).module().asModule();
                    Enumeration enumeration = (Enumeration)mirror.reflectModule(module).instance();
                    ArrowDeserializers.LeafFieldDeserializer<Enumeration.Value> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<Enumeration.Value>(encoder, fieldVector, timeZoneId, enumeration){
                        private final Enumeration enumeration$1;

                        public Enumeration.Value value(int i) {
                            return this.enumeration$1.withName(this.reader().getString(i));
                        }
                        {
                            this.enumeration$1 = enumeration$1;
                            super(encoder$1, x96$1, timeZoneId$1);
                        }
                    };
                    return var4_40;
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder12 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (AgnosticEncoders.BinaryEncoder$.MODULE$.equals(agnosticEncoder12) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<byte[]> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<byte[]>(encoder, fieldVector, timeZoneId){

                    public byte[] value(int i) {
                        return this.reader().getBytes(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder13 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder13 instanceof AgnosticEncoders.SparkDecimalEncoder && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<Decimal> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<Decimal>(encoder, fieldVector, timeZoneId){

                    public Decimal value(int i) {
                        return this.reader().getDecimal(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder14 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder14 instanceof AgnosticEncoders.ScalaDecimalEncoder && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<scala.math.BigDecimal> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<scala.math.BigDecimal>(encoder, fieldVector, timeZoneId){

                    public scala.math.BigDecimal value(int i) {
                        return this.reader().getScalaDecimal(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder15 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder15 instanceof AgnosticEncoders.JavaDecimalEncoder && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<BigDecimal> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<BigDecimal>(encoder, fieldVector, timeZoneId){

                    public BigDecimal value(int i) {
                        return this.reader().getJavaDecimal(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder16 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (AgnosticEncoders.ScalaBigIntEncoder$.MODULE$.equals(agnosticEncoder16) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<BigInt> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<BigInt>(encoder, fieldVector, timeZoneId){

                    public BigInt value(int i) {
                        return this.reader().getScalaBigInt(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder17 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (AgnosticEncoders.JavaBigIntEncoder$.MODULE$.equals(agnosticEncoder17) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<BigInteger> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<BigInteger>(encoder, fieldVector, timeZoneId){

                    public BigInteger value(int i) {
                        return this.reader().getJavaBigInt(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder18 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (AgnosticEncoders.DayTimeIntervalEncoder$.MODULE$.equals(agnosticEncoder18) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<Duration> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<Duration>(encoder, fieldVector, timeZoneId){

                    public Duration value(int i) {
                        return this.reader().getDuration(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder19 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (AgnosticEncoders.YearMonthIntervalEncoder$.MODULE$.equals(agnosticEncoder19) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<Period> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<Period>(encoder, fieldVector, timeZoneId){

                    public Period value(int i) {
                        return this.reader().getPeriod(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder20 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder20 instanceof AgnosticEncoders.DateEncoder && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<Date> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<Date>(encoder, fieldVector, timeZoneId){

                    public Date value(int i) {
                        return this.reader().getDate(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder21 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder21 instanceof AgnosticEncoders.LocalDateEncoder && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<LocalDate> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<LocalDate>(encoder, fieldVector, timeZoneId){

                    public LocalDate value(int i) {
                        return this.reader().getLocalDate(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder22 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder22 instanceof AgnosticEncoders.TimestampEncoder && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<Timestamp> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<Timestamp>(encoder, fieldVector, timeZoneId){

                    public Timestamp value(int i) {
                        return this.reader().getTimestamp(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder23 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder23 instanceof AgnosticEncoders.InstantEncoder && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<Instant> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<Instant>(encoder, fieldVector, timeZoneId){

                    public Instant value(int i) {
                        return this.reader().getInstant(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder24 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (AgnosticEncoders.LocalDateTimeEncoder$.MODULE$.equals(agnosticEncoder24) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                ArrowDeserializers.LeafFieldDeserializer<LocalDateTime> leafFieldDeserializer = new ArrowDeserializers.LeafFieldDeserializer<LocalDateTime>(encoder, fieldVector, timeZoneId){

                    public LocalDateTime value(int i) {
                        return this.reader().getLocalDateTime(i);
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder25 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder25 instanceof AgnosticEncoders.OptionEncoder) {
                AgnosticEncoders.OptionEncoder optionEncoder = (AgnosticEncoders.OptionEncoder)agnosticEncoder25;
                AgnosticEncoder value2 = optionEncoder.elementEncoder();
                ArrowDeserializers.Deserializer<Object> deserializer = this.deserializerFor(value2, v, timeZoneId);
                ArrowDeserializers.Deserializer<Object> deserializer2 = new ArrowDeserializers.Deserializer<Object>(deserializer){
                    private final ArrowDeserializers.Deserializer deserializer$1;

                    public Object get(int i) {
                        return Option$.MODULE$.apply(this.deserializer$1.get(i));
                    }
                    {
                        this.deserializer$1 = deserializer$1;
                    }
                };
                return var4_40;
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder26 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder26 instanceof AgnosticEncoders.ArrayEncoder) {
                AgnosticEncoders.ArrayEncoder arrayEncoder = (AgnosticEncoders.ArrayEncoder)agnosticEncoder26;
                AgnosticEncoder element = arrayEncoder.element();
                if (v instanceof ListVector) {
                    ListVector listVector = (ListVector)v;
                    ArrowDeserializers.Deserializer<Object> deserializer = this.deserializerFor(element, listVector.getDataVector(), timeZoneId);
                    ArrowDeserializers.VectorFieldDeserializer<Object, ListVector> vectorFieldDeserializer = new ArrowDeserializers.VectorFieldDeserializer<Object, ListVector>(listVector, deserializer, element){
                        private final ArrowDeserializers.Deserializer deserializer$2;
                        private final AgnosticEncoder element$1;

                        public Object value(int i) {
                            return ArrowDeserializers$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowDeserializers$$getArray((ListVector)this.vector(), i, this.deserializer$2, (ClassTag<Object>)this.element$1.clsTag());
                        }
                        {
                            this.deserializer$2 = deserializer$2;
                            this.element$1 = element$1;
                            super(x116$1);
                        }
                    };
                    return var4_40;
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder27 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder27 instanceof AgnosticEncoders.IterableEncoder) {
                AgnosticEncoders.IterableEncoder iterableEncoder = (AgnosticEncoders.IterableEncoder)agnosticEncoder27;
                ClassTag tag = iterableEncoder.clsTag();
                AgnosticEncoder element = iterableEncoder.element();
                if (v instanceof ListVector) {
                    ArrowDeserializers.VectorFieldDeserializer<Object, ListVector> vectorFieldDeserializer;
                    ListVector listVector = (ListVector)v;
                    ArrowDeserializers.Deserializer<Object> deserializer = this.deserializerFor(element, listVector.getDataVector(), timeZoneId);
                    if (ArrowEncoderUtils$.MODULE$.isSubClass(ArrowEncoderUtils$Classes$.MODULE$.WRAPPED_ARRAY(), tag)) {
                        vectorFieldDeserializer = new ArrowDeserializers.VectorFieldDeserializer<WrappedArray<Object>, ListVector>(listVector, deserializer, element){
                            private final ArrowDeserializers.Deserializer deserializer$3;
                            private final AgnosticEncoder element$2;

                            public WrappedArray<Object> value(int i) {
                                Object array = ArrowDeserializers$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowDeserializers$$getArray((ListVector)this.vector(), i, this.deserializer$3, (ClassTag<Object>)this.element$2.clsTag());
                                return ScalaCollectionUtils$.MODULE$.wrap(array);
                            }
                            {
                                this.deserializer$3 = deserializer$3;
                                this.element$2 = element$2;
                                super(x117$1);
                            }
                        };
                    } else if (ArrowEncoderUtils$.MODULE$.isSubClass(ArrowEncoderUtils$Classes$.MODULE$.ITERABLE(), tag)) {
                        GenericCompanion<Iterable> companion = ScalaCollectionUtils$.MODULE$.getIterableCompanion(tag);
                        vectorFieldDeserializer = new ArrowDeserializers.VectorFieldDeserializer<Iterable<Object>, ListVector>(listVector, companion, deserializer){
                            private final GenericCompanion companion$1;
                            private final ArrowDeserializers.Deserializer deserializer$3;

                            public Iterable<Object> value(int i) {
                                Builder builder = this.companion$1.newBuilder();
                                ArrowDeserializers$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowDeserializers$$loadListIntoBuilder((ListVector)this.vector(), i, this.deserializer$3, builder);
                                return (Iterable)builder.result();
                            }
                            {
                                this.companion$1 = companion$1;
                                this.deserializer$3 = deserializer$3;
                                super(x117$1);
                            }
                        };
                    } else {
                        if (!ArrowEncoderUtils$.MODULE$.isSubClass(ArrowEncoderUtils$Classes$.MODULE$.JLIST(), tag)) throw ArrowEncoderUtils$.MODULE$.unsupportedCollectionType(tag.runtimeClass());
                        Function1<Object, List<Object>> newInstance = this.resolveJavaListCreator(tag);
                        vectorFieldDeserializer = new ArrowDeserializers.VectorFieldDeserializer<List<Object>, ListVector>(listVector, newInstance, deserializer){
                            private final ListVector x117$1;
                            private final Function1 newInstance$1;
                            private final ArrowDeserializers.Deserializer deserializer$3;

                            public List<Object> value(int i) {
                                int index;
                                int end = this.x117$1.getElementEndIndex(i);
                                List list = (List)this.newInstance$1.apply((Object)BoxesRunTime.boxToInteger((int)(end - index)));
                                for (index = this.x117$1.getElementStartIndex(i); index < end; ++index) {
                                    list.add(this.deserializer$3.get(index));
                                }
                                return list;
                            }
                            {
                                this.x117$1 = x117$1;
                                this.newInstance$1 = newInstance$1;
                                this.deserializer$3 = deserializer$3;
                                super(x117$1);
                            }
                        };
                    }
                    ArrowDeserializers.VectorFieldDeserializer<WrappedArray<Object>, ListVector> vectorFieldDeserializer2 = vectorFieldDeserializer;
                    return var4_40;
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder28 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder28 instanceof AgnosticEncoders.MapEncoder) {
                AgnosticEncoders.MapEncoder mapEncoder = (AgnosticEncoders.MapEncoder)agnosticEncoder28;
                ClassTag tag = mapEncoder.clsTag();
                AgnosticEncoder key = mapEncoder.keyEncoder();
                AgnosticEncoder value3 = mapEncoder.valueEncoder();
                if (v instanceof MapVector) {
                    ArrowDeserializers.VectorFieldDeserializer<Object, MapVector> vectorFieldDeserializer;
                    MapVector mapVector = (MapVector)v;
                    StructVector structVector = (StructVector)mapVector.getDataVector();
                    ArrowDeserializers.Deserializer<Object> keyDeserializer = this.deserializerFor(key, structVector.getChild("key"), timeZoneId);
                    ArrowDeserializers.Deserializer<Object> valueDeserializer = this.deserializerFor(value3, structVector.getChild("value"), timeZoneId);
                    if (ArrowEncoderUtils$.MODULE$.isSubClass(ArrowEncoderUtils$Classes$.MODULE$.MAP(), tag)) {
                        GenMapFactory<scala.collection.immutable.Map> companion = ScalaCollectionUtils$.MODULE$.getMapCompanion(tag);
                        vectorFieldDeserializer = new ArrowDeserializers.VectorFieldDeserializer<scala.collection.immutable.Map<Object, Object>, MapVector>(mapVector, companion, keyDeserializer, valueDeserializer){
                            private final GenMapFactory companion$2;
                            private final MapVector x118$1;
                            private final ArrowDeserializers.Deserializer keyDeserializer$1;
                            private final ArrowDeserializers.Deserializer valueDeserializer$1;

                            public scala.collection.immutable.Map<Object, Object> value(int i) {
                                int index;
                                Builder builder = this.companion$2.newBuilder();
                                int end = this.x118$1.getElementEndIndex(i);
                                builder.sizeHint(end - index);
                                for (index = this.x118$1.getElementStartIndex(i); index < end; ++index) {
                                    builder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.keyDeserializer$1.get(index)), this.valueDeserializer$1.get(index)));
                                }
                                return (scala.collection.immutable.Map)builder.result();
                            }
                            {
                                this.companion$2 = companion$2;
                                this.x118$1 = x118$1;
                                this.keyDeserializer$1 = keyDeserializer$1;
                                this.valueDeserializer$1 = valueDeserializer$1;
                                super(x118$1);
                            }
                        };
                    } else {
                        if (!ArrowEncoderUtils$.MODULE$.isSubClass(ArrowEncoderUtils$Classes$.MODULE$.JMAP(), tag)) throw ArrowEncoderUtils$.MODULE$.unsupportedCollectionType(tag.runtimeClass());
                        Function0<Map<Object, Object>> newInstance = this.resolveJavaMapCreator(tag);
                        vectorFieldDeserializer = new ArrowDeserializers.VectorFieldDeserializer<Map<Object, Object>, MapVector>(mapVector, newInstance, keyDeserializer, valueDeserializer){
                            private final Function0 newInstance$2;
                            private final MapVector x118$1;
                            private final ArrowDeserializers.Deserializer keyDeserializer$1;
                            private final ArrowDeserializers.Deserializer valueDeserializer$1;

                            /*
                             * WARNING - void declaration
                             */
                            public Map<Object, Object> value(int i) {
                                void var2_2;
                                Map map = (Map)this.newInstance$2.apply();
                                int end = this.x118$1.getElementEndIndex(i);
                                for (int index = this.x118$1.getElementStartIndex(i); index < end; ++index) {
                                    map.put(this.keyDeserializer$1.get(index), this.valueDeserializer$1.get(index));
                                }
                                return var2_2;
                            }
                            {
                                this.newInstance$2 = newInstance$2;
                                this.x118$1 = x118$1;
                                this.keyDeserializer$1 = keyDeserializer$1;
                                this.valueDeserializer$1 = valueDeserializer$1;
                                super(x118$1);
                            }
                        };
                    }
                    ArrowDeserializers.VectorFieldDeserializer<Object, MapVector> vectorFieldDeserializer3 = vectorFieldDeserializer;
                    return var4_40;
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder29 = (AgnosticEncoder)tuple2._1();
            Object object = tuple2._2();
            if (agnosticEncoder29 instanceof AgnosticEncoders.ProductEncoder) {
                AgnosticEncoders.ProductEncoder productEncoder = (AgnosticEncoders.ProductEncoder)agnosticEncoder29;
                ClassTag tag = productEncoder.clsTag();
                Seq fields = productEncoder.fields();
                Option outerPointerGetter = productEncoder.outerPointerGetter();
                Option<Tuple2<StructVector, Seq<FieldVector>>> option = StructVectors$.MODULE$.unapply(object);
                if (!option.isEmpty()) {
                    Seq seq;
                    Function1 constructor;
                    StructVector struct = (StructVector)((Tuple2)option.get())._1();
                    Seq vectors = (Seq)((Tuple2)option.get())._2();
                    Seq outer = Option$.MODULE$.option2Iterable(outerPointerGetter.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.apply())).toSeq();
                    Option option2 = ScalaReflection$.MODULE$.findConstructor(tag.runtimeClass(), (Seq)((TraversableLike)outer.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getClass(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)fields.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.enc().clsTag().runtimeClass(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()));
                    if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                    Some some = (Some)option2;
                    Function1 function1 = constructor = (Function1)some.value();
                    Function1 constructor2 = function1;
                    if (this.isTuple(tag.runtimeClass())) {
                        seq = (Seq)((TraversableLike)fields.zip((GenIterable)vectors, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            AgnosticEncoders.EncoderField field = (AgnosticEncoders.EncoderField)tuple2._1();
                            FieldVector vector = (FieldVector)tuple2._2();
                            ArrowDeserializers.Deserializer<Object> deserializer = MODULE$.deserializerFor(field.enc(), vector, timeZoneId);
                            return deserializer;
                        }, Seq$.MODULE$.canBuildFrom());
                    } else {
                        Seq outerDeserializer = (Seq)outer.map((Function1 & Serializable & scala.Serializable)value -> new ArrowDeserializers.Deserializer<Object>(value){
                            private final Object value$1;

                            public Object get(int i) {
                                return this.value$1;
                            }
                            {
                                this.value$1 = value$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Function1<String, FieldVector> lookup = this.createFieldLookup((Seq<FieldVector>)vectors);
                        seq = (Seq)outerDeserializer.$plus$plus((GenTraversableOnce)fields.map((Function1 & Serializable & scala.Serializable)field -> MODULE$.deserializerFor(field.enc(), lookup.apply((Object)field.name()), timeZoneId), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                    }
                    Seq deserializers = seq;
                    ArrowDeserializers.StructFieldSerializer<Object> structFieldSerializer = new ArrowDeserializers.StructFieldSerializer<Object>(struct, constructor2, deserializers){
                        private final Function1 constructor$1;
                        private final Seq deserializers$1;

                        public Object value(int i) {
                            return this.constructor$1.apply(this.deserializers$1.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.get(i), Seq$.MODULE$.canBuildFrom()));
                        }
                        {
                            this.constructor$1 = constructor$1;
                            this.deserializers$1 = deserializers$1;
                            super(struct$1);
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1(int org.apache.spark.sql.connect.client.arrow.ArrowDeserializers$Deserializer )}, serializedLambda);
                        }
                    };
                    return var4_40;
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder r = (AgnosticEncoder)tuple2._1();
            Object object = tuple2._2();
            if (r instanceof AgnosticEncoders.RowEncoder) {
                AgnosticEncoders.RowEncoder rowEncoder = (AgnosticEncoders.RowEncoder)r;
                Seq fields = rowEncoder.fields();
                Option<Tuple2<StructVector, Seq<FieldVector>>> option = StructVectors$.MODULE$.unapply(object);
                if (!option.isEmpty()) {
                    StructVector struct = (StructVector)((Tuple2)option.get())._1();
                    Seq vectors = (Seq)((Tuple2)option.get())._2();
                    Function1<String, FieldVector> lookup = this.createFieldLookup((Seq<FieldVector>)vectors);
                    ArrowDeserializers.Deserializer[] deserializers = (ArrowDeserializers.Deserializer[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields.toArray(ClassTag$.MODULE$.apply(AgnosticEncoders.EncoderField.class)))).map((Function1 & Serializable & scala.Serializable)field -> MODULE$.deserializerFor(field.enc(), lookup.apply((Object)field.name()), timeZoneId), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ArrowDeserializers.Deserializer.class)));
                    ArrowDeserializers.StructFieldSerializer<Object> structFieldSerializer = new ArrowDeserializers.StructFieldSerializer<Object>(struct, deserializers, rowEncoder){
                        private final ArrowDeserializers.Deserializer[] deserializers$2;
                        private final AgnosticEncoders.RowEncoder x62$1;

                        public Object value(int i) {
                            Object[] values = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.deserializers$2)).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.get(i), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
                            return new GenericRowWithSchema(values, this.x62$1.schema());
                        }
                        {
                            this.deserializers$2 = deserializers$2;
                            this.x62$1 = x62$1;
                            super(struct$2);
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$2(int org.apache.spark.sql.connect.client.arrow.ArrowDeserializers$Deserializer )}, serializedLambda);
                        }
                    };
                    return var4_40;
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder30 = (AgnosticEncoder)tuple2._1();
            Object object = tuple2._2();
            if (agnosticEncoder30 instanceof AgnosticEncoders.JavaBeanEncoder) {
                AgnosticEncoders.JavaBeanEncoder javaBeanEncoder = (AgnosticEncoders.JavaBeanEncoder)agnosticEncoder30;
                ClassTag tag = javaBeanEncoder.clsTag();
                Seq fields = javaBeanEncoder.fields();
                Option<Tuple2<StructVector, Seq<FieldVector>>> option = StructVectors$.MODULE$.unapply(object);
                if (!option.isEmpty()) {
                    StructVector struct = (StructVector)((Tuple2)option.get())._1();
                    Seq vectors = (Seq)((Tuple2)option.get())._2();
                    MethodHandle constructor = this.methodLookup().findConstructor(tag.runtimeClass(), MethodType.methodType(BoxedUnit.TYPE));
                    Function1<String, FieldVector> lookup = this.createFieldLookup((Seq<FieldVector>)vectors);
                    Seq setters = (Seq)((TraversableLike)fields.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ArrowDeserializers$.$anonfun$deserializerFor$8(x$6)))).map((Function1 & Serializable & scala.Serializable)field -> {
                        FieldVector vector = (FieldVector)lookup.apply((Object)field.name());
                        ArrowDeserializers.Deserializer<Object> deserializer = MODULE$.deserializerFor(field.enc(), vector, timeZoneId);
                        MethodHandle setter = MODULE$.methodLookup().findVirtual(tag.runtimeClass(), (String)field.writeMethod().get(), MethodType.methodType(BoxedUnit.TYPE, field.enc().clsTag().runtimeClass()));
                        return (Function2 & Serializable & scala.Serializable)(bean, i) -> setter.invoke(bean, deserializer.get(BoxesRunTime.unboxToInt((Object)i)));
                    }, Seq$.MODULE$.canBuildFrom());
                    ArrowDeserializers.StructFieldSerializer<Object> structFieldSerializer = new ArrowDeserializers.StructFieldSerializer<Object>(struct, constructor, setters){
                        private final MethodHandle constructor$2;
                        private final Seq setters$1;

                        /*
                         * WARNING - void declaration
                         */
                        public Object value(int i) {
                            void var2_2;
                            Object instance = this.constructor$2.invoke();
                            this.setters$1.foreach((Function1 & Serializable & scala.Serializable)x$7 -> x$7.apply(instance, (Object)BoxesRunTime.boxToInteger((int)i)));
                            return var2_2;
                        }
                        {
                            this.constructor$2 = constructor$2;
                            this.setters$1 = setters$1;
                            super(struct$3);
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3(java.lang.Object int scala.Function2 )}, serializedLambda);
                        }
                    };
                    return var4_40;
                }
            }
        }
        if (tuple2 == null) throw new RuntimeException(new StringBuilder(43).append("Unsupported Encoder(").append(encoder).append(")/Vector(").append(data.getClass()).append(") combination.").toString());
        AgnosticEncoder agnosticEncoder31 = (AgnosticEncoder)tuple2._1();
        boolean bl = AgnosticEncoders.CalendarIntervalEncoder$.MODULE$.equals(agnosticEncoder31) ? true : agnosticEncoder31 instanceof AgnosticEncoders.UDTEncoder;
        if (!bl) throw new RuntimeException(new StringBuilder(43).append("Unsupported Encoder(").append(encoder).append(")/Vector(").append(data.getClass()).append(") combination.").toString());
        throw ExecutionErrors$.MODULE$.unsupportedDataTypeError(encoder.dataType());
    }

    private MethodHandles.Lookup methodLookup() {
        return this.methodLookup;
    }

    public <T> T resolveCompanion(ClassTag<?> tag) {
        JavaUniverse.JavaMirror mirror = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        Symbols.ModuleSymbolApi module = mirror.classSymbol((Object)tag.runtimeClass()).companion().asModule();
        return (T)mirror.reflectModule(module).instance();
    }

    private Function1<Object, List<Object>> resolveJavaListCreator(ClassTag<?> tag) {
        Function1 & Serializable & scala.Serializable intersect;
        Class cls = tag.runtimeClass();
        int modifiers = cls.getModifiers();
        if (Modifier.isInterface(modifiers) || Modifier.isAbstract(modifiers)) {
            if (!cls.isAssignableFrom(ArrayList.class)) {
                throw ArrowEncoderUtils$.MODULE$.unsupportedCollectionType(cls);
            }
            intersect = (Function1 & Serializable & scala.Serializable)size -> ArrowDeserializers$.$anonfun$resolveJavaListCreator$1(BoxesRunTime.unboxToInt((Object)size));
        } else {
            try {
                MethodHandle ctor = this.methodLookup().findConstructor(tag.runtimeClass(), MethodType.methodType(BoxedUnit.TYPE, Integer.TYPE));
                intersect = (Function1 & Serializable & scala.Serializable)size -> ArrowDeserializers$.$anonfun$resolveJavaListCreator$2(ctor, BoxesRunTime.unboxToInt((Object)size));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                MethodHandle ctor = this.methodLookup().findConstructor(tag.runtimeClass(), MethodType.methodType(BoxedUnit.TYPE));
                intersect = (Function1 & Serializable & scala.Serializable)x$8 -> ArrowDeserializers$.$anonfun$resolveJavaListCreator$3(ctor, BoxesRunTime.unboxToInt((Object)x$8));
            }
        }
        return intersect;
    }

    private Function0<Map<Object, Object>> resolveJavaMapCreator(ClassTag<?> tag) {
        Function0 & Serializable & scala.Serializable intersect;
        Class cls = tag.runtimeClass();
        int modifiers = cls.getModifiers();
        if (Modifier.isInterface(modifiers) || Modifier.isAbstract(modifiers)) {
            if (!cls.isAssignableFrom(HashMap.class)) {
                throw ArrowEncoderUtils$.MODULE$.unsupportedCollectionType(cls);
            }
            intersect = (Function0 & Serializable & scala.Serializable)() -> new HashMap();
        } else {
            MethodHandle ctor = this.methodLookup().findConstructor(tag.runtimeClass(), MethodType.methodType(BoxedUnit.TYPE));
            intersect = (Function0 & Serializable & scala.Serializable)() -> (Map)ctor.invoke();
        }
        return intersect;
    }

    private Function1<String, FieldVector> createFieldLookup(Seq<FieldVector> fields) {
        scala.collection.mutable.Map lookup = Map$.MODULE$.empty();
        fields.foreach((Function1 & Serializable & scala.Serializable)field -> {
            ArrowDeserializers$.$anonfun$createFieldLookup$1(lookup, fields, field);
            return BoxedUnit.UNIT;
        });
        return (Function1 & Serializable & scala.Serializable)name -> (FieldVector)lookup.getOrElse((Object)ArrowDeserializers$.toKey$1(name), (Function0 & Serializable & scala.Serializable)() -> {
            throw CompilationErrors$.MODULE$.columnNotFoundError(name);
        });
    }

    private boolean isTuple(Class<?> cls) {
        return cls.getName().startsWith("scala.Tuple");
    }

    public void org$apache$spark$sql$connect$client$arrow$ArrowDeserializers$$loadListIntoBuilder(ListVector v, int i, ArrowDeserializers.Deserializer<Object> deserializer, Builder<Object, ?> builder) {
        int index;
        int end = v.getElementEndIndex(i);
        builder.sizeHint(end - index);
        for (index = v.getElementStartIndex(i); index < end; ++index) {
            builder.$plus$eq(deserializer.get(index));
        }
    }

    public Object org$apache$spark$sql$connect$client$arrow$ArrowDeserializers$$getArray(ListVector v, int i, ArrowDeserializers.Deserializer<Object> deserializer, ClassTag<Object> tag) {
        ArrayBuilder builder = ArrayBuilder$.MODULE$.make(tag);
        this.org$apache$spark$sql$connect$client$arrow$ArrowDeserializers$$loadListIntoBuilder(v, i, deserializer, (Builder<Object, ?>)builder);
        return builder.result();
    }

    public static final /* synthetic */ boolean $anonfun$deserializerFor$8(AgnosticEncoders.EncoderField x$6) {
        return x$6.writeMethod().isDefined();
    }

    public static final /* synthetic */ ArrayList $anonfun$resolveJavaListCreator$1(int size) {
        return new ArrayList(size);
    }

    public static final /* synthetic */ List $anonfun$resolveJavaListCreator$2(MethodHandle ctor$1, int size) {
        return (List)ctor$1.invoke(size);
    }

    public static final /* synthetic */ List $anonfun$resolveJavaListCreator$3(MethodHandle ctor$2, int x$8) {
        return (List)ctor$2.invoke();
    }

    private static final String toKey$1(String k) {
        return k.toLowerCase(Locale.ROOT);
    }

    public static final /* synthetic */ boolean $anonfun$createFieldLookup$2(String key$1, FieldVector f) {
        String string = ArrowDeserializers$.toKey$1(f.getName());
        String string2 = key$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$createFieldLookup$1(scala.collection.mutable.Map lookup$4, Seq fields$1, FieldVector field) {
        String key = ArrowDeserializers$.toKey$1(field.getName());
        Option old = lookup$4.put((Object)key, (Object)field);
        if (old.isDefined()) {
            String string = field.getName();
            throw CompilationErrors$.MODULE$.ambiguousColumnOrFieldError((Seq)Nil$.MODULE$.$colon$colon((Object)string), fields$1.count((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ArrowDeserializers$.$anonfun$createFieldLookup$2(key, f))));
        }
    }

    private ArrowDeserializers$() {
        MODULE$ = this;
        this.methodLookup = MethodHandles.lookup();
    }
}

