/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import com.databricks.sql.remotefiltering.CloudFetchResult;
import grpc_shaded.com.google.protobuf.ByteString;
import grpc_shaded.com.google.protobuf.util.JsonFormat;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.ipc.message.ArrowMessage;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.connect.proto.CloudResultBatch;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoder;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.connect.client.CloseableIterator;
import org.apache.spark.sql.connect.client.SparkResultCloseable;
import org.apache.spark.sql.connect.client.arrow.AbstractMessageIterator;
import org.apache.spark.sql.connect.client.arrow.ArrowDeserializingIterator;
import org.apache.spark.sql.connect.client.arrow.ConcatenatingArrowStreamReader;
import org.apache.spark.sql.connect.client.arrow.MessageIterator;
import org.apache.spark.sql.connect.client.util.Cleanable;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.ArrowUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t}d!B\u0015+\u000192\u0004\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011B)\t\u0011q\u0003!\u0011!Q\u0001\nuC\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\ty\u0002\u0011\t\u0011)A\u0005{\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001BCA\u0010\u0001\u0001\u0007\t\u0011)Q\u0005{\"A\u0011\u0011\u0005\u0001!B\u0013\t\u0019\u0003C\u0006\u0002*\u0001\u0001\r\u0011!Q!\n\u0005-\u0002bCA\u001c\u0001\u0001\u0007\t\u0011)Q\u0005\u0003sA\u0001\"a\u0013\u0001A\u0003&\u00111\u0005\u0005\n\u0003\u001b\u0002!\u0019!C\u0005\u0003\u001fB\u0001\"a$\u0001A\u0003%\u0011\u0011\u000b\u0005\t\u0003#\u0003\u0001\u0015!\u0003\u0002\u0014\"9\u0011q\u0016\u0001\u0005\n\u0005E\u0006bBAf\u0001\u0011%\u0011Q\u001a\u0005\n\u0003K\u0004\u0011\u0013!C\u0005\u0003OD\u0011\"!@\u0001#\u0003%I!a:\t\u0013\u0005}\b!%A\u0005\n\u0005\u001d\b\"\u0003B\u0001\u0001E\u0005I\u0011BAt\u0011\u001d\u0011\u0019\u0001\u0001C\u0001\u0005\u000bAqAa\u0002\u0001\t\u0003\u0011I\u0001C\u0004\u0003\f\u0001!\tA!\u0004\t\u000f\t=\u0001\u0001\"\u0001\u0003\u0012!9!\u0011\u0004\u0001\u0005\u0002\tm\u0001b\u0002B\u0016\u0001\u0011\u0005!Q\u0006\u0005\b\u0005c\u0001A\u0011\u0001B\u0017\u0011\u001d\u0011\u0019\u0004\u0001C\u0005\u0005kAqAa\u000f\u0001\t\u0003\u0012i\u0004C\u0005\u0003F\u0001\u0011\r\u0011\"\u0011\u0003H!9!\u0011\n\u0001!\u0002\u0013\u0001eA\u0002B&\u0001\u0011\u0011i\u0005\u0003\u0006\u0003:}\u0011\t\u0011)A\u0005\u0003\u001fDq!!\u0005 \t\u0003\u0011y\u0006\u0003\u0005\u0003h}\u0001\u000b\u0015BA4\u0011!\tYe\bQ!\n\u0005\r\u0002\u0002\u0003B5?\u0001\u0006KAa\u001b\t\u000f\tEt\u0004\"\u0011\u0003t!9!qA\u0010\u0005B\tU\u0004b\u0002B<?\u0011\u0005#\u0011\u0010\u0005\b\u0005wzB\u0011\tB?\u0005-\u0019\u0006/\u0019:l%\u0016\u001cX\u000f\u001c;\u000b\u0005-b\u0013AB2mS\u0016tGO\u0003\u0002.]\u000591m\u001c8oK\u000e$(BA\u00181\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003cI\nQa\u001d9be.T!a\r\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0014aA8sOV\u0011q\u0007]\n\u0006\u0001a\u00025)\u0013\t\u0003syj\u0011A\u000f\u0006\u0003wq\nA\u0001\\1oO*\tQ(\u0001\u0003kCZ\f\u0017BA ;\u0005\u0019y%M[3diB\u0011\u0011(Q\u0005\u0003\u0005j\u0012Q\"Q;u_\u000ecwn]3bE2,\u0007C\u0001#H\u001b\u0005)%B\u0001$+\u0003\u0011)H/\u001b7\n\u0005!+%!C\"mK\u0006t\u0017M\u00197f!\tQU*D\u0001L\u0015\ta\u0005'\u0001\u0005j]R,'O\\1m\u0013\tq5JA\u0004M_\u001e<\u0017N\\4\u0002\u0013I,7\u000f]8og\u0016\u001c8\u0001\u0001\t\u0004%N+V\"\u0001\u0016\n\u0005QS#!E\"m_N,\u0017M\u00197f\u0013R,'/\u0019;peB\u0011aKW\u0007\u0002/*\u0011\u0001,W\u0001\u0006aJ|Go\u001c\u0006\u0003[AJ!aW,\u0003'\u0015CXmY;uKBc\u0017M\u001c*fgB|gn]3\u0002\u0013\u0005dGn\\2bi>\u0014\bC\u00010d\u001b\u0005y&B\u00011b\u0003\u0019iW-\\8ss*\u0011!MM\u0001\u0006CJ\u0014xn^\u0005\u0003I~\u0013qBQ;gM\u0016\u0014\u0018\t\u001c7pG\u0006$xN]\u0001\bK:\u001cw\u000eZ3s!\r9GN\\\u0007\u0002Q*\u0011\u0011N[\u0001\tK:\u001cw\u000eZ3sg*\u00111NL\u0001\tG\u0006$\u0018\r\\=ti&\u0011Q\u000e\u001b\u0002\u0010\u0003\u001etwn\u001d;jG\u0016s7m\u001c3feB\u0011q\u000e\u001d\u0007\u0001\t\u0015\t\bA1\u0001s\u0005\u0005!\u0016CA:z!\t!x/D\u0001v\u0015\u00051\u0018!B:dC2\f\u0017B\u0001=v\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u001e>\n\u0005m,(aA!os\u0006QA/[7f5>tW-\u00133\u0011\u0007y\fYAD\u0002\u0000\u0003\u000f\u00012!!\u0001v\u001b\t\t\u0019AC\u0002\u0002\u0006A\u000ba\u0001\u0010:p_Rt\u0014bAA\u0005k\u00061\u0001K]3eK\u001aLA!!\u0004\u0002\u0010\t11\u000b\u001e:j]\u001eT1!!\u0003v\u0003\u0019a\u0014N\\5u}QQ\u0011QCA\f\u00033\tY\"!\b\u0011\u0007I\u0003a\u000eC\u0003P\u000b\u0001\u0007\u0011\u000bC\u0003]\u000b\u0001\u0007Q\fC\u0003f\u000b\u0001\u0007a\rC\u0003}\u000b\u0001\u0007Q0\u0001\u0003pa&#\u0017A\u00038v[J+7m\u001c:egB\u0019A/!\n\n\u0007\u0005\u001dROA\u0002J]R\f!b\u001d;sk\u000e$H+\u001f9f!\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019]\u0005)A/\u001f9fg&!\u0011QGA\u0018\u0005)\u0019FO];diRK\b/Z\u0001\fCJ\u0014xn^*dQ\u0016l\u0017\r\u0005\u0003\u0002<\u0005\u001dSBAA\u001f\u0015\u0011\ty$!\u0011\u0002\tA|'n\u001c\u0006\u0005\u0003c\t\u0019EC\u0002\u0002F\u0005\faA^3di>\u0014\u0018\u0002BA%\u0003{\u0011aaU2iK6\f\u0017a\u00048fqR\u0014Vm];mi&sG-\u001a=\u0002\u0013I,7/\u001e7u\u001b\u0006\u0004XCAA)!!\t\u0019&!\u0018\u0002$\u0005\u0005TBAA+\u0015\u0011\t9&!\u0017\u0002\u000f5,H/\u00192mK*\u0019\u00111L;\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002`\u0005U#aA'baB9A/a\u0019\u0002h\u00055\u0014bAA3k\n1A+\u001e9mKJ\u00022\u0001^A5\u0013\r\tY'\u001e\u0002\u0005\u0019>tw\r\u0005\u0004\u0002p\u0005e\u0014q\u0010\b\u0005\u0003c\n)H\u0004\u0003\u0002\u0002\u0005M\u0014\"\u0001<\n\u0007\u0005]T/A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0014Q\u0010\u0002\u0004'\u0016\f(bAA<kB!\u0011\u0011QAF\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\u001d\u0015aB7fgN\fw-\u001a\u0006\u0005\u0003\u0013\u000b\u0019%A\u0002ja\u000eLA!!$\u0002\u0004\na\u0011I\u001d:po6+7o]1hK\u0006Q!/Z:vYRl\u0015\r\u001d\u0011\u0002\u0013\r4')\u0019;dQ\u0016\u001c\bCBA*\u0003+\u000bI*\u0003\u0003\u0002\u0018\u0006U#A\u0002\"vM\u001a,'\u000f\u0005\u0003\u0002\u001c\u0006-VBAAO\u0015\u0011\ty*!)\u0002\u001fI,Wn\u001c;fM&dG/\u001a:j]\u001eT1aLAR\u0015\u0011\t)+a*\u0002\u0015\u0011\fG/\u00192sS\u000e\\7O\u0003\u0002\u0002*\u0006\u00191m\\7\n\t\u00055\u0016Q\u0014\u0002\u0011\u00072|W\u000f\u001a$fi\u000eD'+Z:vYR\fQb\u0019:fCR,WI\\2pI\u0016\u0014X\u0003BAZ\u0003s#b!!.\u0002>\u0006\u0005\u0007\u0003B4m\u0003o\u00032a\\A]\t\u0019\tYL\u0004b\u0001e\n\tQ\tC\u0004\u0002@:\u0001\r!!.\u0002\u0007\u0015t7\rC\u0004\u0002D:\u0001\r!!2\u0002\u0011\u0011\fG/\u0019+za\u0016\u0004B!!\f\u0002H&!\u0011\u0011ZA\u0018\u0005!!\u0015\r^1UsB,\u0017\u0001\u00059s_\u000e,7o\u001d*fgB|gn]3t))\ty-!6\u0002Z\u0006u\u0017\u0011\u001d\t\u0004i\u0006E\u0017bAAjk\n9!i\\8mK\u0006t\u0007\"CAl\u001fA\u0005\t\u0019AAh\u0003E\u0019Ho\u001c9P]>\u0003XM]1uS>t\u0017\n\u001a\u0005\n\u00037|\u0001\u0013!a\u0001\u0003\u001f\fAb\u001d;pa>s7k\u00195f[\u0006D\u0011\"a8\u0010!\u0003\u0005\r!a4\u0002#M$x\u000e](o\u0003J\u0014xn^*dQ\u0016l\u0017\rC\u0005\u0002d>\u0001\n\u00111\u0001\u0002P\u0006Y2\u000f^8q\u001f:4\u0015N]:u\u001d>tW)\u001c9usJ+7\u000f]8og\u0016\f!\u0004\u001d:pG\u0016\u001c8OU3ta>t7/Z:%I\u00164\u0017-\u001e7uIE*\"!!;+\t\u0005=\u00171^\u0016\u0003\u0003[\u0004B!a<\u0002z6\u0011\u0011\u0011\u001f\u0006\u0005\u0003g\f)0A\u0005v]\u000eDWmY6fI*\u0019\u0011q_;\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002|\u0006E(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Q\u0002O]8dKN\u001c(+Z:q_:\u001cXm\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005Q\u0002O]8dKN\u001c(+Z:q_:\u001cXm\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005Q\u0002O]8dKN\u001c(+Z:q_:\u001cXm\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u00051A.\u001a8hi\",\"!a\t\u0002\rM\u001c\u0007.Z7b+\t\tY#A\u0006pa\u0016\u0014\u0018\r^5p]&#W#A?\u0002\u000fQ|\u0017I\u001d:bsV\u0011!1\u0003\t\u0005i\nUa.C\u0002\u0003\u0018U\u0014Q!\u0011:sCf\f1\u0003^8DY>,HMR3uG\"\u0014\u0015\r^2iKN,\"A!\b\u0011\r\u0005=\u0014\u0011PAMQ\rA\"\u0011\u0005\t\u0005\u0005G\u00119#\u0004\u0002\u0003&)\u0019\u0011q\u001f\u0019\n\t\t%\"Q\u0005\u0002\r\t\u00164X\r\\8qKJ\f\u0005/[\u0001\tSR,'/\u0019;peV\u0011!q\u0006\t\u0004%Ns\u0017a\u00053fgR\u0014Xo\u0019;jm\u0016LE/\u001a:bi>\u0014\u0018!\u00042vS2$\u0017\n^3sCR|'\u000f\u0006\u0003\u00030\t]\u0002b\u0002B\u001d7\u0001\u0007\u0011qZ\u0001\fI\u0016\u001cHO];di&4X-A\u0003dY>\u001cX\r\u0006\u0002\u0003@A\u0019AO!\u0011\n\u0007\t\rSO\u0001\u0003V]&$\u0018aB2mK\u0006tWM]\u000b\u0002\u0001\u0006A1\r\\3b]\u0016\u0014\bEA\u000bSKN,H\u000e^'fgN\fw-Z%uKJ\fGo\u001c:\u0014\u000b}\u0011yE!\u0016\u0011\u0007Q\u0014\t&C\u0002\u0003TU\u0014a!\u00118z%\u00164\u0007\u0003\u0002B,\u00057j!A!\u0017\u000b\u0005\tT\u0013\u0002\u0002B/\u00053\u0012q#\u00112tiJ\f7\r^'fgN\fw-Z%uKJ\fGo\u001c:\u0015\t\t\u0005$Q\r\t\u0004\u0005GzR\"\u0001\u0001\t\u000f\te\u0012\u00051\u0001\u0002P\u0006qAo\u001c;bY\nKH/Z:SK\u0006$\u0017aB2veJ,g\u000e\u001e\t\u0007\u0003_\u0012i'a \n\t\t=\u0014Q\u0010\u0002\t\u0013R,'/\u0019;pe\u0006I!-\u001f;fgJ+\u0017\rZ\u000b\u0003\u0003O*\"!!\u000f\u0002\u000f!\f7OT3yiV\u0011\u0011qZ\u0001\u0005]\u0016DH\u000f\u0006\u0002\u0002\u0000\u0001")
public class SparkResult<T>
implements AutoCloseable,
Cleanable,
Logging {
    private final CloseableIterator<ExecutePlanResponse> responses;
    public final BufferAllocator org$apache$spark$sql$connect$client$SparkResult$$allocator;
    public final AgnosticEncoder<T> org$apache$spark$sql$connect$client$SparkResult$$encoder;
    public final String org$apache$spark$sql$connect$client$SparkResult$$timeZoneId;
    private String opId;
    private int numRecords;
    private StructType structType;
    public Schema org$apache$spark$sql$connect$client$SparkResult$$arrowSchema;
    private int nextResultIndex;
    private final Map<Object, Tuple2<Object, Seq<ArrowMessage>>> org$apache$spark$sql$connect$client$SparkResult$$resultMap;
    private final Buffer<CloudFetchResult> cfBatches;
    private final AutoCloseable cleaner;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Map<Object, Tuple2<Object, Seq<ArrowMessage>>> org$apache$spark$sql$connect$client$SparkResult$$resultMap() {
        return this.org$apache$spark$sql$connect$client$SparkResult$$resultMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <E> AgnosticEncoder<E> org$apache$spark$sql$connect$client$SparkResult$$createEncoder(AgnosticEncoder<E> enc, DataType dataType) {
        AgnosticEncoders.ProductEncoder productEncoder = enc;
        if (AgnosticEncoders.UnboundRowEncoder$.MODULE$.equals(productEncoder)) {
            return RowEncoder$.MODULE$.encoderFor((StructType)dataType);
        }
        if (!(productEncoder instanceof AgnosticEncoders.ProductEncoder)) return enc;
        AgnosticEncoders.ProductEncoder productEncoder2 = productEncoder;
        ClassTag clsTag = productEncoder2.clsTag();
        Seq fields = productEncoder2.fields();
        Option outer = productEncoder2.outerPointerGetter();
        if (!AgnosticEncoders.ProductEncoder$.MODULE$.isTuple(clsTag)) return enc;
        StructType schema = (StructType)dataType;
        Predef$.MODULE$.assert(fields.length() <= schema.fields().length);
        Seq updatedFields = (Seq)((TraversableLike)fields.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AgnosticEncoders.EncoderField f = (AgnosticEncoders.EncoderField)tuple2._1();
            int id = tuple2._2$mcI$sp();
            AgnosticEncoder x$1 = this.org$apache$spark$sql$connect$client$SparkResult$$createEncoder(f.enc(), schema.fields()[id].dataType());
            String x$2 = f.copy$default$1();
            boolean x$3 = f.copy$default$3();
            Metadata x$4 = f.copy$default$4();
            Option x$5 = f.copy$default$5();
            Option x$6 = f.copy$default$6();
            AgnosticEncoders.EncoderField encoderField = f.copy(x$2, x$1, x$3, x$4, x$5, x$6);
            return encoderField;
        }, Seq$.MODULE$.canBuildFrom());
        return new AgnosticEncoders.ProductEncoder(clsTag, updatedFields, outer);
    }

    public boolean org$apache$spark$sql$connect$client$SparkResult$$processResponses(boolean stopOnOperationId, boolean stopOnSchema, boolean stopOnArrowSchema, boolean stopOnFirstNonEmptyResponse) {
        boolean nonEmpty = false;
        boolean stop = false;
        while (!stop && this.responses.hasNext()) {
            ExecutePlanResponse response = (ExecutePlanResponse)this.responses.next();
            if (this.opId == null) {
                this.opId = response.getOperationId();
            }
            String string = this.opId;
            String string2 = response.getOperationId();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new IllegalStateException(new java.lang.StringBuilder(70).append("Received response with wrong operationId. ").append("Expected '").append(this.opId).append("' but received '").append(response.getOperationId()).append("'.").toString());
            }
            stop |= stopOnOperationId;
            if (response.hasSchema()) {
                this.structType = (StructType)DataTypeProtoConverter$.MODULE$.toCatalystType(response.getSchema());
                stop |= stopOnSchema;
            }
            if (response.hasArrowBatch()) {
                ByteString ipcStreamBytes = response.getArrowBatch().getData();
                MessageIterator reader = new MessageIterator(ipcStreamBytes.newInput(), this.org$apache$spark$sql$connect$client$SparkResult$$allocator);
                if (this.org$apache$spark$sql$connect$client$SparkResult$$arrowSchema == null) {
                    this.org$apache$spark$sql$connect$client$SparkResult$$arrowSchema = reader.schema();
                    stop |= stopOnArrowSchema;
                } else {
                    Schema schema = this.org$apache$spark$sql$connect$client$SparkResult$$arrowSchema;
                    Schema schema2 = reader.schema();
                    if (schema == null ? schema2 != null : !schema.equals(schema2)) {
                        throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(184).append("Schema Mismatch between expected and received schema:\n               |=== Expected Schema ===\n               |").append(this.org$apache$spark$sql$connect$client$SparkResult$$arrowSchema).append("\n               |=== Received Schema ===\n               |").append(reader.schema()).append("\n               |").toString())).stripMargin());
                    }
                }
                if (this.structType == null) {
                    this.structType = ArrowUtils$.MODULE$.fromArrowSchema(reader.schema());
                }
                int numRecordsInBatch = 0;
                Builder messages = Seq$.MODULE$.newBuilder();
                while (reader.hasNext()) {
                    BoxedUnit boxedUnit;
                    ArrowMessage message = reader.next();
                    ArrowMessage arrowMessage = message;
                    if (arrowMessage instanceof ArrowRecordBatch) {
                        ArrowRecordBatch arrowRecordBatch = (ArrowRecordBatch)arrowMessage;
                        numRecordsInBatch += arrowRecordBatch.getLength();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    messages.$plus$eq((Object)message);
                }
                if (numRecordsInBatch > 0) {
                    this.numRecords += numRecordsInBatch;
                    this.org$apache$spark$sql$connect$client$SparkResult$$resultMap().put((Object)BoxesRunTime.boxToInteger((int)this.nextResultIndex), (Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)reader.bytesRead()), messages.result()));
                    ++this.nextResultIndex;
                    nonEmpty |= true;
                    stop |= stopOnFirstNonEmptyResponse;
                }
            } else if (response.hasExtension() && response.getExtension().is(CloudResultBatch.class)) {
                CloudResultBatch cfr = response.getExtension().unpack(CloudResultBatch.class);
                Buffer batches = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(cfr.getResultsList()).asScala()).map((Function1 & Serializable & scala.Serializable)r -> new CloudFetchResult(r.getUrl(), r.getCompressedSize(), r.getUncompressedSize(), r.getRowCount()), Buffer$.MODULE$.canBuildFrom());
                this.cfBatches.appendAll((TraversableOnce)batches);
            }
            if (!response.hasMetrics()) continue;
            String jsonMetrics = JsonFormat.printer().print(response.getMetrics());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(33).append("[Metrics execution: ").append($this.opId).append(" response: ").append(response.getResponseId()).append(":").append(" ").append(jsonMetrics).toString());
        }
        return nonEmpty;
    }

    public boolean org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$1() {
        return false;
    }

    public boolean org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$2() {
        return false;
    }

    public boolean org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$3() {
        return false;
    }

    public boolean org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$4() {
        return false;
    }

    public int length() {
        this.org$apache$spark$sql$connect$client$SparkResult$$processResponses(this.org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$1(), this.org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$2(), this.org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$3(), this.org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$4());
        return this.numRecords;
    }

    public StructType schema() {
        Object object;
        if (this.structType == null) {
            boolean x$1 = true;
            boolean x$2 = this.org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$1();
            boolean x$3 = this.org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$3();
            boolean x$4 = this.org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$4();
            object = BoxesRunTime.boxToBoolean((boolean)this.org$apache$spark$sql$connect$client$SparkResult$$processResponses(x$2, x$1, x$3, x$4));
        } else {
            object = BoxedUnit.UNIT;
        }
        return this.structType;
    }

    public String operationId() {
        Object object = this.opId == null ? BoxesRunTime.boxToBoolean((boolean)this.org$apache$spark$sql$connect$client$SparkResult$$processResponses(true, this.org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$2(), this.org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$3(), this.org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$4())) : BoxedUnit.UNIT;
        return this.opId;
    }

    /*
     * WARNING - void declaration
     */
    public Object toArray() {
        void var1_1;
        Object result = this.org$apache$spark$sql$connect$client$SparkResult$$encoder.clsTag().newArray(this.length());
        try (CloseableIterator<T> rows = this.iterator();){
            int i = 0;
            while (rows.hasNext()) {
                ScalaRunTime$.MODULE$.array_update(result, i, rows.next());
                Predef$.MODULE$.assert(i < this.numRecords);
                ++i;
            }
        }
        return var1_1;
    }

    @DeveloperApi
    public Seq<CloudFetchResult> toCloudFetchBatches() {
        boolean x$1 = false;
        boolean x$2 = this.org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$1();
        boolean x$3 = this.org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$2();
        boolean x$4 = this.org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$3();
        this.org$apache$spark$sql$connect$client$SparkResult$$processResponses(x$2, x$3, x$4, x$1);
        return this.cfBatches;
    }

    public CloseableIterator<T> iterator() {
        return this.buildIterator(false);
    }

    public CloseableIterator<T> destructiveIterator() {
        return this.buildIterator(true);
    }

    private CloseableIterator<T> buildIterator(boolean destructive) {
        return new CloseableIterator<T>(this, destructive){
            private CloseableIterator<T> iter;
            private final /* synthetic */ SparkResult $outer;
            private final boolean destructive$1;

            public java.util.Iterator<T> asJava() {
                return CloseableIterator.asJava$(this);
            }

            public Iterator<T> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<T> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<T> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<T> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<T> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<T, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<T, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<T> filter(Function1<T, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<T, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<T> withFilter(Function1<T, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<T> filterNot(Function1<T, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<T, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, T, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<T, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<T> takeWhile(Function1<T, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> partition(Function1<T, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> span(Function1<T, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<T> dropWhile(Function1<T, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<T, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<T, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<T, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<T, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<T, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<T> find(Function1<T, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<T, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<T, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<T> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<T>, Iterator<T>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<T> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<T> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<T> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<T> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<T, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, T, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<T, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public <B> T min(Ordering<B> cmp) {
                return (T)TraversableOnce.min$((TraversableOnce)this, cmp);
            }

            public <B> T max(Ordering<B> cmp) {
                return (T)TraversableOnce.max$((TraversableOnce)this, cmp);
            }

            public <B> T maxBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.maxBy$((TraversableOnce)this, f, cmp);
            }

            public <B> T minBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.minBy$((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<T> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<T> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<T> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<T> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<T> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, T, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<T, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            private void initialize() {
                block0: {
                    if (this.iter != null) break block0;
                    this.iter = new ArrowDeserializingIterator<T>(this.$outer.org$apache$spark$sql$connect$client$SparkResult$$createEncoder(this.$outer.org$apache$spark$sql$connect$client$SparkResult$$encoder, (DataType)this.$outer.schema()), new ConcatenatingArrowStreamReader(this.$outer.org$apache$spark$sql$connect$client$SparkResult$$allocator, (Iterator<AbstractMessageIterator>)package$.MODULE$.Iterator().single((Object)new ResultMessageIterator(this.$outer, this.destructive$1)), this.destructive$1), this.$outer.org$apache$spark$sql$connect$client$SparkResult$$timeZoneId);
                }
            }

            public boolean hasNext() {
                this.initialize();
                return this.iter.hasNext();
            }

            public T next() {
                this.initialize();
                return (T)this.iter.next();
            }

            public void close() {
                block0: {
                    if (this.iter == null) break block0;
                    this.iter.close();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.destructive$1 = destructive$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                CloseableIterator.$init$(this);
            }
        };
    }

    @Override
    public void close() {
        this.cleaner().close();
    }

    @Override
    public AutoCloseable cleaner() {
        return this.cleaner;
    }

    public SparkResult(CloseableIterator<ExecutePlanResponse> responses, BufferAllocator allocator, AgnosticEncoder<T> encoder, String timeZoneId) {
        this.responses = responses;
        this.org$apache$spark$sql$connect$client$SparkResult$$allocator = allocator;
        this.org$apache$spark$sql$connect$client$SparkResult$$encoder = encoder;
        this.org$apache$spark$sql$connect$client$SparkResult$$timeZoneId = timeZoneId;
        Logging.$init$((Logging)this);
        this.numRecords = 0;
        this.nextResultIndex = 0;
        this.org$apache$spark$sql$connect$client$SparkResult$$resultMap = Map$.MODULE$.empty();
        this.cfBatches = (Buffer)Buffer$.MODULE$.empty();
        this.cleaner = new SparkResultCloseable(this.org$apache$spark$sql$connect$client$SparkResult$$resultMap(), responses);
    }

    private class ResultMessageIterator
    implements AbstractMessageIterator {
        private final boolean destructive;
        private long totalBytesRead;
        private int nextResultIndex;
        private Iterator<ArrowMessage> current;
        public final /* synthetic */ SparkResult $outer;

        public Iterator<ArrowMessage> seq() {
            return Iterator.seq$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public boolean isTraversableAgain() {
            return Iterator.isTraversableAgain$((Iterator)this);
        }

        public boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public Iterator<ArrowMessage> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<ArrowMessage> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<ArrowMessage> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<ArrowMessage> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<B> map(Function1<ArrowMessage, B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
            return Iterator.$plus$plus$((Iterator)this, that);
        }

        public <B> Iterator<B> flatMap(Function1<ArrowMessage, GenTraversableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public Iterator<ArrowMessage> filter(Function1<ArrowMessage, Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<ArrowMessage, B, Object> p) {
            return Iterator.corresponds$((Iterator)this, that, p);
        }

        public Iterator<ArrowMessage> withFilter(Function1<ArrowMessage, Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public Iterator<ArrowMessage> filterNot(Function1<ArrowMessage, Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<ArrowMessage, B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, ArrowMessage, B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<ArrowMessage, B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public Iterator<ArrowMessage> takeWhile(Function1<ArrowMessage, Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<ArrowMessage>, Iterator<ArrowMessage>> partition(Function1<ArrowMessage, Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public Tuple2<Iterator<ArrowMessage>, Iterator<ArrowMessage>> span(Function1<ArrowMessage, Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<ArrowMessage> dropWhile(Function1<ArrowMessage, Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public <B> Iterator<Tuple2<ArrowMessage, B>> zip(Iterator<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1> Iterator<A1> padTo(int len, A1 elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Iterator<Tuple2<ArrowMessage, Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public <U> void foreach(Function1<ArrowMessage, U> f) {
            Iterator.foreach$((Iterator)this, f);
        }

        public boolean forall(Function1<ArrowMessage, Object> p) {
            return Iterator.forall$((Iterator)this, p);
        }

        public boolean exists(Function1<ArrowMessage, Object> p) {
            return Iterator.exists$((Iterator)this, p);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public Option<ArrowMessage> find(Function1<ArrowMessage, Object> p) {
            return Iterator.find$((Iterator)this, p);
        }

        public int indexWhere(Function1<ArrowMessage, Object> p) {
            return Iterator.indexWhere$((Iterator)this, p);
        }

        public int indexWhere(Function1<ArrowMessage, Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public BufferedIterator<ArrowMessage> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public int length() {
            return Iterator.length$((Iterator)this);
        }

        public Tuple2<Iterator<ArrowMessage>, Iterator<ArrowMessage>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <B> void copyToArray(Object xs, int start, int len) {
            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
        }

        public boolean sameElements(Iterator<?> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Traversable<ArrowMessage> toTraversable() {
            return Iterator.toTraversable$((Iterator)this);
        }

        public Iterator<ArrowMessage> toIterator() {
            return Iterator.toIterator$((Iterator)this);
        }

        public Stream<ArrowMessage> toStream() {
            return Iterator.toStream$((Iterator)this);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public List<ArrowMessage> reversed() {
            return TraversableOnce.reversed$((TraversableOnce)this);
        }

        public int size() {
            return TraversableOnce.size$((TraversableOnce)this);
        }

        public boolean nonEmpty() {
            return TraversableOnce.nonEmpty$((TraversableOnce)this);
        }

        public int count(Function1<ArrowMessage, Object> p) {
            return TraversableOnce.count$((TraversableOnce)this, p);
        }

        public <B> Option<B> collectFirst(PartialFunction<ArrowMessage, B> pf) {
            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
        }

        public <B> B $div$colon(B z, Function2<B, ArrowMessage, B> op) {
            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
        }

        public <B> B $colon$bslash(B z, Function2<ArrowMessage, B, B> op) {
            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
        }

        public <B> B foldLeft(B z, Function2<B, ArrowMessage, B> op) {
            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
        }

        public <B> B foldRight(B z, Function2<ArrowMessage, B, B> op) {
            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
        }

        public <B> B reduceLeft(Function2<B, ArrowMessage, B> op) {
            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
        }

        public <B> B reduceRight(Function2<ArrowMessage, B, B> op) {
            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, ArrowMessage, B> op) {
            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<ArrowMessage, B, B> op) {
            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
        }

        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
        }

        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, ArrowMessage, B> seqop, Function2<B, B, B> combop) {
            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)TraversableOnce.product$((TraversableOnce)this, num);
        }

        public Object min(Ordering cmp) {
            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object max(Ordering cmp) {
            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
        }

        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
        }

        public <B> void copyToArray(Object xs) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
        }

        public List<ArrowMessage> toList() {
            return TraversableOnce.toList$((TraversableOnce)this);
        }

        public Iterable<ArrowMessage> toIterable() {
            return TraversableOnce.toIterable$((TraversableOnce)this);
        }

        public Seq<ArrowMessage> toSeq() {
            return TraversableOnce.toSeq$((TraversableOnce)this);
        }

        public IndexedSeq<ArrowMessage> toIndexedSeq() {
            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
        }

        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.toBuffer$((TraversableOnce)this);
        }

        public <B> Set<B> toSet() {
            return TraversableOnce.toSet$((TraversableOnce)this);
        }

        public Vector<ArrowMessage> toVector() {
            return TraversableOnce.toVector$((TraversableOnce)this);
        }

        public <Col> Col to(CanBuildFrom<Nothing$, ArrowMessage, Col> cbf) {
            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
        }

        public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<ArrowMessage, Tuple2<T, U>> ev) {
            return TraversableOnce.toMap$((TraversableOnce)this, ev);
        }

        public String mkString(String start, String sep, String end) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
        }

        public String mkString(String sep) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
        }

        public String mkString() {
            return TraversableOnce.mkString$((TraversableOnce)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public StringBuilder addString(StringBuilder b, String sep) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
        }

        public StringBuilder addString(StringBuilder b) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
        }

        public int sizeHintIfCheap() {
            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
        }

        @Override
        public long bytesRead() {
            return this.totalBytesRead;
        }

        @Override
        public Schema schema() {
            BoxedUnit boxedUnit;
            if (this.org$apache$spark$sql$connect$client$SparkResult$ResultMessageIterator$$$outer().org$apache$spark$sql$connect$client$SparkResult$$arrowSchema == null) {
                boolean x$1 = true;
                boolean x$2 = this.org$apache$spark$sql$connect$client$SparkResult$ResultMessageIterator$$$outer().org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$1();
                boolean x$3 = this.org$apache$spark$sql$connect$client$SparkResult$ResultMessageIterator$$$outer().org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$2();
                boolean x$4 = this.org$apache$spark$sql$connect$client$SparkResult$ResultMessageIterator$$$outer().org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$4();
                this.org$apache$spark$sql$connect$client$SparkResult$ResultMessageIterator$$$outer().org$apache$spark$sql$connect$client$SparkResult$$processResponses(x$2, x$3, x$1, x$4);
                boxedUnit = Objects.requireNonNull(this.org$apache$spark$sql$connect$client$SparkResult$ResultMessageIterator$$$outer().org$apache$spark$sql$connect$client$SparkResult$$arrowSchema);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return this.org$apache$spark$sql$connect$client$SparkResult$ResultMessageIterator$$$outer().org$apache$spark$sql$connect$client$SparkResult$$arrowSchema;
        }

        /*
         * WARNING - void declaration
         */
        public boolean hasNext() {
            void var2_5;
            block4: {
                Some some;
                Tuple2 tuple2;
                Option option;
                boolean hasNextResult;
                boolean bl;
                if (this.current.hasNext()) {
                    return true;
                }
                if (!this.org$apache$spark$sql$connect$client$SparkResult$ResultMessageIterator$$$outer().org$apache$spark$sql$connect$client$SparkResult$$resultMap().contains((Object)BoxesRunTime.boxToInteger((int)this.nextResultIndex))) {
                    boolean x$1 = true;
                    boolean x$2 = this.org$apache$spark$sql$connect$client$SparkResult$ResultMessageIterator$$$outer().org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$1();
                    boolean x$3 = this.org$apache$spark$sql$connect$client$SparkResult$ResultMessageIterator$$$outer().org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$2();
                    boolean x$4 = this.org$apache$spark$sql$connect$client$SparkResult$ResultMessageIterator$$$outer().org$apache$spark$sql$connect$client$SparkResult$$processResponses$default$3();
                    bl = this.org$apache$spark$sql$connect$client$SparkResult$ResultMessageIterator$$$outer().org$apache$spark$sql$connect$client$SparkResult$$processResponses(x$2, x$3, x$4, x$1);
                } else {
                    bl = hasNextResult = true;
                }
                if (!hasNextResult) break block4;
                Option option2 = option = this.destructive ? this.org$apache$spark$sql$connect$client$SparkResult$ResultMessageIterator$$$outer().org$apache$spark$sql$connect$client$SparkResult$$resultMap().remove((Object)BoxesRunTime.boxToInteger((int)this.nextResultIndex)) : this.org$apache$spark$sql$connect$client$SparkResult$ResultMessageIterator$$$outer().org$apache$spark$sql$connect$client$SparkResult$$resultMap().get((Object)BoxesRunTime.boxToInteger((int)this.nextResultIndex));
                if (!(option instanceof Some) || (tuple2 = (Tuple2)(some = (Some)option).value()) == null) {
                    throw new MatchError((Object)option);
                }
                long sizeInBytes = tuple2._1$mcJ$sp();
                Seq messages = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)sizeInBytes), (Object)messages);
                Tuple2 tuple23 = tuple22;
                long sizeInBytes2 = tuple23._1$mcJ$sp();
                Seq messages2 = (Seq)tuple23._2();
                this.totalBytesRead += sizeInBytes2;
                this.current = messages2.iterator();
                ++this.nextResultIndex;
            }
            return (boolean)var2_5;
        }

        public ArrowMessage next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (ArrowMessage)this.current.next();
        }

        public /* synthetic */ SparkResult org$apache$spark$sql$connect$client$SparkResult$ResultMessageIterator$$$outer() {
            return this.$outer;
        }

        public ResultMessageIterator(SparkResult $outer, boolean destructive) {
            this.destructive = destructive;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            GenTraversableOnce.$init$((GenTraversableOnce)this);
            TraversableOnce.$init$((TraversableOnce)this);
            Iterator.$init$((Iterator)this);
            this.totalBytesRead = 0L;
            this.nextResultIndex = 0;
            this.current = package$.MODULE$.Iterator().empty();
        }
    }
}

