/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import grpc_shaded.io.grpc.Status;
import grpc_shaded.io.grpc.StatusRuntimeException;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.connect.client.GrpcRetryHandler;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;
import scala.util.control.NonFatal$;

public final class GrpcRetryHandler$
implements Logging {
    public static GrpcRetryHandler$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new GrpcRetryHandler$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Function1<Object, BoxedUnit> $lessinit$greater$default$2() {
        return (JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$1 -> Thread.sleep(x$1);
    }

    public final <T> T retry(GrpcRetryHandler.RetryPolicy retryPolicy, Function1<Object, BoxedUnit> sleep, Function0<T> fn) {
        IntRef currentRetryNum = IntRef.create((int)0);
        Seq exceptionList = (Seq)Nil$.MODULE$;
        FiniteDuration nextBackoff = retryPolicy.initialBackoff();
        if (retryPolicy.maxRetries() < 0) {
            throw new IllegalArgumentException("Can't have negative number of retries");
        }
        while (currentRetryNum.elem <= retryPolicy.maxRetries()) {
            if (currentRetryNum.elem != 0) {
                FiniteDuration currentBackoff = nextBackoff;
                nextBackoff = nextBackoff.$times(retryPolicy.backoffMultiplier()).min((Duration)retryPolicy.maxBackoff());
                if (currentBackoff.$greater$eq((Object)retryPolicy.minJitterThreshold())) {
                    currentBackoff = currentBackoff.$plus(package.DoubleMult$.MODULE$.$times$extension(package$.MODULE$.DoubleMult(Random$.MODULE$.nextDouble()), (Duration)retryPolicy.jitter()));
                }
                sleep.apply$mcVJ$sp(currentBackoff.toMillis());
            }
            try {
                return (T)fn.apply();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    if (BoxesRunTime.unboxToBoolean((Object)retryPolicy.canRetry().apply((Object)e)) && currentRetryNum.elem < retryPolicy.maxRetries()) {
                        BoxedUnit boxedUnit;
                        ++currentRetryNum.elem;
                        Throwable throwable3 = e;
                        exceptionList = (Seq)exceptionList.$plus$colon((Object)throwable3, Seq$.MODULE$.canBuildFrom());
                        if (currentRetryNum.elem <= retryPolicy.maxRetries()) {
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Non-Fatal error during RPC execution: ").append(e).append(", ").append("retrying (currentRetryNum=").append(currentRetryNum$1.elem).append(")").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Non-Fatal error during RPC execution: ").append(e).append(", ").append("exceeded retries (currentRetryNum=").append(currentRetryNum$1.elem).append(")").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        continue;
                    }
                }
                throw throwable;
            }
        }
        Throwable exception = (Throwable)exceptionList.head();
        ((IterableLike)exceptionList.tail()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            exception.addSuppressed(x$4);
            return BoxedUnit.UNIT;
        });
        throw exception;
    }

    public final <T> Function1<Object, BoxedUnit> retry$default$2() {
        return (JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$1 -> Thread.sleep(x$1);
    }

    public boolean retryException(Throwable e) {
        boolean bl;
        Throwable throwable = e;
        if (throwable instanceof StatusRuntimeException) {
            String msgConnectionFailed;
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)throwable;
            String msg = statusRuntimeException.toString();
            Status.Code statusCode = statusRuntimeException.getStatus().getCode();
            if (new .colon.colon((Object)Status.Code.INTERNAL, (List)new .colon.colon((Object)Status.Code.ABORTED, (List)new .colon.colon((Object)Status.Code.FAILED_PRECONDITION, (List)Nil$.MODULE$))).contains((Object)statusCode)) {
                if (msg.contains("INVALID_CURSOR.DISCONNECTED")) {
                    return true;
                }
                String msgSingleUserPolicy = "RESOURCE_LIMIT_EXCEEDED: Only 1 cluster(s)";
                String msgPendingState = "is in unexpected state Pending";
                if (new .colon.colon((Object)msgSingleUserPolicy, (List)new .colon.colon((Object)msgPendingState, (List)Nil$.MODULE$)).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)msg.contains(x$1)))) {
                    return true;
                }
                if (msg.contains("Received RST_STREAM with error")) {
                    return true;
                }
            }
            Status.Code code = statusCode;
            Status.Code code2 = Status.Code.UNAVAILABLE;
            if (!(code != null ? !((Object)((Object)code)).equals((Object)code2) : code2 != null) && !msg.contains(msgConnectionFailed = "failed to connect to all addresses")) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        return bl;
    }

    private GrpcRetryHandler$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

