/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import grpc_shaded.com.google.protobuf.ByteString;
import grpc_shaded.io.grpc.stub.StreamObserver;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.spark.connect.proto.AddArtifactsRequest;
import org.apache.spark.connect.proto.AddArtifactsResponse;
import org.apache.spark.connect.proto.ArtifactStatusesRequest;
import org.apache.spark.connect.proto.ArtifactStatusesResponse;
import org.apache.spark.sql.connect.client.Artifact;
import org.apache.spark.sql.connect.client.Artifact$;
import org.apache.spark.sql.connect.client.ClassFinder;
import org.apache.spark.sql.connect.client.CustomSparkConnectBlockingStub;
import org.apache.spark.sql.connect.client.CustomSparkConnectStub;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.util.SparkFileUtils$;
import org.apache.spark.util.SparkThreadUtils$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u000b\u0017\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tg\u0001\u0011\t\u0011)A\u0005i!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011\u00159\u0005\u0001\"\u0001I\u0011\u001dq\u0005A1A\u0005\n=Caa\u0015\u0001!\u0002\u0013\u0001\u0006B\u0002+\u0001A\u0003%Q\u000bC\u0003c\u0001\u0011\u00051\rC\u0003j\u0001\u0011\u0005!\u000eC\u0003n\u0001\u0011%a\u000e\u0003\u0004j\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0011!\t)\u0002\u0001C\u0001-\u0005]\u0001bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\t\u0003o\u0001A\u0011\u0001\f\u0002:!9\u00111\u0002\u0001\u0005\n\u0005m\u0002bBA$\u0001\u0011%\u0011\u0011\n\u0005\b\u0003c\u0002A\u0011BA:\u0011\u001d\t9\n\u0001C\u0005\u00033\u0013q\"\u0011:uS\u001a\f7\r^'b]\u0006<WM\u001d\u0006\u0003/a\taa\u00197jK:$(BA\r\u001b\u0003\u001d\u0019wN\u001c8fGRT!a\u0007\u000f\u0002\u0007M\fHN\u0003\u0002\u001e=\u0005)1\u000f]1sW*\u0011q\u0004I\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g\u00031\u0019G.[3oi\u000e{gNZ5h!\ta\u0003G\u0004\u0002.]5\ta#\u0003\u00020-\u0005\u00112\u000b]1sW\u000e{gN\\3di\u000ec\u0017.\u001a8u\u0013\t\t$GA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0006\u0003_Y\t\u0011b]3tg&|g.\u00133\u0011\u0005UbdB\u0001\u001c;!\t9d%D\u00019\u0015\tI$%\u0001\u0004=e>|GOP\u0005\u0003w\u0019\na\u0001\u0015:fI\u00164\u0017BA\u001f?\u0005\u0019\u0019FO]5oO*\u00111HJ\u0001\u0006EN$XO\u0019\t\u0003[\u0005K!A\u0011\f\u0003=\r+8\u000f^8n'B\f'o[\"p]:,7\r\u001e\"m_\u000e\\\u0017N\\4TiV\u0014\u0017\u0001B:uk\n\u0004\"!L#\n\u0005\u00193\"AF\"vgR|Wn\u00159be.\u001cuN\u001c8fGR\u001cF/\u001e2\u0002\rqJg.\u001b;?)\u0015I%j\u0013'N!\ti\u0003\u0001C\u0003+\u000b\u0001\u00071\u0006C\u00034\u000b\u0001\u0007A\u0007C\u0003@\u000b\u0001\u0007\u0001\tC\u0003D\u000b\u0001\u0007A)\u0001\u0006D\u0011Vs5jX*J5\u0016+\u0012\u0001\u0015\t\u0003KEK!A\u0015\u0014\u0003\u0007%sG/A\u0006D\u0011Vs5jX*J5\u0016\u0003\u0013\u0001D2mCN\u001ch)\u001b8eKJ\u001c\bc\u0001,^?6\tqK\u0003\u0002Y3\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005i[\u0016\u0001B;uS2T\u0011\u0001X\u0001\u0005U\u00064\u0018-\u0003\u0002_/\n!2i\u001c9z\u001f:<&/\u001b;f\u0003J\u0014\u0018-\u001f'jgR\u0004\"!\f1\n\u0005\u00054\"aC\"mCN\u001ch)\u001b8eKJ\f1C]3hSN$XM]\"mCN\u001ch)\u001b8eKJ$\"\u0001Z4\u0011\u0005\u0015*\u0017B\u00014'\u0005\u0011)f.\u001b;\t\u000b!L\u0001\u0019A0\u0002\r\u0019Lg\u000eZ3s\u0003-\tG\rZ!si&4\u0017m\u0019;\u0015\u0005\u0011\\\u0007\"\u00027\u000b\u0001\u0004!\u0014\u0001\u00029bi\"\fa\u0002]1sg\u0016\f%\u000f^5gC\u000e$8\u000f\u0006\u0002pwB\u0019\u0001/\u001e=\u000f\u0005E\u001chBA\u001cs\u0013\u00059\u0013B\u0001;'\u0003\u001d\u0001\u0018mY6bO\u0016L!A^<\u0003\u0007M+\u0017O\u0003\u0002uMA\u0011Q&_\u0005\u0003uZ\u0011\u0001\"\u0011:uS\u001a\f7\r\u001e\u0005\u0006y.\u0001\r!`\u0001\u0004kJL\u0007c\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002m\u000b1A\\3u\u0013\r\t)a \u0002\u0004+JKEc\u00013\u0002\n!)A\u0010\u0004a\u0001{\u0006a\u0011\r\u001a3BeRLg-Y2ugR\u0019A-a\u0004\t\u000f\u0005EQ\u00021\u0001\u0002\u0014\u0005!QO]5t!\r\u0001X/`\u0001\u0011SN\u001c\u0015m\u00195fI\u0006\u0013H/\u001b4bGR$B!!\u0007\u0002 A\u0019Q%a\u0007\n\u0007\u0005uaEA\u0004C_>dW-\u00198\t\r\u0005\u0005b\u00021\u00015\u0003\u0011A\u0017m\u001d5\u0002\u001b\r\f7\r[3BeRLg-Y2u)\r!\u0014q\u0005\u0005\b\u0003Sy\u0001\u0019AA\u0016\u0003\u0011\u0011Gn\u001c2\u0011\u000b\u0015\ni#!\r\n\u0007\u0005=bEA\u0003BeJ\f\u0017\u0010E\u0002&\u0003gI1!!\u000e'\u0005\u0011\u0011\u0015\u0010^3\u00027U\u0004Hn\\1e\u00032d7\t\\1tg\u001aKG.Z!si&4\u0017m\u0019;t)\u0005!Gc\u00013\u0002>!9\u0011qH\tA\u0002\u0005\u0005\u0013!C1si&4\u0017m\u0019;t!\u0011\u0001\u00181\t=\n\u0007\u0005\u0015sO\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0003M\tG\r\u001a\"bi\u000eDW\rZ!si&4\u0017m\u0019;t)\u0015!\u00171JA'\u0011\u0019\tyD\u0005a\u0001_\"9\u0011q\n\nA\u0002\u0005E\u0013AB:ue\u0016\fW\u000e\u0005\u0004\u0002T\u0005}\u00131M\u0007\u0003\u0003+R1aQA,\u0015\u0011\tI&a\u0017\u0002\t\u001d\u0014\bo\u0019\u0006\u0003\u0003;\n!![8\n\t\u0005\u0005\u0014Q\u000b\u0002\u000f'R\u0014X-Y7PEN,'O^3s!\u0011\t)'!\u001c\u000e\u0005\u0005\u001d$\u0002BA5\u0003W\nQ\u0001\u001d:pi>T!!\u0007\u000f\n\t\u0005=\u0014q\r\u0002\u0014\u0003\u0012$\u0017I\u001d;jM\u0006\u001cGo\u001d*fcV,7\u000f^\u0001\u000ee\u0016\fGMT3yi\u000eCWO\\6\u0015\t\u0005U\u0014\u0011\u0012\t\u0005\u0003o\n))\u0004\u0002\u0002z)!\u00111PA?\u0003!\u0001(o\u001c;pEV4'\u0002BA@\u0003\u0003\u000baaZ8pO2,'BAAB\u0003\r\u0019w.\\\u0005\u0005\u0003\u000f\u000bIH\u0001\u0006CsR,7\u000b\u001e:j]\u001eDq!a#\u0014\u0001\u0004\ti)\u0001\u0002j]B!\u0011qRAJ\u001b\t\t\tJC\u0002\u0002^mKA!!&\u0002\u0012\nY\u0011J\u001c9viN#(/Z1n\u0003I\tG\rZ\"ik:\\W\rZ!si&4\u0017m\u0019;\u0015\u000b\u0011\fY*a(\t\r\u0005uE\u00031\u0001y\u0003!\t'\u000f^5gC\u000e$\bbBA()\u0001\u0007\u0011\u0011\u000b")
public class ArtifactManager {
    private final SparkConnectClient.Configuration clientConfig;
    private final String sessionId;
    private final CustomSparkConnectBlockingStub bstub;
    private final CustomSparkConnectStub stub;
    private final int CHUNK_SIZE;
    private final CopyOnWriteArrayList<ClassFinder> classFinders;

    private int CHUNK_SIZE() {
        return this.CHUNK_SIZE;
    }

    public void registerClassFinder(ClassFinder finder) {
        this.classFinders.add(finder);
    }

    public void addArtifact(String path) {
        this.addArtifact(SparkFileUtils$.MODULE$.resolveURI(path));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Seq<Artifact> parseArtifacts(URI uri) {
        Artifact artifact;
        String string = uri.getScheme();
        if (!"file".equals(string)) throw new UnsupportedOperationException(new StringBuilder(20).append("Unsupported scheme: ").append(string).toString());
        Path path = Paths.get(uri);
        String string2 = ((Object)path.getFileName()).toString();
        if (string2.endsWith(".jar")) {
            artifact = Artifact$.MODULE$.newJarArtifact(path.getFileName(), new Artifact.LocalFile(path));
        } else {
            if (!string2.endsWith(".class")) throw new UnsupportedOperationException(new StringBuilder(24).append("Unsuppoted file format: ").append(string2).toString());
            artifact = Artifact$.MODULE$.newClassArtifact(path.getFileName(), new Artifact.LocalFile(path));
        }
        Artifact artifact2 = artifact;
        return (Seq)new .colon.colon((Object)artifact2, (List)Nil$.MODULE$);
    }

    public void addArtifact(URI uri) {
        this.addArtifacts((Iterable<Artifact>)this.parseArtifacts(uri));
    }

    public void addArtifacts(Seq<URI> uris) {
        this.addArtifacts((Iterable<Artifact>)((Iterable)uris.flatMap((Function1 & Serializable & scala.Serializable)uri -> this.parseArtifacts((URI)uri), Seq$.MODULE$.canBuildFrom())));
    }

    public boolean isCachedArtifact(String hash) {
        String artifactName = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)Artifact$.MODULE$.CACHE_PREFIX()), "/")).append(hash).toString();
        ArtifactStatusesRequest request = ArtifactStatusesRequest.newBuilder().setUserContext(this.clientConfig.userContext()).setClientType(this.clientConfig.userAgent()).setSessionId(this.sessionId).addAllNames(Arrays.asList((Object[])new String[]{artifactName})).build();
        Map<String, ArtifactStatusesResponse.ArtifactStatus> statuses = this.bstub.artifactStatus(request).getStatusesMap();
        return statuses.containsKey(artifactName) ? statuses.get(artifactName).getExists() : false;
    }

    /*
     * WARNING - void declaration
     */
    public String cacheArtifact(byte[] blob) {
        void var2_2;
        block0: {
            String hash = DigestUtils.sha256Hex((byte[])blob);
            if (this.isCachedArtifact(hash)) break block0;
            Artifact artifact = Artifact$.MODULE$.newCacheArtifact(hash, new Artifact.InMemory(blob));
            this.addArtifacts((Iterable<Artifact>)Nil$.MODULE$.$colon$colon((Object)artifact));
        }
        return var2_2;
    }

    public void uploadAllClassFileArtifacts() {
        this.addArtifacts((Iterable<Artifact>)((Iterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.classFinders).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.findClasses(), Buffer$.MODULE$.canBuildFrom())));
    }

    private void addArtifacts(Iterable<Artifact> artifacts) {
        if (artifacts.isEmpty()) {
            return;
        }
        Promise promise = Promise$.MODULE$.apply();
        StreamObserver<AddArtifactsResponse> responseHandler = new StreamObserver<AddArtifactsResponse>(null, promise){
            private final Buffer<AddArtifactsResponse.ArtifactSummary> summaries;
            private final Promise promise$1;

            private Buffer<AddArtifactsResponse.ArtifactSummary> summaries() {
                return this.summaries;
            }

            public void onNext(AddArtifactsResponse v) {
                v.getArtifactsList().forEach(summary -> this.summaries().$plus$eq(summary));
            }

            public void onError(Throwable throwable) {
                this.promise$1.failure(throwable);
            }

            public void onCompleted() {
                this.promise$1.success((Object)this.summaries().toSeq());
            }
            {
                this.promise$1 = promise$1;
                this.summaries = (Buffer)Buffer$.MODULE$.empty();
            }
        };
        StreamObserver<AddArtifactsRequest> stream = this.stub.addArtifacts(responseHandler);
        Buffer currentBatch = (Buffer)Buffer$.MODULE$.empty();
        LongRef currentBatchSize = LongRef.create((long)0L);
        artifacts.iterator().foreach((Function1 & Serializable & scala.Serializable)artifact -> {
            ArtifactManager.$anonfun$addArtifacts$2(this, currentBatch, stream, currentBatchSize, artifact);
            return BoxedUnit.UNIT;
        });
        if (currentBatch.nonEmpty()) {
            this.writeBatch$1(currentBatch, stream, currentBatchSize);
        }
        stream.onCompleted();
        SparkThreadUtils$.MODULE$.awaitResult((Awaitable)promise.future(), (Duration)Duration$.MODULE$.Inf());
    }

    private void addBatchedArtifacts(Seq<Artifact> artifacts, StreamObserver<AddArtifactsRequest> stream) {
        AddArtifactsRequest.Builder builder = AddArtifactsRequest.newBuilder().setUserContext(this.clientConfig.userContext()).setClientType(this.clientConfig.userAgent()).setSessionId(this.sessionId);
        artifacts.foreach((Function1 & Serializable & scala.Serializable)artifact -> {
            AddArtifactsRequest.SingleChunkArtifact singleChunkArtifact;
            try (CheckedInputStream in = new CheckedInputStream(artifact.storage().stream(), new CRC32());){
                try {
                    AddArtifactsRequest.ArtifactChunk.Builder data = AddArtifactsRequest.ArtifactChunk.newBuilder().setData(ByteString.readFrom(in)).setCrc(in.getChecksum().getValue());
                    singleChunkArtifact = builder.getBatchBuilder().addArtifactsBuilder().setName(((Object)artifact.path()).toString()).setData(data).build();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        stream.onError(e);
                        throw e;
                    }
                    throw throwable;
                }
            }
            return singleChunkArtifact;
        });
        stream.onNext(builder.build());
    }

    private ByteString readNextChunk(InputStream in) {
        byte[] buf = new byte[this.CHUNK_SIZE()];
        int bytesRead = 0;
        int count = 0;
        while (count != -1 && bytesRead < this.CHUNK_SIZE()) {
            count = in.read(buf, bytesRead, this.CHUNK_SIZE() - bytesRead);
            if (count == -1) continue;
            bytesRead += count;
        }
        return bytesRead == 0 ? ByteString.EMPTY : ByteString.copyFrom(buf, 0, bytesRead);
    }

    private void addChunkedArtifact(Artifact artifact, StreamObserver<AddArtifactsRequest> stream) {
        AddArtifactsRequest.Builder builder = AddArtifactsRequest.newBuilder().setUserContext(this.clientConfig.userContext()).setClientType(this.clientConfig.userAgent()).setSessionId(this.sessionId);
        try (CheckedInputStream in = new CheckedInputStream(artifact.storage().stream(), new CRC32());){
            try {
                AddArtifactsRequest.ArtifactChunk.Builder artifactChunkBuilder = AddArtifactsRequest.ArtifactChunk.newBuilder();
                ByteString dataChunk = this.readNextChunk(in);
                builder.getBeginChunkBuilder().setName(((Object)artifact.path()).toString()).setTotalBytes(artifact.size()).setNumChunks(this.getNumChunks$1(artifact.size())).setInitialChunk(artifactChunkBuilder.setData(dataChunk).setCrc(in.getChecksum().getValue()));
                stream.onNext(builder.build());
                in.getChecksum().reset();
                builder.clearBeginChunk();
                dataChunk = this.readNextChunk(in);
                while (!dataChunk.isEmpty()) {
                    artifactChunkBuilder.setData(dataChunk).setCrc(in.getChecksum().getValue());
                    builder.setChunk(artifactChunkBuilder.build());
                    stream.onNext(builder.build());
                    in.getChecksum().reset();
                    builder.clearChunk();
                    dataChunk = this.readNextChunk(in);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    stream.onError(e);
                    throw e;
                }
                throw throwable;
            }
        }
    }

    private static final void addToBatch$1(Artifact dep, long size, Buffer currentBatch$1, LongRef currentBatchSize$1) {
        currentBatch$1.$plus$eq((Object)dep);
        currentBatchSize$1.elem += size;
    }

    private final void writeBatch$1(Buffer currentBatch$1, StreamObserver stream$1, LongRef currentBatchSize$1) {
        this.addBatchedArtifacts((Seq<Artifact>)currentBatch$1.toSeq(), stream$1);
        currentBatch$1.clear();
        currentBatchSize$1.elem = 0L;
    }

    public static final /* synthetic */ void $anonfun$addArtifacts$2(ArtifactManager $this, Buffer currentBatch$1, StreamObserver stream$1, LongRef currentBatchSize$1, Artifact artifact) {
        Artifact.LocalData data = artifact.storage();
        long size = data.size();
        if (size > (long)$this.CHUNK_SIZE()) {
            if (currentBatch$1.nonEmpty()) {
                $this.writeBatch$1(currentBatch$1, stream$1, currentBatchSize$1);
            }
            $this.addChunkedArtifact(artifact, stream$1);
        } else {
            if (currentBatchSize$1.elem + size > (long)$this.CHUNK_SIZE()) {
                $this.writeBatch$1(currentBatch$1, stream$1, currentBatchSize$1);
            }
            ArtifactManager.addToBatch$1(artifact, size, currentBatch$1, currentBatchSize$1);
        }
    }

    private final long getNumChunks$1(long size) {
        return (size + (long)(this.CHUNK_SIZE() - 1)) / (long)this.CHUNK_SIZE();
    }

    public ArtifactManager(SparkConnectClient.Configuration clientConfig, String sessionId, CustomSparkConnectBlockingStub bstub, CustomSparkConnectStub stub) {
        this.clientConfig = clientConfig;
        this.sessionId = sessionId;
        this.bstub = bstub;
        this.stub = stub;
        this.CHUNK_SIZE = 32768;
        this.classFinders = new CopyOnWriteArrayList();
    }
}

