/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import grpc_shaded.com.google.common.cache.CacheBuilder;
import grpc_shaded.com.google.common.cache.CacheLoader;
import grpc_shaded.com.google.common.cache.LoadingCache;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.util.Cleaner;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Serializable;

public final class SparkSession$
implements Logging,
Serializable {
    public static SparkSession$ MODULE$;
    private Cleaner cleaner;
    private final int MAX_CACHED_SESSIONS;
    private final AtomicLong org$apache$spark$sql$SparkSession$$planIdGenerator;
    private final LoadingCache<SparkConnectClient.Configuration, SparkSession> org$apache$spark$sql$SparkSession$$sessions;
    private final InheritableThreadLocal<SparkSession> activeThreadSession;
    private final AtomicReference<SparkSession> defaultSession;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new SparkSession$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int MAX_CACHED_SESSIONS() {
        return this.MAX_CACHED_SESSIONS;
    }

    public AtomicLong org$apache$spark$sql$SparkSession$$planIdGenerator() {
        return this.org$apache$spark$sql$SparkSession$$planIdGenerator;
    }

    public LoadingCache<SparkConnectClient.Configuration, SparkSession> org$apache$spark$sql$SparkSession$$sessions() {
        return this.org$apache$spark$sql$SparkSession$$sessions;
    }

    private InheritableThreadLocal<SparkSession> activeThreadSession() {
        return this.activeThreadSession;
    }

    private AtomicReference<SparkSession> defaultSession() {
        return this.defaultSession;
    }

    public void org$apache$spark$sql$SparkSession$$setDefaultAndActiveSession(SparkSession session) {
        block0: {
            this.defaultSession().compareAndSet(null, session);
            if (!this.getActiveSession().isEmpty()) break block0;
            this.setActiveSession(session);
        }
    }

    public SparkSession create(SparkConnectClient.Configuration configuration) {
        return new SparkSession(configuration.toSparkConnectClient(), this.cleaner(), this.org$apache$spark$sql$SparkSession$$planIdGenerator());
    }

    public void onSessionClose(SparkSession session) {
        block0: {
            this.org$apache$spark$sql$SparkSession$$sessions().invalidate(session.client().configuration());
            this.defaultSession().compareAndSet(session, null);
            if (!this.getActiveSession().contains((Object)session)) break block0;
            this.clearActiveSession();
        }
    }

    public SparkSession.Builder builder() {
        return new SparkSession.Builder();
    }

    /*
     * WARNING - void declaration
     */
    private Cleaner cleaner$lzycompute() {
        SparkSession$ sparkSession$ = this;
        synchronized (sparkSession$) {
            if (!this.bitmap$0) {
                void var2_2;
                Cleaner cleaner = new Cleaner();
                cleaner.start();
                this.cleaner = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.cleaner;
    }

    public Cleaner cleaner() {
        return !this.bitmap$0 ? this.cleaner$lzycompute() : this.cleaner;
    }

    public Option<SparkSession> getDefaultSession() {
        return Option$.MODULE$.apply((Object)this.defaultSession().get());
    }

    public void setDefaultSession(SparkSession session) {
        this.defaultSession().set(session);
    }

    public void clearDefaultSession() {
        this.defaultSession().set(null);
    }

    public Option<SparkSession> getActiveSession() {
        return Option$.MODULE$.apply(this.activeThreadSession().get());
    }

    public void setActiveSession(SparkSession session) {
        this.activeThreadSession().set(session);
    }

    public void clearActiveSession() {
        this.activeThreadSession().remove();
    }

    public SparkSession active() {
        return (SparkSession)this.getActiveSession().orElse((Function0 & java.io.Serializable & Serializable)() -> MODULE$.getDefaultSession()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
            throw new IllegalStateException("No active or default Spark session found");
        });
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SparkSession$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.MAX_CACHED_SESSIONS = 100;
        this.org$apache$spark$sql$SparkSession$$planIdGenerator = new AtomicLong();
        this.org$apache$spark$sql$SparkSession$$sessions = CacheBuilder.newBuilder().weakValues().maximumSize(this.MAX_CACHED_SESSIONS()).build(new CacheLoader<SparkConnectClient.Configuration, SparkSession>(){

            public SparkSession load(SparkConnectClient.Configuration c) {
                return SparkSession$.MODULE$.create(c);
            }
        });
        this.activeThreadSession = new InheritableThreadLocal();
        this.defaultSession = new AtomicReference();
    }
}

