/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.JavaTypeInference$;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders$;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.types.StructType;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Seq;
import scala.reflect.api.TypeTags;

public final class Encoders$ {
    public static Encoders$ MODULE$;

    static {
        new Encoders$();
    }

    public Encoder<Boolean> BOOLEAN() {
        return AgnosticEncoders.BoxedBooleanEncoder$.MODULE$;
    }

    public Encoder<Byte> BYTE() {
        return AgnosticEncoders.BoxedByteEncoder$.MODULE$;
    }

    public Encoder<Short> SHORT() {
        return AgnosticEncoders.BoxedShortEncoder$.MODULE$;
    }

    public Encoder<Integer> INT() {
        return AgnosticEncoders.BoxedIntEncoder$.MODULE$;
    }

    public Encoder<Long> LONG() {
        return AgnosticEncoders.BoxedLongEncoder$.MODULE$;
    }

    public Encoder<Float> FLOAT() {
        return AgnosticEncoders.BoxedFloatEncoder$.MODULE$;
    }

    public Encoder<Double> DOUBLE() {
        return AgnosticEncoders.BoxedDoubleEncoder$.MODULE$;
    }

    public Encoder<String> STRING() {
        return AgnosticEncoders.StringEncoder$.MODULE$;
    }

    public Encoder<BigDecimal> DECIMAL() {
        return AgnosticEncoders$.MODULE$.DEFAULT_JAVA_DECIMAL_ENCODER();
    }

    public Encoder<Date> DATE() {
        return new AgnosticEncoders.DateEncoder(false);
    }

    public Encoder<LocalDate> LOCALDATE() {
        return AgnosticEncoders$.MODULE$.STRICT_LOCAL_DATE_ENCODER();
    }

    public Encoder<LocalDateTime> LOCALDATETIME() {
        return AgnosticEncoders.LocalDateTimeEncoder$.MODULE$;
    }

    public Encoder<Timestamp> TIMESTAMP() {
        return AgnosticEncoders$.MODULE$.STRICT_TIMESTAMP_ENCODER();
    }

    public Encoder<Instant> INSTANT() {
        return AgnosticEncoders$.MODULE$.STRICT_INSTANT_ENCODER();
    }

    public Encoder<byte[]> BINARY() {
        return AgnosticEncoders.BinaryEncoder$.MODULE$;
    }

    public Encoder<Duration> DURATION() {
        return AgnosticEncoders.DayTimeIntervalEncoder$.MODULE$;
    }

    public Encoder<Period> PERIOD() {
        return AgnosticEncoders.YearMonthIntervalEncoder$.MODULE$;
    }

    public <T> Encoder<T> bean(Class<T> beanClass) {
        return JavaTypeInference$.MODULE$.encoderFor(beanClass);
    }

    public Encoder<Row> row(StructType schema) {
        return RowEncoder$.MODULE$.encoderFor(schema);
    }

    private <T> Encoder<T> tupleEncoder(Seq<Encoder<?>> encoders) {
        return AgnosticEncoders.ProductEncoder$.MODULE$.tuple(encoders);
    }

    public <T1, T2> Encoder<Tuple2<T1, T2>> tuple(Encoder<T1> e1, Encoder<T2> e2) {
        return this.tupleEncoder((Seq<Encoder<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Encoder[]{e1, e2}));
    }

    public <T1, T2, T3> Encoder<Tuple3<T1, T2, T3>> tuple(Encoder<T1> e1, Encoder<T2> e2, Encoder<T3> e3) {
        return this.tupleEncoder((Seq<Encoder<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Encoder[]{e1, e2, e3}));
    }

    public <T1, T2, T3, T4> Encoder<Tuple4<T1, T2, T3, T4>> tuple(Encoder<T1> e1, Encoder<T2> e2, Encoder<T3> e3, Encoder<T4> e4) {
        return this.tupleEncoder((Seq<Encoder<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Encoder[]{e1, e2, e3, e4}));
    }

    public <T1, T2, T3, T4, T5> Encoder<Tuple5<T1, T2, T3, T4, T5>> tuple(Encoder<T1> e1, Encoder<T2> e2, Encoder<T3> e3, Encoder<T4> e4, Encoder<T5> e5) {
        return this.tupleEncoder((Seq<Encoder<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Encoder[]{e1, e2, e3, e4, e5}));
    }

    public <T extends Product> Encoder<T> product(TypeTags.TypeTag<T> evidence$1) {
        return ScalaReflection$.MODULE$.encoderFor(evidence$1);
    }

    public Encoder<Object> scalaInt() {
        return AgnosticEncoders.PrimitiveIntEncoder$.MODULE$;
    }

    public Encoder<Object> scalaLong() {
        return AgnosticEncoders.PrimitiveLongEncoder$.MODULE$;
    }

    public Encoder<Object> scalaDouble() {
        return AgnosticEncoders.PrimitiveDoubleEncoder$.MODULE$;
    }

    public Encoder<Object> scalaFloat() {
        return AgnosticEncoders.PrimitiveFloatEncoder$.MODULE$;
    }

    public Encoder<Object> scalaByte() {
        return AgnosticEncoders.PrimitiveByteEncoder$.MODULE$;
    }

    public Encoder<Object> scalaShort() {
        return AgnosticEncoders.PrimitiveShortEncoder$.MODULE$;
    }

    public Encoder<Object> scalaBoolean() {
        return AgnosticEncoders.PrimitiveBooleanEncoder$.MODULE$;
    }

    private Encoders$() {
        MODULE$ = this;
    }
}

