/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.spark.annotation.Stable;
import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.WriteOperation;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Stable
@ScalaSignature(bytes="\u0006\u0001\tEd\u0001\u0002\u00192\u0005iB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\u0007%\u0002!\t!M*\t\u000bY\u0003A\u0011A,\t\u000bY\u0003A\u0011A/\t\u000b)\u0004A\u0011A6\t\u000b9\u0004A\u0011A8\t\u000b9\u0004A\u0011\u0001;\t\u000b9\u0004A\u0011\u0001>\t\r9\u0004A\u0011AA\u0001\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!!\u0004\u0001\t\u0003\ty\u0002C\u0004\u00022\u0001!\t!a\r\t\u000f\u00055\u0003\u0001\"\u0001\u0002P!9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0004bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003[\u0002A\u0011AA>\u0011\u001d\ti\b\u0001C\u0005\u0003\u007fBq!!#\u0001\t\u0013\tY\tC\u0004\u00024\u0002!\t!!.\t\u000f\u0005m\u0006\u0001\"\u0001\u0002>\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0007bBAl\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0003;\u0004A\u0011AAp\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003KDq!!;\u0001\t\u0003\tY\u000fC\u0004\u0002p\u0002!\t!!=\t\u00115\u0004\u0001\u0019!C\u0005\u0003kD\u0011\"a>\u0001\u0001\u0004%I!!?\t\u0011\u0005}\b\u0001)Q\u0005\u0003\u0007C\u0001B\u0016\u0001A\u0002\u0013%!\u0011\u0001\u0005\n\u0005\u0007\u0001\u0001\u0019!C\u0005\u0005\u000bAqA!\u0003\u0001A\u0003&!\fC\u0005\u0003\f\u0001\u0001\r\u0011\"\u0003\u0003\u000e!I!Q\u0004\u0001A\u0002\u0013%!q\u0004\u0005\t\u0005G\u0001\u0001\u0015)\u0003\u0003\u0010!I!Q\u0005\u0001A\u0002\u0013%!q\u0005\u0005\n\u0005{\u0001\u0001\u0019!C\u0005\u0005\u007fA\u0001Ba\u0011\u0001A\u0003&!\u0011\u0006\u0005\n\u0005\u000b\u0002\u0001\u0019!C\u0005\u0005OA\u0011Ba\u0012\u0001\u0001\u0004%IA!\u0013\t\u0011\t5\u0003\u0001)Q\u0005\u0005SA\u0011\"a\u0015\u0001\u0001\u0004%IAa\u0014\t\u0013\tM\u0003\u00011A\u0005\n\tU\u0003\u0002\u0003B-\u0001\u0001\u0006KA!\u0015\t\u0013\tm\u0003\u00011A\u0005\n\t\u001d\u0002\"\u0003B/\u0001\u0001\u0007I\u0011\u0002B0\u0011!\u0011\u0019\u0007\u0001Q!\n\t%\"a\u0004#bi\u00064%/Y7f/JLG/\u001a:\u000b\u0005I\u001a\u0014aA:rY*\u0011A'N\u0001\u0006gB\f'o\u001b\u0006\u0003m]\na!\u00199bG\",'\"\u0001\u001d\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005mJ5C\u0001\u0001=!\ti\u0004)D\u0001?\u0015\u0005y\u0014!B:dC2\f\u0017BA!?\u0005\u0019\te.\u001f*fM\u0006\u0011Am\u001d\t\u0004\t\u0016;U\"A\u0019\n\u0005\u0019\u000b$a\u0002#bi\u0006\u001cX\r\u001e\t\u0003\u0011&c\u0001\u0001B\u0003K\u0001\t\u00071JA\u0001U#\tau\n\u0005\u0002>\u001b&\u0011aJ\u0010\u0002\b\u001d>$\b.\u001b8h!\ti\u0004+\u0003\u0002R}\t\u0019\u0011I\\=\u0002\rqJg.\u001b;?)\t!V\u000bE\u0002E\u0001\u001dCQA\u0011\u0002A\u0002\r\u000bA!\\8eKR\u0011A\u000b\u0017\u0005\u00063\u000e\u0001\rAW\u0001\tg\u00064X-T8eKB\u0011AiW\u0005\u00039F\u0012\u0001bU1wK6{G-\u001a\u000b\u0003)zCQ!\u0017\u0003A\u0002}\u0003\"\u0001Y4\u000f\u0005\u0005,\u0007C\u00012?\u001b\u0005\u0019'B\u00013:\u0003\u0019a$o\\8u}%\u0011aMP\u0001\u0007!J,G-\u001a4\n\u0005!L'AB*ue&twM\u0003\u0002g}\u00051am\u001c:nCR$\"\u0001\u00167\t\u000b5,\u0001\u0019A0\u0002\rM|WO]2f\u0003\u0019y\u0007\u000f^5p]R\u0019A\u000b\u001d:\t\u000bE4\u0001\u0019A0\u0002\u0007-,\u0017\u0010C\u0003t\r\u0001\u0007q,A\u0003wC2,X\rF\u0002UkZDQ!]\u0004A\u0002}CQa]\u0004A\u0002]\u0004\"!\u0010=\n\u0005et$a\u0002\"p_2,\u0017M\u001c\u000b\u0004)nd\b\"B9\t\u0001\u0004y\u0006\"B:\t\u0001\u0004i\bCA\u001f\u007f\u0013\tyhH\u0001\u0003M_:<G#\u0002+\u0002\u0004\u0005\u0015\u0001\"B9\n\u0001\u0004y\u0006BB:\n\u0001\u0004\t9\u0001E\u0002>\u0003\u0013I1!a\u0003?\u0005\u0019!u.\u001e2mK\u00069q\u000e\u001d;j_:\u001cHc\u0001+\u0002\u0012!9\u0011Q\u0002\u0006A\u0002\u0005M\u0001CBA\u000b\u00037yv,\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0004 \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001e\u0005]!aA'baR\u0019A+!\t\t\u000f\u000551\u00021\u0001\u0002$A1\u0011QEA\u0018?~k!!a\n\u000b\t\u0005%\u00121F\u0001\u0005kRLGN\u0003\u0002\u0002.\u0005!!.\u0019<b\u0013\u0011\ti\"a\n\u0002\u0017A\f'\u000f^5uS>t')\u001f\u000b\u0004)\u0006U\u0002bBA\u001c\u0019\u0001\u0007\u0011\u0011H\u0001\tG>dg*Y7fgB!Q(a\u000f`\u0013\r\tiD\u0010\u0002\u000byI,\u0007/Z1uK\u0012t\u0004f\u0001\u0007\u0002BA!\u00111IA%\u001b\t\t)EC\u0002\u0002Hy\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY%!\u0012\u0003\u000fY\f'/\u0019:hg\u0006A!-^2lKR\u0014\u0015\u0010F\u0004U\u0003#\nY&a\u0018\t\u000f\u0005MS\u00021\u0001\u0002V\u0005Qa.^7Ck\u000e\\W\r^:\u0011\u0007u\n9&C\u0002\u0002Zy\u00121!\u00138u\u0011\u0019\ti&\u0004a\u0001?\u000691m\u001c7OC6,\u0007bBA\u001c\u001b\u0001\u0007\u0011\u0011\b\u0015\u0004\u001b\u0005\u0005\u0013AB:peR\u0014\u0015\u0010F\u0003U\u0003O\nI\u0007\u0003\u0004\u0002^9\u0001\ra\u0018\u0005\b\u0003oq\u0001\u0019AA\u001dQ\rq\u0011\u0011I\u0001\u0005g\u00064X\r\u0006\u0003\u0002r\u0005]\u0004cA\u001f\u0002t%\u0019\u0011Q\u000f \u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003sz\u0001\u0019A0\u0002\tA\fG\u000f\u001b\u000b\u0003\u0003c\nAb]1wK&sG/\u001a:oC2$B!!\u001d\u0002\u0002\"9\u0011\u0011P\tA\u0002\u0005\r\u0005\u0003B\u001f\u0002\u0006~K1!a\"?\u0005\u0019y\u0005\u000f^5p]\u0006)R\r_3dkR,wK]5uK>\u0003XM]1uS>tG\u0003BA9\u0003\u001bCq!a$\u0013\u0001\u0004\t\t*A\u0001g!\u001di\u00141SAL\u0003cJ1!!&?\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002\u001a\u00065f\u0002BAN\u0003OsA!!(\u0002$6\u0011\u0011q\u0014\u0006\u0004\u0003C\u001b\u0014aB2p]:,7\r^\u0005\u0005\u0003K\u000by*A\u0003qe>$x.\u0003\u0003\u0002*\u0006-\u0016AD,sSR,w\n]3sCRLwN\u001c\u0006\u0005\u0003K\u000by*\u0003\u0003\u00020\u0006E&a\u0002\"vS2$WM\u001d\u0006\u0005\u0003S\u000bY+\u0001\u0006j]N,'\u000f^%oi>$B!!\u001d\u00028\"1\u0011\u0011X\nA\u0002}\u000b\u0011\u0002^1cY\u0016t\u0015-\\3\u0002\u0017M\fg/Z!t)\u0006\u0014G.\u001a\u000b\u0005\u0003c\ny\f\u0003\u0004\u0002:R\u0001\raX\u0001\u0005U\u0012\u00147\r\u0006\u0005\u0002r\u0005\u0015\u0017\u0011ZAg\u0011\u0019\t9-\u0006a\u0001?\u0006\u0019QO\u001d7\t\r\u0005-W\u00031\u0001`\u0003\u0015!\u0018M\u00197f\u0011\u001d\ty-\u0006a\u0001\u0003#\fAcY8o]\u0016\u001cG/[8o!J|\u0007/\u001a:uS\u0016\u001c\b\u0003BA\u0013\u0003'LA!!6\u0002(\tQ\u0001K]8qKJ$\u0018.Z:\u0002\t)\u001cxN\u001c\u000b\u0005\u0003c\nY\u000e\u0003\u0004\u0002zY\u0001\raX\u0001\ba\u0006\u0014\u0018/^3u)\u0011\t\t(!9\t\r\u0005et\u00031\u0001`\u0003\ry'o\u0019\u000b\u0005\u0003c\n9\u000f\u0003\u0004\u0002za\u0001\raX\u0001\u0005i\u0016DH\u000f\u0006\u0003\u0002r\u00055\bBBA=3\u0001\u0007q,A\u0002dgZ$B!!\u001d\u0002t\"1\u0011\u0011\u0010\u000eA\u0002}+\"!a!\u0002\u0015M|WO]2f?\u0012*\u0017\u000f\u0006\u0003\u0002r\u0005m\b\"CA\u007f9\u0005\u0005\t\u0019AAB\u0003\rAH%M\u0001\bg>,(oY3!+\u0005Q\u0016\u0001C7pI\u0016|F%Z9\u0015\t\u0005E$q\u0001\u0005\t\u0003{|\u0012\u0011!a\u00015\u0006)Qn\u001c3fA\u0005aQ\r\u001f;sC>\u0003H/[8ogV\u0011!q\u0002\t\u0006\u0005#\u0011IbX\u0007\u0003\u0005'QA!!\u000b\u0003\u0016)\u0019!qC\u0019\u0002\u0011\r\fG/\u00197zgRLAAa\u0007\u0003\u0014\t\u00112)Y:f\u0013:\u001cXM\\:ji&4X-T1q\u0003A)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u0002r\t\u0005\u0002\"CA\u007fE\u0005\u0005\t\u0019\u0001B\b\u00035)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8tA\u0005\u0019\u0002/\u0019:uSRLwN\\5oO\u000e{G.^7ogV\u0011!\u0011\u0006\t\u0006{\u0005\u0015%1\u0006\t\u0006\u0005[\u00119d\u0018\b\u0005\u0005_\u0011\u0019DD\u0002c\u0005cI\u0011aP\u0005\u0004\u0005kq\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005s\u0011YDA\u0002TKFT1A!\u000e?\u0003]\u0001\u0018M\u001d;ji&|g.\u001b8h\u0007>dW/\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u0002r\t\u0005\u0003\"CA\u007fK\u0005\u0005\t\u0019\u0001B\u0015\u0003Q\u0001\u0018M\u001d;ji&|g.\u001b8h\u0007>dW/\u001c8tA\u0005\t\"-^2lKR\u001cu\u000e\\;n]:\u000bW.Z:\u0002+\t,8m[3u\u0007>dW/\u001c8OC6,7o\u0018\u0013fcR!\u0011\u0011\u000fB&\u0011%\ti\u0010KA\u0001\u0002\u0004\u0011I#\u0001\nck\u000e\\W\r^\"pYVlgNT1nKN\u0004SC\u0001B)!\u0015i\u0014QQA+\u00039qW/\u001c\"vG.,Go]0%KF$B!!\u001d\u0003X!I\u0011Q`\u0016\u0002\u0002\u0003\u0007!\u0011K\u0001\f]Vl')^2lKR\u001c\b%A\bt_J$8i\u001c7v[:t\u0015-\\3t\u0003M\u0019xN\u001d;D_2,XN\u001c(b[\u0016\u001cx\fJ3r)\u0011\t\tH!\u0019\t\u0013\u0005uh&!AA\u0002\t%\u0012\u0001E:peR\u001cu\u000e\\;n]:\u000bW.Z:!Q\r\u0001!q\r\t\u0005\u0005S\u0012i'\u0004\u0002\u0003l)\u0019\u0011qI\u001a\n\t\t=$1\u000e\u0002\u0007'R\f'\r\\3")
public final class DataFrameWriter<T> {
    private final Dataset<T> ds;
    private Option<String> source;
    private SaveMode mode;
    private CaseInsensitiveMap<String> extraOptions;
    private Option<Seq<String>> partitioningColumns;
    private Option<Seq<String>> bucketColumnNames;
    private Option<Object> numBuckets;
    private Option<Seq<String>> sortColumnNames;

    public DataFrameWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, String ... colNames) {
        return this.bucketBy(numBuckets, colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> sortBy(String colName, String ... colNames) {
        return this.sortBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> mode(SaveMode saveMode) {
        this.mode_$eq(saveMode);
        return this;
    }

    public DataFrameWriter<T> mode(String saveMode) {
        DataFrameWriter<T> dataFrameWriter;
        String string = saveMode.toLowerCase(Locale.ROOT);
        if ("overwrite".equals(string)) {
            dataFrameWriter = this.mode(SaveMode.Overwrite);
        } else if ("append".equals(string)) {
            dataFrameWriter = this.mode(SaveMode.Append);
        } else if ("ignore".equals(string)) {
            dataFrameWriter = this.mode(SaveMode.Ignore);
        } else {
            boolean bl = "error".equals(string) ? true : ("errorifexists".equals(string) ? true : "default".equals(string));
            if (bl) {
                dataFrameWriter = this.mode(SaveMode.ErrorIfExists);
            } else {
                throw new IllegalArgumentException(new StringBuilder(114).append("Unknown save mode: ").append(saveMode).append(". Accepted ").append("save modes are 'overwrite', 'append', 'ignore', 'error', 'errorifexists', 'default'.").toString());
            }
        }
        return dataFrameWriter;
    }

    public DataFrameWriter<T> format(String source) {
        this.source_$eq((Option<String>)new Some((Object)source));
        return this;
    }

    public DataFrameWriter<T> option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataFrameWriter<T> option(String key, boolean value) {
        return this.option(key, Boolean.toString(value));
    }

    public DataFrameWriter<T> option(String key, long value) {
        return this.option(key, Long.toString(value));
    }

    public DataFrameWriter<T> option(String key, double value) {
        return this.option(key, Double.toString(value));
    }

    public DataFrameWriter<T> options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataFrameWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public DataFrameWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, Seq<String> colNames) {
        Predef$.MODULE$.require(numBuckets > 0, (Function0 & Serializable & scala.Serializable)() -> "The numBuckets should be > 0.");
        this.numBuckets_$eq((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numBuckets)));
        String string = colName;
        this.bucketColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public DataFrameWriter<T> sortBy(String colName, Seq<String> colNames) {
        String string = colName;
        this.sortColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public void save(String path) {
        this.saveInternal((Option<String>)new Some((Object)path));
    }

    public void save() {
        this.saveInternal((Option<String>)None$.MODULE$);
    }

    private void saveInternal(Option<String> path) {
        this.executeWriteOperation((Function1<WriteOperation.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)builder -> {
            path.foreach((Function1 & Serializable & scala.Serializable)value -> builder.setPath((String)value));
            return BoxedUnit.UNIT;
        });
    }

    private void executeWriteOperation(Function1<WriteOperation.Builder, BoxedUnit> f) {
        WriteOperation.SaveMode saveMode;
        WriteOperation.Builder builder = WriteOperation.newBuilder();
        builder.setInput(this.ds.plan().getRoot());
        f.apply((Object)builder);
        Predef$.MODULE$.require(!builder.hasPath() || !builder.hasTable());
        SaveMode saveMode2 = this.mode();
        if (SaveMode.Append.equals(saveMode2)) {
            saveMode = WriteOperation.SaveMode.SAVE_MODE_APPEND;
        } else if (SaveMode.Overwrite.equals(saveMode2)) {
            saveMode = WriteOperation.SaveMode.SAVE_MODE_OVERWRITE;
        } else if (SaveMode.Ignore.equals(saveMode2)) {
            saveMode = WriteOperation.SaveMode.SAVE_MODE_IGNORE;
        } else if (SaveMode.ErrorIfExists.equals(saveMode2)) {
            saveMode = WriteOperation.SaveMode.SAVE_MODE_ERROR_IF_EXISTS;
        } else {
            throw new MatchError((Object)saveMode2);
        }
        builder.setMode(saveMode);
        this.source().foreach((Function1 & Serializable & scala.Serializable)value -> builder.setSource((String)value));
        this.sortColumnNames().foreach((Function1 & Serializable & scala.Serializable)names -> builder.addAllSortColumnNames((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(names).asJava()));
        this.partitioningColumns().foreach((Function1 & Serializable & scala.Serializable)cols -> builder.addAllPartitioningColumns((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(cols).asJava()));
        this.numBuckets().foreach((Function1 & Serializable & scala.Serializable)n -> DataFrameWriter.$anonfun$executeWriteOperation$4(this, builder, BoxesRunTime.unboxToInt((Object)n)));
        this.extraOptions().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            WriteOperation.Builder builder = builder.putOptions(k, v);
            return builder;
        });
        this.ds.sparkSession().execute(Command.newBuilder().setWriteOperation(builder).build());
    }

    public void insertInto(String tableName) {
        this.executeWriteOperation((Function1<WriteOperation.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)builder -> {
            builder.setTable(WriteOperation.SaveTable.newBuilder().setTableName(tableName).setSaveMethod(WriteOperation.SaveTable.TableSaveMethod.TABLE_SAVE_METHOD_INSERT_INTO));
            return BoxedUnit.UNIT;
        });
    }

    public void saveAsTable(String tableName) {
        this.executeWriteOperation((Function1<WriteOperation.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)builder -> {
            builder.setTable(WriteOperation.SaveTable.newBuilder().setTableName(tableName).setSaveMethod(WriteOperation.SaveTable.TableSaveMethod.TABLE_SAVE_METHOD_SAVE_AS_TABLE));
            return BoxedUnit.UNIT;
        });
    }

    public void jdbc(String url, String table, Properties connectionProperties) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala()));
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)url), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)table), (List)Nil$.MODULE$))));
        this.format("jdbc").save();
    }

    public void json(String path) {
        this.format("json").save(path);
    }

    public void parquet(String path) {
        this.format("parquet").save(path);
    }

    public void orc(String path) {
        this.format("orc").save(path);
    }

    public void text(String path) {
        this.format("text").save(path);
    }

    public void csv(String path) {
        this.format("csv").save(path);
    }

    private Option<String> source() {
        return this.source;
    }

    private void source_$eq(Option<String> x$1) {
        this.source = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private Option<Seq<String>> bucketColumnNames() {
        return this.bucketColumnNames;
    }

    private void bucketColumnNames_$eq(Option<Seq<String>> x$1) {
        this.bucketColumnNames = x$1;
    }

    private Option<Object> numBuckets() {
        return this.numBuckets;
    }

    private void numBuckets_$eq(Option<Object> x$1) {
        this.numBuckets = x$1;
    }

    private Option<Seq<String>> sortColumnNames() {
        return this.sortColumnNames;
    }

    private void sortColumnNames_$eq(Option<Seq<String>> x$1) {
        this.sortColumnNames = x$1;
    }

    public static final /* synthetic */ WriteOperation.Builder $anonfun$executeWriteOperation$4(DataFrameWriter $this, WriteOperation.Builder builder$2, int n) {
        WriteOperation.BucketBy.Builder bucketBuilder = WriteOperation.BucketBy.newBuilder();
        bucketBuilder.setNumBuckets(n);
        $this.bucketColumnNames().foreach((Function1 & Serializable & scala.Serializable)names -> bucketBuilder.addAllBucketColumnNames((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(names).asJava()));
        return builder$2.setBucketBy(bucketBuilder);
    }

    public DataFrameWriter(Dataset<T> ds) {
        this.ds = ds;
        this.source = None$.MODULE$;
        this.mode = SaveMode.ErrorIfExists;
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
        this.partitioningColumns = None$.MODULE$;
        this.bucketColumnNames = None$.MODULE$;
        this.numBuckets = None$.MODULE$;
        this.sortColumnNames = None$.MODULE$;
    }
}

