/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.connect.proto.StatApproxQuantile;
import org.apache.spark.connect.proto.StatFreqItems;
import org.apache.spark.connect.proto.StatSampleBy;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.DataFrameStatFunctions$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.functions$;
import org.apache.spark.util.sketch.CountMinSketch;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tua\u0001B\u000e\u001d\u0005\u0015B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!1!\b\u0001C\u00019mBQa\u0010\u0001\u0005\u0002\u0001CQa\u0010\u0001\u0005\u0002aCQa\u0018\u0001\u0005\u0002\u0001DQ!\u001a\u0001\u0005\u0002\u0019DQ!\u001a\u0001\u0005\u0002-DQA\u001c\u0001\u0005\u0002=DQ!\u001f\u0001\u0005\u0002iDQ!\u001f\u0001\u0005\u0002yDa!\u001f\u0001\u0005\u0002\u0005\u0005\u0001BB=\u0001\t\u0003\t9\u0002C\u0004\u0002\u001c\u0001!\t!!\b\t\u000f\u0005m\u0001\u0001\"\u0001\u0002N!9\u00111\u0004\u0001\u0005\u0002\u0005M\u0004bBA\u000e\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u00033\u0003A\u0011AAN\u0011\u001d\tI\n\u0001C\u0001\u0003\u007fCq!!'\u0001\t\u0003\ti\rC\u0004\u0002\u001a\u0002!\t!a6\b\u000f\u0005\u0005H\u0004#\u0003\u0002d\u001a11\u0004\bE\u0005\u0003KDaAO\f\u0005\u0002\u0005\u001d\b\"CAu/\t\u0007I\u0011BAv\u0011!\u0011Yb\u0006Q\u0001\n\u00055(A\u0006#bi\u00064%/Y7f'R\fGOR;oGRLwN\\:\u000b\u0005uq\u0012aA:rY*\u0011q\u0004I\u0001\u0006gB\f'o\u001b\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g-\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002/_5\tA$\u0003\u000219\ta1\u000b]1sWN+7o]5p]\u0006!!o\\8u!\t\u0019\u0004(D\u00015\u0015\t)d'A\u0003qe>$xN\u0003\u00028=\u000591m\u001c8oK\u000e$\u0018BA\u001d5\u0005!\u0011V\r\\1uS>t\u0017A\u0002\u001fj]&$h\bF\u0002={y\u0002\"A\f\u0001\t\u000b1\u001a\u0001\u0019A\u0017\t\u000bE\u001a\u0001\u0019\u0001\u001a\u0002\u001d\u0005\u0004\bO]8y#V\fg\u000e^5mKR!\u0011i\u0012+W!\r9#\tR\u0005\u0003\u0007\"\u0012Q!\u0011:sCf\u0004\"aJ#\n\u0005\u0019C#A\u0002#pk\ndW\rC\u0003I\t\u0001\u0007\u0011*A\u0002d_2\u0004\"AS)\u000f\u0005-{\u0005C\u0001')\u001b\u0005i%B\u0001(%\u0003\u0019a$o\\8u}%\u0011\u0001\u000bK\u0001\u0007!J,G-\u001a4\n\u0005I\u001b&AB*ue&twM\u0003\u0002QQ!)Q\u000b\u0002a\u0001\u0003\u0006i\u0001O]8cC\nLG.\u001b;jKNDQa\u0016\u0003A\u0002\u0011\u000bQB]3mCRLg/Z#se>\u0014H\u0003B-[;z\u00032a\n\"B\u0011\u0015YV\u00011\u0001]\u0003\u0011\u0019w\u000e\\:\u0011\u0007\u001d\u0012\u0015\nC\u0003V\u000b\u0001\u0007\u0011\tC\u0003X\u000b\u0001\u0007A)A\u0002d_Z$2\u0001R1d\u0011\u0015\u0011g\u00011\u0001J\u0003\u0011\u0019w\u000e\\\u0019\t\u000b\u00114\u0001\u0019A%\u0002\t\r|GNM\u0001\u0005G>\u0014(\u000f\u0006\u0003EO\"L\u0007\"\u00022\b\u0001\u0004I\u0005\"\u00023\b\u0001\u0004I\u0005\"\u00026\b\u0001\u0004I\u0015AB7fi\"|G\rF\u0002EY6DQA\u0019\u0005A\u0002%CQ\u0001\u001a\u0005A\u0002%\u000b\u0001b\u0019:pgN$\u0018M\u0019\u000b\u0004a^D\bCA9u\u001d\tq#/\u0003\u0002t9\u00059\u0001/Y2lC\u001e,\u0017BA;w\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002t9!)!-\u0003a\u0001\u0013\")A-\u0003a\u0001\u0013\u0006IaM]3r\u0013R,Wn\u001d\u000b\u0004and\b\"B.\u000b\u0001\u0004a\u0006\"B?\u000b\u0001\u0004!\u0015aB:vaB|'\u000f\u001e\u000b\u0003a~DQaW\u0006A\u0002q#R\u0001]A\u0002\u0003+Aaa\u0017\u0007A\u0002\u0005\u0015\u0001#BA\u0004\u0003\u001fIe\u0002BA\u0005\u0003\u001bq1\u0001TA\u0006\u0013\u0005I\u0013BA:)\u0013\u0011\t\t\"a\u0005\u0003\u0007M+\u0017O\u0003\u0002tQ!)Q\u0010\u0004a\u0001\tR\u0019\u0001/!\u0007\t\rmk\u0001\u0019AA\u0003\u0003!\u0019\u0018-\u001c9mK\nKX\u0003BA\u0010\u0003c!r\u0001]A\u0011\u0003G\t\u0019\u0005C\u0003I\u001d\u0001\u0007\u0011\nC\u0004\u0002&9\u0001\r!a\n\u0002\u0013\u0019\u0014\u0018m\u0019;j_:\u001c\bC\u0002&\u0002*\u00055B)C\u0002\u0002,M\u00131!T1q!\u0011\ty#!\r\r\u0001\u00119\u00111\u0007\bC\u0002\u0005U\"!\u0001+\u0012\t\u0005]\u0012Q\b\t\u0004O\u0005e\u0012bAA\u001eQ\t9aj\u001c;iS:<\u0007cA\u0014\u0002@%\u0019\u0011\u0011\t\u0015\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002F9\u0001\r!a\u0012\u0002\tM,W\r\u001a\t\u0004O\u0005%\u0013bAA&Q\t!Aj\u001c8h+\u0011\ty%!\u001a\u0015\u000fA\f\t&a\u0015\u0002r!)\u0001j\u0004a\u0001\u0013\"9\u0011QE\bA\u0002\u0005U\u0003\u0003CA,\u0003C\n\u0019'a\u001a\u000e\u0005\u0005e#\u0002BA.\u0003;\nA!\u001e;jY*\u0011\u0011qL\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002,\u0005e\u0003\u0003BA\u0018\u0003K\"q!a\r\u0010\u0005\u0004\t)\u0004\u0005\u0003\u0002j\u0005=TBAA6\u0015\u0011\ti'!\u0018\u0002\t1\fgnZ\u0005\u0004\r\u0006-\u0004bBA#\u001f\u0001\u0007\u0011qI\u000b\u0005\u0003k\n)\tF\u0004q\u0003o\ny(a\"\t\r!\u0003\u0002\u0019AA=!\rq\u00131P\u0005\u0004\u0003{b\"AB\"pYVlg\u000eC\u0004\u0002&A\u0001\r!!!\u0011\r)\u000bI#a!E!\u0011\ty#!\"\u0005\u000f\u0005M\u0002C1\u0001\u00026!9\u0011Q\t\tA\u0002\u0005\u001dS\u0003BAF\u0003+#r\u0001]AG\u0003\u001f\u000b9\n\u0003\u0004I#\u0001\u0007\u0011\u0011\u0010\u0005\b\u0003K\t\u0002\u0019AAI!!\t9&!\u0019\u0002\u0014\u0006\u001d\u0004\u0003BA\u0018\u0003+#q!a\r\u0012\u0005\u0004\t)\u0004C\u0004\u0002FE\u0001\r!a\u0012\u0002\u001d\r|WO\u001c;NS:\u001c6.\u001a;dQRQ\u0011QTAV\u0003_\u000bI,!0\u0011\t\u0005}\u0015qU\u0007\u0003\u0003CSA!a)\u0002&\u000611o[3uG\"T1!a\u0017\u001f\u0013\u0011\tI+!)\u0003\u001d\r{WO\u001c;NS:\u001c6.\u001a;dQ\"1\u0011Q\u0016\nA\u0002%\u000bqaY8m\u001d\u0006lW\rC\u0004\u00022J\u0001\r!a-\u0002\u000b\u0011,\u0007\u000f\u001e5\u0011\u0007\u001d\n),C\u0002\u00028\"\u00121!\u00138u\u0011\u001d\tYL\u0005a\u0001\u0003g\u000bQa^5ei\"Dq!!\u0012\u0013\u0001\u0004\t\u0019\f\u0006\u0006\u0002\u001e\u0006\u0005\u00171YAd\u0003\u0017Da!!,\u0014\u0001\u0004I\u0005BBAc'\u0001\u0007A)A\u0002faNDa!!3\u0014\u0001\u0004!\u0015AC2p]\u001aLG-\u001a8dK\"9\u0011QI\nA\u0002\u0005MFCCAO\u0003\u001f\f\t.a5\u0002V\"1\u0001\n\u0006a\u0001\u0003sBq!!-\u0015\u0001\u0004\t\u0019\fC\u0004\u0002<R\u0001\r!a-\t\u000f\u0005\u0015C\u00031\u0001\u00024RQ\u0011QTAm\u00037\fi.a8\t\r!+\u0002\u0019AA=\u0011\u0019\t)-\u0006a\u0001\t\"1\u0011\u0011Z\u000bA\u0002\u0011Cq!!\u0012\u0016\u0001\u0004\t\u0019,\u0001\fECR\fgI]1nKN#\u0018\r\u001e$v]\u000e$\u0018n\u001c8t!\tqsc\u0005\u0002\u0018MQ\u0011\u00111]\u0001\u001cCB\u0004(o\u001c=Rk\u0006tG/\u001b7f%\u0016\u001cX\u000f\u001c;F]\u000e|G-\u001a:\u0016\u0005\u00055\b#BAx\u0005+\te\u0002BAy\u0005\u001fqA!a=\u0003\n9!\u0011Q\u001fB\u0003\u001d\u0011\t9Pa\u0001\u000f\t\u0005e(\u0011\u0001\b\u0005\u0003w\fyPD\u0002M\u0003{L\u0011aI\u0005\u0003C\tJ!a\b\u0011\n\u0005uq\u0012b\u0001B\u00049\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0003\f\t5\u0011\u0001C3oG>$WM]:\u000b\u0007\t\u001dA$\u0003\u0003\u0003\u0012\tM\u0011\u0001E!h]>\u001cH/[2F]\u000e|G-\u001a:t\u0015\u0011\u0011YA!\u0004\n\t\t]!\u0011\u0004\u0002\r\u0003J\u0014\u0018-_#oG>$WM\u001d\u0006\u0005\u0005#\u0011\u0019\"\u0001\u000fbaB\u0014x\u000e_)vC:$\u0018\u000e\\3SKN,H\u000e^#oG>$WM\u001d\u0011")
public final class DataFrameStatFunctions {
    private final SparkSession sparkSession;
    private final Relation root;

    public double[] approxQuantile(String col, double[] probabilities, double relativeError) {
        return (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.approxQuantile((String[])((Object[])new String[]{col}), probabilities, relativeError))).head();
    }

    public double[][] approxQuantile(String[] cols, double[] probabilities, double relativeError) {
        Predef$.MODULE$.require(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(probabilities)).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)p -> p >= 0.0 && p <= 1.0), (Function0 & Serializable & scala.Serializable)() -> "percentile should be in the range [0.0, 1.0]");
        Predef$.MODULE$.require(relativeError >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Relative Error must be non-negative but got ").append(relativeError).toString());
        return (double[][])this.sparkSession.newDataset(DataFrameStatFunctions$.MODULE$.org$apache$spark$sql$DataFrameStatFunctions$$approxQuantileResultEncoder(), (Function1<Relation.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)builder -> {
            DataFrameStatFunctions.$anonfun$approxQuantile$4(this, relativeError, cols, probabilities, builder);
            return BoxedUnit.UNIT;
        }).head();
    }

    public double cov(String col1, String col2) {
        return BoxesRunTime.unboxToDouble(this.sparkSession.newDataset(AgnosticEncoders.PrimitiveDoubleEncoder$.MODULE$, (Function1<Relation.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)builder -> {
            DataFrameStatFunctions.$anonfun$cov$1(this, col1, col2, builder);
            return BoxedUnit.UNIT;
        }).head());
    }

    public double corr(String col1, String col2, String method) {
        String string = method;
        String string2 = "pearson";
        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> "Currently only the calculation of the Pearson Correlation coefficient is supported.");
        return BoxesRunTime.unboxToDouble(this.sparkSession.newDataset(AgnosticEncoders.PrimitiveDoubleEncoder$.MODULE$, (Function1<Relation.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)builder -> {
            DataFrameStatFunctions.$anonfun$corr$2(this, col1, col2, builder);
            return BoxedUnit.UNIT;
        }).head());
    }

    public double corr(String col1, String col2) {
        return this.corr(col1, col2, "pearson");
    }

    public Dataset<Row> crosstab(String col1, String col2) {
        return this.sparkSession.newDataFrame((Function1<Relation.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)builder -> {
            DataFrameStatFunctions.$anonfun$crosstab$1(this, col1, col2, builder);
            return BoxedUnit.UNIT;
        });
    }

    public Dataset<Row> freqItems(String[] cols, double support) {
        return this.sparkSession.newDataFrame((Function1<Relation.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)builder -> {
            DataFrameStatFunctions.$anonfun$freqItems$1(this, support, cols, builder);
            return BoxedUnit.UNIT;
        });
    }

    public Dataset<Row> freqItems(String[] cols) {
        return this.freqItems(cols, 0.01);
    }

    public Dataset<Row> freqItems(Seq<String> cols, double support) {
        return this.freqItems((String[])cols.toArray(ClassTag$.MODULE$.apply(String.class)), support);
    }

    public Dataset<Row> freqItems(Seq<String> cols) {
        return this.freqItems((String[])cols.toArray(ClassTag$.MODULE$.apply(String.class)), 0.01);
    }

    public <T> Dataset<Row> sampleBy(String col, Map<T, Object> fractions, long seed) {
        return this.sampleBy(Column$.MODULE$.apply(col), fractions, seed);
    }

    public <T> Dataset<Row> sampleBy(String col, java.util.Map<T, Double> fractions, long seed) {
        return this.sampleBy(col, ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(fractions).asScala()).toMap(Predef$.MODULE$.$conforms()), seed);
    }

    public <T> Dataset<Row> sampleBy(Column col, Map<T, Object> fractions, long seed) {
        Predef$.MODULE$.require(fractions.values().forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)p -> p >= 0.0 && p <= 1.0), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Fractions must be in [0, 1], but got ").append(fractions).append(".").toString());
        return this.sparkSession.newDataFrame((Function1<Relation.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)builder -> {
            DataFrameStatFunctions.$anonfun$sampleBy$3(this, col, seed, fractions, builder);
            return BoxedUnit.UNIT;
        });
    }

    public <T> Dataset<Row> sampleBy(Column col, java.util.Map<T, Double> fractions, long seed) {
        return this.sampleBy(col, ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(fractions).asScala()).toMap(Predef$.MODULE$.$conforms()), seed);
    }

    public CountMinSketch countMinSketch(String colName, int depth, int width, int seed) {
        return this.countMinSketch(Column$.MODULE$.apply(colName), depth, width, seed);
    }

    public CountMinSketch countMinSketch(String colName, double eps, double confidence, int seed) {
        return this.countMinSketch(Column$.MODULE$.apply(colName), eps, confidence, seed);
    }

    public CountMinSketch countMinSketch(Column col, int depth, int width, int seed) {
        return this.countMinSketch(col, 2.0 / (double)width, 1.0 - 1.0 / Math.pow(2.0, depth), seed);
    }

    public CountMinSketch countMinSketch(Column col, double eps, double confidence, int seed) {
        Column agg = Column$.MODULE$.fn("count_min_sketch", (Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{col, functions$.MODULE$.lit(BoxesRunTime.boxToDouble((double)eps)), functions$.MODULE$.lit(BoxesRunTime.boxToDouble((double)confidence)), functions$.MODULE$.lit(BoxesRunTime.boxToInteger((int)seed))}));
        Dataset ds = this.sparkSession.newDataset(AgnosticEncoders.BinaryEncoder$.MODULE$, (Function1<Relation.Builder, BoxedUnit>)(Function1 & Serializable & scala.Serializable)builder -> {
            DataFrameStatFunctions.$anonfun$countMinSketch$1(this, agg, builder);
            return BoxedUnit.UNIT;
        });
        return CountMinSketch.readFrom((byte[])((byte[])ds.head()));
    }

    public static final /* synthetic */ void $anonfun$approxQuantile$4(DataFrameStatFunctions $this, double relativeError$1, String[] cols$1, double[] probabilities$1, Relation.Builder builder) {
        StatApproxQuantile.Builder approxQuantileBuilder = builder.getApproxQuantileBuilder().setInput($this.root).setRelativeError(relativeError$1);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cols$1)).foreach((Function1 & Serializable & scala.Serializable)value -> approxQuantileBuilder.addCols((String)value));
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(probabilities$1)).foreach((Function1 & Serializable & scala.Serializable)value -> approxQuantileBuilder.addProbabilities(BoxesRunTime.unboxToDouble((Object)value)));
    }

    public static final /* synthetic */ void $anonfun$cov$1(DataFrameStatFunctions $this, String col1$1, String col2$1, Relation.Builder builder) {
        builder.getCovBuilder().setInput($this.root).setCol1(col1$1).setCol2(col2$1);
    }

    public static final /* synthetic */ void $anonfun$corr$2(DataFrameStatFunctions $this, String col1$2, String col2$2, Relation.Builder builder) {
        builder.getCorrBuilder().setInput($this.root).setCol1(col1$2).setCol2(col2$2);
    }

    public static final /* synthetic */ void $anonfun$crosstab$1(DataFrameStatFunctions $this, String col1$3, String col2$3, Relation.Builder builder) {
        builder.getCrosstabBuilder().setInput($this.root).setCol1(col1$3).setCol2(col2$3);
    }

    public static final /* synthetic */ void $anonfun$freqItems$1(DataFrameStatFunctions $this, double support$1, String[] cols$2, Relation.Builder builder) {
        StatFreqItems.Builder freqItemsBuilder = builder.getFreqItemsBuilder().setInput($this.root).setSupport(support$1);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cols$2)).foreach((Function1 & Serializable & scala.Serializable)value -> freqItemsBuilder.addCols((String)value));
    }

    public static final /* synthetic */ void $anonfun$sampleBy$3(DataFrameStatFunctions $this, Column col$1, long seed$1, Map fractions$1, Relation.Builder builder) {
        StatSampleBy.Builder sampleByBuilder = builder.getSampleByBuilder().setInput($this.root).setCol(col$1.expr()).setSeed(seed$1);
        fractions$1.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object k = tuple2._1();
            double v = tuple2._2$mcD$sp();
            StatSampleBy.Builder builder = sampleByBuilder.addFractions(StatSampleBy.Fraction.newBuilder().setStratum(functions$.MODULE$.lit(k).expr().getLiteral()).setFraction(v));
            return builder;
        });
    }

    public static final /* synthetic */ void $anonfun$countMinSketch$1(DataFrameStatFunctions $this, Column agg$1, Relation.Builder builder) {
        builder.getProjectBuilder().setInput($this.root).addExpressions(agg$1.expr());
    }

    public DataFrameStatFunctions(SparkSession sparkSession, Relation root) {
        this.sparkSession = sparkSession;
        this.root = root;
    }
}

