/*
 * Decompiled with CFR 0.152.
 */
package io.delta.tables;

import grpc_shaded.com.google.protobuf.Any;
import io.delta.connect.proto.CreateDeltaTable;
import io.delta.connect.proto.DeltaCommand;
import io.delta.tables.DeltaTable;
import io.delta.tables.DeltaTable$;
import io.delta.tables.execution.CreateTableOptions;
import io.delta.tables.execution.DeltaTableBuilderOptions;
import io.delta.tables.execution.ReplaceTableOptions;
import java.io.Serializable;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Evolving
@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001\u0002\u0012$\u0001)B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\t{\u0001\u0011\t\u0011)A\u0005}!1A\t\u0001C\u0001G\u0015CqA\u0013\u0001A\u0002\u0013%1\nC\u0004[\u0001\u0001\u0007I\u0011B.\t\r\u0005\u0004\u0001\u0015)\u0003M\u0011\u001d\u0011\u0007\u00011A\u0005\n\rDq!\u001c\u0001A\u0002\u0013%a\u000e\u0003\u0004q\u0001\u0001\u0006K\u0001\u001a\u0005\bc\u0002\u0001\r\u0011\"\u0003s\u0011%\t\t\u0001\u0001a\u0001\n\u0013\t\u0019\u0001C\u0004\u0002\b\u0001\u0001\u000b\u0015B:\t\u0011\u0005%\u0001\u00011A\u0005\n-C\u0011\"a\u0003\u0001\u0001\u0004%I!!\u0004\t\u000f\u0005E\u0001\u0001)Q\u0005\u0019\"A\u00111\u0003\u0001A\u0002\u0013%1\nC\u0005\u0002\u0016\u0001\u0001\r\u0011\"\u0003\u0002\u0018!9\u00111\u0004\u0001!B\u0013a\u0005\"CA\u000f\u0001\u0001\u0007I\u0011BA\u0010\u0011%\ti\u0003\u0001a\u0001\n\u0013\ty\u0003\u0003\u0005\u00024\u0001\u0001\u000b\u0015BA\u0011\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u0013\u0001\t\u0003\tY\u0005C\u0004\u0002\n\u0001!\t!!\u0015\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z!9\u0011q\u000b\u0001\u0005\u0002\u0005\u0015\u0004bBA,\u0001\u0011\u0005\u00111\u000f\u0005\b\u0003/\u0002A\u0011AAC\u0011\u001d\t9\u0006\u0001C\u0001\u0003\u001fCq!a&\u0001\t\u0003\tI\nC\u0004\u0002(\u0002!\t!!+\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005M'!\u0005#fYR\fG+\u00192mK\n+\u0018\u000e\u001c3fe*\u0011A%J\u0001\u0007i\u0006\u0014G.Z:\u000b\u0005\u0019:\u0013!\u00023fYR\f'\"\u0001\u0015\u0002\u0005%|7\u0001A\n\u0003\u0001-\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0017!B:qCJ\\\u0007CA\u001a<\u001b\u0005!$BA\u001b7\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003c]R!\u0001O\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0014aA8sO&\u0011A\b\u000e\u0002\r'B\f'o[*fgNLwN\\\u0001\u000eEVLG\u000eZ3s\u001fB$\u0018n\u001c8\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005\u001b\u0013!C3yK\u000e,H/[8o\u0013\t\u0019\u0005I\u0001\rEK2$\u0018\rV1cY\u0016\u0014U/\u001b7eKJ|\u0005\u000f^5p]N\fa\u0001P5oSRtDc\u0001$I\u0013B\u0011q\tA\u0007\u0002G!)\u0011g\u0001a\u0001e!)Qh\u0001a\u0001}\u0005Q\u0011\u000eZ3oi&4\u0017.\u001a:\u0016\u00031\u00032\u0001L'P\u0013\tqUF\u0001\u0004PaRLwN\u001c\t\u0003!^s!!U+\u0011\u0005IkS\"A*\u000b\u0005QK\u0013A\u0002\u001fs_>$h(\u0003\u0002W[\u00051\u0001K]3eK\u001aL!\u0001W-\u0003\rM#(/\u001b8h\u0015\t1V&\u0001\bjI\u0016tG/\u001b4jKJ|F%Z9\u0015\u0005q{\u0006C\u0001\u0017^\u0013\tqVF\u0001\u0003V]&$\bb\u00021\u0006\u0003\u0003\u0005\r\u0001T\u0001\u0004q\u0012\n\u0014aC5eK:$\u0018NZ5fe\u0002\n1\u0003]1si&$\u0018n\u001c8j]\u001e\u001cu\u000e\\;n]N,\u0012\u0001\u001a\t\u0004K*|eB\u00014i\u001d\t\u0011v-C\u0001/\u0013\tIW&A\u0004qC\u000e\\\u0017mZ3\n\u0005-d'aA*fc*\u0011\u0011.L\u0001\u0018a\u0006\u0014H/\u001b;j_:LgnZ\"pYVlgn]0%KF$\"\u0001X8\t\u000f\u0001D\u0011\u0011!a\u0001I\u0006!\u0002/\u0019:uSRLwN\\5oO\u000e{G.^7og\u0002\nqaY8mk6t7/F\u0001t!\r!\u0018P_\u0007\u0002k*\u0011ao^\u0001\b[V$\u0018M\u00197f\u0015\tAX&\u0001\u0006d_2dWm\u0019;j_:L!a[;\u0011\u0005mtX\"\u0001?\u000b\u0005u$\u0014!\u0002;za\u0016\u001c\u0018BA@}\u0005-\u0019FO];di\u001aKW\r\u001c3\u0002\u0017\r|G.^7og~#S-\u001d\u000b\u00049\u0006\u0015\u0001b\u00021\f\u0003\u0003\u0005\ra]\u0001\tG>dW/\u001c8tA\u0005AAn\\2bi&|g.\u0001\u0007m_\u000e\fG/[8o?\u0012*\u0017\u000fF\u0002]\u0003\u001fAq\u0001\u0019\b\u0002\u0002\u0003\u0007A*A\u0005m_\u000e\fG/[8oA\u0005QAO\u00197D_6lWM\u001c;\u0002\u001dQ\u0014GnQ8n[\u0016tGo\u0018\u0013fcR\u0019A,!\u0007\t\u000f\u0001\f\u0012\u0011!a\u0001\u0019\u0006YAO\u00197D_6lWM\u001c;!\u0003)\u0001(o\u001c9feRLWm]\u000b\u0003\u0003C\u0001b!a\t\u0002*={UBAA\u0013\u0015\r\t9c^\u0001\nS6lW\u000f^1cY\u0016LA!a\u000b\u0002&\t\u0019Q*\u00199\u0002\u001dA\u0014x\u000e]3si&,7o\u0018\u0013fcR\u0019A,!\r\t\u0011\u0001$\u0012\u0011!a\u0001\u0003C\t1\u0002\u001d:pa\u0016\u0014H/[3tA\u0005IA/\u00192mK:\u000bW.\u001a\u000b\u0004\r\u0006e\u0002\"\u0002&\u0017\u0001\u0004y\u0005f\u0001\f\u0002>A!\u0011qHA#\u001b\t\t\tEC\u0002\u0002DY\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9%!\u0011\u0003\u0011\u00153x\u000e\u001c<j]\u001e\fqaY8n[\u0016tG\u000fF\u0002G\u0003\u001bBa!!\u0013\u0018\u0001\u0004y\u0005fA\f\u0002>Q\u0019a)a\u0015\t\r\u0005%\u0001\u00041\u0001PQ\rA\u0012QH\u0001\nC\u0012$7i\u001c7v[:$RARA.\u0003?Ba!!\u0018\u001a\u0001\u0004y\u0015aB2pY:\u000bW.\u001a\u0005\u0007\u0003CJ\u0002\u0019A(\u0002\u0011\u0011\fG/\u0019+za\u0016D3!GA\u001f)\u00151\u0015qMA5\u0011\u0019\tiF\u0007a\u0001\u001f\"9\u0011\u0011\r\u000eA\u0002\u0005-\u0004cA>\u0002n%\u0019\u0011q\u000e?\u0003\u0011\u0011\u000bG/\u0019+za\u0016D3AGA\u001f)\u001d1\u0015QOA<\u0003sBa!!\u0018\u001c\u0001\u0004y\u0005BBA17\u0001\u0007q\nC\u0004\u0002|m\u0001\r!! \u0002\u00119,H\u000e\\1cY\u0016\u00042\u0001LA@\u0013\r\t\t)\f\u0002\b\u0005>|G.Z1oQ\rY\u0012Q\b\u000b\b\r\u0006\u001d\u0015\u0011RAF\u0011\u0019\ti\u0006\ba\u0001\u001f\"9\u0011\u0011\r\u000fA\u0002\u0005-\u0004bBA>9\u0001\u0007\u0011Q\u0010\u0015\u00049\u0005uBc\u0001$\u0002\u0012\"1\u00111S\u000fA\u0002i\f1aY8mQ\ri\u0012QH\u0001\u000bC\u0012$7i\u001c7v[:\u001cHc\u0001$\u0002\u001c\"9\u0011Q\u0014\u0010A\u0002\u0005}\u0015\u0001B2pYN\u00042a_AQ\u0013\r\t\u0019\u000b \u0002\u000b'R\u0014Xo\u0019;UsB,\u0007f\u0001\u0010\u0002>\u0005i\u0001/\u0019:uSRLwN\\3e\u0005f$2ARAV\u0011\u001d\tik\ba\u0001\u0003_\u000b\u0001bY8m\u001d\u0006lWm\u001d\t\u0005Y\u0005Ev*C\u0002\u000246\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?Q\ry\u0012q\u0017\t\u0005\u0003s\u000bi,\u0004\u0002\u0002<*\u0019\u00111I\u0017\n\t\u0005}\u00161\u0018\u0002\bm\u0006\u0014\u0018M]4tQ\ry\u0012QH\u0001\taJ|\u0007/\u001a:usR)a)a2\u0002L\"1\u0011\u0011\u001a\u0011A\u0002=\u000b1a[3z\u0011\u0019\ti\r\ta\u0001\u001f\u0006)a/\u00197vK\"\u001a\u0001%!\u0010\u0002\u000f\u0015DXmY;uKR\u0011\u0011Q\u001b\t\u0004\u000f\u0006]\u0017bAAmG\tQA)\u001a7uCR\u000b'\r\\3)\u0007\u0005\ni\u0004K\u0002\u0001\u0003{\u0001")
public class DeltaTableBuilder {
    private final SparkSession spark;
    private final DeltaTableBuilderOptions builderOption;
    private Option<String> identifier;
    private Seq<String> partitioningColumns;
    private scala.collection.mutable.Seq<StructField> columns;
    private Option<String> location;
    private Option<String> tblComment;
    private Map<String, String> properties;

    public DeltaTableBuilder partitionedBy(String ... colNames) {
        return this.partitionedBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Option<String> identifier() {
        return this.identifier;
    }

    private void identifier_$eq(Option<String> x$1) {
        this.identifier = x$1;
    }

    private Seq<String> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Seq<String> x$1) {
        this.partitioningColumns = x$1;
    }

    private scala.collection.mutable.Seq<StructField> columns() {
        return this.columns;
    }

    private void columns_$eq(scala.collection.mutable.Seq<StructField> x$1) {
        this.columns = x$1;
    }

    private Option<String> location() {
        return this.location;
    }

    private void location_$eq(Option<String> x$1) {
        this.location = x$1;
    }

    private Option<String> tblComment() {
        return this.tblComment;
    }

    private void tblComment_$eq(Option<String> x$1) {
        this.tblComment = x$1;
    }

    private Map<String, String> properties() {
        return this.properties;
    }

    private void properties_$eq(Map<String, String> x$1) {
        this.properties = x$1;
    }

    @Evolving
    public DeltaTableBuilder tableName(String identifier) {
        this.identifier_$eq((Option<String>)new Some((Object)identifier));
        return this;
    }

    @Evolving
    public DeltaTableBuilder comment(String comment) {
        this.tblComment_$eq((Option<String>)Option$.MODULE$.apply((Object)comment));
        return this;
    }

    @Evolving
    public DeltaTableBuilder location(String location) {
        this.location_$eq((Option<String>)Option$.MODULE$.apply((Object)location));
        return this;
    }

    @Evolving
    public DeltaTableBuilder addColumn(String colName, String dataType) {
        this.addColumn(DeltaTable$.MODULE$.columnBuilder(this.spark, colName).dataType(dataType).build());
        return this;
    }

    @Evolving
    public DeltaTableBuilder addColumn(String colName, DataType dataType) {
        this.addColumn(DeltaTable$.MODULE$.columnBuilder(this.spark, colName).dataType(dataType).build());
        return this;
    }

    @Evolving
    public DeltaTableBuilder addColumn(String colName, String dataType, boolean nullable) {
        this.addColumn(DeltaTable$.MODULE$.columnBuilder(this.spark, colName).dataType(dataType).nullable(nullable).build());
        return this;
    }

    @Evolving
    public DeltaTableBuilder addColumn(String colName, DataType dataType, boolean nullable) {
        this.addColumn(DeltaTable$.MODULE$.columnBuilder(this.spark, colName).dataType(dataType).nullable(nullable).build());
        return this;
    }

    @Evolving
    public DeltaTableBuilder addColumn(StructField col) {
        this.columns_$eq((scala.collection.mutable.Seq<StructField>)((scala.collection.mutable.Seq)this.columns().$colon$plus((Object)col, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    @Evolving
    public DeltaTableBuilder addColumns(StructType cols) {
        this.columns_$eq((scala.collection.mutable.Seq<StructField>)((scala.collection.mutable.Seq)this.columns().$plus$plus((GenTraversableOnce)cols, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    @Evolving
    public DeltaTableBuilder partitionedBy(Seq<String> colNames) {
        this.partitioningColumns_$eq(colNames);
        return this;
    }

    @Evolving
    public DeltaTableBuilder property(String key, String value) {
        this.properties_$eq((Map<String, String>)this.properties().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    @Evolving
    public DeltaTable execute() {
        CreateDeltaTable.Mode mode;
        if (this.identifier().isEmpty() && this.location().isEmpty()) {
            throw new AnalysisException("Table name or location has to be specified", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        DeltaTableBuilderOptions deltaTableBuilderOptions = this.builderOption;
        if (deltaTableBuilderOptions instanceof CreateTableOptions) {
            CreateTableOptions createTableOptions = (CreateTableOptions)deltaTableBuilderOptions;
            boolean ifNotExists = createTableOptions.ifNotExists();
            mode = ifNotExists ? CreateDeltaTable.Mode.MODE_CREATE_IF_NOT_EXISTS : CreateDeltaTable.Mode.MODE_CREATE;
        } else if (deltaTableBuilderOptions instanceof ReplaceTableOptions) {
            ReplaceTableOptions replaceTableOptions = (ReplaceTableOptions)deltaTableBuilderOptions;
            boolean orCreate = replaceTableOptions.orCreate();
            mode = orCreate ? CreateDeltaTable.Mode.MODE_CREATE_OR_REPLACE : CreateDeltaTable.Mode.MODE_REPLACE;
        } else {
            throw new MatchError((Object)deltaTableBuilderOptions);
        }
        CreateDeltaTable.Mode mode2 = mode;
        CreateDeltaTable.Builder createDeltaTable = CreateDeltaTable.newBuilder().setMode(mode2).addAllPartitioningColumns((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(this.partitioningColumns()).asJava()).putAllProperties((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.properties()).asJava());
        this.identifier().foreach((Function1 & Serializable & scala.Serializable)value -> createDeltaTable.setTableName((String)value));
        this.location().foreach((Function1 & Serializable & scala.Serializable)value -> createDeltaTable.setLocation((String)value));
        this.tblComment().foreach((Function1 & Serializable & scala.Serializable)value -> createDeltaTable.setComment((String)value));
        scala.collection.mutable.Seq protoColumns = (scala.collection.mutable.Seq)this.columns().map((Function1 & Serializable & scala.Serializable)f -> {
            CreateDeltaTable.Column.Builder builder = CreateDeltaTable.Column.newBuilder().setName(f.name()).setDataType(DataTypeProtoConverter$.MODULE$.toConnectProtoType(f.dataType())).setNullable(f.nullable());
            Object object = f.metadata().contains("delta.generationExpression") ? builder.setGeneratedAlwaysAs(f.metadata().getString("delta.generationExpression")) : BoxedUnit.UNIT;
            Object object2 = f.metadata().contains("comment") ? builder.setComment(f.metadata().getString("comment")) : BoxedUnit.UNIT;
            return builder.build();
        }, Seq$.MODULE$.canBuildFrom());
        createDeltaTable.addAllColumns((Iterable)JavaConverters$.MODULE$.mutableSeqAsJavaListConverter(protoColumns).asJava());
        DeltaCommand command = DeltaCommand.newBuilder().setCreateDeltaTable(createDeltaTable).build();
        Any extension = Any.pack(command);
        this.spark.execute(extension);
        return this.location().isDefined() ? DeltaTable$.MODULE$.forPath(this.spark, (String)this.location().get()) : DeltaTable$.MODULE$.forName(this.spark, (String)this.identifier().get());
    }

    public DeltaTableBuilder(SparkSession spark, DeltaTableBuilderOptions builderOption) {
        this.spark = spark;
        this.builderOption = builderOption;
        this.identifier = None$.MODULE$;
        this.partitioningColumns = Nil$.MODULE$;
        this.columns = (scala.collection.mutable.Seq)Seq$.MODULE$.empty();
        this.location = None$.MODULE$;
        this.tblComment = None$.MODULE$;
        this.properties = Predef$.MODULE$.Map().empty();
    }
}

