/*
 * Decompiled with CFR 0.152.
 */
package grpc_shaded.io.netty.handler.codec.socks;

import grpc_shaded.io.netty.buffer.ByteBuf;
import grpc_shaded.io.netty.channel.ChannelHandlerContext;
import grpc_shaded.io.netty.handler.codec.ReplayingDecoder;
import grpc_shaded.io.netty.handler.codec.socks.SocksAuthScheme;
import grpc_shaded.io.netty.handler.codec.socks.SocksCommonUtils;
import grpc_shaded.io.netty.handler.codec.socks.SocksInitResponse;
import grpc_shaded.io.netty.handler.codec.socks.SocksProtocolVersion;
import java.util.List;

public class SocksInitResponseDecoder
extends ReplayingDecoder<State> {
    public SocksInitResponseDecoder() {
        super(State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                if (byteBuf.readByte() != SocksProtocolVersion.SOCKS5.byteValue()) {
                    out.add(SocksCommonUtils.UNKNOWN_SOCKS_RESPONSE);
                    break;
                }
                this.checkpoint(State.READ_PREFERRED_AUTH_TYPE);
            }
            case READ_PREFERRED_AUTH_TYPE: {
                SocksAuthScheme authScheme = SocksAuthScheme.valueOf(byteBuf.readByte());
                out.add(new SocksInitResponse(authScheme));
                break;
            }
            default: {
                throw new Error();
            }
        }
        ctx.pipeline().remove(this);
    }

    public static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_PREFERRED_AUTH_TYPE;

    }
}

