/*
 * Decompiled with CFR 0.152.
 */
package grpc_shaded.io.netty.handler.codec.http;

import grpc_shaded.io.netty.channel.embedded.EmbeddedChannel;
import grpc_shaded.io.netty.handler.codec.compression.Brotli;
import grpc_shaded.io.netty.handler.codec.compression.BrotliDecoder;
import grpc_shaded.io.netty.handler.codec.compression.ZlibCodecFactory;
import grpc_shaded.io.netty.handler.codec.compression.ZlibWrapper;
import grpc_shaded.io.netty.handler.codec.http.HttpContentDecoder;
import grpc_shaded.io.netty.handler.codec.http.HttpHeaderValues;

public class HttpContentDecompressor
extends HttpContentDecoder {
    private final boolean strict;

    public HttpContentDecompressor() {
        this(false);
    }

    public HttpContentDecompressor(boolean strict) {
        this.strict = strict;
    }

    @Override
    protected EmbeddedChannel newContentDecoder(String contentEncoding) throws Exception {
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), ZlibCodecFactory.newZlibDecoder(ZlibWrapper.GZIP));
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(contentEncoding)) {
            ZlibWrapper wrapper = this.strict ? ZlibWrapper.ZLIB : ZlibWrapper.ZLIB_OR_NONE;
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), ZlibCodecFactory.newZlibDecoder(wrapper));
        }
        if (Brotli.isAvailable() && HttpHeaderValues.BR.contentEqualsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), new BrotliDecoder());
        }
        return null;
    }
}

