/*
 * Decompiled with CFR 0.152.
 */
package grpc_shaded.io.grpc.stub;

import grpc_shaded.io.grpc.CallOptions;
import grpc_shaded.io.grpc.Channel;
import grpc_shaded.io.grpc.stub.AbstractStub;
import grpc_shaded.io.grpc.stub.ClientCalls;
import grpc_shaded.javax.annotation.CheckReturnValue;
import grpc_shaded.javax.annotation.concurrent.ThreadSafe;

@CheckReturnValue
@ThreadSafe
public abstract class AbstractAsyncStub<S extends AbstractAsyncStub<S>>
extends AbstractStub<S> {
    protected AbstractAsyncStub(Channel channel, CallOptions callOptions) {
        super(channel, callOptions);
    }

    public static <T extends AbstractStub<T>> T newStub(AbstractStub.StubFactory<T> factory, Channel channel) {
        return AbstractAsyncStub.newStub(factory, channel, CallOptions.DEFAULT);
    }

    public static <T extends AbstractStub<T>> T newStub(AbstractStub.StubFactory<T> factory, Channel channel, CallOptions callOptions) {
        T stub = factory.newStub(channel, callOptions.withOption(ClientCalls.STUB_TYPE_OPTION, ClientCalls.StubType.ASYNC));
        assert (stub instanceof AbstractAsyncStub) : String.format("Expected AbstractAsyncStub, but got %s.", stub.getClass());
        return stub;
    }
}

