/*
 * Decompiled with CFR 0.152.
 */
package grpc_shaded.io.grpc.protobuf.services.internal;

import grpc_shaded.com.google.common.annotations.VisibleForTesting;
import grpc_shaded.com.google.common.base.Throwables;
import grpc_shaded.io.grpc.Internal;
import grpc_shaded.io.grpc.LoadBalancer;
import grpc_shaded.io.grpc.LoadBalancerProvider;
import grpc_shaded.io.grpc.NameResolver;
import grpc_shaded.io.grpc.protobuf.services.HealthCheckingLoadBalancerUtil;
import java.util.Map;

@Internal
public final class HealthCheckingRoundRobinLoadBalancerProvider
extends LoadBalancerProvider {
    private final LoadBalancerProvider rrProvider = HealthCheckingRoundRobinLoadBalancerProvider.newRoundRobinProvider();

    @Override
    public boolean isAvailable() {
        return this.rrProvider.isAvailable();
    }

    @Override
    public int getPriority() {
        return this.rrProvider.getPriority() + 1;
    }

    @Override
    public String getPolicyName() {
        return this.rrProvider.getPolicyName();
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return HealthCheckingLoadBalancerUtil.newHealthCheckingLoadBalancer(this.rrProvider, helper);
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        return this.rrProvider.parseLoadBalancingPolicyConfig(rawLoadBalancingPolicyConfig);
    }

    @VisibleForTesting
    static LoadBalancerProvider newRoundRobinProvider() {
        try {
            Class<LoadBalancerProvider> rrProviderClass = Class.forName("grpc_shaded.io.grpc.util.SecretRoundRobinLoadBalancerProvider$Provider").asSubclass(LoadBalancerProvider.class);
            return rrProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
}

