/*
 * Decompiled with CFR 0.152.
 */
package grpc_shaded.io.grpc.protobuf.services;

import grpc_shaded.com.google.common.base.Preconditions;
import grpc_shaded.io.grpc.CallOptions;
import grpc_shaded.io.grpc.ClientInterceptor;
import grpc_shaded.io.grpc.ServerInterceptor;
import grpc_shaded.io.grpc.protobuf.services.BinaryLogProvider;
import grpc_shaded.io.grpc.protobuf.services.BinaryLogSink;
import grpc_shaded.io.grpc.protobuf.services.BinlogHelper;
import grpc_shaded.io.grpc.protobuf.services.TempFileSink;
import grpc_shaded.javax.annotation.Nullable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

class BinaryLogProviderImpl
extends BinaryLogProvider {
    private static final AtomicLong counter = new AtomicLong(1L);
    private final BinlogHelper.Factory factory;
    private final BinaryLogSink sink;

    public BinaryLogProviderImpl() throws IOException {
        this(new TempFileSink(), System.getenv("GRPC_BINARY_LOG_CONFIG"));
    }

    @Deprecated
    public BinaryLogProviderImpl(BinaryLogSink sink) throws IOException {
        this(sink, System.getenv("GRPC_BINARY_LOG_CONFIG"));
    }

    public BinaryLogProviderImpl(BinaryLogSink sink, String configStr) throws IOException {
        this.sink = Preconditions.checkNotNull(sink);
        try {
            this.factory = new BinlogHelper.FactoryImpl(sink, configStr);
        }
        catch (RuntimeException e) {
            sink.close();
            throw new IOException("Can not initialize. The env variable GRPC_BINARY_LOG_CONFIG must be valid.", e);
        }
    }

    @Override
    @Nullable
    public ServerInterceptor getServerInterceptor(String fullMethodName) {
        BinlogHelper helperForMethod = this.factory.getLog(fullMethodName);
        if (helperForMethod == null) {
            return null;
        }
        return helperForMethod.getServerInterceptor(counter.getAndIncrement());
    }

    @Override
    @Nullable
    public ClientInterceptor getClientInterceptor(String fullMethodName, CallOptions callOptions) {
        BinlogHelper helperForMethod = this.factory.getLog(fullMethodName);
        if (helperForMethod == null) {
            return null;
        }
        return helperForMethod.getClientInterceptor(counter.getAndIncrement());
    }

    @Override
    public void close() throws IOException {
        this.sink.close();
    }
}

