/*
 * Decompiled with CFR 0.152.
 */
package grpc_shaded.io.grpc.protobuf.services;

import grpc_shaded.com.google.common.annotations.VisibleForTesting;
import grpc_shaded.com.google.common.base.Preconditions;
import grpc_shaded.io.grpc.BinaryLog;
import grpc_shaded.io.grpc.CallOptions;
import grpc_shaded.io.grpc.Channel;
import grpc_shaded.io.grpc.ClientCall;
import grpc_shaded.io.grpc.ClientInterceptor;
import grpc_shaded.io.grpc.ClientInterceptors;
import grpc_shaded.io.grpc.Internal;
import grpc_shaded.io.grpc.InternalClientInterceptors;
import grpc_shaded.io.grpc.InternalServerInterceptors;
import grpc_shaded.io.grpc.MethodDescriptor;
import grpc_shaded.io.grpc.ServerCallHandler;
import grpc_shaded.io.grpc.ServerInterceptor;
import grpc_shaded.io.grpc.ServerMethodDefinition;
import grpc_shaded.javax.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@Internal
public abstract class BinaryLogProvider
extends BinaryLog {
    @VisibleForTesting
    public static final MethodDescriptor.Marshaller<byte[]> BYTEARRAY_MARSHALLER = new ByteArrayMarshaller();
    private final ClientInterceptor binaryLogShim = new BinaryLogShim();

    @Override
    public final Channel wrapChannel(Channel channel) {
        return ClientInterceptors.intercept(channel, this.binaryLogShim);
    }

    private static MethodDescriptor<byte[], byte[]> toByteBufferMethod(MethodDescriptor<?, ?> method) {
        return method.toBuilder(BYTEARRAY_MARSHALLER, BYTEARRAY_MARSHALLER).build();
    }

    @Override
    public final <ReqT, RespT> ServerMethodDefinition<?, ?> wrapMethodDefinition(ServerMethodDefinition<ReqT, RespT> oMethodDef) {
        ServerInterceptor binlogInterceptor = this.getServerInterceptor(oMethodDef.getMethodDescriptor().getFullMethodName());
        if (binlogInterceptor == null) {
            return oMethodDef;
        }
        MethodDescriptor<byte[], byte[]> binMethod = BinaryLogProvider.toByteBufferMethod(oMethodDef.getMethodDescriptor());
        ServerMethodDefinition<byte[], byte[]> binDef = InternalServerInterceptors.wrapMethod(oMethodDef, binMethod);
        ServerCallHandler<byte[], byte[]> binlogHandler = InternalServerInterceptors.interceptCallHandlerCreate(binlogInterceptor, binDef.getServerCallHandler());
        return ServerMethodDefinition.create(binMethod, binlogHandler);
    }

    @Nullable
    protected abstract ServerInterceptor getServerInterceptor(String var1);

    @Nullable
    protected abstract ClientInterceptor getClientInterceptor(String var1, CallOptions var2);

    @Override
    public void close() throws IOException {
    }

    private static final class IoUtils {
        private static final int MAX_BUFFER_LENGTH = 16384;

        private IoUtils() {
        }

        public static byte[] toByteArray(InputStream in) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IoUtils.copy(in, out);
            return out.toByteArray();
        }

        public static long copy(InputStream from, OutputStream to) throws IOException {
            int r;
            Preconditions.checkNotNull(from);
            Preconditions.checkNotNull(to);
            byte[] buf = new byte[16384];
            long total = 0L;
            while ((r = from.read(buf)) != -1) {
                to.write(buf, 0, r);
                total += (long)r;
            }
            return total;
        }
    }

    private final class BinaryLogShim
    implements ClientInterceptor {
        private BinaryLogShim() {
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            ClientInterceptor binlogInterceptor = BinaryLogProvider.this.getClientInterceptor(method.getFullMethodName(), callOptions);
            if (binlogInterceptor == null) {
                return next.newCall(method, callOptions);
            }
            return InternalClientInterceptors.wrapClientInterceptor(binlogInterceptor, BYTEARRAY_MARSHALLER, BYTEARRAY_MARSHALLER).interceptCall(method, callOptions, next);
        }
    }

    private static final class ByteArrayMarshaller
    implements MethodDescriptor.Marshaller<byte[]> {
        private ByteArrayMarshaller() {
        }

        @Override
        public InputStream stream(byte[] value) {
            return new ByteArrayInputStream(value);
        }

        @Override
        public byte[] parse(InputStream stream) {
            try {
                return this.parseHelper(stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private byte[] parseHelper(InputStream stream) throws IOException {
            try {
                byte[] byArray = IoUtils.toByteArray(stream);
                return byArray;
            }
            finally {
                stream.close();
            }
        }
    }
}

