/*
 * Decompiled with CFR 0.152.
 */
package grpc_shaded.io.grpc.netty;

import grpc_shaded.com.google.common.base.Preconditions;
import grpc_shaded.io.grpc.ChannelCredentials;
import grpc_shaded.io.grpc.ExperimentalApi;
import grpc_shaded.io.grpc.netty.GrpcSslContexts;
import grpc_shaded.io.grpc.netty.NettyChannelCredentials;
import grpc_shaded.io.grpc.netty.ProtocolNegotiators;
import grpc_shaded.io.netty.handler.ssl.SslContext;

@ExperimentalApi(value="There is no plan to make this API stable, given transport API instability")
public final class NettySslContextChannelCredentials {
    private NettySslContextChannelCredentials() {
    }

    public static ChannelCredentials create(SslContext sslContext) {
        Preconditions.checkArgument(sslContext.isClient(), "Server SSL context can not be used for client channel");
        GrpcSslContexts.ensureAlpnAndH2Enabled(sslContext.applicationProtocolNegotiator());
        return NettyChannelCredentials.create(ProtocolNegotiators.tlsClientFactory(sslContext));
    }
}

