/*
 * Decompiled with CFR 0.152.
 */
package grpc_shaded.io.grpc.internal;

import grpc_shaded.com.google.common.annotations.VisibleForTesting;
import grpc_shaded.com.google.common.base.Preconditions;
import grpc_shaded.com.google.common.base.Throwables;
import grpc_shaded.com.google.common.util.concurrent.MoreExecutors;
import grpc_shaded.io.grpc.Attributes;
import grpc_shaded.io.grpc.Codec;
import grpc_shaded.io.grpc.Compressor;
import grpc_shaded.io.grpc.CompressorRegistry;
import grpc_shaded.io.grpc.Context;
import grpc_shaded.io.grpc.DecompressorRegistry;
import grpc_shaded.io.grpc.InternalDecompressorRegistry;
import grpc_shaded.io.grpc.Metadata;
import grpc_shaded.io.grpc.MethodDescriptor;
import grpc_shaded.io.grpc.ServerCall;
import grpc_shaded.io.grpc.Status;
import grpc_shaded.io.grpc.internal.CallTracer;
import grpc_shaded.io.grpc.internal.GrpcUtil;
import grpc_shaded.io.grpc.internal.ServerStream;
import grpc_shaded.io.grpc.internal.ServerStreamListener;
import grpc_shaded.io.grpc.internal.StreamListener;
import grpc_shaded.io.perfmark.PerfMark;
import grpc_shaded.io.perfmark.Tag;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ServerCallImpl<ReqT, RespT>
extends ServerCall<ReqT, RespT> {
    private static final Logger log = Logger.getLogger(ServerCallImpl.class.getName());
    @VisibleForTesting
    static final String TOO_MANY_RESPONSES = "Too many responses";
    @VisibleForTesting
    static final String MISSING_RESPONSE = "Completed without a response";
    private final ServerStream stream;
    private final MethodDescriptor<ReqT, RespT> method;
    private final Tag tag;
    private final Context.CancellableContext context;
    private final byte[] messageAcceptEncoding;
    private final DecompressorRegistry decompressorRegistry;
    private final CompressorRegistry compressorRegistry;
    private CallTracer serverCallTracer;
    private volatile boolean cancelled;
    private boolean sendHeadersCalled;
    private boolean closeCalled;
    private Compressor compressor;
    private boolean messageSent;

    ServerCallImpl(ServerStream stream, MethodDescriptor<ReqT, RespT> method, Metadata inboundHeaders, Context.CancellableContext context, DecompressorRegistry decompressorRegistry, CompressorRegistry compressorRegistry, CallTracer serverCallTracer, Tag tag) {
        this.stream = stream;
        this.method = method;
        this.context = context;
        this.messageAcceptEncoding = inboundHeaders.get(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY);
        this.decompressorRegistry = decompressorRegistry;
        this.compressorRegistry = compressorRegistry;
        this.serverCallTracer = serverCallTracer;
        this.serverCallTracer.reportCallStarted();
        this.tag = tag;
    }

    @Override
    public void request(int numMessages) {
        PerfMark.startTask("ServerCall.request", this.tag);
        try {
            this.stream.request(numMessages);
        }
        finally {
            PerfMark.stopTask("ServerCall.request", this.tag);
        }
    }

    @Override
    public void sendHeaders(Metadata headers) {
        PerfMark.startTask("ServerCall.sendHeaders", this.tag);
        try {
            this.sendHeadersInternal(headers);
        }
        finally {
            PerfMark.stopTask("ServerCall.sendHeaders", this.tag);
        }
    }

    private void sendHeadersInternal(Metadata headers) {
        Preconditions.checkState(!this.sendHeadersCalled, "sendHeaders has already been called");
        Preconditions.checkState(!this.closeCalled, "call is closed");
        headers.discardAll(GrpcUtil.CONTENT_LENGTH_KEY);
        headers.discardAll(GrpcUtil.MESSAGE_ENCODING_KEY);
        if (this.compressor == null) {
            this.compressor = Codec.Identity.NONE;
        } else if (this.messageAcceptEncoding != null) {
            if (!GrpcUtil.iterableContains(GrpcUtil.ACCEPT_ENCODING_SPLITTER.split(new String(this.messageAcceptEncoding, GrpcUtil.US_ASCII)), this.compressor.getMessageEncoding())) {
                this.compressor = Codec.Identity.NONE;
            }
        } else {
            this.compressor = Codec.Identity.NONE;
        }
        headers.put(GrpcUtil.MESSAGE_ENCODING_KEY, this.compressor.getMessageEncoding());
        this.stream.setCompressor(this.compressor);
        headers.discardAll(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY);
        byte[] advertisedEncodings = InternalDecompressorRegistry.getRawAdvertisedMessageEncodings(this.decompressorRegistry);
        if (advertisedEncodings.length != 0) {
            headers.put(GrpcUtil.MESSAGE_ACCEPT_ENCODING_KEY, advertisedEncodings);
        }
        this.sendHeadersCalled = true;
        this.stream.writeHeaders(headers);
    }

    @Override
    public void sendMessage(RespT message) {
        PerfMark.startTask("ServerCall.sendMessage", this.tag);
        try {
            this.sendMessageInternal(message);
        }
        finally {
            PerfMark.stopTask("ServerCall.sendMessage", this.tag);
        }
    }

    private void sendMessageInternal(RespT message) {
        Preconditions.checkState(this.sendHeadersCalled, "sendHeaders has not been called");
        Preconditions.checkState(!this.closeCalled, "call is closed");
        if (this.method.getType().serverSendsOneMessage() && this.messageSent) {
            this.internalClose(Status.INTERNAL.withDescription(TOO_MANY_RESPONSES));
            return;
        }
        this.messageSent = true;
        try {
            InputStream resp = this.method.streamResponse(message);
            this.stream.writeMessage(resp);
            this.stream.flush();
        }
        catch (RuntimeException e) {
            this.close(Status.fromThrowable(e), new Metadata());
        }
        catch (Error e) {
            this.close(Status.CANCELLED.withDescription("Server sendMessage() failed with Error"), new Metadata());
            throw e;
        }
    }

    @Override
    public void setMessageCompression(boolean enable) {
        this.stream.setMessageCompression(enable);
    }

    @Override
    public void setCompression(String compressorName) {
        Preconditions.checkState(!this.sendHeadersCalled, "sendHeaders has been called");
        this.compressor = this.compressorRegistry.lookupCompressor(compressorName);
        Preconditions.checkArgument(this.compressor != null, "Unable to find compressor by name %s", (Object)compressorName);
    }

    @Override
    public boolean isReady() {
        if (this.closeCalled) {
            return false;
        }
        return this.stream.isReady();
    }

    @Override
    public void close(Status status, Metadata trailers) {
        PerfMark.startTask("ServerCall.close", this.tag);
        try {
            this.closeInternal(status, trailers);
        }
        finally {
            PerfMark.stopTask("ServerCall.close", this.tag);
        }
    }

    private void closeInternal(Status status, Metadata trailers) {
        Preconditions.checkState(!this.closeCalled, "call already closed");
        try {
            this.closeCalled = true;
            if (status.isOk() && this.method.getType().serverSendsOneMessage() && !this.messageSent) {
                this.internalClose(Status.INTERNAL.withDescription(MISSING_RESPONSE));
                return;
            }
            this.stream.close(status, trailers);
        }
        finally {
            this.serverCallTracer.reportCallEnded(status.isOk());
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    ServerStreamListener newServerStreamListener(ServerCall.Listener<ReqT> listener) {
        return new ServerStreamListenerImpl<ReqT>(this, listener, this.context);
    }

    @Override
    public Attributes getAttributes() {
        return this.stream.getAttributes();
    }

    @Override
    public String getAuthority() {
        return this.stream.getAuthority();
    }

    @Override
    public MethodDescriptor<ReqT, RespT> getMethodDescriptor() {
        return this.method;
    }

    private void internalClose(Status internalError) {
        log.log(Level.WARNING, "Cancelling the stream with status {0}", new Object[]{internalError});
        this.stream.cancel(internalError);
        this.serverCallTracer.reportCallEnded(internalError.isOk());
    }

    @VisibleForTesting
    static final class ServerStreamListenerImpl<ReqT>
    implements ServerStreamListener {
        private final ServerCallImpl<ReqT, ?> call;
        private final ServerCall.Listener<ReqT> listener;
        private final Context.CancellableContext context;

        public ServerStreamListenerImpl(ServerCallImpl<ReqT, ?> call, ServerCall.Listener<ReqT> listener, Context.CancellableContext context) {
            this.call = Preconditions.checkNotNull(call, "call");
            this.listener = Preconditions.checkNotNull(listener, "listener must not be null");
            this.context = Preconditions.checkNotNull(context, "context");
            this.context.addListener(new Context.CancellationListener(){

                @Override
                public void cancelled(Context context) {
                    if (context.cancellationCause() != null) {
                        call.cancelled = true;
                    }
                }
            }, MoreExecutors.directExecutor());
        }

        @Override
        public void messagesAvailable(StreamListener.MessageProducer producer) {
            PerfMark.startTask("ServerStreamListener.messagesAvailable", ((ServerCallImpl)this.call).tag);
            try {
                this.messagesAvailableInternal(producer);
            }
            finally {
                PerfMark.stopTask("ServerStreamListener.messagesAvailable", ((ServerCallImpl)this.call).tag);
            }
        }

        private void messagesAvailableInternal(StreamListener.MessageProducer producer) {
            if (((ServerCallImpl)this.call).cancelled) {
                GrpcUtil.closeQuietly(producer);
                return;
            }
            try {
                InputStream message;
                while ((message = producer.next()) != null) {
                    try {
                        this.listener.onMessage(((ServerCallImpl)this.call).method.parseRequest(message));
                    }
                    catch (Throwable t) {
                        GrpcUtil.closeQuietly(message);
                        throw t;
                    }
                    message.close();
                }
            }
            catch (Throwable t) {
                GrpcUtil.closeQuietly(producer);
                Throwables.throwIfUnchecked(t);
                throw new RuntimeException(t);
            }
        }

        @Override
        public void halfClosed() {
            PerfMark.startTask("ServerStreamListener.halfClosed", ((ServerCallImpl)this.call).tag);
            try {
                if (((ServerCallImpl)this.call).cancelled) {
                    return;
                }
                this.listener.onHalfClose();
            }
            finally {
                PerfMark.stopTask("ServerStreamListener.halfClosed", ((ServerCallImpl)this.call).tag);
            }
        }

        @Override
        public void closed(Status status) {
            PerfMark.startTask("ServerStreamListener.closed", ((ServerCallImpl)this.call).tag);
            try {
                this.closedInternal(status);
            }
            finally {
                PerfMark.stopTask("ServerStreamListener.closed", ((ServerCallImpl)this.call).tag);
            }
        }

        private void closedInternal(Status status) {
            try {
                if (status.isOk()) {
                    this.listener.onComplete();
                } else {
                    ((ServerCallImpl)this.call).cancelled = true;
                    this.listener.onCancel();
                }
            }
            finally {
                this.context.cancel(null);
            }
        }

        @Override
        public void onReady() {
            PerfMark.startTask("ServerStreamListener.onReady", ((ServerCallImpl)this.call).tag);
            try {
                if (((ServerCallImpl)this.call).cancelled) {
                    return;
                }
                this.listener.onReady();
            }
            finally {
                PerfMark.stopTask("ServerCall.closed", ((ServerCallImpl)this.call).tag);
            }
        }
    }
}

