/*
 * Decompiled with CFR 0.152.
 */
package grpc_shaded.io.grpc.internal;

import grpc_shaded.com.google.common.annotations.VisibleForTesting;
import grpc_shaded.com.google.common.base.Preconditions;
import grpc_shaded.com.google.common.util.concurrent.ListenableFuture;
import grpc_shaded.com.google.common.util.concurrent.SettableFuture;
import grpc_shaded.io.grpc.CallOptions;
import grpc_shaded.io.grpc.ClientStreamTracer;
import grpc_shaded.io.grpc.InternalChannelz;
import grpc_shaded.io.grpc.InternalLogId;
import grpc_shaded.io.grpc.Metadata;
import grpc_shaded.io.grpc.MethodDescriptor;
import grpc_shaded.io.grpc.Status;
import grpc_shaded.io.grpc.internal.ClientStream;
import grpc_shaded.io.grpc.internal.ClientStreamListener;
import grpc_shaded.io.grpc.internal.ClientTransport;
import grpc_shaded.io.grpc.internal.FailingClientStream;
import java.util.concurrent.Executor;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        return new FailingClientStream(this.error, this.rpcProgress, tracers);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error.asException());
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

