/*
 * Decompiled with CFR 0.152.
 */
package grpc_shaded.io.grpc.internal;

import grpc_shaded.com.google.common.base.MoreObjects;
import grpc_shaded.com.google.errorprone.annotations.DoNotCall;
import grpc_shaded.io.grpc.BinaryLog;
import grpc_shaded.io.grpc.BindableService;
import grpc_shaded.io.grpc.CompressorRegistry;
import grpc_shaded.io.grpc.DecompressorRegistry;
import grpc_shaded.io.grpc.HandlerRegistry;
import grpc_shaded.io.grpc.Server;
import grpc_shaded.io.grpc.ServerBuilder;
import grpc_shaded.io.grpc.ServerCallExecutorSupplier;
import grpc_shaded.io.grpc.ServerInterceptor;
import grpc_shaded.io.grpc.ServerServiceDefinition;
import grpc_shaded.io.grpc.ServerStreamTracer;
import grpc_shaded.io.grpc.ServerTransportFilter;
import grpc_shaded.javax.annotation.Nullable;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public abstract class AbstractServerImplBuilder<T extends ServerBuilder<T>>
extends ServerBuilder<T> {
    protected AbstractServerImplBuilder() {
    }

    @DoNotCall(value="Unsupported")
    public static ServerBuilder<?> forPort(int port) {
        throw new UnsupportedOperationException("Subclass failed to hide static factory");
    }

    protected abstract ServerBuilder<?> delegate();

    @Override
    public T directExecutor() {
        this.delegate().directExecutor();
        return this.thisT();
    }

    @Override
    public T callExecutor(ServerCallExecutorSupplier executorSupplier) {
        this.delegate().callExecutor(executorSupplier);
        return this.thisT();
    }

    @Override
    public T executor(@Nullable Executor executor) {
        this.delegate().executor(executor);
        return this.thisT();
    }

    @Override
    public T addService(ServerServiceDefinition service) {
        this.delegate().addService(service);
        return this.thisT();
    }

    @Override
    public T addService(BindableService bindableService) {
        this.delegate().addService(bindableService);
        return this.thisT();
    }

    @Override
    public T intercept(ServerInterceptor interceptor) {
        this.delegate().intercept(interceptor);
        return this.thisT();
    }

    @Override
    public T addTransportFilter(ServerTransportFilter filter) {
        this.delegate().addTransportFilter(filter);
        return this.thisT();
    }

    @Override
    public T addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        this.delegate().addStreamTracerFactory(factory);
        return this.thisT();
    }

    @Override
    public T fallbackHandlerRegistry(@Nullable HandlerRegistry fallbackRegistry) {
        this.delegate().fallbackHandlerRegistry(fallbackRegistry);
        return this.thisT();
    }

    @Override
    public T useTransportSecurity(File certChain, File privateKey) {
        this.delegate().useTransportSecurity(certChain, privateKey);
        return this.thisT();
    }

    @Override
    public T useTransportSecurity(InputStream certChain, InputStream privateKey) {
        this.delegate().useTransportSecurity(certChain, privateKey);
        return this.thisT();
    }

    @Override
    public T decompressorRegistry(@Nullable DecompressorRegistry registry) {
        this.delegate().decompressorRegistry(registry);
        return this.thisT();
    }

    @Override
    public T compressorRegistry(@Nullable CompressorRegistry registry) {
        this.delegate().compressorRegistry(registry);
        return this.thisT();
    }

    @Override
    public T handshakeTimeout(long timeout, TimeUnit unit) {
        this.delegate().handshakeTimeout(timeout, unit);
        return this.thisT();
    }

    @Override
    public T maxInboundMessageSize(int bytes) {
        this.delegate().maxInboundMessageSize(bytes);
        return this.thisT();
    }

    @Override
    public T maxInboundMetadataSize(int bytes) {
        this.delegate().maxInboundMetadataSize(bytes);
        return this.thisT();
    }

    @Override
    public T setBinaryLog(BinaryLog binaryLog) {
        this.delegate().setBinaryLog(binaryLog);
        return this.thisT();
    }

    @Override
    public Server build() {
        return this.delegate().build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("delegate", this.delegate()).toString();
    }

    protected final T thisT() {
        AbstractServerImplBuilder thisT = this;
        return (T)thisT;
    }
}

