/*
 * Decompiled with CFR 0.152.
 */
package grpc_shaded.com.google.common.collect;

import grpc_shaded.com.google.common.annotations.GwtCompatible;
import grpc_shaded.com.google.common.annotations.GwtIncompatible;
import grpc_shaded.com.google.common.collect.ElementTypesAreNonnullByDefault;
import grpc_shaded.com.google.common.collect.ImmutableAsList;
import grpc_shaded.com.google.common.collect.ImmutableCollection;
import grpc_shaded.com.google.common.collect.ImmutableList;
import grpc_shaded.com.google.common.collect.UnmodifiableListIterator;
import grpc_shaded.javax.annotation.CheckForNull;
import grpc_shaded.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
class RegularImmutableAsList<E>
extends ImmutableAsList<E> {
    private final ImmutableCollection<E> delegate;
    private final ImmutableList<? extends E> delegateList;

    RegularImmutableAsList(ImmutableCollection<E> delegate, ImmutableList<? extends E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate, Object[] array) {
        this(delegate, ImmutableList.asImmutableList(array));
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate, Object[] array, int size) {
        this(delegate, ImmutableList.asImmutableList(array, size));
    }

    @Override
    ImmutableCollection<E> delegateCollection() {
        return this.delegate;
    }

    ImmutableList<? extends E> delegateList() {
        return this.delegateList;
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return this.delegateList.listIterator(index);
    }

    @Override
    @GwtIncompatible
    int copyIntoArray(@Nullable Object[] dst, int offset) {
        return this.delegateList.copyIntoArray(dst, offset);
    }

    @Override
    @CheckForNull
    @Nullable Object[] internalArray() {
        return this.delegateList.internalArray();
    }

    @Override
    int internalArrayStart() {
        return this.delegateList.internalArrayStart();
    }

    @Override
    int internalArrayEnd() {
        return this.delegateList.internalArrayEnd();
    }

    @Override
    public E get(int index) {
        return this.delegateList.get(index);
    }
}

