/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client.fields;

import com.crankuptheamps.client.CommandId;
import com.crankuptheamps.client.fields.Field;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class StringField
extends Field {
    protected static final String LATIN1 = "ISO-8859-1";
    protected static final byte LATIN1_ZERO = 48;
    private ByteBuffer value = ByteBuffer.allocate(this.getConversionBufInitialSize());
    private byte[] bytes = this.value.array();
    private CharBuffer charValue = CharBuffer.allocate(this.getConversionBufInitialSize());
    private char[] charBytes = this.charValue.array();

    protected int getConversionBufInitialSize() {
        return 256;
    }

    protected StringField(byte[] buffer, int position, int length) {
        super(buffer, position, length);
    }

    public StringField() {
    }

    public StringField(String value) {
        super(value);
    }

    public String getValue(CharsetDecoder decoder) {
        if (this.buffer != null) {
            return new String(this.buffer, this.position, this.length, decoder.charset());
        }
        return null;
    }

    public boolean getValue(ByteBuffer v) {
        if (this.buffer != null) {
            v.put(this.buffer, this.position, this.length);
            return true;
        }
        return false;
    }

    public boolean getValue(CommandId v) {
        if (this.buffer != null) {
            v.set(this.buffer, this.position, this.length);
            return true;
        }
        return false;
    }

    public void setValue(byte[] v, int offset, int length) {
        this.buffer = v;
        this.position = offset;
        this.length = length;
    }

    public void setValue(CommandId v) {
        this.buffer = v.id;
        this.position = 0;
        this.length = v.id == null ? 0 : v.id.length;
    }

    public void setValue(String v, CharsetEncoder encoder) {
        int reqSize;
        if (v == null) {
            this.reset();
            return;
        }
        int vLength = v.length();
        if (vLength > (reqSize = this.charValue.capacity())) {
            while (vLength > reqSize) {
                reqSize *= 2;
            }
            this.charValue = CharBuffer.allocate(reqSize);
            this.charBytes = this.charValue.array();
        }
        reqSize = this.value.capacity();
        float maxBytesPerChar = encoder.maxBytesPerChar();
        if ((float)vLength * maxBytesPerChar > (float)reqSize) {
            while ((float)vLength * maxBytesPerChar > (float)reqSize) {
                reqSize *= 2;
            }
            this.value = ByteBuffer.allocate(reqSize);
            this.bytes = this.value.array();
        }
        this.charValue.clear();
        v.getChars(0, vLength, this.charBytes, 0);
        this.charValue.limit(vLength);
        this.value.clear();
        encoder.reset();
        try {
            CoderResult result = encoder.encode(this.charValue, this.value, true);
            if (result.isError()) {
                result.throwException();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.set(this.bytes, 0, this.value.position());
    }
}

