/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client.fields;

import com.crankuptheamps.client.fields.Field;
import java.nio.charset.StandardCharsets;

public class ReasonField
extends Field {
    private static String[] reasonStrings = new String[]{"", "duplicate", "bad filter", "bad regex topic", "subscription already exists", "deleted", "expired", "match", "invalid topic", "name in use", "auth failure", "not entitled", "authentication disabled", "invalid bookmark", "invalid orderby", "subid in use", "no topic", "logon failed", "logon required", "invalid topic or filter", "invalid subId", "no topic or filter", "no client name", "bad sow key", "regex topic not supported", "sow store failed", "parse error", "not supported", "tx store failure", "duplicate logon attempt", "tx replay failed", "sow canceled", "invalid options", "invalid message type", "orderby too large", "rejected by transport filter", "sow_delete command only supports one of: filter, sow_keys, bookmark, or data", "publish filter no match"};

    public int getValue() {
        if (this.buffer != null) {
            return ReasonField.decodeReason(this.buffer, this.position, this.length);
        }
        return 0;
    }

    public String getText() {
        if (this.buffer != null) {
            return new String(this.buffer, this.position, this.length, StandardCharsets.ISO_8859_1);
        }
        return "";
    }

    private void set(String value) {
        this.set(value.getBytes(StandardCharsets.ISO_8859_1));
    }

    public void setValue(int v) {
        if (v == 0 || v > reasonStrings.length - 1) {
            this.reset();
            return;
        }
        this.set(reasonStrings[v]);
    }

    static final int decodeReason(byte[] buffer, int pos, int len) {
        String reasonBytes = new String(buffer, pos, len, StandardCharsets.ISO_8859_1);
        for (int i = 0; i < reasonStrings.length; ++i) {
            if (!reasonStrings[i].equals(reasonBytes)) continue;
            return i;
        }
        return 38;
    }

    public static final String encodeReason(int r) {
        if (r > reasonStrings.length - 1) {
            return "unknown";
        }
        return reasonStrings[r];
    }
}

