/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client.fields;

import com.crankuptheamps.client.fields.Field;
import com.crankuptheamps.client.fields.StringField;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class OptionsField
extends StringField {
    protected OptionsField(byte[] buffer, int position, int length) {
        super(buffer, position, length);
        int len;
        if (this.buffer == null || (len = this.length--) <= 0 || buffer[this.position + len - 1] == 44) {
            // empty if block
        }
    }

    public OptionsField(String value) {
        super(value);
    }

    public OptionsField() {
    }

    @Override
    public void setValue(byte[] v, int offset, int length) {
        int len;
        super.setValue(v, offset, length);
        if (this.buffer == null || (len = this.length--) <= 0 || this.buffer[this.position + len - 1] == 44) {
            // empty if block
        }
    }

    @Override
    public void setValue(String v, CharsetEncoder encoder) {
        int len;
        super.setValue(v, encoder);
        if (this.buffer == null || (len = this.length--) <= 0 || this.buffer[this.position + len - 1] == 44) {
            // empty if block
        }
    }

    @Override
    public String getValue(CharsetDecoder decoder) {
        if (this.buffer != null) {
            int len;
            if ((len = this.length--) <= 0 || this.buffer[this.position + len - 1] == 44) {
                // empty if block
            }
            return new String(this.buffer, this.position, this.length, decoder.charset());
        }
        return null;
    }

    @Override
    public boolean getValue(ByteBuffer v) {
        if (this.buffer != null) {
            int len;
            if ((len = this.length--) <= 0 || this.buffer[this.position + len - 1] == 44) {
                // empty if block
            }
            v.put(this.buffer, this.position, this.length);
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OptionsField)) {
            if (obj instanceof Field) {
                return super.equals(obj);
            }
            return false;
        }
        int len = this.length;
        if (len > 0 && this.buffer[this.position + len - 1] == 44) {
            --len;
        }
        OptionsField o = (OptionsField)obj;
        int oLen = o.length;
        if (oLen > 0 && o.buffer[o.position + oLen - 1] == 44) {
            --oLen;
        }
        if (oLen != len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (o.buffer[o.position + i] == this.buffer[this.position + i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        int len = this.length;
        if (len > 0 && this.buffer[this.position + len - 1] == 44) {
            --len;
        }
        for (int i = 0; i < len; ++i) {
            result += this.buffer[this.position + i];
        }
        return result;
    }
}

