/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client.fields;

import com.crankuptheamps.client.fields.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class CommandField
extends Field {
    protected static final Charset LATIN1 = StandardCharsets.ISO_8859_1;
    protected static final byte LATIN1_ZERO = 48;
    private static byte[] CT_SUBSCRIBE = null;
    private static byte[] CT_UNSUBSCRIBE = null;
    private static byte[] CT_PUBLISH = null;
    private static byte[] CT_SOW = null;
    private static byte[] CT_LOGON = null;
    private static byte[] CT_START_TIMER = null;
    private static byte[] CT_STOP_TIMER = null;
    private static byte[] CT_SOW_AND_SUBSCRIBE = null;
    private static byte[] CT_DELTA_PUBLISH = null;
    private static byte[] CT_DELTA_SUBSCRIBE = null;
    private static byte[] CT_SOW_AND_DELTA_SUBSCRIBE = null;
    private static byte[] CT_SOW_DELETE = null;
    private static byte[] CT_GROUP_BEGIN = null;
    private static byte[] CT_GROUP_END = null;
    private static byte[] CT_OOF = null;
    private static byte[] CT_ACK = null;
    private static byte[] CT_HEARTBEAT = null;
    private static byte[] CT_FLUSH = null;
    private static byte[] CT_UNKNOWN = null;

    public int getValue() {
        if (this.buffer != null) {
            return CommandField.decodeCommand(this.buffer, this.position, this.length);
        }
        return 0;
    }

    public void setValue(int v) {
        if (v == 0) {
            this.reset();
            return;
        }
        switch (v) {
            case 2: {
                this.set(CT_SUBSCRIBE);
                break;
            }
            case 4: {
                this.set(CT_UNSUBSCRIBE);
                break;
            }
            case 1: {
                this.set(CT_PUBLISH);
                break;
            }
            case 8: {
                this.set(CT_SOW);
                break;
            }
            case 128: {
                this.set(CT_LOGON);
                break;
            }
            case 2048: {
                this.set(CT_START_TIMER);
                break;
            }
            case 4096: {
                this.set(CT_STOP_TIMER);
                break;
            }
            case 256: {
                this.set(CT_SOW_AND_SUBSCRIBE);
                break;
            }
            case 64: {
                this.set(CT_DELTA_PUBLISH);
                break;
            }
            case 512: {
                this.set(CT_DELTA_SUBSCRIBE);
                break;
            }
            case 1024: {
                this.set(CT_SOW_AND_DELTA_SUBSCRIBE);
                break;
            }
            case 32: {
                this.set(CT_SOW_DELETE);
                break;
            }
            case 8192: {
                this.set(CT_GROUP_BEGIN);
                break;
            }
            case 16384: {
                this.set(CT_GROUP_END);
                break;
            }
            case 32768: {
                this.set(CT_OOF);
                break;
            }
            case 65536: {
                this.set(CT_ACK);
                break;
            }
            case 16: {
                this.set(CT_HEARTBEAT);
                break;
            }
            case 131072: {
                this.set(CT_FLUSH);
                break;
            }
            default: {
                this.set(CT_UNKNOWN);
            }
        }
    }

    static final int decodeCommand(byte[] buffer, int pos, int len) {
        switch (len) {
            case 1: {
                switch (buffer[pos]) {
                    case 112: {
                        return 1;
                    }
                }
                break;
            }
            case 3: {
                switch (buffer[pos]) {
                    case 115: {
                        return 8;
                    }
                    case 111: {
                        return 32768;
                    }
                    case 97: {
                        return 65536;
                    }
                }
                break;
            }
            case 5: {
                switch (buffer[pos]) {
                    case 108: {
                        return 128;
                    }
                    case 102: {
                        return 131072;
                    }
                }
                break;
            }
            case 7: {
                return 1;
            }
            case 9: {
                switch (buffer[pos]) {
                    case 115: {
                        return 2;
                    }
                    case 104: {
                        return 16;
                    }
                    case 103: {
                        return 16384;
                    }
                }
                break;
            }
            case 10: {
                switch (buffer[pos + 1]) {
                    case 111: {
                        return 32;
                    }
                    case 116: {
                        return 4096;
                    }
                }
                break;
            }
            case 11: {
                switch (buffer[pos]) {
                    case 117: {
                        return 4;
                    }
                    case 115: {
                        return 2048;
                    }
                    case 103: {
                        return 8192;
                    }
                }
                break;
            }
            case 13: {
                return 64;
            }
            case 15: {
                return 512;
            }
            case 17: {
                switch (buffer[pos]) {
                    case 115: {
                        return 256;
                    }
                }
                break;
            }
            case 23: {
                return 1024;
            }
        }
        return 0;
    }

    public static final String encodeCommand(int command) {
        switch (command) {
            case 1: {
                return "publish";
            }
            case 2: {
                return "subscribe";
            }
            case 4: {
                return "unsubscribe";
            }
            case 8: {
                return "sow";
            }
            case 16: {
                return "heartbeat";
            }
            case 128: {
                return "logon";
            }
            case 2048: {
                return "start_timer";
            }
            case 4096: {
                return "stop_timer";
            }
            case 256: {
                return "sow_and_subscribe";
            }
            case 64: {
                return "delta_publish";
            }
            case 512: {
                return "delta_subscribe";
            }
            case 1024: {
                return "sow_and_delta_subscribe";
            }
            case 32: {
                return "sow_delete";
            }
            case 8192: {
                return "group_begin";
            }
            case 16384: {
                return "group_end";
            }
            case 32768: {
                return "oof";
            }
            case 65536: {
                return "ack";
            }
            case 131072: {
                return "flush";
            }
            case 0: {
                return "unknown";
            }
        }
        return "unknown";
    }

    static {
        CT_SUBSCRIBE = "subscribe".getBytes(LATIN1);
        CT_UNSUBSCRIBE = "unsubscribe".getBytes(LATIN1);
        CT_PUBLISH = "publish".getBytes(LATIN1);
        CT_SOW = "sow".getBytes(LATIN1);
        CT_LOGON = "logon".getBytes(LATIN1);
        CT_START_TIMER = "start_timer".getBytes(LATIN1);
        CT_STOP_TIMER = "stop_timer".getBytes(LATIN1);
        CT_SOW_AND_SUBSCRIBE = "sow_and_subscribe".getBytes(LATIN1);
        CT_DELTA_PUBLISH = "delta_publish".getBytes(LATIN1);
        CT_DELTA_SUBSCRIBE = "delta_subscribe".getBytes(LATIN1);
        CT_SOW_AND_DELTA_SUBSCRIBE = "sow_and_delta_subscribe".getBytes(LATIN1);
        CT_SOW_DELETE = "sow_delete".getBytes(LATIN1);
        CT_GROUP_BEGIN = "group_begin".getBytes(LATIN1);
        CT_GROUP_END = "group_end".getBytes(LATIN1);
        CT_OOF = "oof".getBytes(LATIN1);
        CT_ACK = "ack".getBytes(LATIN1);
        CT_HEARTBEAT = "heartbeat".getBytes(LATIN1);
        CT_FLUSH = "flush".getBytes(LATIN1);
        CT_UNKNOWN = "unknown".getBytes(LATIN1);
    }
}

