/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.exception.CommandException;

public class VersionInfo
implements Comparable<VersionInfo> {
    private String _versionString;
    private long _versionNum = 0L;
    private long DEFAULT_VERSION_NUM = 9900990009900099L;
    private static int MAXVALUES = 4;
    private static int[] MAXDIGITS = new int[]{4, 4, 5, 5};

    public VersionInfo() {
        this._versionString = "default";
    }

    public VersionInfo(String version_) {
        this._versionString = version_ == null || version_.isEmpty() ? "default" : version_;
    }

    public String getVersionString() {
        return this._versionString;
    }

    public void setVersionString(String version_) {
        this._versionString = version_ == null || version_.isEmpty() ? "default" : version_;
        this._versionNum = 0L;
    }

    public long getVersion() {
        if (this._versionNum == 0L) {
            this.parseVersion();
        }
        return this._versionNum;
    }

    public int getOldStyleVersion() {
        int version;
        try {
            version = Client.getVersionAsInt(this._versionString);
        }
        catch (CommandException e) {
            version = 0;
        }
        if (version == 0) {
            version = 99999999;
        }
        return version;
    }

    @Override
    public int compareTo(VersionInfo other) {
        if (this.getVersion() < other.getVersion()) {
            return -1;
        }
        if (this._versionNum > other._versionNum) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof VersionInfo)) {
            return false;
        }
        VersionInfo other = (VersionInfo)obj;
        return this.getVersion() == other.getVersion();
    }

    public int hashCode() {
        return Long.valueOf(this.getVersion()).hashCode();
    }

    private void parseVersion() {
        int i;
        if (!Character.isDigit(this._versionString.charAt(0))) {
            this._versionNum = this.DEFAULT_VERSION_NUM;
            return;
        }
        int digits = 0;
        int values = 0;
        long current = 0L;
        for (i = 0; i < this._versionString.length(); ++i) {
            char c = this._versionString.charAt(i);
            if (Character.isDigit(c)) {
                if (++digits > MAXDIGITS[values]) {
                    this._versionNum = this.DEFAULT_VERSION_NUM;
                    return;
                }
                current *= 10L;
                current += (long)(c - 48);
                continue;
            }
            if (c == '.') {
                this._versionNum += current;
                if (++values >= MAXVALUES) {
                    return;
                }
                for (int j = 0; j < MAXDIGITS[values]; ++j) {
                    this._versionNum *= 10L;
                }
                digits = 0;
                current = 0L;
                continue;
            }
            this._versionNum = this.DEFAULT_VERSION_NUM;
            return;
        }
        this._versionNum += current;
        while (++values < MAXVALUES) {
            for (i = 0; i < MAXDIGITS[values]; ++i) {
                this._versionNum *= 10L;
            }
        }
    }
}

