/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Protocol;
import com.crankuptheamps.client.TCPSTransport;
import com.crankuptheamps.client.TCPTransportImpl;
import com.crankuptheamps.client.TransportFilter;
import com.crankuptheamps.client.exception.InvalidURIException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

public class TCPSTransportImpl
extends TCPTransportImpl {
    public TCPSTransportImpl(Protocol messageType, Properties properties, TransportFilter filter) {
        super(messageType, properties, filter);
    }

    @Override
    protected void handshake() throws Exception {
        ((SSLSocket)this._socket).startHandshake();
    }

    @Override
    protected Socket createSocket() throws Exception {
        String[] protocols;
        SSLSocket s = (SSLSocket)TCPSTransport.getDefaultSSLContext().getSocketFactory().createSocket();
        String[] suites = TCPSTransport.getDefaultEnabledCipherSuites();
        if (suites != null) {
            s.setEnabledCipherSuites(suites);
        }
        if ((protocols = TCPSTransport.getDefaultEnabledProtocols()) != null) {
            s.setEnabledProtocols(protocols);
        }
        return s;
    }

    @Override
    protected void applySocketProperties(Properties properties_) throws SocketException, InvalidURIException {
        if (properties_ == null) {
            return;
        }
        super.applySocketProperties(properties_);
        for (Map.Entry<Object, Object> entry : properties_.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!"sni".equals(key)) continue;
            String SNI = (String)value;
            SSLParameters sslParams = new SSLParameters();
            List<SNIServerName> serverNames = Collections.singletonList(new SNIHostName(SNI));
            sslParams.setServerNames(serverNames);
            ((SSLSocket)this._socket).setSSLParameters(sslParams);
        }
    }
}

