/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.BlockPublishStore;
import com.crankuptheamps.client.Store;
import com.crankuptheamps.client.fields.Field;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MemoryStoreBuffer
implements BlockPublishStore.Buffer {
    protected ByteBuffer _buffer = null;
    protected Store _store = null;

    @Override
    public long getSize() throws IOException {
        return this._buffer == null ? 0L : (long)this._buffer.capacity();
    }

    @Override
    public void setSize(long newSize) throws IOException {
        if (this._buffer == null || newSize > (long)this._buffer.capacity()) {
            ByteBuffer b2 = ByteBuffer.allocate((int)newSize);
            if (this._buffer != null) {
                b2.put(this._buffer.array());
            }
            this._buffer = b2;
        }
    }

    @Override
    public long getPosition() throws IOException {
        return this._buffer.position();
    }

    @Override
    public void setPosition(long position) throws IOException {
        this._buffer.position((int)position);
    }

    @Override
    public void putByte(byte b) throws IOException {
        this._buffer.put(b);
    }

    @Override
    public byte getByte() throws IOException {
        return this._buffer.get();
    }

    @Override
    public void putInt(int i) throws IOException {
        this._buffer.putInt(i);
    }

    @Override
    public void putInt(long position, int i) throws IOException {
        this._buffer.putInt((int)position, i);
    }

    @Override
    public int getInt() throws IOException {
        return this._buffer.getInt();
    }

    @Override
    public int getInt(long position) throws IOException {
        return this._buffer.getInt((int)position);
    }

    @Override
    public void putLong(long l) throws IOException {
        this._buffer.putLong(l);
    }

    @Override
    public void putLong(long position, long l) throws IOException {
        this._buffer.putLong((int)position, l);
    }

    @Override
    public long getLong() throws IOException {
        return this._buffer.getLong();
    }

    @Override
    public void putBytes(BlockPublishStore.ByteSequence bytes) throws IOException {
        this._buffer.put(bytes.array, (int)bytes.offset, (int)bytes.len);
    }

    @Override
    public void getBytes(BlockPublishStore.ByteSequence outBytes) throws IOException {
        if (this._buffer.hasArray()) {
            outBytes.array = this._buffer.array();
            outBytes.offset = this._buffer.position();
            this._buffer.position((int)(outBytes.offset + outBytes.len));
        } else {
            outBytes.array = new byte[(int)outBytes.len];
            outBytes.offset = 0L;
            this._buffer.get(outBytes.array, 0, (int)outBytes.len);
        }
    }

    @Override
    public void putBytes(byte[] buffer, long position, long length) throws IOException {
        if (buffer == null || length == 0L) {
            return;
        }
        this._buffer.put(buffer, (int)position, (int)length);
    }

    @Override
    public void getBytes(Field outField, int length) throws IOException {
        outField.length = length;
        if (outField.length == 0) {
            outField.buffer = null;
            outField.position = 0;
        } else if (this._buffer.hasArray()) {
            outField.buffer = this._buffer.array();
            outField.position = this._buffer.position();
            this._buffer.position(outField.position + outField.length);
        } else {
            outField.buffer = new byte[outField.length];
            outField.position = 0;
            this._buffer.get(outField.buffer, 0, outField.length);
        }
    }

    @Override
    public void zero(long offset, int length) throws IOException {
        for (long i = 0L; i < (long)length; i += 8L) {
            this._buffer.putLong((int)offset + (int)i, 0L);
        }
    }

    @Override
    public void close() throws Exception {
        this._buffer = null;
        this._store = null;
    }
}

