/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.BookmarkRingBuffer;
import com.crankuptheamps.client.BookmarkStore;
import com.crankuptheamps.client.BookmarkStoreResizeHandler;
import com.crankuptheamps.client.FixedRecoveryPointFactory;
import com.crankuptheamps.client.JSONMessage;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.Pool;
import com.crankuptheamps.client.RecoveryPoint;
import com.crankuptheamps.client.RecoveryPointAdapter;
import com.crankuptheamps.client.RecoveryPointFactory;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.exception.CommandException;
import com.crankuptheamps.client.exception.StoreException;
import com.crankuptheamps.client.fields.BookmarkField;
import com.crankuptheamps.client.fields.BookmarkRangeField;
import com.crankuptheamps.client.fields.Field;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LoggedBookmarkStore
implements BookmarkStore {
    static final byte ENTRY_BOOKMARK = 98;
    static final byte ENTRY_DISCARD = 100;
    static final byte ENTRY_PERSISTED = 112;
    HashMap<Field, Subscription> _subs = new HashMap();
    RandomAccessFile _file;
    String _fileName;
    volatile boolean _recovering = false;
    volatile boolean _recentChanged = true;
    final int VERSION = 2;
    Pool<Subscription> _pool;
    BookmarkStoreResizeHandler _resizeHandler = null;
    private int _serverVersion = 4000000;
    final CharsetEncoder _encoder = StandardCharsets.UTF_8.newEncoder();
    final CharsetDecoder _decoder = StandardCharsets.UTF_8.newDecoder();
    final Lock _lock = new ReentrantLock();
    final Lock _subsLock = new ReentrantLock();
    RecoveryPointAdapter _adapter = null;
    RecoveryPointFactory _factory = null;

    public LoggedBookmarkStore(String path) throws IOException {
        this(path, 1);
    }

    public LoggedBookmarkStore(String path, int targetNumberOfSubscriptions) throws IOException {
        this(path, targetNumberOfSubscriptions, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggedBookmarkStore(String path, int targetNumberOfSubscriptions, boolean useLastModifiedTime) throws IOException {
        File bmLogFile = new File(path);
        String recoveryTimestamp = null;
        if (useLastModifiedTime && bmLogFile.exists()) {
            Date lastMod = new Date(bmLogFile.lastModified());
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            df.setTimeZone(tz);
            recoveryTimestamp = df.format(lastMod);
        }
        this._pool = new Pool<Subscription>(Subscription.class, targetNumberOfSubscriptions);
        this._file = new RandomAccessFile(path, "rw");
        this._fileName = path;
        try {
            this.recover();
            if (recoveryTimestamp != null) {
                for (Subscription sub : this._subs.values()) {
                    sub.setRecoveryTimestamp(recoveryTimestamp);
                }
            }
        }
        catch (IOException ioex) {
            try {
                this._file.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this._file = null;
            }
            throw ioex;
        }
    }

    public LoggedBookmarkStore(String path, int targetNumberOfSubscriptions, boolean useLastModifiedTime, RecoveryPointAdapter adapter) throws IOException {
        this(path, targetNumberOfSubscriptions, useLastModifiedTime, adapter, new FixedRecoveryPointFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggedBookmarkStore(String path, int targetNumberOfSubscriptions, boolean useLastModifiedTime, RecoveryPointAdapter adapter, RecoveryPointFactory factory) throws IOException {
        String recoveryTimestamp = null;
        File bmLogFile = new File(path);
        if (useLastModifiedTime && bmLogFile.exists()) {
            Date lastMod = new Date(bmLogFile.lastModified());
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            df.setTimeZone(tz);
            recoveryTimestamp = df.format(lastMod);
        }
        this._pool = new Pool<Subscription>(Subscription.class, targetNumberOfSubscriptions);
        this._file = new RandomAccessFile(path, "rw");
        this._fileName = path;
        try {
            this._recovering = true;
            JSONMessage m = new JSONMessage(this._encoder, this._decoder);
            for (RecoveryPoint rp : adapter) {
                if (rp == null) {
                    break;
                }
                Field subId = rp.getSubId();
                m.reset();
                m.setSubId(subId.buffer, subId.position, subId.length);
                BookmarkField bookmark = rp.getBookmark();
                if (bookmark.isRange()) {
                    m.setBookmark(bookmark.buffer, bookmark.position, bookmark.length);
                    try {
                        this.log(m);
                    }
                    catch (AMPSException aMPSException) {}
                    continue;
                }
                try {
                    for (BookmarkField bm : bookmark.parseBookmarkList()) {
                        if (!bm.isTimestamp()) {
                            m.setBookmark(bm.buffer, bm.position, bm.length);
                            this.isDiscarded(m);
                            if (this.log(m) <= 0L) continue;
                            this.discard(m);
                            continue;
                        }
                        this.find(subId).setRecoveryTimestamp(bm.toString());
                    }
                }
                catch (AMPSException aMPSException) {
                }
            }
        }
        finally {
            this._recovering = false;
        }
        try {
            this.recover();
            if (recoveryTimestamp != null) {
                for (Subscription sub : this._subs.values()) {
                    sub.setRecoveryTimestamp(recoveryTimestamp);
                }
            }
        }
        catch (IOException ioex) {
            try {
                this._file.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this._file = null;
            }
            throw ioex;
        }
        this._adapter = adapter;
        this._factory = factory;
    }

    public void prune() throws IOException, StoreException {
        String name = this._fileName + ".tmp";
        this.prune(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prune(String tmpFileName_) throws IOException, StoreException {
        this._subsLock.lock();
        try {
            List<Map.Entry<Field, Subscription>> subs = this._lockSubs();
            try {
                this.prune(tmpFileName_, subs);
            }
            finally {
                this._unlockSubs(subs);
            }
        }
        finally {
            this._subsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prune(String tmpFileName_, List<Map.Entry<Field, Subscription>> subs_) throws IOException, StoreException {
        this._lock.lock();
        try {
            File tmp;
            if (this._file == null) {
                throw new StoreException("Store not open.");
            }
            if (!this._recentChanged) {
                return;
            }
            RandomAccessFile file = new RandomAccessFile(tmpFileName_, "rw");
            try {
                file.getChannel().force(false);
                file.writeInt(2);
                file.writeByte(10);
                StringBuilder bookmarkBuilder = new StringBuilder(64);
                Field bookmark = new Field();
                for (Map.Entry<Field, Subscription> sub : subs_) {
                    Field subId = sub.getKey();
                    assert (subId != null);
                    Subscription subscription = sub.getValue();
                    BookmarkField recent = (BookmarkField)subscription.getMostRecent().copy();
                    if (recent.isNull()) {
                        recent.copyFrom(Subscription.EPOCH_FIELD);
                    }
                    long recentPub = recent.getPublisherId();
                    if (subscription.getRange().isValid()) {
                        Field range = subscription.getMostRecentList(true);
                        this.writeBookmarkToFile(file, subId, range, (byte)98);
                        recentPub = 0L;
                        recent.reset();
                    }
                    HashMap<Long, Long> publishers = new HashMap<Long, Long>(subscription._publishers);
                    ArrayList<BookmarkRingBuffer.Entry> recovered = new ArrayList<BookmarkRingBuffer.Entry>();
                    subscription.getActiveEntries(recovered);
                    Subscription.setPublishersToDiscarded(recovered, publishers);
                    for (Map.Entry<Long, Long> publisher : publishers.entrySet()) {
                        long pubId = publisher.getKey();
                        long pubSeq = publisher.getValue();
                        if (pubId == 0L || pubSeq == 0L || pubId == recentPub) continue;
                        bookmarkBuilder.setLength(0);
                        bookmarkBuilder.append(Subscription.convertUnsignedLongToString(pubId)).append('|').append(Subscription.convertUnsignedLongToString(pubSeq)).append('|');
                        bookmark.set(bookmarkBuilder.toString().getBytes(StandardCharsets.UTF_8), 0, bookmarkBuilder.length());
                        this.writeBookmarkToFile(file, subId, bookmark, (byte)98);
                        this.writeBookmarkToFile(file, subId, bookmark, (byte)100);
                    }
                    if (recent.length > 1) {
                        this.writeBookmarkToFile(file, subId, recent, (byte)98);
                        this.writeBookmarkToFile(file, subId, recent, (byte)100);
                    }
                    if (subscription._lastPersisted != null && subscription._lastPersisted.length > 1) {
                        this.writeBookmarkToFile(file, subId, subscription._lastPersisted, (byte)112);
                    }
                    for (BookmarkRingBuffer.Entry entry : recovered) {
                        BookmarkField entryBookmark = entry.getBookmark();
                        if (entryBookmark == null || entryBookmark.isNull()) continue;
                        this.writeBookmarkToFile(file, subId, entryBookmark, (byte)98);
                        if (entry.isActive()) continue;
                        this.writeBookmarkToFile(file, subId, entryBookmark, (byte)100);
                    }
                }
            }
            catch (IOException e) {
                file.close();
                File tmp2 = new File(tmpFileName_);
                tmp2.delete();
                throw new StoreException("Failed attempting to prune file " + this._fileName + " to " + tmpFileName_, e);
            }
            file.close();
            this._file.close();
            this._file = null;
            int retries = 0;
            File origTmp = new File(this._fileName);
            while (retries++ < 3 && !origTmp.delete()) {
                if (retries < 3) continue;
                throw new StoreException("Failed to delete original file " + this._fileName + " after completing prune to " + tmpFileName_);
            }
            while (origTmp.exists()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            retries = 0;
            while (retries++ < 3 && !(tmp = new File(tmpFileName_)).renameTo(origTmp)) {
                if (retries >= 3) {
                    throw new StoreException("Failed to rename pruned file " + tmpFileName_ + " to original file name: " + this._fileName);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this._file = new RandomAccessFile(this._fileName, "rw");
            if (this._file.length() > 0L) {
                this._file.seek(this._file.length());
            }
            this._recentChanged = false;
        }
        finally {
            this._lock.unlock();
        }
    }

    private void writeBookmarkToFile(RandomAccessFile file_, Field subId_, Field bookmark_, byte entry_) throws IOException {
        file_.writeInt(subId_.length);
        file_.write(subId_.buffer, subId_.position, subId_.length);
        file_.writeByte(entry_);
        file_.writeInt(bookmark_.length);
        file_.write(bookmark_.buffer, bookmark_.position, bookmark_.length);
        file_.writeByte(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(Field sub, byte entry, Field data) throws IOException {
        this._lock.lock();
        try {
            if (!this._recovering) {
                this.writeBookmarkToFile(this._file, sub, data, entry);
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(Field sub, byte entry, long data) throws IOException {
        this._lock.lock();
        try {
            if (!this._recovering) {
                this._file.writeInt(sub.length);
                this._file.write(sub.buffer, sub.position, sub.length);
                this._file.writeByte(entry);
                this._file.writeLong(data);
                this._file.writeByte(10);
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void recover() throws IOException {
        boolean readInts;
        block62: {
            this._recovering = true;
            if (this._file.length() < 4L) {
                try {
                    this._file.writeInt(2);
                    this._file.writeByte(10);
                }
                finally {
                    this._recovering = false;
                }
                return;
            }
            int version = 0;
            try {
                version = this._file.readInt();
            }
            catch (IOException ex) {
                this._recovering = false;
                throw ex;
            }
            boolean bl = readInts = version == 2;
            if (readInts) {
                try {
                    this._file.readByte();
                }
                catch (IOException ex) {
                    this._recovering = false;
                    throw ex;
                }
                if (this._file.length() == 5L) {
                    this._recovering = false;
                    return;
                }
            } else {
                this._file.seek(0L);
            }
            HashMap ids = new HashMap();
            int maxSubLen = 255;
            byte[] sub = new byte[maxSubLen];
            int maxBookmarkLen = 255;
            byte[] bookmark = new byte[maxBookmarkLen];
            long lastGoodPosition = this._file.getFilePointer();
            int subLen = 0;
            int bmLen = 0;
            Field subId = new Field();
            BookmarkField bookmarkField = new BookmarkField();
            Long zero = 0L;
            Path path = FileSystems.getDefault().getPath(this._fileName, new String[0]);
            FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);
            channel.position(lastGoodPosition);
            FilterInputStream in = null;
            try {
                in = new DataInputStream(new BufferedInputStream(Channels.newInputStream(channel), 8192));
                long position = lastGoodPosition;
                long line = 0L;
                while (lastGoodPosition < this._file.length()) {
                    long entryStartPos = position++;
                    Field subIdCopy = null;
                    if (readInts) {
                        subLen = ((DataInputStream)in).readInt();
                        position += 4L;
                    } else {
                        subLen = ((DataInputStream)in).readUnsignedByte();
                    }
                    if (position < 0L || position + (long)subLen > this._file.length()) {
                        this._file.seek(entryStartPos);
                        throw new IOException("Invalid subid length " + subLen + " starting at position " + entryStartPos + " line " + line + " in file " + this._fileName + " of size " + this._file.length());
                    }
                    if (subLen > maxSubLen) {
                        while (subLen > (maxSubLen *= 2)) {
                        }
                        sub = new byte[maxSubLen];
                    }
                    ((DataInputStream)in).readFully(sub, 0, subLen);
                    subId.set(sub, 0, subLen);
                    position += (long)subLen;
                    HashMap<String, Long> subscriptionMap = (HashMap<String, Long>)ids.get(subId);
                    if (subscriptionMap == null) {
                        subscriptionMap = new HashMap<String, Long>();
                        subIdCopy = subId.copy();
                        ids.put(subIdCopy, subscriptionMap);
                    }
                    Subscription subscription = this.find(subId);
                    int entryType = ((DataInputStream)in).readUnsignedByte();
                    ++position;
                    if (readInts) {
                        bmLen = ((DataInputStream)in).readInt();
                        position += 4L;
                    } else {
                        bmLen = ((DataInputStream)in).readUnsignedByte();
                        ++position;
                    }
                    if (bmLen < 0 || position + (long)bmLen > this._file.length()) {
                        this._file.seek(entryStartPos);
                        throw new IOException("Invalid bookmark len " + bmLen + " starting at position " + entryStartPos + " line " + line + " in file " + this._fileName + " of size " + this._file.length());
                    }
                    if (bmLen > maxBookmarkLen) {
                        while (bmLen > (maxBookmarkLen *= 2)) {
                        }
                        bookmark = new byte[maxBookmarkLen];
                    }
                    ((DataInputStream)in).readFully(bookmark, 0, bmLen);
                    position += (long)bmLen;
                    if (((DataInputStream)in).readUnsignedByte() != 10) {
                        this._file.seek(entryStartPos);
                        throw new IOException("Invalid record didn't end with newline starting at position " + entryStartPos + " line " + line + " in file " + this._fileName + " of size " + this._file.length());
                    }
                    ++position;
                    bookmarkField.set(bookmark, 0, bmLen);
                    switch (entryType) {
                        case 98: {
                            if (bookmarkField.isRange()) {
                                try {
                                    subscription.log(bookmarkField);
                                }
                                catch (CommandException commandException) {}
                                break;
                            }
                            String bmStr = bookmarkField.getValue(this._decoder);
                            if (subscriptionMap.get(bmStr) != null) {
                                subscription.getMostRecent(true);
                                subscriptionMap.clear();
                            }
                            if (!subscription.isDiscarded(bookmarkField)) {
                                try {
                                    long addedIdx = subscription.log(bookmarkField);
                                    subscriptionMap.put(bmStr, addedIdx);
                                }
                                catch (CommandException addedIdx) {}
                                break;
                            }
                            subscriptionMap.put(bmStr, zero);
                            break;
                        }
                        case 100: {
                            String bkmStr = bookmarkField.getValue(this._decoder);
                            Long subscriptionMapEntry = (Long)subscriptionMap.get(bkmStr);
                            if (subscriptionMapEntry == null) break;
                            subscriptionMap.remove(bkmStr);
                            if (subscriptionMapEntry <= 0L) break;
                            subscription.discard(subscriptionMapEntry);
                            break;
                        }
                        case 112: {
                            subscription.setLastPersisted(bookmarkField);
                            break;
                        }
                        default: {
                            throw new IOException("Corrupt file found.");
                        }
                    }
                    lastGoodPosition = position;
                    ++line;
                }
                if (this._file.getFilePointer() != lastGoodPosition) {
                    this._file.seek(lastGoodPosition);
                }
                in.close();
                in = null;
            }
            catch (IOException ex) {
                if (in == null) {
                    this._recovering = false;
                    throw ex;
                }
                boolean onLastTruncatedLine = true;
                try {
                    int len = 0;
                    byte[] buffer = new byte[255];
                    block36: while ((len = ((DataInputStream)in).read(buffer, 0, buffer.length)) != -1) {
                        for (int i = 0; i < len; ++i) {
                            if (10 != buffer[i]) continue;
                            onLastTruncatedLine = false;
                            continue block36;
                        }
                    }
                    in.close();
                    in = null;
                }
                catch (IOException ex2) {
                    ex.addSuppressed(ex2);
                    this._recovering = false;
                    throw ex;
                }
                if (lastGoodPosition > 0L && onLastTruncatedLine) {
                    try {
                        this._file.seek(lastGoodPosition);
                        break block62;
                    }
                    catch (IOException ex2) {
                        ex.addSuppressed(ex2);
                        this._recovering = false;
                        throw ex;
                    }
                }
                this._recovering = false;
                throw ex;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {}
                Iterator<Map.Entry<Field, Subscription>> it = this._subs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Field, Subscription> pairs = it.next();
                    boolean disposeSub = pairs.getValue().justRecovered();
                    if (!disposeSub) continue;
                    it.remove();
                    this._pool.returnToPool(pairs.getValue());
                }
                this._recovering = false;
            }
        }
        if (!readInts) {
            try {
                this.prune();
            }
            catch (StoreException ex) {
                throw new IOException("Failed to rewrite older file version, see inner exception", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long log(Message message) throws AMPSException {
        BookmarkField bookmark = message.getBookmarkRaw();
        if (bookmark.equals(Subscription.EPOCH_FIELD)) {
            return 0L;
        }
        Subscription sub = (Subscription)message.getSubscription();
        Field subId = message.getSubIdRaw();
        if (subId == null || subId.isNull()) {
            subId = message.getSubIdsRaw();
        }
        this._lock.lock();
        try {
            if (!this._recovering && this._file == null) {
                throw new StoreException("Store not open.");
            }
        }
        finally {
            this._lock.unlock();
        }
        long index = 0L;
        try {
            if (sub == null) {
                sub = this.find(subId);
                message.setSubscription(sub);
            }
            index = sub.log(bookmark);
        }
        catch (IOException ioex) {
            throw new AMPSException("Error logging to bookmark store", ioex);
        }
        message.setBookmarkSeqNo(index);
        this._lock.lock();
        try {
            this.write(subId, (byte)98, bookmark);
        }
        catch (IOException ioex) {
            throw new AMPSException("Error logging to bookmark store", ioex);
        }
        finally {
            this._lock.unlock();
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discard(Field subId, long bookmarkSeqNo) throws AMPSException {
        this._lock.lock();
        try {
            if (!this._recovering && this._file == null) {
                throw new StoreException("Store not open.");
            }
        }
        finally {
            this._lock.unlock();
        }
        try {
            this.find(subId).discard(bookmarkSeqNo);
        }
        catch (IOException ioex) {
            throw new AMPSException("Error discarding from bookmark store", ioex);
        }
    }

    @Override
    public void discard(Message message) throws AMPSException {
        this._lock.lock();
        try {
            if (this._file == null) {
                throw new StoreException("Store not open.");
            }
        }
        finally {
            this._lock.unlock();
        }
        BookmarkField bookmarkField = message.getBookmarkRaw();
        if (bookmarkField.equals(Subscription.EPOCH_FIELD) || bookmarkField.isTimestamp() || bookmarkField.isRange() || bookmarkField.isBookmarkList()) {
            return;
        }
        long bookmark = message.getBookmarkSeqNo();
        Subscription sub = (Subscription)message.getSubscription();
        if (sub == null) {
            Field subId = message.getSubIdRaw();
            if (subId == null || subId.isNull()) {
                subId = message.getSubIdsRaw();
            }
            sub = this.find(subId);
            message.setSubscription(sub);
        }
        try {
            sub.discard(bookmark);
        }
        catch (IOException ioex) {
            throw new AMPSException("Error discarding from bookmark store", ioex);
        }
    }

    @Override
    public Field getMostRecent(Field subId) throws AMPSException {
        return this.getMostRecent(subId, true);
    }

    @Override
    public Field getMostRecent(Field subId, boolean useList) throws AMPSException {
        this._lock.lock();
        try {
            if (this._file == null) {
                throw new StoreException("Store not open.");
            }
        }
        finally {
            this._lock.unlock();
        }
        return this.find(subId).getMostRecentList(useList).copy();
    }

    @Override
    public boolean isDiscarded(Message message) throws AMPSException {
        this._lock.lock();
        try {
            if (this._file == null) {
                throw new StoreException("Store not open.");
            }
        }
        finally {
            this._lock.unlock();
        }
        BookmarkField bookmark = message.getBookmarkRaw();
        if (bookmark.equals(Subscription.EPOCH_FIELD)) {
            return true;
        }
        if (bookmark.isTimestamp() || bookmark.isBookmarkList()) {
            return false;
        }
        Subscription sub = (Subscription)message.getSubscription();
        if (sub == null) {
            Field subId = message.getSubIdRaw();
            if (subId == null || subId.isNull()) {
                subId = message.getSubIdsRaw();
            }
            sub = this.find(subId);
            message.setSubscription(sub);
        }
        try {
            return sub.isDiscarded(bookmark);
        }
        catch (IOException ioex) {
            throw new AMPSException("Error checking is discarded in bookmark store", ioex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void persisted(Field subId, long bookmark) throws AMPSException {
        this._lock.lock();
        try {
            if (this._file == null) {
                throw new StoreException("Store not open.");
            }
        }
        finally {
            this._lock.unlock();
        }
        try {
            this.find(subId).setLastPersisted(bookmark);
        }
        catch (IOException ioex) {
            throw new AMPSException("Error logging persisted to bookmark store", ioex);
        }
    }

    @Override
    public void persisted(Field subId, BookmarkField bookmark) throws AMPSException {
        this._lock.lock();
        try {
            if (this._file == null) {
                throw new StoreException("Store not open.");
            }
        }
        finally {
            this._lock.unlock();
        }
        if (bookmark.equals(Subscription.EPOCH_FIELD) || bookmark.isRange()) {
            return;
        }
        try {
            this.find(subId).setLastPersisted(bookmark);
        }
        catch (IOException ioex) {
            throw new AMPSException("Error logging persisted to bookmark store", ioex);
        }
    }

    @Override
    public long getOldestBookmarkSeq(Field subId) throws AMPSException {
        this._lock.lock();
        try {
            if (this._file == null) {
                throw new StoreException("Store not open.");
            }
        }
        finally {
            this._lock.unlock();
        }
        return this.find(subId).getOldestBookmarkSeq();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResizeHandler(BookmarkStoreResizeHandler handler) {
        this._subsLock.lock();
        try {
            this._resizeHandler = handler;
            for (Map.Entry<Field, Subscription> pairs : this._subs.entrySet()) {
                pairs.getValue().setResizeHandler(handler, this);
            }
        }
        finally {
            this._subsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subscription find(Field subId) {
        this._subsLock.lock();
        try {
            Subscription s = this._subs.get(subId);
            if (s == null) {
                s = this._pool.get();
                s.init(subId, this);
                s.setResizeHandler(this._resizeHandler, this);
                this._subs.put(subId.copy(), s);
            }
            Subscription subscription = s;
            return subscription;
        }
        finally {
            this._subsLock.unlock();
        }
    }

    @Override
    public void purge() throws AMPSException {
        if (this._file == null) {
            throw new StoreException("Store not open.");
        }
        this._purge();
        if (this._adapter != null) {
            try {
                this._adapter.purge();
            }
            catch (AMPSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new StoreException("Exception in RecoveryPointAdapter.purge()", e);
            }
        }
    }

    public void _purge() throws AMPSException {
        this._subsLock.lock();
        this._lock.lock();
        try {
            this._recentChanged = true;
            try {
                this._file.setLength(0L);
                this._file.writeInt(2);
                this._file.writeByte(10);
            }
            catch (IOException ioex) {
                throw new StoreException("Error truncating file", ioex);
            }
            for (Subscription sub : this._subs.values()) {
                sub.reset();
                this._pool.returnToPool(sub);
            }
            this._subs.clear();
        }
        finally {
            this._lock.unlock();
            this._subsLock.unlock();
        }
    }

    @Override
    public void purge(Field subId_) throws AMPSException {
        if (this._file == null) {
            throw new StoreException("Store not open.");
        }
        this._purge(subId_);
        if (this._adapter != null) {
            try {
                this._adapter.purge(subId_);
            }
            catch (AMPSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new StoreException("Exception in RecoveryPointAdapter.purge(" + subId_.toString() + ")", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _purge(Field subId_) throws AMPSException {
        this._subsLock.lock();
        String name = "";
        try {
            List<Map.Entry<Field, Subscription>> subs = this._lockSubs();
            try {
                this._lock.lock();
                try {
                    Subscription sub = this._subs.remove(subId_);
                    if (sub == null) {
                        return;
                    }
                    sub.reset();
                    this._pool.returnToPool(sub);
                    name = this._fileName + ".tmp";
                    this.prune(name);
                }
                finally {
                    this._lock.unlock();
                }
            }
            finally {
                this._unlockSubs(subs);
            }
        }
        catch (IOException e) {
            throw new StoreException("Underlying IOException while pruning. temp bookmark log file = " + name, e);
        }
        finally {
            this._subsLock.unlock();
        }
    }

    public void setRecoveryPointFactory(RecoveryPointFactory factory_) throws AMPSException {
        if (factory_ == null || this._adapter == null) {
            throw new CommandException("Factory and Adapter must not be null.");
        }
        this._factory = factory_;
    }

    @Override
    public void close() throws AMPSException {
        this._lock.lock();
        try {
            StoreException ex = null;
            if (this._adapter != null) {
                try {
                    this._adapter.close();
                }
                catch (Exception e) {
                    ex = new StoreException("Error closing adapter", e);
                }
            }
            if (this._file != null) {
                try {
                    this._file.close();
                }
                catch (IOException ioex) {
                    if (ex == null) {
                        throw new StoreException("Error closing file", ioex);
                    }
                    throw new StoreException("Error closing adapter and file " + ioex.toString(), ex);
                }
            } else {
                throw new StoreException("Store not open.");
            }
            if (ex != null) {
                throw ex;
            }
        }
        finally {
            this._adapter = null;
            this._factory = null;
            this._file = null;
            this._lock.unlock();
        }
    }

    @Override
    public void setServerVersion(int version) {
        this._serverVersion = version;
    }

    public int getServerVersion() {
        return this._serverVersion;
    }

    protected void adapterUpdate(Field subId, BookmarkField bookmark) throws IOException {
        if (this._adapter != null) {
            try {
                this._adapter.update(this._factory.createRecoveryPoint(subId, bookmark));
            }
            catch (Exception e) {
                throw new IOException("Exception in LoggedBookmarkStore updating the RecoveryPointAdapter", e);
            }
        }
    }

    private List<Map.Entry<Field, Subscription>> _lockSubs() {
        Vector<Map.Entry<Field, Subscription>> subs = new Vector<Map.Entry<Field, Subscription>>(this._subs.size());
        for (Map.Entry<Field, Subscription> entry : this._subs.entrySet()) {
            subs.add(entry);
        }
        for (Map.Entry<Field, Subscription> entry : subs) {
            entry.getValue().lock();
        }
        return subs;
    }

    private void _unlockSubs(List<Map.Entry<Field, Subscription>> subs_) {
        for (Map.Entry<Field, Subscription> entry : subs_) {
            entry.getValue().unlock();
        }
    }

    protected static class Subscription
    implements com.crankuptheamps.client.Subscription {
        Field _sub;
        BookmarkField _lastPersisted;
        BookmarkRangeField _range = new BookmarkRangeField();
        protected volatile String _recoveryTimestamp = null;
        static final Field EPOCH_FIELD = new Field("0");
        HashMap<Field, Long> _recovered = new HashMap();
        BookmarkRingBuffer _ring = new BookmarkRingBuffer();
        HashMap<Long, Long> _publishers = new HashMap();
        LoggedBookmarkStore _parent;
        final Lock _lock = new ReentrantLock();
        final CharsetEncoder _encoder = StandardCharsets.UTF_8.newEncoder();
        final CharsetDecoder _decoder = StandardCharsets.UTF_8.newDecoder();

        public Subscription() {
            this._lastPersisted = new BookmarkField();
            this._lastPersisted.copyFrom(EPOCH_FIELD);
        }

        public void reset() {
            this._sub.reset();
            this._lastPersisted.copyFrom(EPOCH_FIELD);
            this._recoveryTimestamp = null;
            this._recovered.clear();
            this._ring.reset();
            this._publishers.clear();
            this._range.reset();
        }

        public void init(Field subscriptionId, LoggedBookmarkStore parent) {
            this._sub = subscriptionId.copy();
            this._ring.setSubId(this._sub);
            this._parent = parent;
        }

        public String getRecoveryTimestamp() {
            return this._recoveryTimestamp;
        }

        protected final void setRecoveryTimestamp(String rts) {
            this._recoveryTimestamp = rts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long log(BookmarkField bookmark) throws IOException, CommandException {
            this._lock.lock();
            try {
                if (!bookmark.isRange()) {
                    Long recoveredValue = this._recovered.remove(bookmark);
                    if (recoveredValue != null) {
                        long l = recoveredValue;
                        return l;
                    }
                    if (!bookmark.isBookmarkList()) {
                        long l = this._log(bookmark);
                        return l;
                    }
                    long seq = 0L;
                    for (BookmarkField bm : bookmark.parseBookmarkList()) {
                        this.isDiscarded(bm);
                        seq = this._log(bm);
                        if (seq == 0L) continue;
                        this._ring.discard(seq);
                        this._parent._recentChanged = true;
                    }
                    if (this._parent._adapter != null) {
                        this._parent.adapterUpdate(this._sub, bookmark);
                    }
                    long l = 0L;
                    return l;
                }
                this._range.copyFrom(bookmark);
                if (!this._range.isValid()) {
                    throw new CommandException("Invalid bookmark range specified");
                }
                long seq = 0L;
                if (this._range.isStartExclusive()) {
                    BookmarkField start = this._range.getStart();
                    if (!start.isBookmarkList()) {
                        this.isDiscarded(start);
                        seq = this._log(start);
                        if (seq != 0L) {
                            this._ring.discard(seq);
                            this._parent._recentChanged = true;
                        }
                    } else {
                        for (BookmarkField bm : start.parseBookmarkList()) {
                            this.isDiscarded(bm);
                            seq = this._log(bm);
                            if (seq == 0L) continue;
                            this._ring.discard(seq);
                            this._parent._recentChanged = true;
                        }
                        seq = 0L;
                    }
                }
                if (this._parent._adapter != null) {
                    this._parent.adapterUpdate(this._sub, this._range);
                }
                long l = seq;
                return l;
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long _log(BookmarkField bm) throws IOException {
            long seq = 0L;
            if (!bm.isTimestamp()) {
                seq = this._ring.log(bm);
                while (seq == 0L) {
                    this._lock.unlock();
                    try {
                        this._ring.checkResize();
                    }
                    finally {
                        this._lock.lock();
                    }
                    seq = this._ring.log(bm);
                }
            } else {
                this.setLastPersisted(bm);
            }
            return seq;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void discard(long index) throws IOException {
            this._lock.lock();
            try {
                BookmarkRingBuffer.Entry entry = this._ring.getByIndex(index);
                if (entry == null || !entry.isActive()) {
                    return;
                }
                if (!this._parent._recovering) {
                    this._parent.write(this._sub, (byte)100, entry.getBookmark());
                }
                if (this._ring.discard(index)) {
                    this._parent._recentChanged = true;
                    this._recoveryTimestamp = null;
                    if (this._parent._adapter != null) {
                        this._parent.adapterUpdate(this._sub, (BookmarkField)this.getMostRecentList(false));
                    }
                }
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDiscarded(BookmarkField bookmark) throws IOException {
            this._lock.lock();
            try {
                if (bookmark.isRange() || bookmark.isBookmarkList()) {
                    boolean bl = false;
                    return bl;
                }
                Long recoveredIndex = this._recovered.get(bookmark);
                long publisher = bookmark.getPublisherId();
                long sequence = bookmark.getSequenceNumber();
                if (!this._publishers.containsKey(publisher) || Subscription.unsignedLongLess(this._publishers.get(publisher), sequence)) {
                    this._publishers.put(publisher, sequence);
                    if (recoveredIndex == null) {
                        boolean bl = false;
                        return bl;
                    }
                }
                if (recoveredIndex != null) {
                    long recoveredVal = recoveredIndex;
                    BookmarkRingBuffer.Entry entry = this._ring.getByIndex(recoveredVal);
                    if (entry == null && (recoveredVal < this._ring.getStartIndex() || this._ring.isEmpty())) {
                        this._recovered.remove(bookmark);
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = entry == null ? false : !entry.isActive();
                    return bl;
                }
                boolean bl = !this._parent._recovering;
                return bl;
            }
            finally {
                this._lock.unlock();
            }
        }

        public Field getLastPersisted() {
            this._lock.lock();
            try {
                BookmarkField bookmarkField = this._lastPersisted;
                return bookmarkField;
            }
            finally {
                this._lock.unlock();
            }
        }

        @Override
        public BookmarkRangeField getRange() {
            this._lock.lock();
            try {
                BookmarkRangeField bookmarkRangeField = this._range;
                return bookmarkRangeField;
            }
            finally {
                this._lock.unlock();
            }
        }

        @Override
        public Field getMostRecent() {
            this._lock.lock();
            try {
                Field field = this.getMostRecent(false);
                return field;
            }
            finally {
                this._lock.unlock();
            }
        }

        protected Field getMostRecent(boolean updateRecovery_) {
            this._lock.lock();
            try {
                if (updateRecovery_ && this._parent._recentChanged) {
                    this.updateRecovery();
                }
                BookmarkField bookmarkField = this._ring.getLastDiscarded();
                return bookmarkField;
            }
            finally {
                this._lock.unlock();
            }
        }

        private static String convertUnsignedLongToString(long publisherId_) {
            BigInteger offset = BigInteger.valueOf(Long.MAX_VALUE).shiftLeft(1).add(BigInteger.valueOf(2L));
            if (publisherId_ < 0L) {
                return offset.add(BigInteger.valueOf(publisherId_)).toString();
            }
            return Long.toString(publisherId_);
        }

        private static boolean unsignedLongLess(long seqLeft_, long seqRight_) {
            BigInteger offset = BigInteger.valueOf(Long.MAX_VALUE).shiftLeft(1).add(BigInteger.valueOf(2L));
            if (seqLeft_ < 0L || seqRight_ < 0L) {
                BigInteger right;
                BigInteger left = offset.add(BigInteger.valueOf(seqLeft_));
                return left.compareTo(right = offset.add(BigInteger.valueOf(seqRight_))) < 0;
            }
            return seqLeft_ < seqRight_;
        }

        private static boolean unsignedLongLessEqual(long seqLeft_, long seqRight_) {
            BigInteger offset = BigInteger.valueOf(Long.MAX_VALUE).shiftLeft(1).add(BigInteger.valueOf(2L));
            if (seqLeft_ < 0L || seqRight_ < 0L) {
                BigInteger right;
                BigInteger left = offset.add(BigInteger.valueOf(seqLeft_));
                return left.compareTo(right = offset.add(BigInteger.valueOf(seqRight_))) <= 0;
            }
            return seqLeft_ <= seqRight_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Field getMostRecentList(boolean useList) {
            this._lock.lock();
            try {
                boolean rangeIsValid = this._range.isValid();
                BookmarkField lastDiscarded = this._ring.getLastDiscarded();
                boolean useLastDiscarded = lastDiscarded != null && !lastDiscarded.isNull();
                long lastDiscardedPub = 0L;
                long lastDiscardedSeq = 0L;
                boolean useLastPersisted = this._lastPersisted != null && this._lastPersisted.length > 1;
                long lastPersistedPub = 0L;
                long lastPersistedSeq = 0L;
                if (useLastPersisted) {
                    lastPersistedPub = this._lastPersisted.getPublisherId();
                    lastPersistedSeq = this._lastPersisted.getSequenceNumber();
                }
                if (useLastDiscarded) {
                    if (useLastPersisted && this._ring.isEmpty() && (!rangeIsValid || this._range.getEnd().equals(this._lastPersisted))) {
                        useLastDiscarded = false;
                    } else {
                        lastDiscardedPub = lastDiscarded.getPublisherId();
                        lastDiscardedSeq = lastDiscarded.getSequenceNumber();
                        if (useLastPersisted && lastDiscardedPub == lastPersistedPub) {
                            useLastDiscarded = lastDiscardedSeq < lastPersistedSeq;
                            useLastPersisted = !useLastDiscarded;
                        }
                    }
                }
                StringBuilder recentStr = new StringBuilder();
                BookmarkField recentList = new BookmarkField();
                if (this._recoveryTimestamp != null) {
                    recentStr.append(this._recoveryTimestamp);
                }
                if (useLastDiscarded) {
                    if (recentStr.length() > 0) {
                        recentStr.append(',');
                    }
                    recentStr.append(lastDiscarded.getValue(this._decoder));
                }
                if (useList && (!useLastPersisted && !useLastDiscarded || this._lastPersisted != null && this._lastPersisted.equals(EPOCH_FIELD))) {
                    BookmarkField bookmarkField;
                    if (this._publishers.isEmpty() && !rangeIsValid) {
                        if (this._lastPersisted == null) {
                            this._lastPersisted = new BookmarkField();
                            this._lastPersisted.copyFrom(EPOCH_FIELD);
                        }
                        BookmarkField bookmarkField2 = this._lastPersisted;
                        return bookmarkField2;
                    }
                    if (useLastDiscarded && lastDiscarded.equals(EPOCH_FIELD)) {
                        int len = recentStr.length();
                        if (len == 1) {
                            recentStr.setLength(0);
                        } else if (len > 2) {
                            recentStr.setLength(len - 2);
                        }
                    }
                    for (Map.Entry<Long, Long> pairs : this._publishers.entrySet()) {
                        long pubId = pairs.getKey();
                        if (pubId == 0L || useLastDiscarded && pubId == lastDiscardedPub) continue;
                        long seq = pairs.getValue();
                        if (recentStr.length() > 0) {
                            recentStr.append(',');
                        }
                        recentStr.append(Subscription.convertUnsignedLongToString(pubId)).append('|').append(Subscription.convertUnsignedLongToString(seq)).append('|');
                    }
                    recentList.setValue(recentStr.toString(), this._encoder);
                    if (rangeIsValid) {
                        if (recentList.length > 1 && (this._range.isStartInclusive() || !recentList.equals(this._range.getStart()))) {
                            this._range.replaceStart(recentList, true);
                        }
                        bookmarkField = this._range;
                        return bookmarkField;
                    }
                    bookmarkField = recentList;
                    return bookmarkField;
                }
                if (useLastPersisted) {
                    if (recentStr.length() > 0) {
                        recentStr.append(',');
                    }
                    recentStr.append(this._lastPersisted.getValue(this._decoder));
                }
                recentList.setValue(recentStr.toString(), this._encoder);
                if (rangeIsValid) {
                    if (recentList.length > 1 && (this._range.isStartInclusive() || !recentList.equals(this._range.getStart()))) {
                        this._range.replaceStart(recentList, true);
                    }
                    BookmarkRangeField bookmarkRangeField = this._range;
                    return bookmarkRangeField;
                }
                BookmarkField bookmarkField = recentList;
                return bookmarkField;
            }
            finally {
                this._lock.unlock();
            }
        }

        private void updateRecovery() {
            this._recovered.clear();
            long end = this._ring.getEndIndex();
            for (long index = this._ring.getStartIndex(); index < end; ++index) {
                BookmarkRingBuffer.Entry entry = this._ring.getByIndex(index);
                if (entry == null || entry._bookmark == null || entry._bookmark.isNull()) continue;
                this._recovered.put(entry.getBookmark().copy(), index);
            }
        }

        private void getActiveEntries(ArrayList<BookmarkRingBuffer.Entry> entryList_) {
            this._ring.getRecoveryEntries(entryList_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public void setLastPersisted(long bookmark) throws IOException {
            this._lock.lock();
            try {
                boolean lastPersistedNull;
                BookmarkRingBuffer.Entry entry = this._ring.getByIndex(bookmark);
                if (entry == null) {
                    return;
                }
                BookmarkField bookmarkField = entry.getBookmark();
                if (bookmarkField == null || bookmarkField.isNull()) {
                    return;
                }
                long publisherId = bookmarkField.getPublisherId();
                boolean bl = lastPersistedNull = this._lastPersisted == null;
                if (!lastPersistedNull && publisherId == this._lastPersisted.getPublisherId() && Subscription.unsignedLongLessEqual(bookmarkField.getSequenceNumber(), this._lastPersisted.getSequenceNumber())) {
                    return;
                }
                if (!lastPersistedNull) {
                    this._lastPersisted.reset();
                }
                this._lastPersisted = bookmarkField.copy();
                if (!this._parent._recovering) {
                    this._parent.write(this._sub, (byte)112, bookmarkField);
                }
                if (lastPersistedNull || publisherId == this._ring.getLastDiscarded().getPublisherId()) {
                    this._parent._recentChanged = true;
                    this._recoveryTimestamp = null;
                    if (!this._parent._recovering && this._parent._adapter != null) {
                        this._parent.adapterUpdate(this._sub, (BookmarkField)this.getMostRecentList(false));
                    }
                }
            }
            finally {
                this._lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setLastPersisted(BookmarkField bookmark) throws IOException {
            this._lock.lock();
            try {
                boolean lastPersistedNull;
                if (bookmark == null || bookmark.isNull() || bookmark.equals(this._lastPersisted) || bookmark.isRange()) {
                    return;
                }
                if (bookmark.isTimestamp()) {
                    if (this._lastPersisted != null) {
                        this._lastPersisted.reset();
                    }
                    this._lastPersisted = bookmark.copy();
                    this._parent.write(this._sub, (byte)112, bookmark);
                    this._parent._recentChanged = true;
                    if (this._parent._adapter != null) {
                        this._parent.adapterUpdate(this._sub, (BookmarkField)this.getMostRecentList(false));
                    }
                    return;
                }
                long publisherId = bookmark.getPublisherId();
                boolean bl = lastPersistedNull = this._lastPersisted == null;
                if (!lastPersistedNull && publisherId == this._lastPersisted.getPublisherId() && Subscription.unsignedLongLessEqual(bookmark.getSequenceNumber(), this._lastPersisted.getSequenceNumber())) {
                    return;
                }
                if (!lastPersistedNull) {
                    this._lastPersisted.reset();
                }
                this._lastPersisted = bookmark.copy();
                if (!this._parent._recovering) {
                    this._parent.write(this._sub, (byte)112, bookmark);
                }
                if (lastPersistedNull || this._ring.isEmpty() || publisherId == this._ring.getLastDiscarded().getPublisherId()) {
                    this._parent._recentChanged = true;
                    this._recoveryTimestamp = null;
                    if (!this._parent._recovering && this._parent._adapter != null) {
                        this._parent.adapterUpdate(this._sub, (BookmarkField)this.getMostRecentList(false));
                    }
                }
            }
            finally {
                this._lock.unlock();
            }
        }

        @Override
        public long getOldestBookmarkSeq() {
            this._lock.lock();
            try {
                long l = this._ring.getStartIndex();
                return l;
            }
            finally {
                this._lock.unlock();
            }
        }

        public boolean justRecovered() {
            this._lock.lock();
            try {
                BookmarkField ld = this._ring.getLastDiscarded();
                if ((ld == null || ld.isNull() || ld.equals(EPOCH_FIELD)) && (this._lastPersisted == null || this._lastPersisted.isNull() || this._lastPersisted.equals(EPOCH_FIELD)) && !this._range.isValid()) {
                    this.reset();
                    boolean bl = true;
                    return bl;
                }
                this.updateRecovery();
                ArrayList<BookmarkRingBuffer.Entry> active = new ArrayList<BookmarkRingBuffer.Entry>();
                this.getActiveEntries(active);
                Subscription.setPublishersToDiscarded(active, this._publishers);
            }
            finally {
                this._lock.unlock();
            }
            return false;
        }

        public static void setPublishersToDiscarded(List<BookmarkRingBuffer.Entry> active, Map<Long, Long> publishers) {
            if (active == null || publishers == null || publishers.isEmpty()) {
                return;
            }
            for (BookmarkRingBuffer.Entry entry : active) {
                long publisher;
                Long pubSeq;
                BookmarkField bf;
                long seq;
                if (!entry.isActive() || (seq = (bf = entry.getBookmark()).getSequenceNumber()) == 0L || (pubSeq = publishers.get(publisher = bf.getPublisherId())) == null || !Subscription.unsignedLongLessEqual(seq, pubSeq)) continue;
                publishers.put(publisher, seq - 1L);
            }
        }

        @Override
        public void setResizeHandler(BookmarkStoreResizeHandler handler, BookmarkStore store) {
            this._ring.setResizeHandler(handler, store);
        }

        void lock() {
            this._lock.lock();
        }

        void unlock() {
            this._lock.unlock();
        }
    }
}

