/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Authenticator;
import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.ClientDisconnectHandler;
import com.crankuptheamps.client.ClientDisconnectHandler2;
import com.crankuptheamps.client.CommandId;
import com.crankuptheamps.client.ConnectionInfo;
import com.crankuptheamps.client.DefaultDisconnectHandler;
import com.crankuptheamps.client.DefaultServerChooser;
import com.crankuptheamps.client.ExponentialDelayStrategy;
import com.crankuptheamps.client.FixedDelayStrategy;
import com.crankuptheamps.client.LoggedBookmarkStore;
import com.crankuptheamps.client.MemoryBookmarkStore;
import com.crankuptheamps.client.MemoryPublishStore;
import com.crankuptheamps.client.MemorySubscriptionManager;
import com.crankuptheamps.client.PublishStore;
import com.crankuptheamps.client.ReconnectDelayStrategy;
import com.crankuptheamps.client.ServerChooser;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.exception.AlreadyConnectedException;
import com.crankuptheamps.client.exception.ConnectionException;
import com.crankuptheamps.client.exception.DisconnectedException;
import com.crankuptheamps.client.exception.StoreException;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class HAClient
extends Client {
    private volatile boolean _disconnected = true;
    private static final int DefaultTimeout = 10000;
    private Lock _haClientLock = new ReentrantLock();
    private int _timeout = 10000;
    private ReconnectDelayStrategy _delayStrategy = null;
    ServerChooser _serverChooser;
    String _options;

    public void setReconnectDelay(int reconnectInterval) {
        this._delayStrategy = new FixedDelayStrategy(reconnectInterval);
    }

    public void setTimeout(int timeout_) {
        this._timeout = timeout_;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public ServerChooser getServerChooser() {
        return this._serverChooser;
    }

    public void setServerChooser(ServerChooser serverChooser_) {
        this._haClientLock.lock();
        try {
            this._serverChooser = serverChooser_ != null ? serverChooser_ : new DefaultServerChooser();
        }
        finally {
            this._haClientLock.unlock();
        }
    }

    public String getLogonOptions() {
        return this._options;
    }

    public void setLogonOptions(String options_) {
        this._options = options_;
    }

    public HAClient(String name) {
        super(name);
        super.setDisconnectHandler(new HADisconnectHandler());
        super.setSubscriptionManager(new MemorySubscriptionManager());
        this.setReconnectDelayStrategy(new ExponentialDelayStrategy());
    }

    public static HAClient createMemoryBacked(String name) throws StoreException {
        HAClient client = new HAClient(name);
        try {
            client.setBookmarkStore(new MemoryBookmarkStore());
            client.setPublishStore(new MemoryPublishStore(10000));
        }
        catch (AlreadyConnectedException alreadyConnectedException) {
        }
        catch (StoreException ex_) {
            client.close();
            throw ex_;
        }
        return client;
    }

    public static HAClient createFileBacked(String name, String publishLog, int initialPublishCapacity, String subscribeLog) throws IOException, StoreException {
        HAClient client = new HAClient(name);
        try {
            client.setBookmarkStore(new LoggedBookmarkStore(subscribeLog));
            client.setPublishStore(new PublishStore(publishLog, initialPublishCapacity));
        }
        catch (AlreadyConnectedException alreadyConnectedException) {
        }
        catch (IOException ex_) {
            client.close();
            throw ex_;
        }
        catch (StoreException ex_) {
            client.close();
            throw ex_;
        }
        return client;
    }

    public static HAClient createFileBacked(String name, String publishLog, String subscribeLog) throws IOException, StoreException {
        HAClient client = new HAClient(name);
        try {
            client.setBookmarkStore(new LoggedBookmarkStore(subscribeLog));
            client.setPublishStore(new PublishStore(publishLog));
        }
        catch (AlreadyConnectedException alreadyConnectedException) {
        }
        catch (IOException ex_) {
            client.close();
            throw ex_;
        }
        catch (StoreException ex_) {
            client.close();
            throw ex_;
        }
        return client;
    }

    public void connectAndLogon() throws ConnectionException {
        this._haClientLock.lock();
        try {
            if (!this._disconnected) {
                throw new AlreadyConnectedException("HAClient is already connected. Call disconnect() first.");
            }
            this._disconnected = false;
            this._delayStrategy.reset();
            while (true) {
                this.connectAndLogonInternal();
                try {
                    this.getSubscriptionManager().resubscribe(this);
                    this.broadcastConnectionStateChanged(32);
                    return;
                }
                catch (AMPSException subException) {
                    super.disconnect();
                    try {
                        this._serverChooser.reportFailure(subException, this.getConnectionInfo());
                    }
                    catch (Exception ex) {
                        throw new ConnectionException("ServerChooser.reportFailure exception", ex);
                    }
                    continue;
                }
                break;
            }
        }
        finally {
            this._haClientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connectAndLogonInternal() throws ConnectionException {
        this._haClientLock.lock();
        try {
            if (this._serverChooser == null) {
                this._disconnected = true;
                throw new ConnectionException("No server chooser registered with this HAClient.");
            }
            ClientDisconnectHandler currentHandler = super.getDisconnectHandler();
            super.setDisconnectHandler(new DefaultDisconnectHandler());
            long origAckTimeout = super.getAckTimeout();
            super.setAckTimeout(0L);
            try {
                while (!this._disconnected) {
                    String uri = this._serverChooser.getCurrentURI();
                    if (uri == null) {
                        this._disconnected = true;
                        throw new ConnectionException("No AMPS instances available for connection. " + this._serverChooser.getError());
                    }
                    int sleepTimeMillis = 0;
                    try {
                        sleepTimeMillis = this._delayStrategy.getConnectWaitDuration(uri);
                    }
                    catch (Exception e) {
                        this._disconnected = true;
                        throw new ConnectionException("The reconnect delay strategy indicated that no more reconnect attempts should be made. The last connection error was: " + this._serverChooser.getError(), e);
                    }
                    try {
                        Thread.sleep(sleepTimeMillis);
                        Authenticator authenticator = this._serverChooser.getCurrentAuthenticator();
                        this.lock.lock();
                        try {
                            if (this._disconnected) {
                                return;
                            }
                            super.connect(uri);
                            super.logon(this._timeout, authenticator, this._options);
                        }
                        finally {
                            this.lock.unlock();
                        }
                        this._serverChooser.reportSuccess(this.getConnectionInfo());
                        this._delayStrategy.reset();
                        if (!this._disconnected) return;
                        super.disconnect();
                        return;
                    }
                    catch (Exception exception) {
                        ConnectionInfo ci = this.getConnectionInfo();
                        ci.put("client.uri", uri);
                        try {
                            this._serverChooser.reportFailure(exception, ci);
                        }
                        catch (Exception ex) {
                            throw new ConnectionException("ServerChooser.reportFailure exception", ex);
                        }
                        try {
                            super._disconnect(true);
                        }
                        catch (Exception e) {
                            if (this.exceptionListener == null) continue;
                            this.exceptionListener.exceptionThrown(e);
                        }
                    }
                }
            }
            finally {
                super.setAckTimeout(origAckTimeout);
                super.setDisconnectHandler(currentHandler);
            }
        }
        finally {
            this._haClientLock.unlock();
        }
    }

    public void connect() throws ConnectionException {
        this.connectAndLogon();
    }

    @Override
    public void connect(String uri) throws ConnectionException {
        this.connectAndLogon();
    }

    @Override
    public CommandId logon(long timeout) throws ConnectionException {
        if (this._disconnected) {
            throw new DisconnectedException("Attempt to logon a disconnected HAClient. Call connectAndLogon() instead.");
        }
        throw new AlreadyConnectedException("Attempt to logon an HAClient. Call connectAndLogon() instead.");
    }

    @Override
    public CommandId logon(String options) throws ConnectionException {
        if (this._disconnected) {
            throw new DisconnectedException("Attempt to logon a disconnected HAClient. Call connectAndLogon() instead.");
        }
        throw new AlreadyConnectedException("Attempt to logon an HAClient. Call connectAndLogon() instead.");
    }

    @Override
    public CommandId logon(long timeout, String options) throws ConnectionException {
        if (this._disconnected) {
            throw new DisconnectedException("Attempt to logon a disconnected HAClient. Call connectAndLogon() instead.");
        }
        throw new AlreadyConnectedException("Attempt to logon an HAClient. Call connectAndLogon() instead.");
    }

    @Override
    public CommandId logon(long timeout, Authenticator authenticator) throws ConnectionException {
        if (this._disconnected) {
            throw new DisconnectedException("Attempt to logon a disconnected HAClient. Call connectAndLogon() instead.");
        }
        throw new AlreadyConnectedException("Attempt to logon an HAClient. Call connectAndLogon() instead.");
    }

    @Override
    public CommandId logon(long timeout, Authenticator authenticator, String options) throws ConnectionException {
        if (this._disconnected) {
            throw new DisconnectedException("Attempt to logon a disconnected HAClient. Call connectAndLogon() instead.");
        }
        throw new AlreadyConnectedException("Attempt to logon an HAClient. Call connectAndLogon() instead.");
    }

    @Override
    public CommandId logon() throws ConnectionException {
        if (this._disconnected) {
            throw new DisconnectedException("Attempt to logon a disconnected HAClient. Call connectAndLogon() instead.");
        }
        throw new AlreadyConnectedException("Attempt to logon an HAClient. Call connectAndLogon() instead.");
    }

    @Override
    public void disconnect() {
        this._disconnected = true;
        super.disconnect();
    }

    @Override
    public ConnectionInfo getConnectionInfo() {
        ConnectionInfo ci = super.getConnectionInfo();
        ci.put("haClient.timeout", this._timeout);
        return ci;
    }

    public final HAClient setReconnectDelayStrategy(ReconnectDelayStrategy delayStrategy_) {
        this._haClientLock.lock();
        try {
            this._delayStrategy = delayStrategy_ != null ? delayStrategy_ : new ExponentialDelayStrategy();
        }
        finally {
            this._haClientLock.unlock();
        }
        return this;
    }

    public ReconnectDelayStrategy getReconnectDelayStrategy() {
        return this._delayStrategy;
    }

    public static class HADisconnectHandler
    implements ClientDisconnectHandler,
    ClientDisconnectHandler2 {
        @Override
        public void invoke(Client client) {
        }

        @Override
        public void invoke(Client client_, Exception e_) {
            this.invoke(client_);
            HAClient haClient = (HAClient)client_;
            try {
                haClient.getServerChooser().reportFailure(e_, client_.getConnectionInfo());
                haClient.connectAndLogonInternal();
            }
            catch (Exception e) {
                if (client_.exceptionListener != null) {
                    client_.exceptionListener.exceptionThrown(e);
                }
                return;
            }
        }
    }
}

