/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.ReconnectDelayStrategy;
import com.crankuptheamps.client.exception.AMPSException;

public class FixedDelayStrategy
implements ReconnectDelayStrategy {
    public static final int DEFAULT_DELAY = 200;
    protected int _delay;
    protected int _maximum;
    protected long _start;
    protected String _lastUri;
    protected String _firstUri;

    public FixedDelayStrategy() {
        this._delay = 200;
        this._maximum = 0;
    }

    public FixedDelayStrategy(int delay_) {
        this._maximum = 0;
        this._delay = delay_ < 0 ? 200 : delay_;
    }

    public FixedDelayStrategy(int delay_, int maximum_) {
        this._maximum = maximum_;
        this._delay = delay_ < 0 ? 200 : delay_;
    }

    @Override
    public int getConnectWaitDuration(String uri_) throws Exception {
        int delay = 0;
        if (this._lastUri == null || !this._lastUri.equals(uri_)) {
            this._lastUri = uri_;
            if (this._firstUri != null && this._firstUri.equals(uri_)) {
                delay = this._delay;
            } else if (this._firstUri == null) {
                this._firstUri = uri_;
            }
        } else {
            delay = this._delay;
        }
        if (this._maximum > 0) {
            long now = System.currentTimeMillis();
            if (this._start > 0L) {
                if (now - this._start > (long)(this._maximum + delay)) {
                    throw new MaximumRetryExceeded();
                }
            } else {
                this._start = now;
            }
        }
        return delay;
    }

    @Override
    public void reset() {
        this._lastUri = null;
        this._firstUri = null;
        this._start = 0L;
    }

    public static class MaximumRetryExceeded
    extends AMPSException {
        private static final long serialVersionUID = 1L;
    }
}

