/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.fields.Field;
import java.nio.charset.Charset;

public class CompositeMessageParser {
    private static int MAX_PARTS = 1024;
    private static Charset UTF8 = Charset.forName("UTF-8");
    private int[] _metadata = new int[MAX_PARTS * 2];
    private byte[] _data = null;
    private int _validCount;

    public CompositeMessageParser() {
        this._validCount = 0;
    }

    public CompositeMessageParser(Field body_) {
        this.parse(body_);
    }

    public CompositeMessageParser(Message message_) {
        this.parse(message_.getDataRaw());
    }

    public final int parse(Message message_) {
        return this.parse(message_.getDataRaw());
    }

    public final int parse(Field body_) {
        this._validCount = 0;
        int position = body_.position;
        int end = position + body_.length;
        byte[] buf = body_.buffer;
        int metaIndex = 0;
        while (position + 4 <= end) {
            int partlength = (buf[position++] & 0xFF) << 24;
            partlength |= (buf[position++] & 0xFF) << 16;
            partlength |= (buf[position++] & 0xFF) << 8;
            int n = position++;
            this._metadata[metaIndex++] = position;
            this._metadata[metaIndex++] = partlength |= buf[n] & 0xFF;
            position += partlength;
        }
        this._data = buf;
        this._validCount = metaIndex / 2;
        return this._validCount;
    }

    public String getString(int index_) {
        return this.getString(index_, UTF8);
    }

    public String getString(int index_, Charset charset) {
        if (index_ < this._validCount) {
            return new String(this._data, this._metadata[index_ * 2], this._metadata[index_ * 2 + 1], charset);
        }
        throw new RuntimeException("index out of bounds.");
    }

    public Field getPart(int index_, Field field_) {
        if (index_ < this._validCount) {
            field_.buffer = this._data;
            field_.position = this._metadata[index_ * 2];
            field_.length = this._metadata[index_ * 2 + 1];
            return field_;
        }
        throw new RuntimeException("index out of bounds.");
    }
}

