/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.AMPSRunnable;
import com.crankuptheamps.client.Authenticator;
import com.crankuptheamps.client.BookmarkStore;
import com.crankuptheamps.client.ClientDisconnectHandler;
import com.crankuptheamps.client.ClientDisconnectHandler2;
import com.crankuptheamps.client.Command;
import com.crankuptheamps.client.CommandId;
import com.crankuptheamps.client.ConnectionInfo;
import com.crankuptheamps.client.ConnectionStateListener;
import com.crankuptheamps.client.DefaultAuthenticator;
import com.crankuptheamps.client.DefaultBookmarkStore;
import com.crankuptheamps.client.DefaultDisconnectHandler;
import com.crankuptheamps.client.DefaultMessageHandler;
import com.crankuptheamps.client.DefaultSubscriptionManager;
import com.crankuptheamps.client.DefaultTransportFilter;
import com.crankuptheamps.client.FailedWriteHandler;
import com.crankuptheamps.client.FailedWriteHandlerV4;
import com.crankuptheamps.client.HashBox;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.MessageHandler;
import com.crankuptheamps.client.MessageRouter;
import com.crankuptheamps.client.MessageStream;
import com.crankuptheamps.client.Protocol;
import com.crankuptheamps.client.ProtocolFactory;
import com.crankuptheamps.client.Store;
import com.crankuptheamps.client.SubscriptionManager;
import com.crankuptheamps.client.ThreadCreatedHandler;
import com.crankuptheamps.client.Transport;
import com.crankuptheamps.client.TransportDisconnectHandler;
import com.crankuptheamps.client.TransportFactory;
import com.crankuptheamps.client.TransportFilter;
import com.crankuptheamps.client.URIProperties;
import com.crankuptheamps.client.VersionInfo;
import com.crankuptheamps.client.exception.AMPSException;
import com.crankuptheamps.client.exception.AlreadyConnectedException;
import com.crankuptheamps.client.exception.AuthenticationException;
import com.crankuptheamps.client.exception.BadFilterException;
import com.crankuptheamps.client.exception.BadRegexTopicException;
import com.crankuptheamps.client.exception.BadSowKeyException;
import com.crankuptheamps.client.exception.CommandException;
import com.crankuptheamps.client.exception.ConnectionException;
import com.crankuptheamps.client.exception.ConnectionRefusedException;
import com.crankuptheamps.client.exception.DisconnectedException;
import com.crankuptheamps.client.exception.DuplicateLogonException;
import com.crankuptheamps.client.exception.InvalidBookmarkException;
import com.crankuptheamps.client.exception.InvalidOptionsException;
import com.crankuptheamps.client.exception.InvalidOrderByException;
import com.crankuptheamps.client.exception.InvalidSubIdException;
import com.crankuptheamps.client.exception.InvalidTopicException;
import com.crankuptheamps.client.exception.InvalidURIException;
import com.crankuptheamps.client.exception.LogonRequiredException;
import com.crankuptheamps.client.exception.NameInUseException;
import com.crankuptheamps.client.exception.NotEntitledException;
import com.crankuptheamps.client.exception.PublishFilterException;
import com.crankuptheamps.client.exception.RetryOperationException;
import com.crankuptheamps.client.exception.StoreException;
import com.crankuptheamps.client.exception.SubidInUseException;
import com.crankuptheamps.client.exception.SubscriptionAlreadyExistsException;
import com.crankuptheamps.client.exception.TimedOutException;
import com.crankuptheamps.client.fields.BookmarkField;
import com.crankuptheamps.client.fields.Field;
import com.crankuptheamps.client.fields.LongField;
import com.crankuptheamps.client.fields.OptionsField;
import com.crankuptheamps.client.fields.StringField;
import java.beans.ExceptionListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class Client
implements AutoCloseable {
    private volatile String name = null;
    private volatile String nameHash = null;
    private volatile String logonCorrelationData = null;
    private Transport transport = null;
    private long lastSentSequenceNumber = 0L;
    private Store publishStore = null;
    private volatile boolean connected = false;
    private volatile boolean _isRetryOnDisconnect = true;
    private volatile int _defaultMaxDepth = Integer.MAX_VALUE;
    private volatile URI uri = null;
    private volatile ClientDisconnectHandler disconnectHandler = new DefaultDisconnectHandler();
    protected volatile ExceptionListener exceptionListener = null;
    private Message message = null;
    private Command _command = new Command();
    private ThreadLocal<Command> _publishCommand = new ThreadLocal<Command>(){

        @Override
        protected Command initialValue() {
            return new Command(1);
        }
    };
    private ThreadLocal<byte[]> _bookmarksData = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[64];
        }
    };
    private Message beatMessage = null;
    protected final Lock lock = new ReentrantLock();
    private final Condition _reconnecting = this.lock.newCondition();
    private final Lock acksLock = new ReentrantLock();
    private final Condition ackReceived = this.acksLock.newCondition();
    protected volatile int _lastFailedConnectionVersion = -1;
    private final HashSet<ConnectionStateListener> _connectionStateListeners = new HashSet();
    private volatile long _queueAckTimeout = 0L;
    private volatile boolean _isAutoAckEnabled = false;
    private volatile int _ackBatchSize = 0;
    private HashBox _hashBox = new HashBox();
    private CommandId _queueAckCommandId = CommandId.nextIdentifier();
    private static final OptionsField CANCEL_FIELD = new OptionsField("cancel,");
    private Map<HashBox, QueueBookmarks> _topicHashMap = new HashMap<HashBox, QueueBookmarks>();
    private Map<CommandId, AckResponse> _acks = new ConcurrentHashMap<CommandId, AckResponse>();
    private MessageRouter _routes = new MessageRouter();
    private ClientHandler _handler = new ClientHandler(this);
    private int version = 327680;
    private static volatile String _version = null;
    private BookmarkStore bookmarkStore = new DefaultBookmarkStore();
    private volatile String username;
    private volatile SubscriptionManager subscriptionManager = new DefaultSubscriptionManager();
    private volatile boolean _reconnectingPublishStore = false;
    private volatile boolean _reconnectingSubscriptionManager = false;
    private boolean _defaultSubscriptionManager = true;
    private volatile FailedWriteHandler _failedWriteHandler = null;
    private VersionInfo serverVersion = new VersionInfo("default");
    private StopWatch heartbeatTimer = new StopWatch();
    private int _heartbeatInterval = 0;
    private int _readTimeout = 0;
    public static final int MIN_PERSISTED_BOOKMARK_VERSION = 3080000;
    public static final int MIN_MULTI_BOOKMARK_VERSION = 4000000;
    private static final int MIN_FLUSH_VERSION = 4000000;
    private ThreadCreatedHandler _threadCreatedHandler = null;
    private TransportFilter _transportFilter = null;
    private final MessageHandler[] _globalCommandTypeHandlers = new MessageHandler[GlobalCommandTypeHandlers.COUNT.ordinal()];
    private static VersionInfo minPersistedFlushVersion = new VersionInfo("5.3.3");
    private ClientStoreReplayer replayer = null;

    public Client(String name) {
        this(name, null);
    }

    public Client(String name, int version) {
        this(name, null, version);
    }

    public Client(String name, Transport transport) {
        this(name, transport, 327680);
    }

    public Client(String name, Transport transport, int version) {
        this.name = name;
        if (transport != null) {
            this.transport = transport;
            this.transport.setMessageHandler(this._handler);
            this.transport.setDisconnectHandler(this._handler);
            this.transport.setIdleRunnable(new AckFlusherRunnable());
            this.message = this.transport.allocateMessage();
            this.message._client = this;
            this.beatMessage = this.transport.allocateMessage();
            this.beatMessage.setCommand(16);
            this.beatMessage.setOptions("beat");
        }
        this.version = version;
        this.replayer = new ClientStoreReplayer(this);
        for (int i = 0; i < GlobalCommandTypeHandlers.COUNT.ordinal(); ++i) {
            this._globalCommandTypeHandlers[i] = new DefaultMessageHandler();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getNameHash() {
        return this.nameHash;
    }

    public URI getURI() {
        return this.uri;
    }

    public int getServerVersion() {
        return this.serverVersion.getOldStyleVersion();
    }

    public VersionInfo getServerVersionInfo() {
        return this.serverVersion;
    }

    @Deprecated
    public static int getVersionAsInt(String version) throws CommandException {
        if (version == null || version.length() == 0) {
            return 0;
        }
        int retVersion = 0;
        byte c = 0;
        int dots = 0;
        int lastDot = -1;
        byte[] bytes = version.getBytes(StandardCharsets.ISO_8859_1);
        for (int i = 0; dots < 4 && i < version.length(); ++i) {
            c = bytes[i];
            if (c == 46) {
                ++dots;
                retVersion *= 10;
                if (i - lastDot > 5) {
                    throw new CommandException("Too many digits between dots found translating version string.");
                }
                if (i - lastDot > 3) {
                    retVersion *= 10;
                    retVersion += 99;
                } else {
                    if (i - lastDot == 3) {
                        retVersion += bytes[i - 2] - 48;
                    }
                    retVersion *= 10;
                    retVersion += bytes[i - 1] - 48;
                }
                lastDot = i;
                continue;
            }
            if (c < 48 || c > 57) {
                throw new CommandException("Invalid character found in version string.");
            }
            if (i != version.length() - 1) continue;
            ++dots;
            retVersion *= 10;
            if (i - lastDot > 4) {
                throw new CommandException("Too many digits between dots found translating version string.");
            }
            if (i - lastDot > 2) {
                retVersion *= 10;
                retVersion += 99;
                continue;
            }
            if (i - lastDot == 2) {
                retVersion += bytes[i - 1] - 48;
            }
            retVersion *= 10;
            retVersion += bytes[i] - 48;
        }
        while (dots < 4) {
            retVersion *= 100;
            ++dots;
        }
        return retVersion;
    }

    public Transport getTransport() {
        try {
            this.lock.lock();
            Transport transport = this.transport;
            return transport;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setBookmarkStore(BookmarkStore val) throws AlreadyConnectedException {
        try {
            this.lock.lock();
            if (this.connected) {
                throw new AlreadyConnectedException("Setting a bookmark store on a connected client is undefined behavior.");
            }
            this.bookmarkStore = val != null ? val : new DefaultBookmarkStore();
        }
        finally {
            this.lock.unlock();
        }
    }

    public BookmarkStore getBookmarkStore() {
        return this.bookmarkStore;
    }

    public void setPublishStore(Store store) throws AlreadyConnectedException {
        try {
            this.lock.lock();
            if (this.connected) {
                throw new AlreadyConnectedException("Setting a publish store on a connected client is undefined behavior.");
            }
            this.publishStore = store;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Store getPublishStore() {
        return this.publishStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String uri) throws ConnectionException {
        this.lock.lock();
        try {
            try {
                this.uri = new URI(uri);
            }
            catch (URISyntaxException urisex) {
                throw new InvalidURIException(urisex);
            }
            if (this.transport == null) {
                URIProperties props = new URIProperties(this.uri);
                String uriPath = this.uri.getPath();
                String[] sPath = uriPath.substring(1, uriPath.length()).split("/");
                String sProtocol = sPath[0];
                if (sPath.length > 1 && !"amps".equals(sProtocol)) {
                    throw new InvalidURIException("Specification of message type requires amps protocol");
                }
                Protocol messageType = ProtocolFactory.createProtocol(sProtocol, props);
                this.transport = TransportFactory.createTransport(this.uri.getScheme(), messageType, props);
                this.message = this.transport.allocateMessage();
                this.message._client = this;
                this.beatMessage = this.transport.allocateMessage();
                this.beatMessage.setCommand(16);
                this.beatMessage.setOptions("beat");
                if (this.publishStore != null) {
                    this.publishStore.setMessage(this.transport.allocateMessage());
                }
                this.transport.setMessageHandler(this._handler);
                this.transport.setDisconnectHandler(this._handler);
                this.transport.setIdleRunnable(new AckFlusherRunnable());
            }
            if (this._threadCreatedHandler != null) {
                this.transport.setThreadCreatedHandler(this._threadCreatedHandler);
            }
            if (this.exceptionListener != null) {
                this.transport.setExceptionListener(this.exceptionListener);
            }
            if (this._transportFilter != null) {
                this.transport.setTransportFilter(this._transportFilter);
            }
            this.transport.connect(this.uri);
            this.broadcastConnectionStateChanged(2);
            this.connected = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setDisconnectHandler(ClientDisconnectHandler disconnectHandler_) {
        this.disconnectHandler = disconnectHandler_ != null ? disconnectHandler_ : new DefaultDisconnectHandler();
    }

    public ClientDisconnectHandler getDisconnectHandler() {
        return this.disconnectHandler;
    }

    @Deprecated
    public void setUnhandledMessageHandler(MessageHandler messageHandler) {
        this.setLastChanceMessageHandler(messageHandler);
    }

    public void setLastChanceMessageHandler(MessageHandler messageHandler) {
        this._globalCommandTypeHandlers[GlobalCommandTypeHandlers.LastChance.ordinal()] = messageHandler != null ? messageHandler : new DefaultMessageHandler();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
        if (this.transport != null && exceptionListener != null) {
            this.transport.setExceptionListener(exceptionListener);
        }
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setSubscriptionManager(SubscriptionManager subscriptionManager) {
        if (subscriptionManager != null) {
            this.subscriptionManager = subscriptionManager;
            this._defaultSubscriptionManager = subscriptionManager instanceof DefaultSubscriptionManager;
        } else {
            this.subscriptionManager = new DefaultSubscriptionManager();
            this._defaultSubscriptionManager = true;
        }
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    void absorbedException(Exception e) {
        try {
            if (this.exceptionListener != null) {
                this.exceptionListener.exceptionThrown(e);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setGlobalCommandTypeMessageHandler(String command, MessageHandler messageHandler) throws CommandException {
        MessageHandler handler = messageHandler;
        if (handler == null) {
            handler = new DefaultMessageHandler();
        }
        switch (command.charAt(0)) {
            case 'h': {
                this.setGlobalCommandTypeMessageHandler(GlobalCommandTypeHandlers.Heartbeat, handler);
                break;
            }
            case 'a': {
                this.setGlobalCommandTypeMessageHandler(GlobalCommandTypeHandlers.Ack, handler);
                break;
            }
            case 'L': 
            case 'l': {
                this.setGlobalCommandTypeMessageHandler(GlobalCommandTypeHandlers.LastChance, handler);
                break;
            }
            case 'D': 
            case 'd': {
                this.setGlobalCommandTypeMessageHandler(GlobalCommandTypeHandlers.DuplicateMessage, handler);
                break;
            }
            default: {
                throw new CommandException("Invalid command " + command + " passed to setGlobalCommandTypeMessageHandler");
            }
        }
    }

    public void setGlobalCommandTypeMessageHandler(int command, MessageHandler messageHandler) throws CommandException {
        MessageHandler handler = messageHandler;
        if (handler == null) {
            handler = new DefaultMessageHandler();
        }
        switch (command) {
            case 16: {
                this.setGlobalCommandTypeMessageHandler(GlobalCommandTypeHandlers.Heartbeat, handler);
                break;
            }
            case 65536: {
                this.setGlobalCommandTypeMessageHandler(GlobalCommandTypeHandlers.Ack, handler);
                break;
            }
            default: {
                throw new CommandException("Invalid command " + command + " passed to setGlobalCommandTypeMessageHandler");
            }
        }
    }

    public void setGlobalCommandTypeMessageHandler(GlobalCommandTypeHandlers command, MessageHandler messageHandler) throws CommandException {
        MessageHandler handler = messageHandler;
        if (handler == null) {
            handler = new DefaultMessageHandler();
        }
        this._globalCommandTypeHandlers[command.ordinal()] = handler;
    }

    public void setDuplicateMessageHandler(MessageHandler messageHandler) {
        MessageHandler handler = messageHandler;
        if (handler == null) {
            handler = new DefaultMessageHandler();
        }
        this._globalCommandTypeHandlers[GlobalCommandTypeHandlers.DuplicateMessage.ordinal()] = handler;
    }

    public MessageHandler getDuplicateMessageHandler() {
        return this._globalCommandTypeHandlers[GlobalCommandTypeHandlers.DuplicateMessage.ordinal()];
    }

    public void setFailedWriteHandler(FailedWriteHandlerV4 handler_) {
        this._failedWriteHandler = new FailedWriteHandlerV4Compat(handler_);
    }

    public void setFailedWriteHandler(FailedWriteHandler handler_) {
        this._failedWriteHandler = handler_;
    }

    public FailedWriteHandler getFailedWriteHandler() {
        return this._failedWriteHandler;
    }

    public void addConnectionStateListener(ConnectionStateListener listener_) {
        this.lock.lock();
        try {
            this._connectionStateListeners.add(listener_);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeConnectionStateListener(ConnectionStateListener listener_) {
        this.lock.lock();
        try {
            this._connectionStateListeners.remove(listener_);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void broadcastConnectionStateChanged(int newState_) {
        ConnectionStateListener[] listeners = null;
        this.lock.lock();
        try {
            listeners = new ConnectionStateListener[this._connectionStateListeners.size()];
            this._connectionStateListeners.toArray(listeners);
        }
        finally {
            this.lock.unlock();
        }
        for (ConnectionStateListener listener : listeners) {
            try {
                listener.connectionStateChanged(newState_);
            }
            catch (Exception ex_) {
                this.absorbedException(ex_);
            }
        }
    }

    public void disconnect() {
        this._disconnect(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _disconnect(boolean reconnecting) {
        Transport currentTransport = null;
        try {
            if (!reconnecting && this.getAckBatchSize() > 1) {
                this.flushAcks();
            }
        }
        catch (AMPSException e) {
            this.absorbedException(e);
        }
        this.lock.lock();
        try {
            currentTransport = this.transport;
            this.heartbeatTimer.setTimeout(0L);
            if (this.connected) {
                this.broadcastConnectionStateChanged(0);
            }
            this.connected = false;
        }
        finally {
            this.lock.unlock();
        }
        if (currentTransport != null) {
            currentTransport.disconnect();
        }
        this.lock.lock();
        try {
            this._routes.clear();
            this.cancelSynchronousWaiters(Integer.MAX_VALUE);
            if (!reconnecting) {
                this.broadcastConnectionStateChanged(1);
            }
        }
        catch (Exception e) {
            this.absorbedException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        this.disconnect();
    }

    public Message allocateMessage() throws DisconnectedException {
        if (this.transport == null) {
            throw new DisconnectedException("Cannot allocate a message  while not connected.");
        }
        try {
            this.lock.lock();
            Message message = this.transport.allocateMessage();
            return message;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void send(Message message) throws DisconnectedException {
        this.lock.lock();
        try {
            this.sendInternal(message);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addMessageHandler(CommandId commandId_, MessageHandler messageHandler_, int requestedAcks_, boolean isSubscribe_) {
        this._routes.addRoute(commandId_, messageHandler_, requestedAcks_, 0, isSubscribe_);
    }

    public boolean removeMessageHandler(CommandId commandId_) {
        return this._routes.removeRoute(commandId_);
    }

    private int sendWithoutRetry(Message message) throws DisconnectedException {
        if (this.transport != null) {
            int version = this.transport.getVersion();
            this.transport.sendWithoutRetry(message);
            return version;
        }
        throw new DisconnectedException("There is no current connection");
    }

    private int sendInternal(Message message) throws DisconnectedException {
        return this.sendInternal(message, 0L, false);
    }

    private int sendInternal(Message message, long haSeq) throws DisconnectedException {
        return this.sendInternal(message, haSeq, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendInternal(Message message, long haSeq, boolean isSubscribe) throws DisconnectedException {
        assert (((ReentrantLock)this.lock).isHeldByCurrentThread());
        while (true) {
            if (haSeq != 0L && this._reconnectingPublishStore) {
                if (!this._isRetryOnDisconnect) {
                    throw new DisconnectedException();
                }
                try {
                    this._reconnecting.await(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Transport currentTransport = this.transport;
            if (currentTransport == null) {
                throw new DisconnectedException("There is no current connection.");
            }
            int version = currentTransport.getVersion();
            if (haSeq != 0L && (haSeq <= this.lastSentSequenceNumber || this.lastSentSequenceNumber == 0L) || isSubscribe && this._reconnectingSubscriptionManager) {
                return -1;
            }
            while (haSeq > this.lastSentSequenceNumber + 1L) {
                try {
                    if (this.publishStore.replaySingle(this.replayer, this.lastSentSequenceNumber + 1L)) continue;
                    try {
                        this._reconnecting.await(1000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (AMPSException ex) {
                    return version;
                }
            }
            try {
                currentTransport.sendWithoutRetry(message);
                if (haSeq != 0L) {
                    ++this.lastSentSequenceNumber;
                }
                return version;
            }
            catch (DisconnectedException d) {
                if (this._isRetryOnDisconnect && message.getCommand() != 128) {
                    this.lock.unlock();
                    try {
                        currentTransport.handleCloseEvent(version, "Error occured while sending message", d);
                        continue;
                    }
                    catch (RetryOperationException r) {
                        if (!isSubscribe && haSeq == 0L) continue;
                        int n = version;
                        return n;
                    }
                    finally {
                        this.lock.lock();
                        continue;
                    }
                }
                throw d;
            }
            break;
        }
    }

    private boolean _registerHandler(CommandId qid, CommandId subid, CommandId cid, MessageHandler messageHandler, int requestedAcks, int systemAddedAcks, boolean isSubscribe) {
        boolean added;
        boolean bl = added = qid != null || subid != null || cid != null;
        if (qid != null && this._routes.findRoute(qid) == null) {
            this._routes.addRoute(qid, messageHandler, requestedAcks, systemAddedAcks, isSubscribe);
            added = true;
        }
        if (subid != null && this._routes.findRoute(subid) == null) {
            if (qid == null || !subid.equals(qid)) {
                this._routes.addRoute(subid, messageHandler, requestedAcks, systemAddedAcks, isSubscribe);
            }
            if (requestedAcks != 0 && cid != subid) {
                this._routes.addRoute(cid, messageHandler, requestedAcks, systemAddedAcks, isSubscribe);
            }
            added = true;
        } else if (!(cid == null || qid != null && cid.equals(qid) || this._routes.findRoute(cid) != null)) {
            this._routes.addRoute(cid, messageHandler, requestedAcks, systemAddedAcks, isSubscribe);
            added = true;
        }
        return added;
    }

    public void setRetryOnDisconnect(boolean isRetryOnDisconnect) {
        this._isRetryOnDisconnect = isRetryOnDisconnect;
    }

    public boolean getRetryOnDisconnect() {
        return this._isRetryOnDisconnect;
    }

    public void setDefaultMaxDepth(int md) {
        this._defaultMaxDepth = md;
    }

    public int getDefaultMaxDepth() {
        return this._defaultMaxDepth;
    }

    public CommandId send(MessageHandler messageHandler, Message message, long timeout) throws AMPSException {
        CommandId id = null;
        String strId = message.getCommandId();
        if (strId != null) {
            id = new CommandId(strId);
        }
        int requestedAcks = message.getAckTypeOutgoing();
        int systemAddedAcks = 0;
        boolean isSubscribe = false;
        switch (message.getCommand()) {
            case 2: 
            case 512: {
                if (this.bookmarkStore != null && message.getBookmark() != null) {
                    systemAddedAcks |= 8;
                }
            }
            case 256: 
            case 1024: {
                if (id == null) {
                    id = CommandId.nextIdentifier();
                    message.setCommandId(id);
                }
                if (message.getSubId() == null) {
                    message.setSubId(id);
                }
                isSubscribe = true;
            }
            case 8: {
                if (id == null) {
                    id = CommandId.nextIdentifier();
                    message.setCommandId(id);
                }
                if (message.getQueryId() == null) {
                    message.setQueryId(id);
                }
                systemAddedAcks |= 4;
                if (!isSubscribe) {
                    systemAddedAcks |= 0x10;
                }
                message.setAckType(requestedAcks | systemAddedAcks);
                if (messageHandler != null) {
                    CommandId subCmdId = new CommandId(message.getSubId());
                    CommandId qid = new CommandId(message.getQueryId());
                    this._registerHandler(qid, subCmdId, id, messageHandler, requestedAcks, systemAddedAcks, isSubscribe);
                }
                this.lock.lock();
                try {
                    this.syncAckProcessing(id, message, timeout, 0L, false);
                    break;
                }
                catch (TimedOutException e) {
                    this._routes.removeRoute(id);
                    throw e;
                }
                finally {
                    this.lock.unlock();
                }
            }
            case 1: 
            case 4: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 2048: 
            case 4096: {
                if (requestedAcks != 0) {
                    if (id == null) {
                        id = CommandId.nextIdentifier();
                        message.setCommandId(id);
                    }
                    if (messageHandler != null) {
                        this._routes.addRoute(id, messageHandler, requestedAcks, 0, false);
                    }
                }
                this.send(message);
                break;
            }
            default: {
                throw new CommandException("Command type can not be sent directly to AMPS");
            }
        }
        return id;
    }

    public MessageStream execute(Command command) throws AMPSException {
        boolean statsAck;
        boolean useExistingHandler;
        CommandId cid = null;
        CommandId subIdCmdId = command.getSubId();
        int commandEnum = command.getCommand();
        int ackType = command.getAckType();
        String options = command.getOptions();
        boolean bl = useExistingHandler = subIdCmdId != null && (options != null && options.contains("replace") || commandEnum == 8);
        if (useExistingHandler) {
            MessageHandler existingHandler;
            byte[] subId = subIdCmdId.id;
            if (subId != null && (existingHandler = this._routes.findRoute(subIdCmdId)) != null) {
                this.executeAsync(command, existingHandler);
                return existingHandler instanceof MessageStream ? (MessageStream)existingHandler : null;
            }
        } else if ((commandEnum & 0x218F5) != 0 && (ackType == 8 || ackType == 0)) {
            this.executeAsync(command, null);
            return MessageStream.getEmptyMessageStream();
        }
        MessageStream result = new MessageStream(this);
        result.maxDepth(this._defaultMaxDepth);
        try {
            cid = this.executeAsync(command, result);
        }
        catch (AMPSException e) {
            result.close();
            throw e;
        }
        boolean bl2 = statsAck = commandEnum != 2 && commandEnum != 512 && commandEnum != 256 && commandEnum != 1024 && (command._message.getAckTypeOutgoing() & 0x20) != 0;
        if (statsAck) {
            result.setStatsOnly();
            result.setQueryId(command.getQueryId());
        } else if (commandEnum == 8) {
            result.setSOWOnly();
            result.setQueryId(command.getQueryId());
        } else if (cid != null) {
            if (command.isSubscribe()) {
                result.setSubscription(cid);
                if (!cid.equals(command.getCommandId())) {
                    result.setCommandId(command.getCommandId());
                }
                if (commandEnum == 256 || commandEnum == 1024) {
                    result.setQueryId(command.getQueryId());
                }
            } else if (commandEnum == 1 || commandEnum == 64 || commandEnum == 32) {
                result.setAcksOnly(cid, command._message.getAckTypeOutgoing() & 0xFFFFFFF7);
            } else {
                result.setAcksOnly(cid, command._message.getAckTypeOutgoing());
            }
        } else {
            result.close();
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId executeAsync(Command command, MessageHandler handler) throws AMPSException {
        this.lock.lock();
        try {
            CommandId commandId = this.executeAsyncNoLock(command, handler);
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandId executeAsyncNoLock(Command command, MessageHandler messageHandler) throws AMPSException {
        int requestedAcks;
        CommandId qid;
        CommandId subid;
        CommandId cid;
        block54: {
            String bookmark;
            boolean isPublishStore;
            cid = command.prepare(this);
            subid = command.getSubId();
            qid = command.getQueryId();
            int commandEnum = command.getCommand();
            int systemAddedAcks = messageHandler == null ? 0 : 4;
            requestedAcks = command.getAckType();
            boolean bl = isPublishStore = this.publishStore != null && command.needsSequenceNumber();
            if (commandEnum == 8) {
                systemAddedAcks |= 0x10;
            }
            if ((bookmark = command.getBookmark()) != null) {
                if (this.bookmarkStore != null) {
                    if (command.isSubscribe()) {
                        systemAddedAcks |= 8;
                    }
                    Field subIdField = command._message.getSubIdRaw();
                    if ("recent".equals(bookmark)) {
                        Field mostRecent = this.bookmarkStore.getMostRecent(subIdField);
                        command._message.setBookmark(mostRecent.buffer, mostRecent.position, mostRecent.length);
                    } else if (!("0".equals(bookmark) || "0|1|".equals(bookmark) || subIdField.isNull() || this.bookmarkStore.getMostRecent(subIdField).toString().equals(bookmark))) {
                        command._message.setBookmark(bookmark);
                        if (!this.bookmarkStore.isDiscarded(command._message) && this.bookmarkStore.log(command._message) > 0L) {
                            this.bookmarkStore.discard(command._message);
                            this.bookmarkStore.persisted(subIdField, command._message.getBookmarkRaw());
                        }
                    }
                } else if ("recent".equals(bookmark)) {
                    command._message.setBookmark("0");
                }
            }
            if (isPublishStore) {
                systemAddedAcks |= 8;
            }
            boolean isSubscribe = command.isSubscribe();
            boolean isRegistered = false;
            if (messageHandler != null && !isSubscribe) {
                if (!this._registerHandler(qid, subid, cid, messageHandler, requestedAcks, systemAddedAcks, isSubscribe)) {
                    if ((commandEnum & 0x218F5) != 0) {
                        cid = command.setCommandId(CommandId.nextIdentifier()).getCommandId();
                        command._message.setCommandId(cid);
                        this._routes.addRoute(cid, messageHandler, requestedAcks, systemAddedAcks, isSubscribe);
                    } else {
                        throw new IllegalArgumentException("To use a messagehandler, you must also supply a command or subscription ID.");
                    }
                }
                isRegistered = true;
            }
            boolean useSyncSend = cid != null && ((systemAddedAcks | requestedAcks) & 4) != 0;
            try {
                if (isPublishStore) {
                    command._message.setAckType(systemAddedAcks | requestedAcks);
                    try {
                        this.lock.unlock();
                        this.publishStore.store(command._message);
                    }
                    finally {
                        this.lock.lock();
                    }
                    long sequence = command._message.getSequence();
                    command.setClientSequenceNumber(sequence);
                    if (useSyncSend) {
                        this.syncAckProcessing(cid, command._message, command.getTimeout(), sequence, false);
                    } else {
                        this.sendInternal(command._message, sequence);
                    }
                    break block54;
                }
                if (isSubscribe) {
                    subid = new CommandId(subid.id, 0, subid.id.length);
                    if (!this._defaultSubscriptionManager) {
                        boolean existingSub = this._routes.findRoute(subid) != null;
                        try {
                            Message message = command._message.copy();
                            if (cid != null) {
                                message.getCommandId(cid);
                            }
                            this.lock.unlock();
                            try {
                                this.subscriptionManager.subscribe(messageHandler, message);
                            }
                            finally {
                                this.lock.lock();
                            }
                            if (cid != null) {
                                message.setCommandId(cid);
                            }
                            message.setAckType(systemAddedAcks | requestedAcks);
                            if (useSyncSend) {
                                if (!this._registerHandler(qid, subid, cid, messageHandler, requestedAcks, systemAddedAcks, isSubscribe)) {
                                    command._message.setAckType(requestedAcks);
                                    throw new IllegalArgumentException("To use a messagehandler, you must also supply a command or subscription ID.");
                                }
                                isRegistered = !existingSub;
                                this.syncAckProcessing(cid, message, command.getTimeout(), 0L, !(messageHandler instanceof MessageStream));
                            } else {
                                this.sendInternal(message, 0L, !(messageHandler instanceof MessageStream));
                            }
                            break block54;
                        }
                        catch (AMPSException ex) {
                            if (!existingSub) {
                                this.lock.unlock();
                                try {
                                    this.subscriptionManager.unsubscribe(subid);
                                }
                                finally {
                                    this.lock.lock();
                                }
                            }
                            throw ex;
                        }
                    }
                    command._message.setAckType(systemAddedAcks | requestedAcks);
                    if (useSyncSend) {
                        if (!this._registerHandler(qid, subid, cid, messageHandler, requestedAcks, systemAddedAcks, isSubscribe)) {
                            command._message.setAckType(requestedAcks);
                            throw new IllegalArgumentException("To use a messagehandler, you must also supply a command or subscription ID.");
                        }
                        isRegistered = true;
                        this.syncAckProcessing(cid, command._message, command.getTimeout(), 0L, false);
                    } else {
                        this.sendInternal(command._message, 0L, true);
                    }
                    break block54;
                }
                command._message.setAckType(systemAddedAcks | requestedAcks);
                if (useSyncSend) {
                    this.syncAckProcessing(cid, command._message, command.getTimeout());
                } else {
                    this.sendInternal(command._message);
                }
            }
            catch (DisconnectedException ex) {
                if (isRegistered && !isPublishStore) {
                    this._routes.removeRoute(cid);
                    if (qid != null && !cid.equals(qid)) {
                        this._routes.removeRoute(qid);
                    }
                    if (subid != null && !cid.equals(subid)) {
                        this._routes.removeRoute(subid);
                    }
                }
                throw ex;
            }
            catch (AMPSException ex) {
                if (isRegistered && !isPublishStore) {
                    this._routes.removeRoute(cid);
                    if (qid != null && !cid.equals(qid)) {
                        this._routes.removeRoute(qid);
                    }
                    if (subid != null && !cid.equals(subid)) {
                        this._routes.removeRoute(subid);
                    }
                }
                throw ex;
            }
        }
        command._message.setAckType(requestedAcks);
        if (subid != null) {
            return subid;
        }
        if (qid != null) {
            return qid;
        }
        return cid;
    }

    public void setHeartbeat(int intervalSeconds_, int timeoutSeconds_) throws DisconnectedException {
        this._heartbeatInterval = intervalSeconds_;
        this._readTimeout = Math.max(timeoutSeconds_, intervalSeconds_);
        this._sendHeartbeat();
    }

    public void setHeartbeat(int intervalSeconds_) throws DisconnectedException {
        this.setHeartbeat(intervalSeconds_, intervalSeconds_ * 2);
    }

    public int getHeartbeatInterval() {
        return this._heartbeatInterval;
    }

    public int getReadTimeout() {
        return this._readTimeout;
    }

    void _sendHeartbeat() throws DisconnectedException {
        if (this.transport != null) {
            this.lock.lock();
            try {
                if (this._heartbeatInterval > 0) {
                    this.message.reset();
                    this.message.setCommand(16);
                    this.message.setOptions(String.format("start,%d", this._heartbeatInterval));
                    this.heartbeatTimer.setTimeout((long)this._heartbeatInterval * 1000L);
                    this.heartbeatTimer.start();
                    this.transport.sendWithoutRetry(this.message);
                    this.transport.setReadTimeout(this._readTimeout * 1000);
                    this.broadcastConnectionStateChanged(16);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public long publish(byte[] topic, int topicOffset, int topicLength, byte[] data, int dataOffset, int dataLength) throws AMPSException {
        if (topicLength == 0) {
            throw new InvalidTopicException("A topic must be specified.");
        }
        Command publishCommand = this._publishCommand.get();
        publishCommand.reset(1).setTopic(topic, topicOffset, topicLength).setData(data, dataOffset, dataLength);
        this.executeAsync(publishCommand, null);
        return publishCommand.getClientSequenceNumber();
    }

    public long publish(String topic, String data) throws AMPSException {
        if (topic == null || topic.length() == 0) {
            throw new InvalidTopicException("A topic must be specified.");
        }
        Command publishCommand = this._publishCommand.get();
        publishCommand.reset(1).setTopic(topic).setData(data);
        this.executeAsync(publishCommand, null);
        return publishCommand.getClientSequenceNumber();
    }

    public long publish(byte[] topic, int topicOffset, int topicLength, byte[] data, int dataOffset, int dataLength, int expiration) throws AMPSException {
        if (topicLength == 0) {
            throw new InvalidTopicException("A topic must be specified.");
        }
        Command publishCommand = this._publishCommand.get();
        publishCommand.reset(1).setTopic(topic, topicOffset, topicLength).setData(data, dataOffset, dataLength).setExpiration(expiration);
        this.executeAsync(publishCommand, null);
        return publishCommand.getClientSequenceNumber();
    }

    public long publish(String topic, String data, int expiration) throws AMPSException {
        if (topic == null || topic.length() == 0) {
            throw new InvalidTopicException("A topic must be specified.");
        }
        Command publishCommand = this._publishCommand.get();
        publishCommand.reset(1).setTopic(topic).setData(data).setExpiration(expiration);
        this.executeAsync(publishCommand, null);
        return publishCommand.getClientSequenceNumber();
    }

    public long deltaPublish(byte[] topic, int topicOffset, int topicLength, byte[] data, int dataOffset, int dataLength) throws AMPSException {
        if (topicLength == 0) {
            throw new InvalidTopicException("A topic must be specified.");
        }
        Command publishCommand = this._publishCommand.get();
        publishCommand.reset(64).setTopic(topic, topicOffset, topicLength).setData(data, dataOffset, dataLength);
        this.executeAsync(publishCommand, null);
        return publishCommand.getClientSequenceNumber();
    }

    public long deltaPublish(String topic, String data) throws AMPSException {
        if (topic == null || topic.length() == 0) {
            throw new InvalidTopicException("A topic must be specified.");
        }
        Command publishCommand = this._publishCommand.get();
        publishCommand.reset(64).setTopic(topic).setData(data);
        this.executeAsync(publishCommand, null);
        return publishCommand.getClientSequenceNumber();
    }

    public long deltaPublish(byte[] topic, int topicOffset, int topicLength, byte[] data, int dataOffset, int dataLength, int expiration) throws AMPSException {
        if (topicLength == 0) {
            throw new InvalidTopicException("A topic must be specified.");
        }
        Command publishCommand = this._publishCommand.get();
        publishCommand.reset(64).setTopic(topic, topicOffset, topicLength).setData(data, dataOffset, dataLength).setExpiration(expiration);
        this.executeAsync(publishCommand, null);
        return publishCommand.getClientSequenceNumber();
    }

    public long deltaPublish(String topic, String data, int expiration) throws AMPSException {
        if (topic == null || topic.length() == 0) {
            throw new InvalidTopicException("A topic must be specified.");
        }
        Command publishCommand = this._publishCommand.get();
        publishCommand.reset(64).setTopic(topic).setData(data).setExpiration(expiration);
        this.executeAsync(publishCommand, null);
        return publishCommand.getClientSequenceNumber();
    }

    @Deprecated
    public void startTimer() throws AMPSException {
        this.lock.lock();
        try {
            if (this.serverVersion.compareTo(new VersionInfo("5.3.2")) >= 0) {
                throw new CommandException("The start_timer command has been deprecated");
            }
            this.executeAsyncNoLock(this._command.reset(2048), null);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    public CommandId stopTimer(MessageHandler handler_) throws AMPSException {
        this.lock.lock();
        try {
            if (this.serverVersion.compareTo(new VersionInfo("5.3.2")) >= 0) {
                throw new CommandException("The stop_timer command has been deprecated");
            }
            CommandId commandId = this.executeAsyncNoLock(this._command.reset(4096).addAckType(32), handler_);
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setLogonCorrelationData(String correlationData) {
        this.logonCorrelationData = correlationData;
    }

    public String getLogonCorrelationData() {
        return this.logonCorrelationData;
    }

    public CommandId logon(long timeout) throws ConnectionException {
        return this.logon(timeout, new DefaultAuthenticator(), null);
    }

    public CommandId logon(long timeout, String options) throws ConnectionException {
        return this.logon(timeout, new DefaultAuthenticator(), options);
    }

    public CommandId logon(String options) throws ConnectionException {
        return this.logon(0L, new DefaultAuthenticator(), options);
    }

    public CommandId logon(long timeout, Authenticator authenticator) throws ConnectionException {
        return this.logon(timeout, authenticator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId logon(long timeout, Authenticator authenticator, String options) throws ConnectionException {
        if (this.uri == null) {
            throw new DisconnectedException("Not connected");
        }
        if (authenticator == null) {
            authenticator = new DefaultAuthenticator();
        }
        CommandId id = CommandId.nextIdentifier();
        this.lock.lock();
        try {
            URIProperties properties;
            String p;
            String uriPath;
            String[] path;
            String uriUserInfo;
            this._reconnectingPublishStore = this.publishStore != null;
            this.message.reset();
            this.message.setCommand(128);
            this.message.setCommandId(id);
            this.message.setClientName(this.name);
            if (options != null) {
                this.message.setOptions(options);
            }
            if ((uriUserInfo = this.uri.getUserInfo()) != null) {
                int upSep = uriUserInfo.indexOf(58);
                if (upSep < 0) {
                    this.username = uriUserInfo;
                    this.message.setUserId(this.username);
                    this.message.setPassword(authenticator.authenticate(this.username, null));
                } else {
                    this.username = uriUserInfo.substring(0, upSep);
                    String passToken = uriUserInfo.substring(upSep + 1);
                    this.message.setUserId(this.username);
                    this.message.setPassword(authenticator.authenticate(this.username, passToken));
                }
            }
            if ((path = (uriPath = this.uri.getPath()).substring(1, uriPath.length()).split("/")).length > 1) {
                this.message.setMessageType(path[path.length - 1]);
            }
            if ((p = (properties = new URIProperties(this.uri)).getProperty("pretty")) != null && ("true".equalsIgnoreCase(p) || "t".equalsIgnoreCase(p) || "1".equals(p))) {
                this.message.setOptions("pretty");
            }
            try {
                if (this.version >= 196608) {
                    this.message.setAckType(4);
                    String version = Client.getVersion();
                    if (version != null && version.length() != 0) {
                        this.message.setVersion(version + ":java");
                    } else {
                        this.message.setVersion("notinmanifest:java");
                    }
                    if (this.logonCorrelationData != null) {
                        this.message.setCorrelationId(this.logonCorrelationData);
                    }
                    AckResponse response = null;
                    while (true) {
                        response = this.syncAckProcessing(id, this.message, timeout);
                        if (response.state != 3) break;
                        this.message.setPassword(authenticator.retry(response.username, response.password));
                        this.username = response.username;
                        this.message.setUserId(this.username);
                    }
                    this.serverVersion = response.serverVersion;
                    this.nameHash = response.bookmark.substring(0, response.bookmark.indexOf(124));
                    if (this.bookmarkStore != null) {
                        this.bookmarkStore.setServerVersion(this.serverVersion.getOldStyleVersion());
                    }
                    authenticator.completed(response.username, response.password, response.reason);
                    this.broadcastConnectionStateChanged(4);
                    this._sendHeartbeat();
                } else {
                    this.sendInternal(this.message);
                    this.broadcastConnectionStateChanged(4);
                }
            }
            catch (CommandException e) {
                this.absorbedException(e);
            }
            catch (StoreException storeException) {
                throw new ConnectionException("A local store exception occurred while logging on.", storeException);
            }
            try {
                if (this.publishStore != null) {
                    this.publishStore.replay(this.replayer);
                    this.broadcastConnectionStateChanged(8);
                }
            }
            catch (StoreException storeException) {
                throw new ConnectionException("A local store exception occurred while replaying stored messages during logon.", storeException);
            }
            CommandId commandId = id;
            return commandId;
        }
        finally {
            this._reconnectingPublishStore = false;
            this.lock.unlock();
        }
    }

    public CommandId logon() throws ConnectionException {
        return this.logon(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId bookmarkSubscribe(MessageHandler messageHandler, String topic, String filter, CommandId subId, String bookmark, String options, long timeout) throws AMPSException {
        if (bookmark == null) {
            throw new AMPSException("A bookmark (or one of the Client.Bookmarks constants) is required to initiate a bookmark subscription.");
        }
        this.lock.lock();
        try {
            this._command.reset(2).setTopic(topic).setFilter(filter).setOptions(options).setBookmark(bookmark).setTimeout(timeout);
            if (subId != null) {
                this._command.setSubId(subId);
            }
            CommandId commandId = this.executeAsyncNoLock(this._command, messageHandler);
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    public CommandId subscribe(MessageHandler messageHandler, String topic, String filter, long timeout) throws AMPSException {
        return this.subscribe(messageHandler, topic, filter, Message.Options.None, timeout);
    }

    public CommandId subscribe(MessageHandler messageHandler, String topic, String filter, String options, long timeout) throws AMPSException {
        return this.subscribe(messageHandler, topic, filter, options, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId subscribe(MessageHandler messageHandler, String topic, String filter, String options, long timeout, String subId) throws AMPSException {
        this.lock.lock();
        try {
            if (subId == null && options != null && options.contains("replace")) {
                throw new CommandException("Cannot issue a replacement subscription; a valid subscription id is required.");
            }
            this._command.reset(2).setTopic(topic).setFilter(filter).setOptions(options).setTimeout(timeout).setSubId(subId);
            CommandId commandId = this.executeAsyncNoLock(this._command, messageHandler);
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    public MessageStream subscribe(String topic) throws AMPSException {
        return this.execute(new Command("subscribe").setTopic(topic));
    }

    public MessageStream subscribe(String topic, String filter) throws AMPSException {
        return this.execute(new Command("subscribe").setTopic(topic).setFilter(filter));
    }

    public CommandId subscribe(MessageHandler messageHandler, String topic, long timeout) throws AMPSException {
        return this.subscribe(messageHandler, topic, null, timeout);
    }

    public CommandId deltaSubscribe(MessageHandler messageHandler, String topic, String filter, String options, long timeout) throws AMPSException {
        return this.deltaSubscribe(messageHandler, topic, filter, options, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId deltaSubscribe(MessageHandler messageHandler, String topic, String filter, String options, long timeout, String subId) throws AMPSException {
        this.lock.lock();
        try {
            this._command.reset(512).setTopic(topic).setFilter(filter).setOptions(options).setTimeout(timeout);
            if (subId != null) {
                this._command.setSubId(new CommandId(subId));
            }
            CommandId commandId = this.executeAsyncNoLock(this._command, messageHandler);
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    public CommandId deltaSubscribe(MessageHandler messageHandler, String topic, String filter, long timeout) throws AMPSException {
        return this.deltaSubscribe(messageHandler, topic, filter, Message.Options.None, timeout);
    }

    public CommandId deltaSubscribe(MessageHandler messageHandler, String topic, long timeout) throws AMPSException {
        return this.deltaSubscribe(messageHandler, topic, null, timeout);
    }

    public void unsubscribe(CommandId subscriptionId) throws DisconnectedException {
        this.lock.lock();
        try {
            this.unsubscribeInternal(subscriptionId);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void unsubscribeInternal(CommandId subscriptionId) throws DisconnectedException {
        CommandId id = CommandId.nextIdentifier();
        if (subscriptionId != null) {
            this.lock.unlock();
            try {
                this.subscriptionManager.unsubscribe(subscriptionId);
            }
            finally {
                this.lock.lock();
            }
            this._routes.removeRoute(subscriptionId);
            if (this.transport != null) {
                this.message.reset();
                this.message.setCommand(4);
                this.message.setCommandId(id);
                this.message.setSubId(subscriptionId);
                this.transport.sendWithoutRetry(this.message);
            } else {
                throw new DisconnectedException("There is no current connection.");
            }
        }
    }

    public void unsubscribe() throws DisconnectedException {
        block4: {
            this.subscriptionManager.clear();
            CommandId id = CommandId.nextIdentifier();
            this.lock.lock();
            try {
                this._routes.unsubscribeAll();
                if (this.transport != null) {
                    this.message.reset();
                    this.message.setCommand(4);
                    this.message.setCommandId(id);
                    this.message.setSubId("all");
                    this.transport.sendWithoutRetry(this.message);
                    break block4;
                }
                throw new DisconnectedException("There is no current connection.");
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public MessageStream sow(String topic, String filter) throws AMPSException {
        return this.execute(new Command("sow").setTopic(topic).setFilter(filter).setBatchSize(10));
    }

    public MessageStream sow(String topic) throws AMPSException {
        return this.execute(new Command("sow").setTopic(topic).setBatchSize(10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId sow(MessageHandler messageHandler, String topic, String filter, String orderBy, String bookmark, int batchSize, int topN, String options, long timeout) throws AMPSException {
        this.lock.lock();
        try {
            this._command.reset(8).setTopic(topic).setFilter(filter).setOrderBy(orderBy).setOptions(options).setBookmark(bookmark).setBatchSize(batchSize).setTopN(topN).setTimeout(timeout);
            CommandId commandId = this.executeAsyncNoLock(this._command, messageHandler);
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    public CommandId sow(MessageHandler messageHandler, String topic, String filter, int batchSize, String options, long timeout) throws AMPSException {
        return this.sow(messageHandler, topic, filter, null, null, batchSize, -1, options, timeout);
    }

    public CommandId sow(MessageHandler messageHandler, String topic, String filter, int batchSize, long timeout) throws AMPSException {
        return this.sow(messageHandler, topic, filter, batchSize, Message.Options.None, timeout);
    }

    public CommandId sow(MessageHandler messageHandler, String topic, int batchSize, long timeout) throws AMPSException {
        return this.sow(messageHandler, topic, null, batchSize, timeout);
    }

    public CommandId sow(MessageHandler messageHandler, String topic, long timeout) throws AMPSException {
        return this.sow(messageHandler, topic, null, 10, timeout);
    }

    public MessageStream sowAndSubscribe(String topic, String filter) throws AMPSException {
        return this.execute(new Command("sow_and_subscribe").setTopic(topic).setFilter(filter).setBatchSize(10));
    }

    public MessageStream sowAndSubscribe(String topic) throws AMPSException {
        return this.execute(new Command("sow_and_subscribe").setTopic(topic).setBatchSize(10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId sowAndSubscribe(MessageHandler messageHandler, String topic, String filter, String orderBy, String bookmark, int batchSize, int topN, String options, long timeout) throws AMPSException {
        this.lock.lock();
        try {
            this._command.reset(256).setTopic(topic).setFilter(filter).setOrderBy(orderBy).setOptions(options).setBookmark(bookmark).setBatchSize(batchSize).setTopN(topN).setTimeout(timeout);
            CommandId commandId = this.executeAsyncNoLock(this._command, messageHandler);
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    public CommandId sowAndSubscribe(MessageHandler messageHandler, String topic, String filter, int batchSize, String options, long timeout) throws AMPSException {
        return this.sowAndSubscribe(messageHandler, topic, filter, null, null, batchSize, -1, options, timeout);
    }

    public CommandId sowAndSubscribe(MessageHandler messageHandler, String topic, String filter, int batchSize, boolean oofEnabled, long timeout) throws AMPSException {
        return this.sowAndSubscribe(messageHandler, topic, filter, null, null, batchSize, -1, oofEnabled ? "oof" : null, timeout);
    }

    public CommandId sowAndSubscribe(MessageHandler messageHandler, String topic, String filter, int batchSize, long timeout) throws AMPSException {
        return this.sowAndSubscribe(messageHandler, topic, filter, batchSize, false, timeout);
    }

    public CommandId sowAndSubscribe(MessageHandler messageHandler, String topic, int batchSize, long timeout) throws AMPSException {
        return this.sowAndSubscribe(messageHandler, topic, null, batchSize, false, timeout);
    }

    public CommandId sowAndSubscribe(MessageHandler messageHandler, String topic, long timeout) throws AMPSException {
        return this.sowAndSubscribe(messageHandler, topic, null, 10, false, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandId sowAndDeltaSubscribe(MessageHandler messageHandler, String topic, String filter, String orderBy, int batchSize, int topN, String options, long timeout) throws AMPSException {
        this.lock.lock();
        try {
            this._command.reset(1024).setTopic(topic).setFilter(filter).setOrderBy(orderBy).setOptions(options).setBatchSize(batchSize).setTopN(topN).setTimeout(timeout);
            CommandId commandId = this.executeAsyncNoLock(this._command, messageHandler);
            return commandId;
        }
        finally {
            this.lock.unlock();
        }
    }

    public CommandId sowAndDeltaSubscribe(MessageHandler messageHandler, String topic, String filter, int batchSize, boolean oofEnabled, boolean sendEmpties, String options, long timeout) throws AMPSException {
        String opts = options;
        if (oofEnabled) {
            String string = opts = opts == null ? "oof" : opts + ",oof";
        }
        if (!sendEmpties) {
            opts = opts == null ? "no_empties" : opts + ",no_empties";
        }
        return this.sowAndDeltaSubscribe(messageHandler, topic, filter, null, batchSize, -1, opts, timeout);
    }

    public CommandId sowAndDeltaSubscribe(MessageHandler messageHandler, String topic, String filter, int batchSize, boolean oofEnabled, boolean sendEmpties, long timeout) throws AMPSException {
        return this.sowAndDeltaSubscribe(messageHandler, topic, filter, batchSize, oofEnabled, sendEmpties, null, timeout);
    }

    public CommandId sowAndDeltaSubscribe(MessageHandler messageHandler, String topic, String filter, int batchSize, long timeout) throws AMPSException {
        return this.sowAndDeltaSubscribe(messageHandler, topic, filter, batchSize, false, true, timeout);
    }

    public CommandId sowAndDeltaSubscribe(MessageHandler messageHandler, String topic, int batchSize, long timeout) throws AMPSException {
        return this.sowAndDeltaSubscribe(messageHandler, topic, null, batchSize, false, true, timeout);
    }

    public CommandId sowAndDeltaSubscribe(MessageHandler messageHandler, String topic, long timeout) throws AMPSException {
        return this.sowAndDeltaSubscribe(messageHandler, topic, null, 10, false, true, timeout);
    }

    public CommandId sowDelete(MessageHandler messageHandler, String topic, String filter, String options, long timeout) throws AMPSException {
        Command publishCommand = this._publishCommand.get();
        publishCommand.reset(32).setTopic(topic).setFilter(filter).addAckType(32).setOptions(options).setTimeout(timeout);
        return this.executeAsync(publishCommand, messageHandler);
    }

    public CommandId sowDelete(MessageHandler messageHandler, String topic, String filter, long timeout) throws AMPSException {
        return this.sowDelete(messageHandler, topic, filter, null, timeout);
    }

    public Message sowDelete(String topic, String filter, long timeout) throws AMPSException {
        MessageStream ms = null;
        ms = this.execute(this._publishCommand.get().reset(32).addAckType(32).setTopic(topic).setFilter(filter).setTimeout(timeout));
        return ms == null ? null : ms.next();
    }

    public CommandId sowDeleteByKeys(MessageHandler messageHandler, String topic, String keys, long timeout) throws AMPSException {
        return this.executeAsync(this._publishCommand.get().reset(32).setTopic(topic).setSowKeys(keys).addAckType(32).setTimeout(timeout), messageHandler);
    }

    public CommandId sowDeleteByData(MessageHandler messageHandler, String topic, String data, long timeout) throws AMPSException {
        return this.executeAsync(this._publishCommand.get().reset(32).addAckType(32).setTopic(topic).setData(data).setTimeout(timeout), messageHandler);
    }

    public void publishFlush() throws DisconnectedException, TimedOutException {
        if (this.publishStore == null) {
            try {
                this.lock.lock();
                this.message.reset();
                CommandId id = CommandId.nextIdentifier();
                this.message.setCommandId(id);
                this.message.setAckType(4);
                this.message.setCommand(131072);
                this.syncAckProcessing(id, this.message, 0L);
                return;
            }
            catch (NullPointerException e) {
                throw new DisconnectedException("not connected", e);
            }
            catch (AMPSException e) {
                this.absorbedException(e);
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.publishStore.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishFlush(String ackType) throws CommandException, DisconnectedException, TimedOutException {
        if (!"persisted".equals(ackType) && !"processed".equals(ackType)) {
            throw new CommandException("publishFlush only accepts 'processed' or 'persisted' ack types");
        }
        if ("persisted".equals(ackType) && this.serverVersion.compareTo(minPersistedFlushVersion) < 0) {
            ackType = "processed";
        }
        CommandId id = CommandId.nextIdentifier();
        FlushAckHandler handler = new FlushAckHandler(this);
        try {
            this.lock.lock();
            if (!this.connected) {
                throw new DisconnectedException("Not connected");
            }
            this.message.reset();
            this.message.setCommandId(id);
            this.message.setAckType(ackType);
            this.message.setCommand(131072);
            if ("persisted".equals(ackType)) {
                this.addMessageHandler(id, handler, 8, false);
            } else {
                this.addMessageHandler(id, handler, 4, false);
            }
            this.send(this.message);
        }
        catch (NullPointerException e) {
            throw new DisconnectedException("not connected", e);
        }
        finally {
            this.lock.unlock();
        }
        try {
            if (this.publishStore != null) {
                this.publishStore.flush();
            }
            while (handler._status == 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.publishStore == null && handler._status == 2) {
                throw new DisconnectedException("Client disconnected waiting for flush acknowledgement");
            }
        }
        finally {
            this.removeMessageHandler(id);
            this.removeConnectionStateListener(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishFlush(long timeout) throws DisconnectedException, TimedOutException {
        if (this.publishStore == null) {
            try {
                this.lock.lock();
                this.message.reset();
                CommandId id = CommandId.nextIdentifier();
                this.message.setCommandId(id);
                this.message.setAckType(4);
                this.message.setCommand(131072);
                this.syncAckProcessing(id, this.message, timeout);
                return;
            }
            catch (NullPointerException e) {
                throw new DisconnectedException("not connected", e);
            }
            catch (AMPSException e) {
                this.absorbedException(e);
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.publishStore.flush(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishFlush(String ackType, long timeout) throws CommandException, DisconnectedException, TimedOutException {
        if (!"persisted".equals(ackType) && !"processed".equals(ackType)) {
            throw new CommandException("publishFlush only accepts processed or persisted ack types");
        }
        if ("persisted".equals(ackType) && this.serverVersion.compareTo(minPersistedFlushVersion) < 0) {
            ackType = "processed";
        }
        CommandId id = CommandId.nextIdentifier();
        FlushAckHandler handler = new FlushAckHandler(this);
        try {
            this.lock.lock();
            if (!this.connected) {
                throw new DisconnectedException("Not connected");
            }
            this.message.reset();
            this.message.setCommandId(id);
            this.message.setAckType(ackType);
            this.message.setCommand(131072);
            if ("persisted".equals(ackType)) {
                this.addMessageHandler(id, handler, 8, false);
            } else {
                this.addMessageHandler(id, handler, 4, false);
            }
            this.send(this.message);
        }
        catch (NullPointerException e) {
            throw new DisconnectedException("not connected", e);
        }
        finally {
            this.lock.unlock();
        }
        long end = System.currentTimeMillis() + timeout;
        try {
            if (this.publishStore != null) {
                this.publishStore.flush(timeout);
            }
            while (handler._status == 0 && (timeout == 0L || System.currentTimeMillis() < end)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.publishStore == null && handler._status == 2) {
                throw new DisconnectedException("Client disconnected waiting for flush acknowledgement");
            }
            if (this.publishStore == null && handler._status != 1) {
                throw new TimedOutException("Timed out waiting for flush acknowledgement");
            }
        }
        finally {
            this.removeMessageHandler(id);
            this.removeConnectionStateListener(handler);
        }
    }

    @Deprecated
    public long flush() throws DisconnectedException {
        return 0L;
    }

    @Deprecated
    public long flush(long timeout) throws DisconnectedException {
        return 0L;
    }

    public static String getVersion() {
        Enumeration<URL> urls;
        if (_version != null) {
            return _version;
        }
        String version = "unknown";
        try {
            Class<?> clientVersionCls = Class.forName("com.crankuptheamps.client.ClientVersion");
            Method getImplementationVersion = clientVersionCls.getMethod("getImplementationVersion", new Class[0]);
            version = (String)getImplementationVersion.invoke(null, new Object[0]);
        }
        catch (Exception clientVersionCls) {
            // empty catch block
        }
        ClassLoader cl = Client.class.getClassLoader();
        if (cl == null) {
            _version = version;
            return _version;
        }
        try {
            urls = cl.getResources("META-INF/MANIFEST.MF");
        }
        catch (IOException e) {
            _version = version;
            return _version;
        }
        URL url = null;
        while (urls.hasMoreElements()) {
            Manifest manifest;
            url = urls.nextElement();
            if (!url.toString().contains("amps_client")) continue;
            try {
                manifest = new Manifest(url.openStream());
            }
            catch (IOException E) {
                _version = version;
                return _version;
            }
            Attributes attrs = manifest.getMainAttributes();
            version = attrs.getValue("Implementation-Version");
            break;
        }
        _version = version;
        return _version;
    }

    public void setThreadCreatedHandler(ThreadCreatedHandler handler_) {
        this._threadCreatedHandler = handler_;
        if (this.transport != null) {
            this.transport.setThreadCreatedHandler(this._threadCreatedHandler);
        }
    }

    public void setTransportFilter(TransportFilter filter_) {
        this._transportFilter = filter_;
        if (this.transport != null) {
            if (filter_ != null) {
                this.transport.setTransportFilter(this._transportFilter);
            } else {
                this.transport.setTransportFilter(new DefaultTransportFilter());
            }
        }
    }

    public ConnectionInfo getConnectionInfo() {
        ConnectionInfo ci = new ConnectionInfo();
        ci.put("client.uri", this.uri == null ? null : this.uri.toString());
        ci.put("client.name", this.name);
        ci.put("client.username", this.username);
        if (this.publishStore != null) {
            ci.put("publishStore.unpersistedCount", this.publishStore.unpersistedCount());
        }
        return ci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _ack(QueueBookmarks bookmarks) throws AMPSException {
        if (bookmarks._bookmarkCount > 0) {
            if (bookmarks._length == 0 || bookmarks._data == null) {
                bookmarks._length = 0;
                bookmarks._bookmarkCount = 0;
                return 0;
            }
            int bookmarksLength = bookmarks._length;
            bookmarks._length = 0;
            bookmarks._bookmarkCount = 0;
            Command publishCommand = this._publishCommand.get();
            if (publishCommand._message == null) {
                publishCommand._message = this.allocateMessage();
            }
            publishCommand._message.reset();
            publishCommand._message.setCommand(32);
            publishCommand._message.setCommandId(this._queueAckCommandId);
            publishCommand._message.getTopicRaw().set(bookmarks._topic, 0, bookmarks._topic.length);
            byte[] bookmarksData = this._bookmarksData.get();
            if (bookmarksData.length < bookmarksLength) {
                bookmarksData = new byte[bookmarksLength * 2];
                this._bookmarksData.set(bookmarksData);
            }
            System.arraycopy(bookmarks._data, 0, bookmarksData, 0, bookmarksLength);
            publishCommand._message.setBookmark(bookmarksData, 0, bookmarksLength);
            long sequence = 0L;
            if (this.publishStore != null) {
                publishCommand._message.setAckType(8);
                try {
                    this.lock.unlock();
                    this.publishStore.store(publishCommand._message);
                    if (!publishCommand._message.isSequenceNull()) {
                        sequence = publishCommand._message.getSequence();
                    }
                }
                finally {
                    this.lock.lock();
                }
            }
            this.sendInternal(publishCommand._message, sequence);
            return 1;
        }
        return 0;
    }

    public void ack(byte[] topic, int topicPos, int topicLen, byte[] bookmark, int bookmarkPos, int bookmarkLen) throws AMPSException {
        if (this._isAutoAckEnabled || bookmark == null || bookmarkLen == 0) {
            return;
        }
        if (this._ackBatchSize < 2) {
            this._ackImmediate(topic, topicPos, topicLen, bookmark, bookmarkPos, bookmarkLen, null, 0, 0);
        } else {
            this._ackMany(topic, topicPos, topicLen, bookmark, bookmarkPos, bookmarkLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _ackOne(byte[] topic, int topicPos, int topicLen, byte[] bookmark, int bookmarkPos, int bookmarkLen) throws AMPSException {
        try {
            int newLength;
            int bookmarksCapacity;
            this.lock.lock();
            this._hashBox.set(topic, topicPos, topicLen);
            QueueBookmarks bookmarks = this._topicHashMap.get(this._hashBox);
            if (bookmarks == null) {
                bookmarks = new QueueBookmarks();
                QueueBookmarks.access$402(bookmarks, new byte[topicLen]);
                System.arraycopy(topic, topicPos, bookmarks._topic, 0, topicLen);
                QueueBookmarks.access$302(bookmarks, new byte[512]);
                this._topicHashMap.put(this._hashBox.clone(), bookmarks);
            }
            if ((bookmarksCapacity = bookmarks._data.length) < (newLength = bookmarks._length + bookmarkLen + 1)) {
                bookmarksCapacity = 512 * (1 + newLength / 512);
                byte[] newData = new byte[bookmarksCapacity];
                System.arraycopy(bookmarks._data, 0, newData, 0, bookmarks._length);
                QueueBookmarks.access$302(bookmarks, newData);
            }
            if (bookmarks._length > 0) {
                ((QueueBookmarks)bookmarks)._data[((QueueBookmarks)bookmarks)._length] = 44;
                ++bookmarks._length;
            } else {
                bookmarks._oldestTime = System.currentTimeMillis();
            }
            System.arraycopy(bookmark, bookmarkPos, bookmarks._data, bookmarks._length, bookmarkLen);
            QueueBookmarks queueBookmarks = bookmarks;
            queueBookmarks._length = queueBookmarks._length + bookmarkLen;
            if (++bookmarks._bookmarkCount >= this._ackBatchSize) {
                this._ack(bookmarks);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _ackMany(byte[] topic, int topicPos, int topicLen, byte[] bookmark, int bookmarkPos, int bookmarkLen) throws AMPSException {
        try {
            Object newData;
            int newLength;
            int bookmarksCapacity;
            int end;
            this.lock.lock();
            this._hashBox.set(topic, topicPos, topicLen);
            QueueBookmarks bookmarks = this._topicHashMap.get(this._hashBox);
            if (bookmarks == null) {
                bookmarks = new QueueBookmarks();
                QueueBookmarks.access$402(bookmarks, new byte[topicLen]);
                System.arraycopy(topic, topicPos, bookmarks._topic, 0, topicLen);
                QueueBookmarks.access$302(bookmarks, new byte[512]);
                this._topicHashMap.put(this._hashBox.clone(), bookmarks);
            }
            int start = bookmarkPos;
            for (end = start + 1; end < bookmarkPos + bookmarkLen; ++end) {
                if (bookmark[end] != 44 || ++bookmarks._bookmarkCount < this._ackBatchSize) continue;
                bookmarksCapacity = bookmarks._data.length;
                if (bookmarksCapacity < (newLength = bookmarks._length + end - start + 1)) {
                    bookmarksCapacity = 512 * (1 + newLength / 512);
                    newData = new byte[bookmarksCapacity];
                    System.arraycopy(bookmarks._data, 0, newData, 0, bookmarks._length);
                    QueueBookmarks.access$302(bookmarks, newData);
                }
                if (bookmarks._length > 0) {
                    ((QueueBookmarks)bookmarks)._data[((QueueBookmarks)bookmarks)._length] = 44;
                    ++bookmarks._length;
                } else {
                    bookmarks._oldestTime = System.currentTimeMillis();
                }
                System.arraycopy(bookmark, start, bookmarks._data, bookmarks._length, end - start);
                newData = bookmarks;
                ((QueueBookmarks)newData)._length = ((QueueBookmarks)newData)._length + (end - start);
                this._ack(bookmarks);
                start = ++end;
            }
            if (end - start >= 4) {
                bookmarksCapacity = bookmarks._data.length;
                if (bookmarksCapacity < (newLength = bookmarks._length + end - start + 1)) {
                    bookmarksCapacity = 512 * (1 + newLength / 512);
                    newData = new byte[bookmarksCapacity];
                    System.arraycopy(bookmarks._data, 0, newData, 0, bookmarks._length);
                    QueueBookmarks.access$302(bookmarks, newData);
                }
                if (bookmarks._length > 0) {
                    ((QueueBookmarks)bookmarks)._data[((QueueBookmarks)bookmarks)._length] = 44;
                    ++bookmarks._length;
                } else {
                    bookmarks._oldestTime = System.currentTimeMillis();
                }
                System.arraycopy(bookmark, start, bookmarks._data, bookmarks._length, end - start);
                QueueBookmarks queueBookmarks = bookmarks;
                queueBookmarks._length = queueBookmarks._length + (end - start);
                if (++bookmarks._bookmarkCount >= this._ackBatchSize) {
                    this._ack(bookmarks);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _ackImmediate(byte[] topic, int topicPos, int topicLen, byte[] bookmark, int bookmarkPos, int bookmarkLen, byte[] options, int optionsPos, int optionsLen) throws AMPSException {
        Command publishCommand = this._publishCommand.get();
        if (publishCommand._message == null) {
            publishCommand._message = this.allocateMessage();
        }
        publishCommand._message.reset();
        publishCommand._message.setCommand(32);
        publishCommand._message.setCommandId(this._queueAckCommandId);
        publishCommand._message.getTopicRaw().set(topic, topicPos, topicLen);
        publishCommand._message.getBookmarkRaw().set(bookmark, bookmarkPos, bookmarkLen);
        if (options != null && optionsLen > 0) {
            publishCommand._message.getOptionsRaw().set(options, optionsPos, optionsLen);
        }
        long sequence = 0L;
        if (this.publishStore != null) {
            publishCommand._message.setAckType(8);
            this.publishStore.store(publishCommand._message);
            if (!publishCommand._message.isSequenceNull()) {
                sequence = publishCommand._message.getSequence();
            }
        }
        if (sequence > 0L || options == null || !CANCEL_FIELD.equals(publishCommand._message.getOptionsRaw())) {
            try {
                this.lock.lock();
                this.sendInternal(publishCommand._message, sequence);
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.transport.sendWithoutRetry(publishCommand._message);
        }
    }

    public void ack(Field topic, Field bookmark) throws AMPSException {
        this.ack(topic.buffer, topic.position, topic.length, bookmark.buffer, bookmark.position, bookmark.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(String topic, String bookmark) throws AMPSException {
        if (bookmark == null || bookmark.length() == 0 || this._isAutoAckEnabled) {
            return;
        }
        if (this._ackBatchSize < 2) {
            Command publishCommand = this._publishCommand.get();
            if (publishCommand._message == null) {
                publishCommand._message = this.allocateMessage();
            }
            publishCommand._message.reset();
            publishCommand._message.setCommand(32);
            publishCommand._message.setCommandId(this._queueAckCommandId);
            publishCommand._message.setTopic(topic);
            publishCommand._message.setBookmark(bookmark);
            long sequence = 0L;
            if (this.publishStore != null) {
                publishCommand._message.setAckType(8);
                this.publishStore.store(publishCommand._message);
                if (!publishCommand._message.isSequenceNull()) {
                    sequence = publishCommand._message.getSequence();
                }
            }
            try {
                this.lock.lock();
                this.sendInternal(publishCommand._message, sequence);
            }
            finally {
                this.lock.unlock();
            }
            return;
        }
        try {
            int newLength;
            int bookmarksCapacity;
            this.lock.lock();
            this._hashBox.set(topic);
            QueueBookmarks bookmarks = this._topicHashMap.get(this._hashBox);
            if (bookmarks == null) {
                bookmarks = new QueueBookmarks();
                QueueBookmarks.access$402(bookmarks, topic.getBytes(StandardCharsets.UTF_8));
                QueueBookmarks.access$302(bookmarks, new byte[512]);
                this._topicHashMap.put(this._hashBox.clone(), bookmarks);
            }
            if ((bookmarksCapacity = bookmarks._data.length) < (newLength = bookmarks._length + bookmark.length() + 1)) {
                bookmarksCapacity = 512 * (1 + newLength / 512);
                byte[] newData = new byte[bookmarksCapacity];
                System.arraycopy(bookmarks._data, 0, newData, 0, bookmarks._length);
                QueueBookmarks.access$302(bookmarks, newData);
            }
            if (bookmarks._length > 0) {
                ((QueueBookmarks)bookmarks)._data[((QueueBookmarks)bookmarks)._length] = 44;
                ++bookmarks._length;
            } else {
                bookmarks._oldestTime = System.currentTimeMillis();
            }
            for (int i = 0; i < bookmark.length(); ++i) {
                ((QueueBookmarks)bookmarks)._data[((QueueBookmarks)bookmarks)._length] = (byte)bookmark.charAt(i);
                if (bookmarks._data[bookmarks._length++] != 44 || ++bookmarks._bookmarkCount < this._ackBatchSize) continue;
                this._ack(bookmarks);
            }
            if (++bookmarks._bookmarkCount >= this._ackBatchSize) {
                this._ack(bookmarks);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void ack(byte[] topic, int topicPos, int topicLen, byte[] bookmark, int bookmarkPos, int bookmarkLen, byte[] options, int optionsPos, int optionsLen) throws AMPSException {
        if (this._isAutoAckEnabled) {
            return;
        }
        if (this._ackBatchSize < 2 || options != null && optionsLen > 0) {
            this._ackImmediate(topic, topicPos, topicLen, bookmark, bookmarkPos, bookmarkLen, options, optionsPos, optionsLen);
        } else {
            this._ackMany(topic, topicPos, topicLen, bookmark, bookmarkPos, bookmarkLen);
        }
    }

    protected void _ack(byte[] topic, int topicPos, int topicLen, byte[] bookmark, int bookmarkPos, int bookmarkLen, byte[] options, int optionsPos, int optionsLen) throws AMPSException {
        if (bookmark == null || bookmarkLen == 0) {
            return;
        }
        if (this._ackBatchSize < 2 || options != null && optionsLen > 0) {
            this._ackImmediate(topic, topicPos, topicLen, bookmark, bookmarkPos, bookmarkLen, options, optionsPos, optionsLen);
        } else {
            this._ackOne(topic, topicPos, topicLen, bookmark, bookmarkPos, bookmarkLen);
        }
    }

    public void ack(Field topic, Field bookmark, Field options) throws AMPSException {
        if (this._isAutoAckEnabled) {
            return;
        }
        this.ack(topic.buffer, topic.position, topic.length, bookmark.buffer, bookmark.position, bookmark.length, options.buffer, options.position, options.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(String topic, String bookmark, String options) throws AMPSException {
        if (bookmark == null || bookmark.length() == 0 || this._isAutoAckEnabled) {
            return;
        }
        if (this._ackBatchSize < 2 || options != null && options.length() > 0) {
            Command publishCommand = this._publishCommand.get();
            if (publishCommand._message == null) {
                publishCommand._message = this.allocateMessage();
            }
            publishCommand._message.reset();
            publishCommand._message.setCommand(32);
            publishCommand._message.setCommandId(this._queueAckCommandId);
            publishCommand._message.setTopic(topic);
            publishCommand._message.setBookmark(bookmark);
            if (options != null && options.length() > 0) {
                publishCommand._message.setOptions(options);
            }
            long sequence = 0L;
            if (this.publishStore != null) {
                publishCommand._message.setAckType(8);
                this.publishStore.store(publishCommand._message);
                if (!publishCommand._message.isSequenceNull()) {
                    sequence = publishCommand._message.getSequence();
                }
            }
            if (sequence > 0L || !"cancel,".equals(options)) {
                try {
                    this.lock.lock();
                    this.sendInternal(publishCommand._message, sequence);
                }
                finally {
                    this.lock.unlock();
                }
            } else {
                this.sendWithoutRetry(publishCommand._message);
            }
            return;
        }
        try {
            int bookmarksCapacity;
            this.lock.lock();
            this._hashBox.set(topic);
            QueueBookmarks bookmarks = this._topicHashMap.get(this._hashBox);
            if (bookmarks == null) {
                bookmarks = new QueueBookmarks();
                QueueBookmarks.access$402(bookmarks, topic.getBytes(StandardCharsets.UTF_8));
                QueueBookmarks.access$302(bookmarks, new byte[512]);
                this._topicHashMap.put(this._hashBox.clone(), bookmarks);
            }
            if ((bookmarksCapacity = bookmarks._data.length) < bookmarks._length + 1 + bookmark.length()) {
                byte[] newData = new byte[2 * bookmarksCapacity];
                System.arraycopy(bookmarks._data, 0, newData, 0, bookmarks._length);
                QueueBookmarks.access$302(bookmarks, newData);
            }
            if (bookmarks._length > 0) {
                ((QueueBookmarks)bookmarks)._data[((QueueBookmarks)bookmarks)._length] = 44;
                ++bookmarks._length;
            } else {
                bookmarks._oldestTime = System.currentTimeMillis();
            }
            for (int i = 0; i < bookmark.length(); ++i) {
                ((QueueBookmarks)bookmarks)._data[((QueueBookmarks)bookmarks)._length] = (byte)bookmark.charAt(i);
                if (bookmarks._data[bookmarks._length++] != 44 || ++bookmarks._bookmarkCount < this._ackBatchSize) continue;
                this._ack(bookmarks);
            }
            if (++bookmarks._bookmarkCount >= this._ackBatchSize) {
                this._ack(bookmarks);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void _ack(Field topic, Field bookmark) throws AMPSException {
        this._ack(topic.buffer, topic.position, topic.length, bookmark.buffer, bookmark.position, bookmark.length, null, 0, 0);
    }

    protected void _ack(Field topic, Field bookmark, Field options) throws AMPSException {
        this._ack(topic.buffer, topic.position, topic.length, bookmark.buffer, bookmark.position, bookmark.length, options.buffer, options.position, options.length);
    }

    public void setAutoAck(boolean isAutoAckEnabled) {
        this._isAutoAckEnabled = isAutoAckEnabled;
    }

    public boolean getAutoAck() {
        return this._isAutoAckEnabled;
    }

    public void setAckBatchSize(int batchSize) {
        if (batchSize > 1 && this._queueAckTimeout <= 0L) {
            this._queueAckTimeout = 1000L;
        }
        this._ackBatchSize = batchSize;
    }

    public int getAckBatchSize() {
        return this._ackBatchSize;
    }

    public void setAckTimeout(long ackTimeout) {
        this._queueAckTimeout = ackTimeout;
    }

    public long getAckTimeout() {
        return this._queueAckTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAcks() throws AMPSException {
        int sendCount = 0;
        this.lock.lock();
        try {
            Collection<QueueBookmarks> entries = this._topicHashMap.values();
            Iterator<QueueBookmarks> iterator = entries.iterator();
            while (iterator.hasNext()) {
                sendCount += this._ack(iterator.next());
            }
        }
        finally {
            this.lock.unlock();
        }
        if (sendCount > 0) {
            this.publishFlush();
        }
    }

    private AckResponse syncAckProcessing(CommandId id, Message m, long timeout) throws DisconnectedException, TimedOutException, NameInUseException, AuthenticationException, NotEntitledException, CommandException, StoreException {
        return this.syncAckProcessing(id, m, timeout, 0L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AckResponse syncAckProcessing(CommandId id, Message m, long timeout, long haSeq, boolean isSubscribe) throws DisconnectedException, TimedOutException, NameInUseException, AuthenticationException, NotEntitledException, CommandException, StoreException {
        AckResponse ackResponse = new AckResponse();
        ackResponse.responded = false;
        this.acksLock.lock();
        try {
            this._acks.put(id, ackResponse);
        }
        finally {
            this.acksLock.unlock();
        }
        ackResponse.connectionVersion = this.sendInternal(m, haSeq, isSubscribe);
        if (ackResponse.connectionVersion == -1) {
            this.acksLock.lock();
            try {
                this._acks.remove(id);
            }
            finally {
                this.acksLock.unlock();
            }
            return ackResponse;
        }
        this.lock.unlock();
        try {
            long startTime;
            long now = startTime = System.currentTimeMillis();
            this.acksLock.lock();
            try {
                if (!ackResponse.abandoned && ackResponse.connectionVersion <= this._lastFailedConnectionVersion) {
                    ackResponse.abandoned = true;
                    this._acks.remove(id);
                }
                while (!(ackResponse.abandoned || ackResponse.responded || timeout != 0L && now - startTime >= timeout)) {
                    try {
                        if (timeout > 0L) {
                            long remainingTime = timeout - (now - startTime);
                            if (remainingTime > 0L) {
                                this.ackReceived.await(remainingTime, TimeUnit.MILLISECONDS);
                            }
                        } else {
                            this.ackReceived.await();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    now = System.currentTimeMillis();
                }
            }
            finally {
                this.acksLock.unlock();
            }
        }
        finally {
            this.lock.lock();
        }
        if (ackResponse.responded) {
            if (ackResponse.state != 2) {
                int maxBacklogReturned;
                if (m.getCommand() == 128) {
                    if (this.publishStore != null) {
                        try {
                            this.publishStore.discardUpTo(ackResponse.sequence);
                        }
                        catch (AMPSException e) {
                            this.absorbedException(e);
                        }
                        long lastPersisted = this.publishStore.getLastPersisted();
                        if (this.lastSentSequenceNumber <= lastPersisted) {
                            this.lastSentSequenceNumber = lastPersisted;
                        }
                    } else if (this.lastSentSequenceNumber < ackResponse.sequence) {
                        this.lastSentSequenceNumber = ackResponse.sequence;
                    }
                } else if (this._ackBatchSize > 1 && ackResponse.options != null && ackResponse.options.length() > 0 && (maxBacklogReturned = this.extractMaxBacklog(ackResponse.options)) > 0 && maxBacklogReturned < this._ackBatchSize) {
                    this._ackBatchSize = maxBacklogReturned;
                }
                return ackResponse;
            }
            switch (ackResponse.reason) {
                case 2: {
                    throw new BadFilterException("Filter '" + m.getFilter() + "' is invalid.");
                }
                case 3: {
                    throw new BadRegexTopicException("Regular Expression Topic '" + m.getTopic() + "' is invalid.");
                }
                case 8: {
                    throw new InvalidTopicException("Topic \"" + m.getTopic() + "\" is invalid.");
                }
                case 4: {
                    throw new SubscriptionAlreadyExistsException("Subscription for command '" + m.getCommandId() + "' already exists.");
                }
                case 15: {
                    throw new SubidInUseException("Subscription with subscription id '" + m.getSubId() + "' already exists.");
                }
                case 9: {
                    throw new NameInUseException("Client name \"" + m.getClientName() + "\" is already in use.");
                }
                case 10: {
                    throw new AuthenticationException("Logon failed for user \"" + this.username + "\"");
                }
                case 11: {
                    if (m.getCommand() == 128) {
                        throw new NotEntitledException("User \"" + this.username + "\" not entitled to logon.");
                    }
                    throw new NotEntitledException("User \"" + this.username + "\" not entitled to topic \"" + m.getTopic() + "\".");
                }
                case 13: {
                    throw new InvalidBookmarkException("Bookmark \"" + m.getBookmark() + "\" is not valid.");
                }
                case 14: {
                    throw new InvalidOrderByException("OrderBy \"" + m.getOrderBy() + "\" is not valid.");
                }
                case 18: {
                    throw new LogonRequiredException();
                }
                case 19: {
                    throw new InvalidTopicException("Invalid topic \"" + m.getTopic() + "\" or filter \"" + m.getFilter() + "\"");
                }
                case 20: {
                    throw new InvalidSubIdException("SubId \"" + m.getSubId() + "\" is not valid.");
                }
                case 23: {
                    if (m.isSowKeyNull()) {
                        throw new BadSowKeyException("Bad sow key \"" + m.getSowKeys() + "\" is not valid.");
                    }
                    throw new BadSowKeyException("Bad sow key \"" + m.getSowKey() + "\" is not valid.");
                }
                case 29: {
                    throw new DuplicateLogonException();
                }
                case 32: {
                    throw new InvalidOptionsException("Options \"" + m.getOptions() + "\" is not valid.");
                }
                case 34: {
                    throw new InvalidOrderByException("OrderBy \"" + m.getOrderBy() + "\" is too large.");
                }
                case 37: {
                    throw new PublishFilterException(m.getFilter(), m.getData());
                }
            }
            throw new CommandException("Error from server: " + ackResponse.reasonText);
        }
        if (!ackResponse.abandoned) {
            throw new TimedOutException("timed out waiting for operation");
        }
        throw new DisconnectedException("Connection closed while waiting for operation.");
    }

    private int extractMaxBacklog(String optionsString) {
        int optionsLength = optionsString.length();
        int keyStart = 0;
        int data = 0;
        boolean inData = false;
        block5: for (int i = 0; i < optionsLength; ++i) {
            char c = optionsString.charAt(i);
            switch (c) {
                case '=': {
                    if (inData) continue block5;
                    data = 0;
                    inData = true;
                    continue block5;
                }
                case ' ': {
                    if (inData) continue block5;
                    ++keyStart;
                    continue block5;
                }
                case ',': {
                    if (optionsString.regionMatches(keyStart, "max_backlog=", 0, 12)) {
                        return data;
                    }
                    data = 0;
                    keyStart = i + 1;
                    inData = false;
                    continue block5;
                }
                default: {
                    if (!inData) continue block5;
                    data = data * 10 + (c - 48);
                }
            }
        }
        if (optionsString.regionMatches(keyStart, "max_backlog=", 0, 12)) {
            return data;
        }
        return 0;
    }

    void checkAndSendHeartbeat(boolean force) {
        this._handler.checkAndSendHeartbeat(force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelSynchronousWaiters(int connectionVersion) {
        ArrayList<CommandId> removeList = new ArrayList<CommandId>();
        this.acksLock.lock();
        try {
            if (connectionVersion < Integer.MAX_VALUE) {
                this._lastFailedConnectionVersion = connectionVersion;
            }
            for (Map.Entry<CommandId, AckResponse> e : this._acks.entrySet()) {
                AckResponse response = e.getValue();
                if (response.connectionVersion > connectionVersion) continue;
                response.abandoned = true;
                removeList.add(e.getKey());
            }
            for (CommandId commandId : removeList) {
                this._acks.remove(commandId);
            }
            this.ackReceived.signalAll();
        }
        finally {
            this.acksLock.unlock();
        }
    }

    static /* synthetic */ boolean access$2000(Client x0) {
        return x0.connected;
    }

    static /* synthetic */ Transport access$2100(Client x0) {
        return x0.transport;
    }

    static /* synthetic */ Transport access$2102(Client x0, Transport x1) {
        x0.transport = x1;
        return x0.transport;
    }

    static /* synthetic */ boolean access$2202(Client x0, boolean x1) {
        x0._reconnectingPublishStore = x1;
        return x0._reconnectingPublishStore;
    }

    static /* synthetic */ boolean access$2302(Client x0, boolean x1) {
        x0._reconnectingSubscriptionManager = x1;
        return x0._reconnectingSubscriptionManager;
    }

    static /* synthetic */ boolean access$2400(Client x0) {
        return x0._defaultSubscriptionManager;
    }

    static /* synthetic */ ClientDisconnectHandler access$2500(Client x0) {
        return x0.disconnectHandler;
    }

    static /* synthetic */ Condition access$2600(Client x0) {
        return x0._reconnecting;
    }

    static /* synthetic */ boolean access$2002(Client x0, boolean x1) {
        x0.connected = x1;
        return x0.connected;
    }

    static /* synthetic */ SubscriptionManager access$2700(Client x0) {
        return x0.subscriptionManager;
    }

    private class AckFlusherRunnable
    implements AMPSRunnable {
        private AckFlusherRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() throws AMPSException {
            if (Client.this._queueAckTimeout <= 0L) {
                return;
            }
            Client.this.lock.lock();
            try {
                if (Client.this._topicHashMap.size() > 0) {
                    long currentTimeMillis = System.currentTimeMillis();
                    for (QueueBookmarks q : Client.this._topicHashMap.values()) {
                        if (q._bookmarkCount <= 0 || currentTimeMillis - q._oldestTime < Client.this._queueAckTimeout) continue;
                        Client.this._ack(q);
                    }
                }
            }
            finally {
                Client.this.lock.unlock();
            }
        }
    }

    private static class StopWatch {
        private long _timeout = 0L;
        private long _start = 0L;

        public boolean check() {
            if (this._timeout == 0L) {
                return false;
            }
            long current = System.currentTimeMillis();
            return current - this._start > this._timeout;
        }

        public void start() {
            this._start = System.currentTimeMillis();
        }

        public void setTimeout(long timeout) {
            this._start = System.currentTimeMillis();
            this._timeout = timeout;
        }

        public long getTimeout() {
            return this._timeout;
        }
    }

    class FailedWriteStoreReplayer
    implements Store.StoreReplayer {
        int _reason;
        int _replayCount;

        public FailedWriteStoreReplayer(int reason) {
            this._reason = reason;
            this._replayCount = 0;
        }

        @Override
        public void execute(Message m) {
            ++this._replayCount;
            Client.this._failedWriteHandler.failedWrite(m, this._reason);
        }

        public int replayCount() {
            return this._replayCount;
        }
    }

    static class FailedWriteHandlerV4Compat
    implements FailedWriteHandler {
        FailedWriteHandlerV4 _handler;

        public FailedWriteHandlerV4Compat(FailedWriteHandlerV4 handler_) {
            this._handler = handler_;
        }

        @Override
        public void failedWrite(Message m, int reason) {
            Field topic = m.getTopicRaw();
            Field data = m.getDataRaw();
            StringField corId = m.getCorrelationIdRaw();
            if (m.isDataNull()) {
                data = !m.isFilterNull() ? m.getFilterRaw() : m.getSowKeysRaw();
            }
            long sequence = m.isSequenceNull() ? 0L : m.getSequence();
            this._handler.failedWrite(sequence, m.getCommand(), topic.buffer, topic.position, topic.length, data.buffer, data.position, data.length, corId.buffer, corId.position, corId.length, reason);
        }
    }

    static class ClientStoreReplayer
    implements Store.StoreReplayer {
        Client client;

        public ClientStoreReplayer(Client c) {
            this.client = c;
        }

        @Override
        public void execute(Message m) throws DisconnectedException {
            long sequence;
            if (!(m.isCommandNull() || !m.isOptionsNull() && this.client._reconnectingPublishStore && m.getOptions().contains("cancel"))) {
                m.setAckType(8 | m.getAckTypeOutgoing());
                this.client.sendWithoutRetry(m);
            }
            if ((sequence = m.getSequence()) > this.client.lastSentSequenceNumber) {
                this.client.lastSentSequenceNumber = sequence;
            }
        }
    }

    class ClientHandler
    implements MessageHandler,
    TransportDisconnectHandler {
        Client client = null;
        CommandId key = new CommandId();

        ClientHandler(Client client) {
            this.client = client;
        }

        @Override
        public void preInvoke(int connectionVersion) {
            this.client.cancelSynchronousWaiters(connectionVersion);
        }

        @Override
        public void invoke(Message m) {
            int SOWMask = 24584;
            int PublishMask = 32833;
            try {
                int commandType = m.getCommand();
                if ((commandType & 0x6008) != 0) {
                    m.getQueryId(this.key);
                    Client.this._routes.deliverData(m, this.key);
                } else if ((commandType & 0x8041) != 0) {
                    Field subIds = m.getSubIdsRaw();
                    BookmarkField bookmark = m.getBookmarkRaw();
                    int index = 0;
                    while (index < subIds.length) {
                        int end;
                        for (end = index; end < subIds.length && subIds.buffer[subIds.position + end] != 44; ++end) {
                        }
                        this.key.set(subIds.buffer, subIds.position + index, end - index);
                        MessageHandler handler = Client.this._routes.findRoute(this.key);
                        if (handler != null) {
                            boolean isQueueMessage;
                            m.setSubId(subIds.buffer, subIds.position + index, end - index);
                            m.setSubscription(null);
                            boolean bl = isQueueMessage = m.getLeasePeriodRaw().length > 0;
                            if (!isQueueMessage && !bookmark.isNull()) {
                                if (Client.this.bookmarkStore.isDiscarded(m)) {
                                    try {
                                        this.client._globalCommandTypeHandlers[GlobalCommandTypeHandlers.DuplicateMessage.ordinal()].invoke(m);
                                    }
                                    catch (Exception e) {
                                        Client.this.absorbedException(e);
                                    }
                                } else {
                                    Client.this.bookmarkStore.log(m);
                                    try {
                                        handler.invoke(m);
                                    }
                                    catch (Exception e) {
                                        Client.this.absorbedException(e);
                                    }
                                }
                            } else {
                                boolean thrown;
                                block33: {
                                    thrown = false;
                                    if (isQueueMessage) {
                                        m._client = this.client;
                                    }
                                    try {
                                        handler.invoke(m);
                                    }
                                    catch (Exception e) {
                                        thrown = true;
                                        Client.this.absorbedException(e);
                                        if (!isQueueMessage || !this.client._isAutoAckEnabled || m.isIgnoreAutoAck()) break block33;
                                        Client.this._ack(m.getTopicRaw(), m.getBookmarkRaw(), CANCEL_FIELD);
                                    }
                                }
                                if (isQueueMessage && !thrown && this.client._isAutoAckEnabled && !m.isIgnoreAutoAck()) {
                                    try {
                                        this.client._ack(m.getTopicRaw(), m.getBookmarkRaw());
                                    }
                                    catch (Exception e) {
                                        Client.this.absorbedException(e);
                                    }
                                }
                            }
                        }
                        index = end + 1;
                    }
                } else if (commandType == 65536) {
                    this.client._globalCommandTypeHandlers[GlobalCommandTypeHandlers.Ack.ordinal()].invoke(m);
                    int ackType = m.getAckType();
                    Client.this._routes.deliverAck(m, ackType);
                    switch (ackType) {
                        case 8: {
                            this.persistedAck(m);
                            return;
                        }
                        case 4: {
                            this.processedAck(m);
                            return;
                        }
                    }
                } else {
                    if (m.getCommand() == 16) {
                        this.client._globalCommandTypeHandlers[GlobalCommandTypeHandlers.Heartbeat.ordinal()].invoke(m);
                        if (this.client.heartbeatTimer.getTimeout() != 0L) {
                            this.checkAndSendHeartbeat(true);
                        } else {
                            this.client._globalCommandTypeHandlers[GlobalCommandTypeHandlers.LastChance.ordinal()].invoke(m);
                        }
                        return;
                    }
                    if (Client.this._routes.deliverData(m) == 0) {
                        this.client._globalCommandTypeHandlers[GlobalCommandTypeHandlers.LastChance.ordinal()].invoke(m);
                    }
                }
                this.checkAndSendHeartbeat(false);
            }
            catch (Exception e) {
                this.client.absorbedException(e);
            }
        }

        private void checkAndSendHeartbeat(boolean force) {
            if (force || this.client.heartbeatTimer.check()) {
                try {
                    this.client.heartbeatTimer.start();
                    this.client.sendWithoutRetry(this.client.beatMessage);
                }
                catch (Exception e) {
                    Client.this.absorbedException(e);
                }
            }
        }

        private void processedAck(Message message) {
            if (message.getCommandId(this.key)) {
                Client.this.acksLock.lock();
                try {
                    AckResponse response = null;
                    response = (AckResponse)this.client._acks.remove(this.key);
                    if (response != null) {
                        response.state = message.getStatus();
                        response.reason = message.getReason();
                        response.reasonText = message.getReasonText();
                        response.username = message.getUserId();
                        response.password = message.getPassword();
                        response.serverVersion = new VersionInfo(message.getVersion());
                        response.sequence = message.getSequenceRaw().isNull() ? 0L : message.getSequence();
                        response.responded = true;
                        response.options = message.getOptions();
                        response.bookmark = message.getBookmark();
                        Client.this.ackReceived.signalAll();
                        return;
                    }
                }
                catch (Exception e) {
                    this.client.absorbedException(e);
                }
                finally {
                    Client.this.acksLock.unlock();
                }
                try {
                    Client.this._globalCommandTypeHandlers[GlobalCommandTypeHandlers.LastChance.ordinal()].invoke(message);
                }
                catch (Exception e) {
                    this.client.absorbedException(e);
                }
                return;
            }
        }

        private void persistedAck(Message message) {
            BookmarkField bookmark;
            boolean handled = false;
            int reason = message.getReason();
            if (!message.isSequenceNull()) {
                if (Client.this.publishStore != null) {
                    long sequence = ((LongField)message.getSequenceRaw()).getValue();
                    if (this.client._failedWriteHandler != null && (reason == 1 || reason == 11 || message.getStatus() == 2)) {
                        try {
                            FailedWriteStoreReplayer replayer = new FailedWriteStoreReplayer(reason);
                            Client.this.publishStore.replaySingle(replayer, sequence);
                        }
                        catch (Exception e) {
                            this.client.absorbedException(e);
                        }
                    }
                    handled = true;
                    try {
                        Client.this.publishStore.discardUpTo(sequence);
                    }
                    catch (Exception e) {
                        this.client.absorbedException(e);
                    }
                } else if (this.client._failedWriteHandler != null && (reason == 1 || reason == 11 || message.getStatus() == 2)) {
                    try {
                        LongField sequenceField = (LongField)message.getSequenceRaw();
                        long sequence = sequenceField != null && !sequenceField.isNull() ? sequenceField.getValue() : 0L;
                        message.reset();
                        message.setSequence(sequence);
                        this.client._failedWriteHandler.failedWrite(message, reason);
                    }
                    catch (Exception e) {
                        this.client.absorbedException(e);
                    }
                    handled = true;
                }
            }
            if (!handled && Client.this.bookmarkStore != null && (bookmark = message.getBookmarkRaw()) != null && bookmark.length > 1 && !bookmark.isNull()) {
                message.getSubId(this.key);
                if (Client.this._routes.hasRoute(this.key)) {
                    try {
                        handled = true;
                        Client.this.bookmarkStore.persisted(message.getSubIdRaw(), bookmark);
                    }
                    catch (AMPSException e) {
                        this.client.absorbedException(e);
                    }
                }
            }
            if (!handled) {
                try {
                    Client.this._globalCommandTypeHandlers[GlobalCommandTypeHandlers.LastChance.ordinal()].invoke(message);
                }
                catch (Exception e) {
                    this.client.absorbedException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void invoke(Transport newTransport, Exception e_) {
            oldTransport = null;
            try {
                Client.this.lock.lock();
                if (Client.access$2000(this.client)) {
                    Client.this.broadcastConnectionStateChanged(0);
                }
                oldTransport = Client.access$2100(Client.this);
                measurer = new TransportConnectionMeasurer(newTransport);
                Client.access$2102(Client.this, measurer);
lbl10:
                // 4 sources

                while (true) {
                    connectComplete = false;
                    try {
                        Client.access$2202(Client.this, Client.access$1800(Client.this) != null);
                        Client.access$2302(Client.this, Client.access$2400(Client.this) == false);
                        measurer.clear();
                        try {
                            Client.this.lock.unlock();
                            if (Client.access$2500(Client.this) instanceof ClientDisconnectHandler2) {
                                ((ClientDisconnectHandler2)Client.access$2500(Client.this)).invoke(this.client, e_);
                            } else {
                                Client.access$2500(Client.this).invoke(this.client);
                            }
                        }
                        finally {
                            Client.this.lock.lock();
                        }
                        connectComplete = true;
                    }
                    finally {
                        if (!connectComplete) {
                            Client.access$2302(Client.this, false);
                        }
                        Client.access$2202(Client.this, false);
                        Client.access$2600(Client.this).signalAll();
                    }
                    if (measurer.successfullyConnected()) ** GOTO lbl-1000
                    Client.this.broadcastConnectionStateChanged(1);
                    Client.access$2002(this.client, false);
                    this.client.absorbedException(new DisconnectedException("reconnect failed."));
                    Client.access$2302(Client.this, false);
                    Client.access$2600(Client.this).signalAll();
                    ** GOTO lbl63
                    break;
                }
            }
            catch (Exception e) {
                try {
                    Client.this.broadcastConnectionStateChanged(1);
                    Client.access$2002(this.client, false);
                    this.client.absorbedException(e);
                }
                catch (Throwable var9_13) {
                    Client.access$2302(Client.this, false);
                    Client.access$2102(Client.this, oldTransport);
                    Client.this.lock.unlock();
                    throw var9_13;
                }
lbl63:
                // 1 sources

                Client.access$2302(Client.this, false);
                Client.access$2102(Client.this, oldTransport);
                Client.this.lock.unlock();
                return;
lbl-1000:
                // 1 sources

                {
                    try {
                        Client.this.lock.unlock();
                        Client.access$2700(this.client).resubscribe(this.client);
                        Client.this.broadcastConnectionStateChanged(32);
                    }
                    catch (TimedOutException ex) {
                        this.client.absorbedException(ex);
                        ** GOTO lbl10
                    }
                    catch (DisconnectedException ex) {
                        this.client.absorbedException(ex);
                        ** GOTO lbl10
                    }
                    finally {
                        Client.this.lock.lock();
                        Client.access$2302(Client.this, false);
                        Client.access$2600(Client.this).signalAll();
                        ** continue;
                    }
                }
                Client.access$2302(Client.this, false);
                Client.access$2102(Client.this, oldTransport);
                Client.this.lock.unlock();
                return;
                Client.access$2302(Client.this, false);
                Client.access$2102(Client.this, oldTransport);
                Client.this.lock.unlock();
                return;
            }
        }

        class TransportConnectionMeasurer
        implements Transport {
            Transport _t;
            boolean _successfullyConnected = false;

            public TransportConnectionMeasurer(Transport underlying) {
                this._t = underlying;
            }

            public void clear() {
                this._successfullyConnected = false;
            }

            public boolean successfullyConnected() {
                return this._successfullyConnected;
            }

            @Override
            public void connect(URI uri) throws ConnectionRefusedException, AlreadyConnectedException, InvalidURIException {
                this._t.connect(uri);
                this._successfullyConnected = true;
            }

            @Override
            public void close() throws Exception {
                this._t.close();
            }

            @Override
            public void disconnect() {
                this._t.disconnect();
            }

            @Override
            public void setMessageHandler(MessageHandler ml) {
                this._t.setMessageHandler(ml);
            }

            @Override
            public void setDisconnectHandler(TransportDisconnectHandler dh) {
                this._t.setDisconnectHandler(dh);
            }

            @Override
            public void setExceptionListener(ExceptionListener exceptionListener) {
                this._t.setExceptionListener(exceptionListener);
            }

            @Override
            public void setThreadCreatedHandler(ThreadCreatedHandler tch_) {
                this._t.setThreadCreatedHandler(tch_);
            }

            @Override
            public void send(Message message) throws DisconnectedException {
                this._t.send(message);
            }

            @Override
            public void sendWithoutRetry(Message message) throws DisconnectedException {
                this._t.sendWithoutRetry(message);
            }

            @Override
            public Message allocateMessage() {
                return this._t.allocateMessage();
            }

            @Override
            public long writeQueueSize() throws DisconnectedException {
                return this._t.writeQueueSize();
            }

            @Override
            public long readQueueSize() throws DisconnectedException {
                return this._t.readQueueSize();
            }

            @Override
            public long flush() throws DisconnectedException {
                return this._t.flush();
            }

            @Override
            public long flush(long timeout) throws DisconnectedException {
                return this._t.flush(timeout);
            }

            @Override
            public void handleCloseEvent(int failedVersion_, String message, Exception e) throws DisconnectedException, RetryOperationException {
                this._t.handleCloseEvent(failedVersion_, message, e);
            }

            @Override
            public int getVersion() {
                return this._t.getVersion();
            }

            @Override
            public void setReadTimeout(int readTimeoutMillis_) {
                this._t.setReadTimeout(readTimeoutMillis_);
            }

            @Override
            public void setTransportFilter(TransportFilter tracer_) {
                this._t.setTransportFilter(tracer_);
            }

            @Override
            public void setIdleRunnable(AMPSRunnable runnable) {
                this._t.setIdleRunnable(runnable);
            }
        }
    }

    private static class FlushAckHandler
    implements MessageHandler,
    ConnectionStateListener {
        public static final int Waiting = 0;
        public static final int Acked = 1;
        public static final int Disconnected = 2;
        public volatile int _status = 0;

        public FlushAckHandler(Client client_) {
            client_.addConnectionStateListener(this);
        }

        @Override
        public void connectionStateChanged(int state_) {
            if (state_ <= 1) {
                this._status = 2;
            }
        }

        @Override
        public void invoke(Message m) {
            this._status = 1;
        }
    }

    public static final class Bookmarks {
        public static final String MOST_RECENT = "recent";
        public static final String EPOCH = "0";
        public static final String NOW = "0|1|";
    }

    public static final class Version {
        public static final int AMPS_3 = 196608;
        public static final int AMPS_4 = 262144;
        public static final int AMPS_5 = 327680;
    }

    public static enum GlobalCommandTypeHandlers {
        Publish,
        SOW,
        GroupBegin,
        GroupEnd,
        Heartbeat,
        OOF,
        Ack,
        LastChance,
        DuplicateMessage,
        COUNT;

    }

    static class AckResponse {
        public volatile int connectionVersion;
        public VersionInfo serverVersion;
        public volatile boolean responded;
        public volatile boolean abandoned;
        public volatile int state;
        public volatile int reason;
        public volatile String reasonText;
        public volatile String username;
        public volatile String password;
        public volatile long sequence;
        public volatile String options;
        public volatile String bookmark;

        AckResponse() {
        }
    }

    static class QueueBookmarks {
        private byte[] _topic;
        private byte[] _data;
        private long _oldestTime;
        private volatile int _bookmarkCount;
        private int _length;

        QueueBookmarks() {
        }

        static /* synthetic */ byte[] access$402(QueueBookmarks x0, byte[] x1) {
            x0._topic = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$302(QueueBookmarks x0, byte[] x1) {
            x0._data = x1;
            return x1;
        }
    }
}

