/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.ArrayStoreBuffer;
import com.crankuptheamps.client.Client;
import com.crankuptheamps.client.JSONMessage;
import com.crankuptheamps.client.Message;
import com.crankuptheamps.client.PublishStoreResizeHandler;
import com.crankuptheamps.client.Store;
import com.crankuptheamps.client.exception.CommandException;
import com.crankuptheamps.client.exception.DisconnectedException;
import com.crankuptheamps.client.exception.StoreException;
import com.crankuptheamps.client.exception.TimedOutException;
import com.crankuptheamps.client.fields.Field;
import com.crankuptheamps.client.fields.IntegerField;
import com.crankuptheamps.client.fields.StringField;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.CRC32;

public class BlockPublishStore
implements Store {
    private int _blocksPerRealloc = 10000;
    private volatile long _nextSequence = 1L;
    private final Lock lock = new ReentrantLock();
    private final Condition _blocksFree = this.lock.newCondition();
    private final Condition _messageReady = this.lock.newCondition();
    private volatile boolean _resizing = false;
    protected PublishStoreResizeHandler _resizeHandler = null;
    protected Buffer _buffer;
    volatile Block _freeList = null;
    volatile Block _usedList = null;
    volatile Block _endOfUsedList = null;
    Block _metadataBlock = null;
    CRC32 _crc = null;
    ByteSequence _argument = new ByteSequence();
    Message _message;
    byte[] _readBuffer;
    ArrayStoreBuffer _sb = null;
    protected static final int AMPS_MIN_PUB_STORE_DISCARDED_VERSION = 4000100;
    protected static final int METADATA_VERSION_LOCATION = 4;
    protected static final int METADATA_LAST_DISCARDED_LOCATION = 8;

    protected BlockPublishStore(Buffer buffer, int blocksPerRealloc, boolean isAFile) {
        this._blocksPerRealloc = blocksPerRealloc;
        this._buffer = buffer;
        if (isAFile) {
            this._crc = new CRC32();
            this._sb = new ArrayStoreBuffer();
            try {
                this._sb.setSize(2048L);
            }
            catch (IOException e) {
                this._sb = null;
            }
        }
    }

    protected BlockPublishStore(Buffer buffer, int blocksPerRealloc) {
        this(buffer, blocksPerRealloc, false);
    }

    protected BlockPublishStore(Buffer buffer) {
        this(buffer, 10000, false);
    }

    @Override
    public void store(Message m) throws StoreException {
        this.store(m, true);
    }

    @Override
    public void close() throws Exception {
        this._buffer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flattenToFreeList(Block toRemove) {
        Block currentInChain = toRemove;
        this.lock.lock();
        try {
            if (toRemove == this._usedList) {
                this._usedList = this._usedList.nextInList;
            } else {
                Block prev = this._usedList;
                Block b = prev.nextInList;
                while (b != null) {
                    if (b == toRemove) {
                        prev.nextInList = b.nextInList;
                        break;
                    }
                    prev = prev.nextInList;
                    b = b.nextInList;
                }
            }
            while (currentInChain != null) {
                Block nextInChain = currentInChain.nextInChain;
                try {
                    this._buffer.zero(currentInChain.getPosition(), 32);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                currentInChain.sequenceNumber = 0L;
                currentInChain.nextInChain = null;
                currentInChain.nextInList = this._freeList;
                this._freeList = currentInChain;
                currentInChain = nextInChain;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(Message m, boolean assignSequence) throws StoreException {
        int lastBlockLength;
        int operation = m.getCommand();
        int flag = -1;
        Field data = null;
        if (operation == 1 || operation == 64 || operation == 32 && !m.isDataNull()) {
            data = m.getDataRaw();
            if (operation == 32) {
                flag = 1;
            }
        } else if (!m.isFilterNull()) {
            data = m.getFilterRaw();
            flag = 2;
        } else if (!m.isSowKeysNull()) {
            data = m.getSowKeysRaw();
            flag = 4;
        } else if (!m.isBookmarkNull()) {
            if (m.isOptionsNull() || !m.getOptions().contains("cancel")) {
                data = m.getBookmarkRaw();
                flag = 8;
            } else {
                data = m.getBookmarkRaw();
                flag = 16;
            }
        } else {
            throw new StoreException("Cannot store a Message with no data, filter, sow keys, or bookmark.");
        }
        Block first = null;
        Field cmdId = m.getCommandIdRaw();
        long commandIdRemaining = cmdId == null ? 0L : (long)cmdId.length;
        StringField correlationId = m.getCorrelationIdRaw();
        long correlationIdRemaining = correlationId == null ? 0L : (long)correlationId.length;
        IntegerField expiration = m.getExpirationRaw();
        long expirationRemaining = expiration == null ? 0L : (long)expiration.length;
        Field sowKey = m.getSowKeyRaw();
        long sowKeyRemaining = sowKey == null ? 0L : (long)sowKey.length;
        Field topic = m.getTopicRaw();
        long topicRemaining = topic.length;
        long dataRemaining = data.length;
        long totalRemaining = operation == 0 ? 0L : 32L + commandIdRemaining + correlationIdRemaining + expirationRemaining + sowKeyRemaining + topicRemaining + dataRemaining;
        int n = lastBlockLength = operation == 0 ? 0 : (int)(totalRemaining % 2016L);
        int blocksToWrite = operation == 0 ? 0 : (int)(totalRemaining / 2016L + (long)(lastBlockLength > 0 ? 1 : 0));
        long crcVal = 0L;
        try {
            Block next;
            long currentSequence = assignSequence ? 0L : m.getSequence();
            first = next = this.get(assignSequence, currentSequence);
            if (first == null) {
                throw new StoreException("The store is full, and no blocks can be allocated.");
            }
            if (assignSequence) {
                m.setSequence(first.sequenceNumber);
            }
            boolean loopComplete = false;
            while (blocksToWrite > 0) {
                loopComplete = false;
                Block current = next;
                int bytesRemainingInBlock = 2016;
                if (blocksToWrite > 1) {
                    next = this.get(false, 0L);
                    if (next == null) {
                        this.flattenToFreeList(first);
                        throw new StoreException("The store is full, and no additional blocks can be allocated.");
                    }
                } else {
                    next = null;
                }
                current.nextInChain = next;
                Buffer buffer = this._sb == null ? this._buffer : this._sb;
                this.lock.lock();
                try {
                    Field rawField;
                    long bytesToWrite;
                    long start = this._sb == null ? current.getPosition() : 0L;
                    buffer.setPosition(start);
                    if (current == first) {
                        buffer.putInt((int)totalRemaining);
                    } else {
                        buffer.putInt(next == null ? lastBlockLength : 2016);
                    }
                    buffer.putInt(next == null ? current.index : next.index);
                    buffer.putLong(current == first ? m.getSequence() : 0L);
                    if (this._crc != null) {
                        this._crc.reset();
                        if (cmdId != null && commandIdRemaining > 0L) {
                            this._crc.update(cmdId.buffer, cmdId.position, (int)commandIdRemaining);
                        }
                        if (correlationId != null && correlationIdRemaining > 0L) {
                            this._crc.update(correlationId.buffer, correlationId.position, (int)correlationIdRemaining);
                        }
                        if (expiration != null && expirationRemaining > 0L) {
                            this._crc.update(expiration.buffer, expiration.position, (int)expirationRemaining);
                        }
                        if (sowKey != null && sowKeyRemaining > 0L) {
                            this._crc.update(sowKey.buffer, sowKey.position, (int)sowKeyRemaining);
                        }
                        if (topicRemaining > 0L) {
                            this._crc.update(topic.buffer, topic.position, (int)topicRemaining);
                        }
                        if (dataRemaining > 0L) {
                            this._crc.update(data.buffer, data.position, (int)dataRemaining);
                        }
                        crcVal = this._crc.getValue();
                    }
                    buffer.putLong(crcVal);
                    buffer.setPosition(start + 32L);
                    if (current == first) {
                        buffer.putInt(operation);
                        buffer.putInt((int)commandIdRemaining);
                        buffer.putInt((int)correlationIdRemaining);
                        buffer.putInt((int)expirationRemaining);
                        buffer.putInt((int)sowKeyRemaining);
                        buffer.putInt((int)topicRemaining);
                        buffer.putInt(flag);
                        buffer.putInt(m.getAckTypeOutgoing());
                        bytesRemainingInBlock -= 32;
                    }
                    long l = bytesToWrite = commandIdRemaining <= (long)bytesRemainingInBlock ? commandIdRemaining : (long)bytesRemainingInBlock;
                    if (bytesToWrite > 0L) {
                        rawField = m.getCommandIdRaw();
                        buffer.putBytes(rawField.buffer, (long)(rawField.position + rawField.length) - commandIdRemaining, bytesToWrite);
                        bytesRemainingInBlock = (int)((long)bytesRemainingInBlock - bytesToWrite);
                        commandIdRemaining -= bytesToWrite;
                    }
                    long l2 = bytesToWrite = correlationIdRemaining <= (long)bytesRemainingInBlock ? correlationIdRemaining : (long)bytesRemainingInBlock;
                    if (bytesToWrite > 0L) {
                        rawField = m.getCorrelationIdRaw();
                        buffer.putBytes(rawField.buffer, (long)(rawField.position + rawField.length) - correlationIdRemaining, bytesToWrite);
                        bytesRemainingInBlock = (int)((long)bytesRemainingInBlock - bytesToWrite);
                        correlationIdRemaining -= bytesToWrite;
                    }
                    long l3 = bytesToWrite = expirationRemaining <= (long)bytesRemainingInBlock ? expirationRemaining : (long)bytesRemainingInBlock;
                    if (bytesToWrite > 0L) {
                        rawField = m.getExpirationRaw();
                        buffer.putBytes(rawField.buffer, (long)(rawField.position + rawField.length) - expirationRemaining, bytesToWrite);
                        bytesRemainingInBlock = (int)((long)bytesRemainingInBlock - bytesToWrite);
                        expirationRemaining -= bytesToWrite;
                    }
                    long l4 = bytesToWrite = sowKeyRemaining <= (long)bytesRemainingInBlock ? sowKeyRemaining : (long)bytesRemainingInBlock;
                    if (bytesToWrite > 0L) {
                        rawField = m.getSowKeyRaw();
                        buffer.putBytes(rawField.buffer, (long)(rawField.position + rawField.length) - sowKeyRemaining, bytesToWrite);
                        bytesRemainingInBlock = (int)((long)bytesRemainingInBlock - bytesToWrite);
                        sowKeyRemaining -= bytesToWrite;
                    }
                    long l5 = bytesToWrite = topicRemaining <= (long)bytesRemainingInBlock ? topicRemaining : (long)bytesRemainingInBlock;
                    if (bytesToWrite > 0L) {
                        rawField = m.getTopicRaw();
                        buffer.putBytes(rawField.buffer, (long)(rawField.position + rawField.length) - topicRemaining, bytesToWrite);
                        bytesRemainingInBlock = (int)((long)bytesRemainingInBlock - bytesToWrite);
                        topicRemaining -= bytesToWrite;
                    }
                    long l6 = bytesToWrite = dataRemaining <= (long)bytesRemainingInBlock ? dataRemaining : (long)bytesRemainingInBlock;
                    if (bytesToWrite > 0L) {
                        buffer.putBytes(data.buffer, (long)(data.position + data.length) - dataRemaining, bytesToWrite);
                        dataRemaining -= bytesToWrite;
                    }
                    if (this._sb != null) {
                        this._buffer.setPosition(current.getPosition());
                        this._argument.array = this._sb.getBuffer();
                        this._argument.offset = 0L;
                        this._argument.len = this._sb.getPosition();
                        this._buffer.putBytes(this._argument);
                    }
                    loopComplete = true;
                }
                finally {
                    this.lock.unlock();
                    if (!loopComplete) {
                        this.flattenToFreeList(first);
                        first = null;
                    }
                }
                --blocksToWrite;
            }
            assert (dataRemaining == 0L && topicRemaining == 0L);
            this.lock.lock();
            try {
                this._buffer.putInt(first.getPosition() + 24L, 1);
                this._messageReady.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (IOException e) {
            if (first != null) {
                this.flattenToFreeList(first);
            }
            throw new StoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discardUpTo(long index) throws StoreException {
        if (index == 0L || this._usedList == null || index <= this._metadataBlock.sequenceNumber) {
            this.lock.lock();
            try {
                if (this._getLastPersisted() < index) {
                    this._metadataBlock.sequenceNumber = index;
                    this._buffer.putLong(this._metadataBlock.getPosition() + 8L, this._metadataBlock.sequenceNumber);
                }
                if (this._nextSequence <= index) {
                    this._nextSequence = index + 1L;
                }
            }
            catch (IOException ex) {
                throw new StoreException("Error saving last discarded: " + ex, ex);
            }
            finally {
                this.lock.unlock();
            }
            return;
        }
        this._metadataBlock.sequenceNumber = index;
        Block almostFreeList = this.detach(index);
        Block zeroedOutList = null;
        Block lastOnTheList = almostFreeList;
        try {
            Block current = almostFreeList;
            while (current != null) {
                Block next = current.nextInList;
                Block currentInChain = current;
                while (currentInChain != null) {
                    Block nextInChain = currentInChain.nextInChain;
                    this._buffer.zero(currentInChain.getPosition(), 32);
                    currentInChain.sequenceNumber = 0L;
                    currentInChain.nextInChain = null;
                    currentInChain.nextInList = zeroedOutList;
                    zeroedOutList = currentInChain;
                    currentInChain = nextInChain;
                }
                current = next;
            }
        }
        catch (IOException ioex) {
            throw new StoreException(ioex);
        }
        this.lock.lock();
        try {
            this._metadataBlock.sequenceNumber = index;
            try {
                this._buffer.putLong(this._metadataBlock.getPosition() + 8L, this._metadataBlock.sequenceNumber);
            }
            catch (IOException ex) {
                throw new StoreException("Error saving last discarded: " + ex, ex);
            }
            if (lastOnTheList != null) {
                lastOnTheList.nextInList = this._freeList;
                this._freeList = zeroedOutList;
            }
            this._blocksFree.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getLastPersisted() throws StoreException {
        this.lock.lock();
        try {
            long l = this._getLastPersisted();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private long _getLastPersisted() throws StoreException {
        if (this._metadataBlock.sequenceNumber != 0L) {
            return this._metadataBlock.sequenceNumber;
        }
        if (this._nextSequence != 1L) {
            long minSeq = this._getLowestUnpersisted();
            long maxSeq = this._getHighestUnpersisted();
            if (minSeq != -1L) {
                this._metadataBlock.sequenceNumber = minSeq - 1L;
            }
            if (maxSeq != -1L && this._nextSequence <= maxSeq) {
                this._nextSequence = maxSeq + 1L;
            }
            if (this._nextSequence < this._metadataBlock.sequenceNumber) {
                this._metadataBlock.sequenceNumber = this._nextSequence - 1L;
            }
        } else {
            this._metadataBlock.sequenceNumber = System.currentTimeMillis() * 1000000L;
            this._nextSequence = this._metadataBlock.sequenceNumber + 1L;
        }
        try {
            this._buffer.putLong(this._metadataBlock.getPosition() + 8L, this._metadataBlock.sequenceNumber);
        }
        catch (IOException ex) {
            throw new StoreException("Error saving last discarded: " + ex, ex);
        }
        return this._metadataBlock.sequenceNumber;
    }

    @Override
    public long getLowestUnpersisted() {
        this.lock.lock();
        try {
            long l = this._getLowestUnpersisted();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private long _getLowestUnpersisted() {
        if (this._usedList != null) {
            return this._usedList.sequenceNumber;
        }
        return -1L;
    }

    public long getHighestUnpersisted() {
        this.lock.lock();
        try {
            long l = this._getHighestUnpersisted();
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private long _getHighestUnpersisted() {
        if (this._endOfUsedList != null) {
            return this._endOfUsedList.sequenceNumber;
        }
        return -1L;
    }

    @Override
    public void setMessage(Message m) {
        this._message = m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block detach(long index) {
        Block keepList = null;
        Block endOfDiscardList = null;
        Block discardList = null;
        this.lock.lock();
        try {
            keepList = this._usedList;
            while (keepList != null && keepList.sequenceNumber <= index) {
                if (discardList == null) {
                    discardList = keepList;
                }
                endOfDiscardList = keepList;
                keepList = keepList.nextInList;
            }
            if (endOfDiscardList != null) {
                endOfDiscardList.nextInList = null;
            }
            this._usedList = keepList;
            if (keepList == null) {
                this._endOfUsedList = null;
            }
        }
        finally {
            this.lock.unlock();
        }
        return discardList;
    }

    private void replayOnto(Block b, Store.StoreReplayer replayer) throws IOException, DisconnectedException {
        block33: {
            int flag;
            int topicLength;
            int operation;
            int totalLength;
            block34: {
                int offset;
                byte[] array;
                block32: {
                    Block part;
                    if (this._message == null) {
                        this._message = new JSONMessage(StandardCharsets.UTF_8.newEncoder(), StandardCharsets.UTF_8.newDecoder());
                    }
                    this._message.reset();
                    long bPosition = b.getPosition();
                    this._buffer.setPosition(bPosition);
                    totalLength = this._buffer.getInt() - 32;
                    if (totalLength <= 0) {
                        return;
                    }
                    this._buffer.getInt();
                    this._message.setSequence(this._buffer.getLong());
                    this._buffer.getLong();
                    while (this._buffer.getInt(bPosition + 24L) == 0) {
                        try {
                            this._messageReady.await(1000L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this._buffer.setPosition(bPosition + 16L);
                    long crcVal = this._buffer.getLong();
                    this._buffer.setPosition(bPosition + 32L);
                    operation = this._buffer.getInt();
                    if (operation == 0) {
                        return;
                    }
                    this._message.setCommand(operation);
                    int commandIdLength = this._buffer.getInt();
                    int correlationIdLength = this._buffer.getInt();
                    int expirationLength = this._buffer.getInt();
                    int sowKeyLength = this._buffer.getInt();
                    topicLength = this._buffer.getInt();
                    flag = this._buffer.getInt();
                    this._message.setAckType(this._buffer.getInt());
                    this._buffer.setPosition(bPosition + 32L + 32L);
                    array = null;
                    offset = 0;
                    if (b.nextInChain == null) {
                        this._argument.len = totalLength;
                        this._buffer.getBytes(this._argument);
                        array = this._argument.array;
                        offset = (int)this._argument.offset;
                    } else {
                        if (this._readBuffer == null || this._readBuffer.length < totalLength) {
                            this._readBuffer = new byte[totalLength];
                        }
                        int position = 0;
                        part = b;
                        while (part != null) {
                            int maxReadable = 2016;
                            if (b != part) {
                                this._buffer.setPosition(part.getPosition() + 32L);
                            } else {
                                maxReadable -= 32;
                            }
                            int readLen = totalLength - position > maxReadable ? maxReadable : totalLength - position;
                            this._argument.len = readLen;
                            try {
                                this._buffer.getBytes(this._argument);
                            }
                            catch (Exception e) {
                                throw new IOException("Corrupted message found.", e);
                            }
                            System.arraycopy(this._argument.array, (int)this._argument.offset, this._readBuffer, position, readLen);
                            position += readLen;
                            part = part.nextInChain;
                        }
                        if (position != totalLength) {
                            throw new IOException(String.format("Corrupted message found.  Expected %d bytes, read %d bytes.", totalLength, position));
                        }
                        array = this._readBuffer;
                        offset = 0;
                    }
                    if (this._crc != null) {
                        this._crc.reset();
                        try {
                            this._crc.update(array, offset, totalLength);
                        }
                        catch (Exception e) {
                            throw new IOException("Corrupted message found.", e);
                        }
                        if (this._crc.getValue() != crcVal) {
                            StringBuilder sb = new StringBuilder();
                            part = b;
                            while (part != null) {
                                sb.append(part);
                                sb.append('\n');
                                part = part.nextInChain;
                            }
                            String message = String.format("Corrupted message found.  Block index %d, sequence %d, topic length %d, expected CRC %d, actual CRC %d, Block list: %s", b.index, b.sequenceNumber, topicLength, crcVal, this._crc.getValue(), sb.toString());
                            throw new IOException(message);
                        }
                    }
                    if (commandIdLength > 0) {
                        this._message.setCommandId(array, offset, commandIdLength);
                        totalLength -= commandIdLength;
                        offset += commandIdLength;
                    }
                    if (correlationIdLength > 0) {
                        this._message.getCorrelationIdRaw().set(array, offset, correlationIdLength);
                        totalLength -= correlationIdLength;
                        offset += correlationIdLength;
                    }
                    if (expirationLength > 0) {
                        this._message.getExpirationRaw().set(array, offset, expirationLength);
                        totalLength -= expirationLength;
                        offset += expirationLength;
                    }
                    if (sowKeyLength > 0) {
                        this._message.setSowKey(array, offset, sowKeyLength);
                        totalLength -= sowKeyLength;
                        offset += sowKeyLength;
                    }
                    if (topicLength > 0) {
                        this._message.setTopic(array, offset, topicLength);
                        totalLength -= topicLength;
                        offset += topicLength;
                    }
                    if (operation != 1 && operation != 64) break block32;
                    this._message.setData(array, offset, totalLength);
                    replayer.execute(this._message);
                    break block33;
                }
                if (operation != 32) break block34;
                switch (flag) {
                    case 1: {
                        this._message.setData(array, offset, totalLength);
                        replayer.execute(this._message);
                        break block33;
                    }
                    case 2: {
                        this._message.setFilter(array, offset, totalLength);
                        replayer.execute(this._message);
                        break block33;
                    }
                    case 4: {
                        this._message.setSowKeys(array, offset, totalLength);
                        replayer.execute(this._message);
                        break block33;
                    }
                    case 8: {
                        this._message.setBookmark(array, offset, totalLength);
                        replayer.execute(this._message);
                        break block33;
                    }
                    case 16: {
                        this._message.setBookmark(array, offset, totalLength).setOptions("cancel");
                        replayer.execute(this._message);
                        break block33;
                    }
                    default: {
                        String message = String.format("SOWDelete message with invalid flag found.  Block index %d, sequence %d, topic length %d, expected data length %d, operation %d, flag %d", b.index, b.sequenceNumber, topicLength, totalLength, operation, flag);
                        throw new IOException(message);
                    }
                }
            }
            String message = String.format("Message with invalid operation found.  Block index %d, sequence %d, topic length %d, expected data length %d, operation %d, flag %d", b.index, b.sequenceNumber, topicLength, totalLength, operation, flag);
            throw new IOException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replay(Store.StoreReplayer replayer) throws StoreException, DisconnectedException {
        this.lock.lock();
        try {
            if (this._usedList == null) {
                return;
            }
            boolean corrupted = false;
            StoreException ex = null;
            Block lastGood = null;
            Block nextInList = null;
            Block b = this._usedList;
            while (b != null) {
                nextInList = b.nextInList;
                if (!corrupted) {
                    try {
                        if (this._buffer.getInt(b.getPosition() + 24L) == 0) break;
                        this.replayOnto(b, replayer);
                        lastGood = b;
                    }
                    catch (IOException ioex) {
                        corrupted = true;
                        this._endOfUsedList = lastGood == null ? this._usedList : lastGood;
                        ex = new StoreException("Exception during replay, ignoring all following blocks", ioex);
                    }
                }
                if (corrupted) {
                    Block currentInChain = b;
                    while (currentInChain != null) {
                        Block nextInChain = currentInChain.nextInChain;
                        try {
                            this._buffer.zero(currentInChain.getPosition(), 32);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        currentInChain.sequenceNumber = 0L;
                        currentInChain.nextInChain = null;
                        currentInChain.nextInList = this._freeList;
                        this._freeList = currentInChain;
                        currentInChain = nextInChain;
                    }
                }
                b = nextInList;
            }
            if (corrupted) {
                throw ex;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean replaySingle(Store.StoreReplayer replayer, long index) throws StoreException, DisconnectedException {
        this.lock.lock();
        try {
            if (index <= this._metadataBlock.sequenceNumber) {
                boolean bl = true;
                return bl;
            }
            Block b22 = this._usedList;
            while (b22 != null) {
                while (b22.sequenceNumber == index && this._buffer.getInt(b22.getPosition() + 24L) == 0) {
                    try {
                        this._messageReady.await(1000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (b22.sequenceNumber == index) {
                    this._buffer.setPosition(b22.getPosition());
                    if (this._buffer.getInt() <= 0) {
                        boolean bl = false;
                        return bl;
                    }
                    this.replayOnto(b22, replayer);
                    boolean bl = true;
                    return bl;
                }
                if (b22.sequenceNumber > index) break;
                b22 = b22.nextInList;
            }
            boolean b22 = false;
            return b22;
        }
        catch (IOException ioex) {
            throw new StoreException(ioex);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long unpersistedCount() {
        this.lock.lock();
        try {
            if (this._usedList == null) {
                long l = 0L;
                return l;
            }
            long l = this._endOfUsedList.sequenceNumber - this._usedList.sequenceNumber + 1L;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    Block findOrCreate(int index, Map<Integer, Block> allBlocks) {
        if (allBlocks.containsKey(index)) {
            return allBlocks.get(index);
        }
        Block b = new Block(index);
        allBlocks.put(index, b);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recover() throws StoreException {
        this.lock.lock();
        try {
            long end;
            TreeMap<Long, Block> heads;
            HashMap<Integer, Block> allBlocks;
            block18: {
                this._freeList = null;
                this._usedList = null;
                allBlocks = new HashMap<Integer, Block>();
                heads = new TreeMap<Long, Block>();
                end = this._buffer.getSize();
                if (end != 0L) break block18;
                return;
            }
            try {
                long minSeq = 0L;
                long maxSeq = 0L;
                for (long offset = 0L; offset < end; offset += 2048L) {
                    int index = (int)(offset / 2048L);
                    this._buffer.setPosition(offset);
                    int size = this._buffer.getInt();
                    int nextIndex = this._buffer.getInt();
                    long sequence = this._buffer.getLong();
                    this._buffer.getLong();
                    int ready = this._buffer.getInt();
                    if (index == 0) {
                        this._metadataBlock = new Block(index);
                        this._metadataBlock.nextInChain = null;
                        this._metadataBlock.nextInList = null;
                        this._metadataBlock.sequenceNumber = sequence;
                        minSeq = this._nextSequence = sequence + 1L;
                        continue;
                    }
                    Block b = this.findOrCreate(index, allBlocks);
                    Block block = b.nextInChain = size == 0 || nextIndex == index ? null : this.findOrCreate(nextIndex, allBlocks);
                    if (size == 0) {
                        b.nextInList = this._freeList;
                        this._freeList = b;
                        continue;
                    }
                    if (sequence == 0L) continue;
                    if (ready == 0) {
                        Block currentInChain = b;
                        while (currentInChain != null) {
                            Block nextInChain = currentInChain.nextInChain;
                            this._buffer.zero(currentInChain.getPosition(), 32);
                            currentInChain.sequenceNumber = 0L;
                            currentInChain.nextInChain = null;
                            currentInChain.nextInList = this._freeList;
                            this._freeList = currentInChain;
                            currentInChain = nextInChain;
                        }
                        continue;
                    }
                    b.sequenceNumber = sequence;
                    if (sequence < minSeq) {
                        minSeq = sequence;
                    }
                    if (sequence > maxSeq) {
                        maxSeq = sequence;
                    }
                    heads.put(sequence, b);
                }
                if (this._metadataBlock.sequenceNumber < minSeq - 1L) {
                    this._metadataBlock.sequenceNumber = minSeq - 1L;
                }
                if (this._nextSequence <= maxSeq) {
                    this._nextSequence = maxSeq + 1L;
                }
                for (Map.Entry e : heads.entrySet()) {
                    Block b = (Block)e.getValue();
                    b.nextInList = null;
                    if (this._endOfUsedList != null) {
                        this._endOfUsedList.nextInList = b;
                        this._endOfUsedList = b;
                        continue;
                    }
                    this._usedList = this._endOfUsedList = b;
                }
            }
            catch (IOException ioex) {
                throw new StoreException(ioex);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void growFreeListIfEmpty() throws StoreException {
        this.lock.lock();
        try {
            this._growFreeListIfEmpty();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _growFreeListIfEmpty() throws StoreException {
        while (this._resizing) {
            try {
                this._blocksFree.await(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this._freeList != null) {
            return;
        }
        try {
            long oldSize = this._buffer.getSize();
            long newSize = oldSize + 2048L * (long)this._blocksPerRealloc;
            this._resizing = true;
            try {
                while (this._buffer.getSize() == oldSize) {
                    boolean changeSize = true;
                    if (this._resizeHandler != null) {
                        this.lock.unlock();
                        try {
                            changeSize = this._resizeHandler.invoke(this, newSize);
                        }
                        finally {
                            this.lock.lock();
                        }
                    }
                    if (this._freeList != null) {
                        return;
                    }
                    if (!changeSize) continue;
                    this._buffer.setSize(newSize);
                }
            }
            finally {
                this._resizing = false;
            }
            if (this._buffer.getSize() < newSize) {
                throw new StoreException("Publish store could not resize, possibly due to resize handler.");
            }
            int idx = (int)(oldSize / 2048L);
            if (idx == 0) {
                int version;
                this._metadataBlock = new Block(idx);
                this._metadataBlock.nextInChain = null;
                this._metadataBlock.nextInList = null;
                this._metadataBlock.sequenceNumber = 0L;
                long metadataPosition = this._metadataBlock.getPosition();
                this._buffer.zero(metadataPosition, 2048);
                this._buffer.setPosition(metadataPosition + 4L);
                try {
                    version = Client.getVersionAsInt(Client.getVersion());
                }
                catch (CommandException ex) {
                    version = 4000100;
                }
                this._buffer.putInt(version);
                this._buffer.setPosition(metadataPosition + 8L);
                this._buffer.putLong(0L);
                ++idx;
            }
            while (idx < (int)(newSize / 2048L)) {
                Block b = new Block(idx);
                this._buffer.zero(b.getPosition(), 2048);
                b.nextInChain = null;
                b.nextInList = this._freeList;
                this._freeList = b;
                ++idx;
            }
            this._blocksFree.signalAll();
        }
        catch (IOException e) {
            throw new StoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws TimedOutException {
        this.lock.lock();
        try {
            if (this._usedList == null) {
                return;
            }
            long current = this._endOfUsedList.sequenceNumber;
            while (this._usedList != null && current >= this._usedList.sequenceNumber) {
                try {
                    this._blocksFree.await();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(long timeout) throws TimedOutException {
        this.lock.lock();
        try {
            if (this._usedList == null) {
                return;
            }
            long current = this._endOfUsedList.sequenceNumber;
            long start = System.currentTimeMillis();
            while (this._usedList != null && current >= this._usedList.sequenceNumber) {
                long end = System.currentTimeMillis();
                if (timeout > 0L && end - start >= timeout) {
                    throw new TimedOutException("Timed out waiting to flush publish store.");
                }
                try {
                    long remaining = timeout - (end - start);
                    this._blocksFree.await(remaining, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setResizeHandler(PublishStoreResizeHandler handler) {
        this._resizeHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block get(boolean assignSequence, long sequence) throws StoreException {
        Block b = null;
        this.lock.lock();
        try {
            this._growFreeListIfEmpty();
            b = this._freeList;
            if (b != null) {
                this._freeList = b.nextInList;
                b.nextInList = null;
                if (assignSequence) {
                    if (this._nextSequence <= 1L) {
                        this._getLastPersisted();
                    }
                    b.sequenceNumber = this._nextSequence++;
                } else if (sequence != 0L) {
                    b.sequenceNumber = sequence;
                }
                if (assignSequence || sequence != 0L) {
                    if (this._endOfUsedList != null) {
                        this._endOfUsedList.nextInList = b;
                        this._endOfUsedList = b;
                    } else {
                        this._endOfUsedList = this._usedList = b;
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return b;
    }

    static class Block {
        public int index;
        public Block nextInChain;
        public Block nextInList;
        public long sequenceNumber;
        public static final int SIZE = 2048;
        public static final int BLOCK_HEADER_SIZE = 32;
        public static final int BLOCK_DATA_SIZE = 2016;
        public static final int CHAIN_HEADER = 32;
        public static final int BLOCK_CRC_POSITION = 16;
        public static final int BLOCK_READY_POSITION = 24;

        public Block(int index) {
            this.index = index;
        }

        public long getPosition() {
            return 2048L * (long)this.index;
        }

        public String toString() {
            return String.format("block %d sequenceNumber %d", this.index, this.sequenceNumber);
        }
    }

    public static interface Buffer
    extends AutoCloseable {
        public long getSize() throws IOException;

        public void setSize(long var1) throws IOException;

        public long getPosition() throws IOException;

        public void setPosition(long var1) throws IOException;

        public void putByte(byte var1) throws IOException;

        public byte getByte() throws IOException;

        public void putInt(int var1) throws IOException;

        public void putInt(long var1, int var3) throws IOException;

        public int getInt() throws IOException;

        public int getInt(long var1) throws IOException;

        public void putLong(long var1) throws IOException;

        public void putLong(long var1, long var3) throws IOException;

        public long getLong() throws IOException;

        public void putBytes(ByteSequence var1) throws IOException;

        public void getBytes(ByteSequence var1) throws IOException;

        public void zero(long var1, int var3) throws IOException;

        public void putBytes(byte[] var1, long var2, long var4) throws IOException;

        public void getBytes(Field var1, int var2) throws IOException;
    }

    public static class ByteSequence {
        public byte[] array;
        public long offset;
        public long len;

        public ByteSequence() {
            this.array = null;
            this.len = 0L;
            this.offset = 0L;
        }

        public ByteSequence(byte[] array, long offset, long len) {
            this.array = array;
            this.offset = offset;
            this.len = len;
        }
    }
}

