/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

import com.crankuptheamps.client.BlockPublishStore;
import com.crankuptheamps.client.Store;
import com.crankuptheamps.client.fields.Field;
import java.io.IOException;
import java.util.Arrays;

public class ArrayStoreBuffer
implements BlockPublishStore.Buffer {
    byte[] _buf = null;
    volatile int _pos = 0;
    Store _store = null;

    public byte[] getBuffer() {
        return this._buf;
    }

    @Override
    public long getSize() throws IOException {
        return this._buf == null ? 0L : (long)this._buf.length;
    }

    @Override
    public void setSize(long newSize) throws IOException {
        byte[] oldBuf = this._buf;
        if (oldBuf == null || newSize > (long)oldBuf.length) {
            byte[] newBuf = new byte[(int)newSize];
            if (oldBuf != null && oldBuf.length > 0) {
                System.arraycopy(oldBuf, 0, newBuf, 0, oldBuf.length);
            }
            this._buf = newBuf;
        }
    }

    @Override
    public long getPosition() throws IOException {
        return this._pos;
    }

    @Override
    public void setPosition(long position) throws IOException {
        this._pos = (int)position;
    }

    @Override
    public void putByte(byte b) throws IOException {
        this._buf[this._pos++] = b;
    }

    @Override
    public byte getByte() throws IOException {
        return this._buf[this._pos++];
    }

    @Override
    public void putInt(int i) throws IOException {
        this._buf[this._pos++] = (byte)((i & 0xFF000000) >> 24);
        this._buf[this._pos++] = (byte)((i & 0xFF0000) >> 16);
        this._buf[this._pos++] = (byte)((i & 0xFF00) >> 8);
        this._buf[this._pos++] = (byte)(i & 0xFF);
    }

    @Override
    public void putInt(long position, int i) throws IOException {
        int pos = (int)position;
        this._buf[pos++] = (byte)((i & 0xFF000000) >> 24);
        this._buf[pos++] = (byte)((i & 0xFF0000) >> 16);
        this._buf[pos++] = (byte)((i & 0xFF00) >> 8);
        this._buf[pos] = (byte)(i & 0xFF);
    }

    @Override
    public int getInt() throws IOException {
        int result = this._buf[this._pos + 3] & 0xFF | (this._buf[this._pos + 2] & 0xFF) << 8 | (this._buf[this._pos + 1] & 0xFF) << 16 | (this._buf[this._pos + 0] & 0xFF) << 24;
        this._pos += 4;
        return result;
    }

    @Override
    public int getInt(long position) throws IOException {
        int pos = (int)position;
        return this._buf[pos + 3] & 0xFF | (this._buf[pos + 2] & 0xFF) << 8 | (this._buf[pos + 1] & 0xFF) << 16 | (this._buf[pos + 0] & 0xFF) << 24;
    }

    @Override
    public void putLong(long l) throws IOException {
        this._buf[this._pos++] = (byte)((l & 0xFF00000000000000L) >> 56);
        this._buf[this._pos++] = (byte)((l & 0xFF000000000000L) >> 48);
        this._buf[this._pos++] = (byte)((l & 0xFF0000000000L) >> 40);
        this._buf[this._pos++] = (byte)((l & 0xFF00000000L) >> 32);
        this._buf[this._pos++] = (byte)((l & 0xFF000000L) >> 24);
        this._buf[this._pos++] = (byte)((l & 0xFF0000L) >> 16);
        this._buf[this._pos++] = (byte)((l & 0xFF00L) >> 8);
        this._buf[this._pos++] = (byte)(l & 0xFFL);
    }

    @Override
    public void putLong(long position, long l) throws IOException {
        int pos = (int)position;
        this._buf[pos++] = (byte)((l & 0xFF00000000000000L) >> 56);
        this._buf[pos++] = (byte)((l & 0xFF000000000000L) >> 48);
        this._buf[pos++] = (byte)((l & 0xFF0000000000L) >> 40);
        this._buf[pos++] = (byte)((l & 0xFF00000000L) >> 32);
        this._buf[pos++] = (byte)((l & 0xFF000000L) >> 24);
        this._buf[pos++] = (byte)((l & 0xFF0000L) >> 16);
        this._buf[pos++] = (byte)((l & 0xFF00L) >> 8);
        this._buf[pos] = (byte)(l & 0xFFL);
    }

    @Override
    public long getLong() throws IOException {
        long result = (long)(this._buf[this._pos + 7] & 0xFF) | (long)(this._buf[this._pos + 6] & 0xFF) << 8 | (long)(this._buf[this._pos + 5] & 0xFF) << 16 | (long)(this._buf[this._pos + 4] & 0xFF) << 24 | (long)(this._buf[this._pos + 3] & 0xFF) << 32 | (long)(this._buf[this._pos + 2] & 0xFF) << 40 | (long)(this._buf[this._pos + 1] & 0xFF) << 48 | (long)(this._buf[this._pos + 0] & 0xFF) << 56;
        this._pos += 8;
        return result;
    }

    @Override
    public void putBytes(BlockPublishStore.ByteSequence bytes) throws IOException {
        if (bytes.array == null || bytes.len == 0L) {
            return;
        }
        System.arraycopy(bytes.array, (int)bytes.offset, this._buf, this._pos, (int)bytes.len);
        this._pos = (int)((long)this._pos + bytes.len);
    }

    @Override
    public void getBytes(BlockPublishStore.ByteSequence outBytes) throws IOException {
        if (outBytes.len == 0L) {
            return;
        }
        outBytes.array = this._buf;
        outBytes.offset = this._pos;
        this._pos = (int)((long)this._pos + outBytes.len);
    }

    @Override
    public void putBytes(byte[] buffer, long position, long length) throws IOException {
        if (buffer == null || length == 0L) {
            return;
        }
        System.arraycopy(buffer, (int)position, this._buf, this._pos, (int)length);
        this._pos = (int)((long)this._pos + length);
    }

    @Override
    public void getBytes(Field outField, int length) throws IOException {
        outField.length = length;
        if (outField.length == 0) {
            outField.buffer = null;
            outField.position = 0;
        } else {
            outField.buffer = this._buf;
            outField.position = this._pos;
            this._pos += outField.length;
        }
    }

    @Override
    public void zero(long offset, int length) throws IOException {
        Arrays.fill(this._buf, (int)offset, (int)offset + length, (byte)0);
    }

    @Override
    public void close() {
        this._buf = null;
        this._store = null;
        this._pos = -1;
    }
}

