/*
 * Decompiled with CFR 0.152.
 */
package com.crankuptheamps.client;

public class AMPSTimestamp {
    public static final int AMPS_TIMESTAMP_LENGTH = 23;
    public int year;
    public int month;
    public int day;
    public int hour;
    public int minute;
    public int second;
    public int nano;

    public static void parse(String data, AMPSTimestamp out) {
        if (data.length() != 23) {
            throw new RuntimeException("Timestamp length incorrect -- this is not an AMPS timestamp.");
        }
        out.year = (data.charAt(0) - 48) * 1000 + (data.charAt(1) - 48) * 100 + (data.charAt(2) - 48) * 10 + (data.charAt(3) - 48);
        out.month = (data.charAt(4) - 48) * 10 + (data.charAt(5) - 48);
        out.day = (data.charAt(6) - 48) * 10 + (data.charAt(7) - 48);
        out.hour = (data.charAt(9) - 48) * 10 + (data.charAt(10) - 48);
        out.minute = (data.charAt(11) - 48) * 10 + (data.charAt(12) - 48);
        out.second = (data.charAt(13) - 48) * 10 + (data.charAt(14) - 48);
        out.nano = (data.charAt(16) - 48) * 100000000 + (data.charAt(17) - 48) * 10000000 + (data.charAt(18) - 48) * 1000000 + (data.charAt(19) - 48) * 100000 + (data.charAt(20) - 48) * 10000 + (data.charAt(21) - 48) * 1000;
    }

    public static void parse(byte[] data, int offset, int length, AMPSTimestamp out) {
        if (length != 23) {
            throw new RuntimeException("Timestamp length incorrect -- this is not an AMPS timestamp.");
        }
        out.year = (data[offset] - 48) * 1000 + (data[offset + 1] - 48) * 100 + (data[offset + 2] - 48) * 10 + (data[offset + 3] - 48);
        out.month = (data[offset + 4] - 48) * 10 + (data[offset + 5] - 48);
        out.day = (data[offset + 6] - 48) * 10 + (data[offset + 7] - 48);
        out.hour = (data[offset + 9] - 48) * 10 + (data[offset + 10] - 48);
        out.minute = (data[offset + 11] - 48) * 10 + (data[offset + 12] - 48);
        out.second = (data[offset + 13] - 48) * 10 + (data[offset + 14] - 48);
        out.nano = (data[offset + 16] - 48) * 100000000 + (data[offset + 17] - 48) * 10000000 + (data[offset + 18] - 48) * 1000000 + (data[offset + 19] - 48) * 100000 + (data[offset + 20] - 48) * 10000 + (data[offset + 21] - 48) * 1000;
    }

    public AMPSTimestamp(String data) {
        AMPSTimestamp.parse(data, this);
    }

    public AMPSTimestamp(byte[] data, int offset, int length) {
        AMPSTimestamp.parse(data, offset, length, this);
    }
}

