/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.bucket;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.manager.bucket.CoreBucketSettings;
import com.couchbase.client.core.manager.bucket.CoreCompressionMode;
import com.couchbase.client.core.manager.bucket.CoreEvictionPolicyType;
import com.couchbase.client.core.manager.bucket.CoreStorageBackend;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.manager.bucket.BucketType;
import com.couchbase.client.java.manager.bucket.CompressionMode;
import com.couchbase.client.java.manager.bucket.ConflictResolutionType;
import com.couchbase.client.java.manager.bucket.EjectionPolicy;
import com.couchbase.client.java.manager.bucket.EvictionPolicyType;
import com.couchbase.client.java.manager.bucket.StorageBackend;
import java.time.Duration;

public class BucketSettings {
    private final String name;
    private boolean flushEnabled = false;
    private long ramQuotaMB = 100L;
    private int numReplicas = 1;
    private boolean replicaIndexes = false;
    private Duration maxExpiry = Duration.ZERO;
    private CompressionMode compressionMode;
    private BucketType bucketType = BucketType.COUCHBASE;
    private ConflictResolutionType conflictResolutionType = ConflictResolutionType.SEQUENCE_NUMBER;
    private EvictionPolicyType evictionPolicy = null;
    private DurabilityLevel minimumDurabilityLevel = DurabilityLevel.NONE;
    private StorageBackend storageBackend = null;
    private boolean healthy = true;

    @Stability.Internal
    public BucketSettings(CoreBucketSettings internal) {
        this.name = internal.name();
        this.flushEnabled = internal.flushEnabled();
        this.ramQuotaMB = internal.ramQuotaMB();
        this.replicaIndexes = internal.replicaIndexes();
        this.numReplicas = internal.numReplicas();
        this.maxExpiry = internal.maxExpiry();
        if (internal.compressionMode() != null) {
            switch (internal.compressionMode()) {
                case OFF: {
                    this.compressionMode = CompressionMode.OFF;
                    break;
                }
                case PASSIVE: {
                    this.compressionMode = CompressionMode.PASSIVE;
                    break;
                }
                case ACTIVE: {
                    this.compressionMode = CompressionMode.ACTIVE;
                    break;
                }
                default: {
                    throw new CouchbaseException("Unknown compression mode");
                }
            }
        }
        switch (internal.bucketType()) {
            case COUCHBASE: {
                this.bucketType = BucketType.COUCHBASE;
                break;
            }
            case EPHEMERAL: {
                this.bucketType = BucketType.EPHEMERAL;
                break;
            }
            case MEMCACHED: {
                this.bucketType = BucketType.MEMCACHED;
            }
        }
        switch (internal.evictionPolicy()) {
            case FULL: {
                this.evictionPolicy = EvictionPolicyType.FULL;
                break;
            }
            case VALUE_ONLY: {
                this.evictionPolicy = EvictionPolicyType.VALUE_ONLY;
                break;
            }
            case NOT_RECENTLY_USED: {
                this.evictionPolicy = EvictionPolicyType.NOT_RECENTLY_USED;
                break;
            }
            case NO_EVICTION: {
                this.evictionPolicy = EvictionPolicyType.NO_EVICTION;
            }
        }
        this.minimumDurabilityLevel = internal.minimumDurabilityLevel();
        if (internal.storageBackend() == CoreStorageBackend.COUCHSTORE) {
            this.storageBackend = StorageBackend.COUCHSTORE;
        } else if (internal.storageBackend() == CoreStorageBackend.MAGMA) {
            this.storageBackend = StorageBackend.MAGMA;
        }
    }

    BucketSettings(String name) {
        this.name = name;
    }

    public static BucketSettings create(String name) {
        return new BucketSettings(name);
    }

    private static long ramQuotaToMB(long ramQuotaBytes) {
        long BYTES_PER_MEGABYTE = 0x100000L;
        return ramQuotaBytes == 0L ? 0L : ramQuotaBytes / 0x100000L;
    }

    public String name() {
        return this.name;
    }

    public boolean flushEnabled() {
        return this.flushEnabled;
    }

    public long ramQuotaMB() {
        return this.ramQuotaMB;
    }

    public int numReplicas() {
        return this.numReplicas;
    }

    public boolean replicaIndexes() {
        return this.replicaIndexes;
    }

    public DurabilityLevel minimumDurabilityLevel() {
        return this.minimumDurabilityLevel;
    }

    public Duration maxExpiry() {
        return this.maxExpiry;
    }

    public CompressionMode compressionMode() {
        if (this.compressionMode == null) {
            return CompressionMode.OFF;
        }
        return this.compressionMode;
    }

    public BucketType bucketType() {
        return this.bucketType;
    }

    public ConflictResolutionType conflictResolutionType() {
        return this.conflictResolutionType;
    }

    public StorageBackend storageBackend() {
        return this.storageBackend;
    }

    public EvictionPolicyType evictionPolicy() {
        return this.evictionPolicy;
    }

    @Stability.Internal
    public boolean healthy() {
        return this.healthy;
    }

    public BucketSettings flushEnabled(boolean flushEnabled) {
        this.flushEnabled = flushEnabled;
        return this;
    }

    public BucketSettings ramQuotaMB(long ramQuotaMB) {
        this.ramQuotaMB = ramQuotaMB;
        return this;
    }

    public BucketSettings numReplicas(int numReplicas) {
        this.numReplicas = numReplicas;
        return this;
    }

    public BucketSettings replicaIndexes(boolean replicaIndexes) {
        this.replicaIndexes = replicaIndexes;
        return this;
    }

    public BucketSettings maxExpiry(Duration maxExpiry) {
        this.maxExpiry = (Duration)Validators.notNull((Object)maxExpiry, (String)"MaxExpiry");
        return this;
    }

    public BucketSettings compressionMode(CompressionMode compressionMode) {
        this.compressionMode = (CompressionMode)((Object)Validators.notNull((Object)((Object)compressionMode), (String)"CompressionMode"));
        return this;
    }

    public BucketSettings bucketType(BucketType bucketType) {
        this.bucketType = (BucketType)((Object)Validators.notNull((Object)((Object)bucketType), (String)"BucketType"));
        return this;
    }

    public BucketSettings conflictResolutionType(ConflictResolutionType conflictResolutionType) {
        this.conflictResolutionType = (ConflictResolutionType)((Object)Validators.notNull((Object)((Object)conflictResolutionType), (String)"ConflictResolutionType"));
        return this;
    }

    public BucketSettings evictionPolicy(EvictionPolicyType evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public BucketSettings minimumDurabilityLevel(DurabilityLevel durabilityLevel) {
        this.minimumDurabilityLevel = (DurabilityLevel)Validators.notNull((Object)durabilityLevel, (String)"DurabilityLevel");
        return this;
    }

    public BucketSettings storageBackend(StorageBackend storageBackend) {
        this.storageBackend = (StorageBackend)Validators.notNull((Object)storageBackend, (String)"storageBackend");
        return this;
    }

    @Deprecated
    public int maxTTL() {
        return (int)this.maxExpiry().getSeconds();
    }

    @Deprecated
    public BucketSettings maxTTL(int maxTTL) {
        return this.maxExpiry(Duration.ofSeconds(maxTTL));
    }

    @Deprecated
    public EjectionPolicy ejectionPolicy() {
        return EjectionPolicy.of(this.evictionPolicy);
    }

    @Deprecated
    public BucketSettings ejectionPolicy(EjectionPolicy ejectionPolicy) {
        this.evictionPolicy = ejectionPolicy == null ? null : ejectionPolicy.toEvictionPolicy();
        return this;
    }

    @Stability.Internal
    public CoreBucketSettings toCore() {
        return new CoreBucketSettings(){

            public String name() {
                return BucketSettings.this.name;
            }

            public Boolean flushEnabled() {
                return BucketSettings.this.flushEnabled;
            }

            public long ramQuotaMB() {
                return BucketSettings.this.ramQuotaMB;
            }

            public Integer numReplicas() {
                return BucketSettings.this.numReplicas;
            }

            public Boolean replicaIndexes() {
                return BucketSettings.this.replicaIndexes;
            }

            public com.couchbase.client.core.config.BucketType bucketType() {
                switch (BucketSettings.this.bucketType) {
                    case COUCHBASE: {
                        return com.couchbase.client.core.config.BucketType.COUCHBASE;
                    }
                    case MEMCACHED: {
                        return com.couchbase.client.core.config.BucketType.MEMCACHED;
                    }
                    case EPHEMERAL: {
                        return com.couchbase.client.core.config.BucketType.EPHEMERAL;
                    }
                }
                throw new CouchbaseException("Unknown bucket type " + (Object)((Object)BucketSettings.this.bucketType));
            }

            public CoreEvictionPolicyType evictionPolicy() {
                if (BucketSettings.this.evictionPolicy == null) {
                    return null;
                }
                switch (BucketSettings.this.evictionPolicy) {
                    case FULL: {
                        return CoreEvictionPolicyType.FULL;
                    }
                    case VALUE_ONLY: {
                        return CoreEvictionPolicyType.VALUE_ONLY;
                    }
                    case NOT_RECENTLY_USED: {
                        return CoreEvictionPolicyType.NOT_RECENTLY_USED;
                    }
                    case NO_EVICTION: {
                        return CoreEvictionPolicyType.NO_EVICTION;
                    }
                }
                throw new CouchbaseException("Unknown eviction policy " + (Object)((Object)BucketSettings.this.evictionPolicy));
            }

            public Duration maxExpiry() {
                return BucketSettings.this.maxExpiry;
            }

            public CoreCompressionMode compressionMode() {
                if (BucketSettings.this.compressionMode == null) {
                    return null;
                }
                switch (BucketSettings.this.compressionMode) {
                    case OFF: {
                        return CoreCompressionMode.OFF;
                    }
                    case PASSIVE: {
                        return CoreCompressionMode.PASSIVE;
                    }
                    case ACTIVE: {
                        return CoreCompressionMode.ACTIVE;
                    }
                }
                throw new CouchbaseException("Unknown compression mode " + (Object)((Object)BucketSettings.this.compressionMode));
            }

            public DurabilityLevel minimumDurabilityLevel() {
                return BucketSettings.this.minimumDurabilityLevel;
            }

            public CoreStorageBackend storageBackend() {
                if (BucketSettings.this.storageBackend == null) {
                    return null;
                }
                return BucketSettings.this.storageBackend.alias().equals(StorageBackend.MAGMA.alias()) ? CoreStorageBackend.MAGMA : CoreStorageBackend.COUCHSTORE;
            }

            public Boolean historyRetentionCollectionDefault() {
                return null;
            }

            public Long historyRetentionBytes() {
                return null;
            }

            public Duration historyRetentionDuration() {
                return null;
            }
        };
    }

    public String toString() {
        return "BucketSettings{name='" + RedactableArgument.redactMeta((Object)this.name) + '\'' + ", flushEnabled=" + this.flushEnabled + ", ramQuotaMB=" + this.ramQuotaMB + ", numReplicas=" + this.numReplicas + ", replicaIndexes=" + this.replicaIndexes + ", maxExpiry=" + this.maxExpiry.getSeconds() + ", compressionMode=" + (Object)((Object)this.compressionMode) + ", bucketType=" + (Object)((Object)this.bucketType) + ", conflictResolutionType=" + (Object)((Object)this.conflictResolutionType) + ", evictionPolicy=" + (Object)((Object)this.evictionPolicy) + ", minimumDurabilityLevel=" + this.minimumDurabilityLevel + ", storageBackend=" + this.storageBackend + '}';
    }
}

