/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.radosstriper;

import com.ceph.rados.RadosBase;
import com.ceph.rados.exceptions.RadosException;
import com.ceph.rados.jna.RadosObjectInfo;
import com.ceph.radosstriper.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.LongByReference;
import java.util.concurrent.Callable;

public class IoCTXStriper
extends RadosBase
implements AutoCloseable {
    private static final int EXT_ATTR_MAX_LEN = 4096;
    private Pointer ioCtxStriperPtr;

    public IoCTXStriper(Pointer p) {
        this.ioCtxStriperPtr = p;
    }

    public Pointer getPointer() {
        return this.ioCtxStriperPtr.getPointer(0L);
    }

    public void write(final String oid, final byte[] buf, final int length, final long offset) throws RadosException, IllegalArgumentException {
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset shouldn't be a negative value");
        }
        if (buf.length < length) {
            throw new IllegalArgumentException("Length shouldn't be a smaller than Buffer length");
        }
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_striper_write(IoCTXStriper.this.getPointer(), oid, buf, length, offset);
            }
        }, "Failed writing %s bytes with offset %s to %s", length, offset, oid);
    }

    public void write(String oid, byte[] buf, long offset) throws RadosException, IllegalArgumentException {
        this.write(oid, buf, buf.length, offset);
    }

    public void write(String oid, byte[] buf) throws RadosException {
        this.writeFull(oid, buf, buf.length);
    }

    public void writeFull(final String oid, final byte[] buf, final int len) throws RadosException {
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_striper_write_full(IoCTXStriper.this.getPointer(), oid, buf, len);
            }
        }, "Failed to write %s bytes to %s", len, oid);
    }

    public int setStripeUnit(final int stripeUnit) throws RadosException {
        return this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_set_object_layout_stripe_unit(IoCTXStriper.this.getPointer(), stripeUnit);
            }
        }, "Failed to set stripe unit to: %s", stripeUnit);
    }

    public int setStripeCount(final int stripeCount) throws RadosException {
        return this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_set_object_layout_stripe_count(IoCTXStriper.this.getPointer(), stripeCount);
            }
        }, "Failed to set stripe count to: %s", stripeCount);
    }

    public int setStripeObjectSize(final int stripeObjectSize) throws RadosException {
        return this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_set_object_layout_object_size(IoCTXStriper.this.getPointer(), stripeObjectSize);
            }
        }, "Failed to set stripe object size to: %s", stripeObjectSize);
    }

    public void write(String oid, String buf, long offset) throws RadosException {
        this.write(oid, buf.getBytes(), offset);
    }

    public void write(String oid, String buf) throws RadosException {
        this.write(oid, buf.getBytes());
    }

    public int read(final String oid, final int length, final long offset, final byte[] buf) throws RadosException {
        if (length < 0) {
            throw new IllegalArgumentException("Length shouldn't be a negative value");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset shouldn't be a negative value");
        }
        return this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_striper_read(IoCTXStriper.this.getPointer(), oid, buf, length, offset);
            }
        }, "Failed to read object %s using offset %s and length %s", oid, offset, length);
    }

    public void truncate(final String oid, final long size) throws RadosException {
        if (size < 0L) {
            throw new IllegalArgumentException("Size shouldn't be a negative value");
        }
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_striper_trunc(IoCTXStriper.this.getPointer(), oid, size);
            }
        }, "Failed resizing objects %s to %s bytes", oid, size);
    }

    public void append(final String oid, final byte[] buf, final int len) throws RadosException {
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_striper_append(IoCTXStriper.this.getPointer(), oid, buf, len);
            }
        }, "Failed appending %s bytes to object %s", len, oid);
    }

    public void append(String oid, byte[] buf) throws RadosException {
        this.append(oid, buf, buf.length);
    }

    public void append(String oid, String buf) throws RadosException {
        this.append(oid, buf.getBytes());
    }

    public void remove(final String oid) throws RadosException {
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_striper_remove(IoCTXStriper.this.getPointer(), oid);
            }
        }, "Failed removing object %s", oid);
    }

    public RadosObjectInfo stat(final String oid) throws RadosException {
        final LongByReference size = new LongByReference();
        final LongByReference mtime = new LongByReference();
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_striper_stat(IoCTXStriper.this.getPointer(), oid, size, mtime);
            }
        }, "Failed performing a stat on object %s", oid);
        return new RadosObjectInfo(oid, size.getValue(), mtime.getValue());
    }

    public String getExtendedAttribute(final String oid, final String xattrName) throws RadosException {
        final byte[] buf = new byte[4096];
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_striper_getxattr(IoCTXStriper.this.getPointer(), oid, xattrName, buf, buf.length);
            }
        }, "Failed to get extended attribute %s on %s", xattrName, oid);
        return Native.toString((byte[])buf);
    }

    public void setExtendedAttribute(final String oid, final String xattrName, String val) throws IllegalArgumentException, RadosException {
        final byte[] buf = Native.toByteArray((String)val);
        if (buf.length > 4096) {
            throw new IllegalArgumentException("Length of attribute value must not exceed 4096");
        }
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_striper_setxattr(IoCTXStriper.this.getPointer(), oid, xattrName, buf, buf.length);
            }
        }, "Failed to set extended attribute %s on %s", xattrName, oid);
    }

    public void removeExtendedAttribute(final String oid, final String xattrName) throws RadosException {
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_striper_rmxattr(IoCTXStriper.this.getPointer(), oid, xattrName);
            }
        }, "Failed to remove extended attribute %s from %s", xattrName, oid);
    }

    @Override
    public void close() throws Exception {
        Library.rados.rados_striper_destroy(this.getPointer());
    }
}

