/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.rados;

import com.ceph.rados.Library;
import com.ceph.rados.RadosBase;
import com.ceph.rados.exceptions.RadosException;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class Completion
extends RadosBase
implements Closeable {
    private static Map<Integer, Completion> completionMap = new HashMap<Integer, Completion>();
    private static int nextCompletionId = 1;
    private boolean safe;
    private boolean complete;
    private static Callback completeCallback = new Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callback(Pointer completionPointer, Pointer callbackContext) throws RadosException {
            Completion completion;
            int completionId = (int)Pointer.nativeValue((Pointer)callbackContext);
            Map map = completionMap;
            synchronized (map) {
                completion = (Completion)completionMap.get(completionId);
            }
            if (completion != null) {
                completion.complete = true;
                completion.onComplete();
            }
        }
    };
    private static Callback safeCallback = new Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callback(Pointer completionPointer, Pointer callbackContext) throws RadosException {
            Completion completion;
            int completionId = (int)Pointer.nativeValue((Pointer)callbackContext);
            Map map = completionMap;
            synchronized (map) {
                completion = (Completion)completionMap.get(completionId);
            }
            if (completion != null) {
                completion.safe = true;
                completion.onSafe();
            }
        }
    };
    private Pointer pointer;
    private int id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Completion(final boolean notifyOnComplete, final boolean notifyOnSafe) throws RadosException {
        final PointerByReference pointerByReference = new PointerByReference();
        Map<Integer, Completion> map = completionMap;
        synchronized (map) {
            this.id = nextCompletionId++;
            if (this.id <= 0) {
                this.id = 1;
                nextCompletionId = 2;
            }
            if (notifyOnComplete || notifyOnSafe) {
                completionMap.put(this.id, this);
            }
        }
        if (notifyOnComplete || notifyOnSafe) {
            this.handleReturnCode(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return Library.rados.rados_aio_create_completion(Pointer.createConstant((long)Completion.this.id), (Callback)(notifyOnComplete ? completeCallback : null), (Callback)(notifyOnSafe ? safeCallback : null), pointerByReference);
                }
            }, "Failed to create completion with callbacks", new Object[0]);
        } else {
            this.handleReturnCode(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return Library.rados.rados_aio_create_completion(null, null, null, pointerByReference);
                }
            }, "Failed to create completion", new Object[0]);
        }
        this.pointer = pointerByReference.getValue();
    }

    public void waitForComplete() throws RadosException {
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_aio_wait_for_complete(Completion.this.getPointer());
            }
        }, "Failed to wait for AIO completion", new Object[0]);
    }

    public void waitForSafe() throws RadosException {
        this.handleReturnCode(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Library.rados.rados_aio_wait_for_safe(Completion.this.getPointer());
            }
        }, "Failed to wait for AIO safe", new Object[0]);
    }

    public void onComplete() {
    }

    public void onSafe() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Library.rados.rados_aio_release(this.getPointer());
        if (this.id > 0) {
            Map<Integer, Completion> map = completionMap;
            synchronized (map) {
                completionMap.remove(this.id);
            }
            this.id = 0;
        }
    }

    public int getId() {
        return this.id;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public Pointer getPointer() {
        return this.pointer;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!(that instanceof Completion)) {
            return false;
        }
        return this.id == ((Completion)that).id;
    }
}

