/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.remote.impl.model;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.neo4j.api.model.Neo4jPropertyContainer;
import com.buschmais.xo.neo4j.remote.impl.model.state.AbstractPropertyContainerState;
import java.util.Collections;
import java.util.Map;

public abstract class AbstractRemotePropertyContainer<S extends AbstractPropertyContainerState>
implements Neo4jPropertyContainer {
    private final S state;
    private final int hashCode;
    private long id;

    protected AbstractRemotePropertyContainer(long id, S state) {
        this.id = id;
        this.state = state;
        this.hashCode = super.hashCode();
    }

    public long getId() {
        return this.id;
    }

    public void updateId(Long id) {
        if (this.id >= 0L) {
            throw new XOException("Cannot update persistent id of " + this);
        }
        this.id = id;
    }

    public S getState() {
        return this.state;
    }

    public boolean hasProperty(String key) {
        return ((AbstractPropertyContainerState)this.state).getReadCache().containsKey(key);
    }

    public Object getProperty(String key) {
        return ((AbstractPropertyContainerState)this.state).getReadCache().get(key);
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(((AbstractPropertyContainerState)this.state).getReadCache());
    }

    public void setProperty(String key, Object value) {
        ((AbstractPropertyContainerState)this.state).getOrCreateWriteCache().put(key, value);
        ((AbstractPropertyContainerState)this.state).getReadCache().put(key, value);
    }

    public void removeProperty(String name) {
        this.setProperty(name, null);
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "{id=" + this.id + '}';
    }
}

