/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.remote.impl.datastore;

import com.buschmais.xo.spi.logging.LogLevel;

public class StatementConfig {
    private static final StatementConfig PROTOTYPE = new StatementConfig();
    private LogLevel logLevel = LogLevel.NONE;
    private boolean batchableDefault = true;

    public static final StatementConfigBuilder builder() {
        return PROTOTYPE.toBuilder();
    }

    public StatementConfigBuilder toBuilder() {
        return new StatementConfigBuilder().logLevel(this.logLevel).batchableDefault(this.batchableDefault);
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public boolean isBatchableDefault() {
        return this.batchableDefault;
    }

    private StatementConfig() {
    }

    private StatementConfig(LogLevel logLevel, boolean batchableDefault) {
        this.logLevel = logLevel;
        this.batchableDefault = batchableDefault;
    }

    public String toString() {
        return "StatementConfig(logLevel=" + this.getLogLevel() + ", batchableDefault=" + this.isBatchableDefault() + ")";
    }

    public static class StatementConfigBuilder {
        private LogLevel logLevel;
        private boolean batchableDefault;

        StatementConfigBuilder() {
        }

        public StatementConfigBuilder logLevel(LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public StatementConfigBuilder batchableDefault(boolean batchableDefault) {
            this.batchableDefault = batchableDefault;
            return this;
        }

        public StatementConfig build() {
            return new StatementConfig(this.logLevel, this.batchableDefault);
        }

        public String toString() {
            return "StatementConfig.StatementConfigBuilder(logLevel=" + this.logLevel + ", batchableDefault=" + this.batchableDefault + ")";
        }
    }
}

