/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.remote.impl.datastore;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.spi.datastore.DatastoreTransaction;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementRunner;
import org.neo4j.driver.v1.Transaction;

public class RemoteDatastoreTransaction
implements DatastoreTransaction {
    private Session session;
    private Transaction transaction = null;

    public RemoteDatastoreTransaction(Session session) {
        this.session = session;
    }

    public void begin() {
        if (this.transaction != null) {
            throw new XOException("There is already an existing transaction.");
        }
        this.transaction = this.session.beginTransaction();
    }

    public void commit() {
        this.assertTransaction();
        try {
            this.transaction.success();
        }
        finally {
            this.close();
        }
    }

    public void rollback() {
        this.assertTransaction();
        try {
            this.transaction.failure();
        }
        finally {
            this.close();
        }
    }

    private void close() {
        this.assertTransaction();
        this.transaction.close();
        this.transaction = null;
    }

    private void assertTransaction() {
        if (this.transaction == null) {
            throw new XOException("There is no existing transaction.");
        }
    }

    public boolean isActive() {
        return this.transaction != null && this.transaction.isOpen();
    }

    public StatementRunner getStatementRunner() {
        return this.transaction != null ? this.transaction : this.session;
    }
}

