/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.remote.impl.datastore;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.neo4j.remote.impl.model.AbstractRemotePropertyContainer;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteLabel;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteNode;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteRelationship;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteRelationshipType;
import com.buschmais.xo.neo4j.remote.impl.model.state.AbstractPropertyContainerState;
import com.buschmais.xo.neo4j.remote.impl.model.state.NodeState;
import com.buschmais.xo.neo4j.remote.impl.model.state.RelationshipState;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Relationship;

public class RemoteDatastoreSessionCache {
    private Cache<Long, RemoteNode> nodeCache = CacheBuilder.newBuilder().weakValues().build();
    private Cache<Long, RemoteRelationship> relationshipCache = CacheBuilder.newBuilder().weakValues().build();

    public RemoteRelationship getRelationship(Long id) {
        return (RemoteRelationship)this.relationshipCache.getIfPresent((Object)id);
    }

    public RemoteNode getNode(long id) {
        return this.getNode(id, new NodeState());
    }

    public RemoteNode getNode(long id, NodeState nodeState) {
        try {
            return (RemoteNode)this.nodeCache.get((Object)id, () -> new RemoteNode(id, nodeState));
        }
        catch (ExecutionException e) {
            throw new XOException("Cannot fetch node");
        }
    }

    public RemoteRelationship getRelationship(long id, RemoteNode source, RemoteRelationshipType type, RemoteNode target) {
        return this.getRelationship(id, source, type, target, new RelationshipState());
    }

    public RemoteRelationship getRelationship(long id, RemoteNode source, RemoteRelationshipType type, RemoteNode target, RelationshipState relationshipState) {
        try {
            RemoteRelationship remoteRelationship = (RemoteRelationship)this.relationshipCache.get((Object)id, () -> new RemoteRelationship(id, relationshipState, source, type, target));
            return remoteRelationship;
        }
        catch (ExecutionException e) {
            throw new XOException("Cannot fetch node");
        }
    }

    public RemoteNode getNode(Node node) {
        RemoteNode remoteNode = this.getNode(node.id());
        NodeState nodeState = (NodeState)remoteNode.getState();
        if (!nodeState.isLoaded()) {
            nodeState.load(node.asMap());
            HashSet<RemoteLabel> labels = new HashSet<RemoteLabel>();
            for (String label : node.labels()) {
                labels.add(new RemoteLabel(label));
            }
            nodeState.getLabels().load(labels);
        }
        return remoteNode;
    }

    public RemoteRelationship getRelationship(Node start, Relationship relationship, Node end) {
        RemoteNode startNode = this.getNode(start);
        RemoteNode endNode = this.getNode(end);
        RemoteRelationshipType type = new RemoteRelationshipType(relationship.type());
        return this.getRelationship(relationship, startNode, endNode, type);
    }

    public RemoteRelationship getRelationship(Relationship relationship) {
        RemoteNode startNode = this.getNode(relationship.startNodeId());
        RemoteNode endNode = this.getNode(relationship.endNodeId());
        RemoteRelationshipType type = new RemoteRelationshipType(relationship.type());
        return this.getRelationship(relationship, startNode, endNode, type);
    }

    private RemoteRelationship getRelationship(Relationship relationship, RemoteNode startNode, RemoteNode endNode, RemoteRelationshipType type) {
        RemoteRelationship remoteRelationship = this.getRelationship(relationship.id(), startNode, type, endNode);
        if (!((RelationshipState)remoteRelationship.getState()).isLoaded()) {
            ((RelationshipState)remoteRelationship.getState()).load(relationship.asMap());
        }
        return remoteRelationship;
    }

    public void update(long id, RemoteNode remoteNode) {
        this.update(id, remoteNode, this.nodeCache);
    }

    public void update(long id, RemoteRelationship remoteRelationship) {
        this.update(id, remoteRelationship, this.relationshipCache);
    }

    private <C extends AbstractRemotePropertyContainer<S>, S extends AbstractPropertyContainerState> void update(long id, C propertyContainer, Cache<Long, C> cache) {
        cache.invalidate((Object)propertyContainer.getId());
        propertyContainer.updateId(id);
        cache.put((Object)id, propertyContainer);
    }
}

