/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.remote.impl.datastore;

import com.buschmais.xo.api.ResultIterator;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.neo4j.remote.impl.datastore.AbstractRemoteDatastorePropertyManager;
import com.buschmais.xo.neo4j.remote.impl.datastore.RemoteDatastoreSessionCache;
import com.buschmais.xo.neo4j.remote.impl.datastore.StatementBatchBuilder;
import com.buschmais.xo.neo4j.remote.impl.datastore.StatementExecutor;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteDirection;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteLabel;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteNode;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteRelationship;
import com.buschmais.xo.neo4j.remote.impl.model.RemoteRelationshipType;
import com.buschmais.xo.neo4j.remote.impl.model.state.NodeState;
import com.buschmais.xo.neo4j.remote.impl.model.state.StateTracker;
import com.buschmais.xo.neo4j.spi.helper.MetadataHelper;
import com.buschmais.xo.neo4j.spi.metadata.NodeMetadata;
import com.buschmais.xo.neo4j.spi.metadata.PropertyMetadata;
import com.buschmais.xo.neo4j.spi.metadata.RelationshipMetadata;
import com.buschmais.xo.spi.datastore.DatastoreEntityManager;
import com.buschmais.xo.spi.datastore.TypeMetadataSet;
import com.buschmais.xo.spi.metadata.method.AbstractRelationPropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.MethodMetadata;
import com.buschmais.xo.spi.metadata.method.PrimitivePropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.type.EntityTypeMetadata;
import com.buschmais.xo.spi.metadata.type.RelationTypeMetadata;
import com.buschmais.xo.spi.metadata.type.TypeMetadata;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.types.Node;

public class RemoteDatastoreEntityManager
extends AbstractRemoteDatastorePropertyManager<RemoteNode, NodeState>
implements DatastoreEntityManager<Long, RemoteNode, NodeMetadata<RemoteLabel>, RemoteLabel, PropertyMetadata> {
    private long idSequence = -1L;

    public RemoteDatastoreEntityManager(StatementExecutor statementExecutor, RemoteDatastoreSessionCache datastoreSessionCache) {
        super(statementExecutor, datastoreSessionCache);
    }

    public boolean isEntity(Object o) {
        return RemoteNode.class.isAssignableFrom(o.getClass());
    }

    public Set<RemoteLabel> getEntityDiscriminators(RemoteNode remoteNode) {
        this.ensureLoaded(remoteNode);
        return ((NodeState)remoteNode.getState()).getLabels().getElements();
    }

    public Long getEntityId(RemoteNode remoteNode) {
        return remoteNode.getId();
    }

    public RemoteNode createEntity(TypeMetadataSet<EntityTypeMetadata<NodeMetadata<RemoteLabel>>> types, Set<RemoteLabel> remoteLabels, Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> exampleEntity) {
        RemoteNode remoteNode;
        Map<String, Object> properties = this.getProperties(exampleEntity);
        NodeState nodeState = new NodeState(remoteLabels, properties);
        this.initializeEntity((Collection<? extends TypeMetadata>)types, nodeState);
        if (this.isBatchable(types)) {
            long id = this.idSequence--;
            remoteNode = this.datastoreSessionCache.getNode(id, nodeState);
        } else {
            Record record;
            String statement;
            StringBuilder labels = this.getLabelExpression(remoteLabels);
            if (properties.isEmpty()) {
                statement = "CREATE (n" + labels.toString() + ") RETURN id(n) as id";
                record = this.statementExecutor.getSingleResult(statement, Collections.emptyMap());
            } else {
                statement = "CREATE (n" + labels.toString() + "{n}) RETURN id(n) as id";
                record = this.statementExecutor.getSingleResult(statement, Values.parameters((Object[])new Object[]{"n", properties}));
            }
            long id = record.get("id").asLong();
            remoteNode = this.datastoreSessionCache.getNode(id, nodeState);
        }
        return remoteNode;
    }

    private boolean isBatchable(TypeMetadataSet<EntityTypeMetadata<NodeMetadata<RemoteLabel>>> types) {
        for (EntityTypeMetadata type : types) {
            if (!((NodeMetadata)type.getDatastoreMetadata()).isBatchable()) continue;
            return true;
        }
        return false;
    }

    private void initializeEntity(Collection<? extends TypeMetadata> types, NodeState nodeState) {
        for (TypeMetadata typeMetadata : types) {
            Collection superTypes = typeMetadata.getSuperTypes();
            this.initializeEntity(superTypes, nodeState);
            for (MethodMetadata methodMetadata : typeMetadata.getProperties()) {
                RemoteDirection remoteDirection;
                if (!(methodMetadata instanceof AbstractRelationPropertyMethodMetadata)) continue;
                AbstractRelationPropertyMethodMetadata relationPropertyMethodMetadata = (AbstractRelationPropertyMethodMetadata)methodMetadata;
                RelationTypeMetadata relationshipMetadata = relationPropertyMethodMetadata.getRelationshipMetadata();
                RemoteRelationshipType relationshipType = (RemoteRelationshipType)((RelationshipMetadata)relationshipMetadata.getDatastoreMetadata()).getDiscriminator();
                RelationTypeMetadata.Direction direction = relationPropertyMethodMetadata.getDirection();
                switch (direction) {
                    case FROM: {
                        remoteDirection = RemoteDirection.OUTGOING;
                        break;
                    }
                    case TO: {
                        remoteDirection = RemoteDirection.INCOMING;
                        break;
                    }
                    default: {
                        throw new XOException("Unsupported direction: " + direction);
                    }
                }
                if (nodeState.getRelationships(remoteDirection, relationshipType) != null) continue;
                nodeState.setRelationships(remoteDirection, relationshipType, new StateTracker<RemoteRelationship, Set<RemoteRelationship>>(new LinkedHashSet()));
            }
        }
    }

    public void deleteEntity(RemoteNode remoteNode) {
        try (StatementBatchBuilder batchBuilder = new StatementBatchBuilder(this.statementExecutor);){
            for (StateTracker<RemoteRelationship, Set<RemoteRelationship>> tracker : ((NodeState)remoteNode.getState()).getOutgoingRelationships().values()) {
                this.flushRemovedRelationships(batchBuilder, tracker.getRemoved());
            }
            String statement = "MATCH (n) WHERE id(n)=entry['n'] DELETE n RETURN collect(id(n))";
            batchBuilder.add(statement, Values.parameters((Object[])new Object[]{"n", remoteNode.getId()}));
        }
    }

    public RemoteNode findEntityById(EntityTypeMetadata<NodeMetadata<RemoteLabel>> metadata, RemoteLabel remoteLabel, Long id) {
        Node node = this.fetch(id);
        return this.datastoreSessionCache.getNode(node);
    }

    public ResultIterator<RemoteNode> findEntity(EntityTypeMetadata<NodeMetadata<RemoteLabel>> type, RemoteLabel remoteLabel, Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> values) {
        if (values.size() > 1) {
            throw new XOException("Only one property value is supported for find operation");
        }
        Map.Entry<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> entry = values.entrySet().iterator().next();
        PropertyMetadata propertyMetadata = MetadataHelper.getIndexedPropertyMetadata(type, entry.getKey());
        Object value = entry.getValue();
        String statement = String.format("MATCH (n:%s) WHERE n.%s={v} RETURN n", remoteLabel.getName(), propertyMetadata.getName());
        final StatementResult result = this.statementExecutor.execute(statement, Values.parameters((Object[])new Object[]{"v", value}));
        return new ResultIterator<RemoteNode>(){

            public boolean hasNext() {
                return result.hasNext();
            }

            public RemoteNode next() {
                Record record = result.next();
                Node node = record.get("n").asNode();
                return RemoteDatastoreEntityManager.this.datastoreSessionCache.getNode(node);
            }

            public void close() {
                result.consume();
            }
        };
    }

    public void addDiscriminators(TypeMetadataSet<EntityTypeMetadata<NodeMetadata<RemoteLabel>>> types, RemoteNode remoteNode, Set<RemoteLabel> remoteLabels) {
        NodeState state = (NodeState)remoteNode.getState();
        state.getLabels().addAll(remoteLabels);
        this.initializeEntity((Collection<? extends TypeMetadata>)types, state);
    }

    public void removeDiscriminators(TypeMetadataSet<EntityTypeMetadata<NodeMetadata<RemoteLabel>>> removedTypes, RemoteNode remoteNode, Set<RemoteLabel> remoteLabels) {
        ((NodeState)remoteNode.getState()).getLabels().removeAll(remoteLabels);
    }

    protected Node load(RemoteNode remoteNode) {
        return this.fetch(remoteNode.getId());
    }

    private Node fetch(Long id) {
        Record record = this.statementExecutor.getSingleResult("MATCH (n) WHERE id(n)={id} RETURN n", Values.parameters((Object[])new Object[]{"id", id}));
        return record.get("n").asNode();
    }

    private StringBuilder getLabelExpression(Set<RemoteLabel> remoteLabels) {
        StringBuilder labels = new StringBuilder();
        for (RemoteLabel remoteLabel : remoteLabels) {
            labels.append(':').append(remoteLabel.getName());
        }
        return labels;
    }

    public void flush(Iterable<RemoteNode> entities) {
        try (StatementBatchBuilder batchBuilder = new StatementBatchBuilder(this.statementExecutor);){
            for (RemoteNode entity : entities) {
                if (entity.getId() < 0L) {
                    this.flushAddedEntity(batchBuilder, entity);
                    continue;
                }
                this.flush(batchBuilder, entity, "(n)", "n");
                this.flushLabels(batchBuilder, entity);
            }
        }
        batchBuilder = new StatementBatchBuilder(this.statementExecutor);
        var3_3 = null;
        try {
            for (RemoteNode entity : entities) {
                for (StateTracker<RemoteRelationship, Set<RemoteRelationship>> tracker : ((NodeState)entity.getState()).getOutgoingRelationships().values()) {
                    this.flushAddedRelationships(batchBuilder, tracker.getAdded());
                    this.flushRemovedRelationships(batchBuilder, tracker.getRemoved());
                }
                ((NodeState)entity.getState()).flush();
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (batchBuilder != null) {
                if (var3_3 != null) {
                    try {
                        batchBuilder.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    batchBuilder.close();
                }
            }
        }
    }

    private void flushAddedEntity(StatementBatchBuilder batchBuilder, RemoteNode entity) {
        Map<String, Object> properties = entity.getProperties();
        StringBuilder labelExpression = this.getLabelExpression((Set<RemoteLabel>)entity.getLabels());
        String statement = "CREATE (n" + labelExpression.toString() + ") SET n=entry['n'] RETURN collect({oldId:entry['id'], newId:id(n)}) as nodes";
        batchBuilder.add(statement, Values.parameters((Object[])new Object[]{"id", entity.getId(), "n", properties}), result -> {
            List nodes = result.get("nodes").asList();
            for (Object node : nodes) {
                Map r = (Map)node;
                Long oldId = (Long)r.get("oldId");
                Long newId = (Long)r.get("newId");
                RemoteNode oldNode = this.datastoreSessionCache.getNode(oldId);
                this.datastoreSessionCache.update((long)newId, oldNode);
            }
        });
    }

    private void flushLabels(StatementBatchBuilder batchBuilder, RemoteNode node) {
        Set<RemoteLabel> removed;
        StateTracker<RemoteLabel, Set<RemoteLabel>> labels = ((NodeState)node.getState()).getLabels();
        Set<RemoteLabel> added = labels.getAdded();
        if (!added.isEmpty()) {
            StringBuilder addedLabelsExpression = this.getLabelExpression(added);
            String statement = "MATCH (n) WHERE id(n)=entry['n'] SET n" + addedLabelsExpression + " RETURN collect(id(n))";
            batchBuilder.add(statement, Values.parameters((Object[])new Object[]{"n", node.getId()}));
        }
        if (!(removed = labels.getRemoved()).isEmpty()) {
            StringBuilder removedLabelsExpression = this.getLabelExpression(removed);
            String statement = "MATCH (n) WHERE id(n)=entry['n'] REMOVE n" + removedLabelsExpression + " RETURN collect(id(n))";
            batchBuilder.add(statement, Values.parameters((Object[])new Object[]{"n", node.getId()}));
        }
    }

    private void flushAddedRelationships(StatementBatchBuilder batchBuilder, Set<RemoteRelationship> addedRelationships) {
        for (RemoteRelationship addedRelationship : addedRelationships) {
            String statement = "MATCH (start),(end) WHERE id(start)=entry['start'] AND id(end)=entry['end'] CREATE (start)-[r:" + addedRelationship.getType().getName() + "]->(end) SET r=entry['r'] RETURN collect({oldId:entry['id'], newId:id(r)}) as relations";
            batchBuilder.add(statement, Values.parameters((Object[])new Object[]{"start", addedRelationship.getStartNode().getId(), "id", addedRelationship.getId(), "r", addedRelationship.getProperties(), "end", addedRelationship.getEndNode().getId()}), result -> {
                List relations = result.get("relations").asList();
                for (Object relation : relations) {
                    Map r = (Map)relation;
                    Long oldId = (Long)r.get("oldId");
                    Long newId = (Long)r.get("newId");
                    RemoteRelationship oldRelationship = this.datastoreSessionCache.getRelationship(oldId);
                    this.datastoreSessionCache.update((long)newId, oldRelationship);
                }
            });
        }
    }

    private void flushRemovedRelationships(StatementBatchBuilder batchBuilder, Set<RemoteRelationship> removedRelationships) {
        for (RemoteRelationship removedRelationship : removedRelationships) {
            String statement;
            if (removedRelationship.getId() < 0L) {
                statement = "MATCH (start)-[r:" + removedRelationship.getType().getName() + "]->(end) WHERE id(start)=entry['start'] AND id(end)=entry['end'] DELETE r RETURN collect(id(r))";
                batchBuilder.add(statement, Values.parameters((Object[])new Object[]{"start", removedRelationship.getStartNode().getId(), "end", removedRelationship.getEndNode().getId()}));
                continue;
            }
            statement = "MATCH ()-[r]->() WHERE id(r)=entry['r'] DELETE r RETURN collect(id(r))";
            batchBuilder.add(statement, Values.parameters((Object[])new Object[]{"r", removedRelationship.getId()}));
        }
    }
}

