/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.model.ZipArchiveDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractContainerScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.AbstractDirectoryResource;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.AbstractFileResource;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.Resource;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.ZipFileResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;

public class ZipFileScannerPlugin
extends AbstractContainerScannerPlugin<ZipFileResource, ZipArchiveEntry, ZipArchiveDescriptor> {
    @Override
    public Class<? extends ZipFileResource> getType() {
        return ZipFileResource.class;
    }

    @Override
    public Class<ZipArchiveDescriptor> getDescriptorType() {
        return ZipArchiveDescriptor.class;
    }

    public boolean accepts(ZipFileResource item, String path, Scope scope) throws IOException {
        return true;
    }

    @Override
    protected ZipArchiveDescriptor getContainerDescriptor(ZipFileResource zipFile, ScannerContext scannerContext) {
        return (ZipArchiveDescriptor)scannerContext.peek(ZipArchiveDescriptor.class);
    }

    @Override
    protected Iterable<? extends ZipArchiveEntry> getEntries(ZipFileResource container) throws IOException {
        Enumeration entries = container.getZipFile().getEntriesInPhysicalOrder();
        return new ZipArchiveEntryIterable(entries);
    }

    @Override
    protected String getContainerPath(ZipFileResource container, String path) {
        return path;
    }

    @Override
    protected String getRelativePath(ZipFileResource container, ZipArchiveEntry entry) {
        String name = entry.getName();
        if (entry.isDirectory()) {
            return "/" + name.substring(0, name.length() - 1);
        }
        return "/" + name;
    }

    @Override
    protected void enterContainer(ZipFileResource zipFile, ZipArchiveDescriptor archiveDescriptor, ScannerContext context) throws IOException {
    }

    @Override
    protected void leaveContainer(ZipFileResource zipFile, ZipArchiveDescriptor archiveDescriptor, ScannerContext scannerContext) throws IOException {
        zipFile.close();
    }

    @Override
    protected Resource getEntry(ZipFileResource container, ZipArchiveEntry entry) {
        if (entry.isDirectory()) {
            return new AbstractDirectoryResource(entry.getName()){};
        }
        return new ZipArchiveEntryResource(container, entry);
    }

    private static class ZipArchiveEntryIterable
    implements Iterable<ZipArchiveEntry> {
        private final Enumeration<? extends ZipArchiveEntry> entries;

        public ZipArchiveEntryIterable(Enumeration<? extends ZipArchiveEntry> entries) {
            this.entries = entries;
        }

        @Override
        public Iterator<ZipArchiveEntry> iterator() {
            return new Iterator<ZipArchiveEntry>(){

                @Override
                public boolean hasNext() {
                    return entries.hasMoreElements();
                }

                @Override
                public ZipArchiveEntry next() {
                    return (ZipArchiveEntry)entries.nextElement();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }
    }

    private static class ZipArchiveEntryResource
    extends AbstractFileResource {
        private final ZipFileResource container;
        private final ZipArchiveEntry entry;

        public ZipArchiveEntryResource(ZipFileResource container, ZipArchiveEntry entry) {
            this.container = container;
            this.entry = entry;
        }

        @Override
        public InputStream createStream() throws IOException {
            return this.container.getZipFile().getInputStream(this.entry);
        }

        public String toString() {
            String containerPath = this.container.getPath();
            String inContainerPath = this.entry.getName();
            return String.format("%s!%s", containerPath, inContainerPath);
        }
    }
}

