/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.scanner.filesystem;

import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public abstract class AbstractFileResource
implements FileResource {
    public static final String TMP_FILE_PREFIX = "jqassistant-";
    public static final String TMP_FILE_SUFFIX = ".tmp";
    private File file = null;

    @Override
    public File getFile() throws IOException {
        if (this.file == null) {
            this.file = File.createTempFile(TMP_FILE_PREFIX, TMP_FILE_SUFFIX);
            try (InputStream input = this.createStream();
                 BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.file));){
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
        }
        return this.file;
    }

    @Override
    public void close() {
        if (this.file != null) {
            this.file.delete();
        }
    }
}

