/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.FileResolver;
import java.util.function.Function;

public abstract class AbstractFileResolver
implements FileResolver {
    private final String cacheKey;

    protected AbstractFileResolver(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    @Override
    public <D extends FileDescriptor> D require(String requiredPath, Class<D> type, ScannerContext context) {
        return this.require(requiredPath, requiredPath, type, context);
    }

    @Deprecated
    protected <D extends FileDescriptor> D toFileDescriptor(Descriptor descriptor, Class<D> type, String path, ScannerContext context) {
        if (descriptor == null) {
            FileDescriptor result = (FileDescriptor)context.getStore().create(type);
            result.setFileName(path);
            return (D)result;
        }
        return this.migrateOrCast(descriptor, type, context);
    }

    protected <D extends FileDescriptor> D getOrCreateAs(String path, Class<D> type, Function<String, FileDescriptor> resolveExisting, ScannerContext context) {
        FileDescriptor descriptor = (FileDescriptor)context.getStore().getCache(this.cacheKey).get((Object)path, p -> {
            FileDescriptor fileDescriptor = (FileDescriptor)resolveExisting.apply((String)p);
            if (fileDescriptor != null) {
                return fileDescriptor;
            }
            fileDescriptor = (FileDescriptor)context.getStore().create(type);
            fileDescriptor.setFileName(path);
            return fileDescriptor;
        });
        return this.migrateOrCast(descriptor, type, context);
    }

    private <D extends FileDescriptor> D migrateOrCast(Descriptor descriptor, Class<D> type, ScannerContext context) {
        return (D)(type.isAssignableFrom(descriptor.getClass()) ? (FileDescriptor)type.cast(descriptor) : (FileDescriptor)context.getStore().addDescriptorType(descriptor, type));
    }
}

