/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport.plantuml.component;

import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.graph.SubGraphFactory;
import com.buschmais.jqassistant.core.report.api.graph.model.Node;
import com.buschmais.jqassistant.core.report.api.graph.model.Relationship;
import com.buschmais.jqassistant.core.report.api.graph.model.SubGraph;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.plugin.asciidocreport.plantuml.AbstractDiagramRenderer;
import com.buschmais.jqassistant.plugin.asciidocreport.plantuml.RenderMode;
import com.google.common.base.CaseFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ComponentDiagramRenderer
extends AbstractDiagramRenderer {
    private final SubGraphFactory subGraphFactory;

    public ComponentDiagramRenderer(SubGraphFactory subGraphFactory, RenderMode renderMode) {
        super(renderMode);
        this.subGraphFactory = subGraphFactory;
    }

    @Override
    protected void render(Result<? extends ExecutableRule> result, StringBuilder builder) throws ReportException {
        SubGraph subGraph = this.subGraphFactory.createSubGraph(result);
        Map<Long, Node> nodes = this.renderRootNodes(subGraph, builder, 0);
        builder.append('\n');
        this.renderRelationships(subGraph, builder, nodes);
    }

    private Map<Long, Node> renderRootNodes(SubGraph graph, StringBuilder builder, int level) {
        LinkedHashMap<Long, Node> nodes = new LinkedHashMap<Long, Node>();
        Node parentNode = graph.getParent();
        if (parentNode != null) {
            nodes.put(parentNode.getId(), parentNode);
            builder.append(this.indent(level)).append("folder ").append('\"').append(parentNode.getLabel()).append('\"').append(" {\n");
            nodes.putAll(this.renderNodes(graph, builder, level + 1));
            nodes.putAll(this.renderSubGraphs(graph, builder, level + 1));
            builder.append(this.indent(level)).append("}\n");
        } else {
            nodes.putAll(this.renderNodes(graph, builder, level));
            nodes.putAll(this.renderSubGraphs(graph, builder, level));
        }
        return nodes;
    }

    private Map<Long, Node> renderNodes(SubGraph graph, StringBuilder builder, int level) {
        LinkedHashMap<Long, Node> nodes = new LinkedHashMap<Long, Node>();
        for (Node node : graph.getNodes().values()) {
            if (node.equals((Object)graph.getParent())) continue;
            nodes.put(node.getId(), node);
            builder.append(this.indent(level + 1)).append('[').append(node.getLabel()).append("] ");
            Set labels = node.getLabels();
            if (!labels.isEmpty()) {
                builder.append("<<");
                builder.append(StringUtils.join((Iterable)labels, (String)" "));
                builder.append(">>");
            }
            builder.append(" as ").append(this.getNodeId(node)).append('\n');
        }
        return nodes;
    }

    private Map<Long, Node> renderSubGraphs(SubGraph graph, StringBuilder builder, int level) {
        LinkedHashMap<Long, Node> nodes = new LinkedHashMap<Long, Node>();
        for (SubGraph subgraph : graph.getSubGraphs().values()) {
            nodes.putAll(this.renderRootNodes(subgraph, builder, level + 1));
        }
        return nodes;
    }

    private void renderRelationships(SubGraph subGraph, StringBuilder builder, Map<Long, Node> nodes) {
        Map<Long, Relationship> relationships = this.getRelationships(subGraph, nodes);
        for (Relationship relationship : relationships.values()) {
            Node startNode = relationship.getStartNode();
            Node endNode = relationship.getEndNode();
            String type = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, relationship.getType()).replace('_', ' ');
            builder.append(this.getNodeId(startNode)).append(" --> ").append(this.getNodeId(endNode)).append(" : ").append(type);
            if (StringUtils.isNotEmpty((CharSequence)relationship.getLabel())) {
                builder.append(" (").append(relationship.getLabel()).append(")");
            }
            builder.append('\n');
        }
        builder.append('\n');
    }
}

