/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport.plantuml.clazz;

import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.graph.SubGraphFactory;
import com.buschmais.jqassistant.core.report.api.graph.model.Identifiable;
import com.buschmais.jqassistant.core.report.api.graph.model.Node;
import com.buschmais.jqassistant.core.report.api.graph.model.Relationship;
import com.buschmais.jqassistant.core.report.api.model.Result;
import com.buschmais.jqassistant.core.rule.api.model.ExecutableRule;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.asciidocreport.plantuml.clazz.ClassDiagramResult;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.AccessModifierDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MemberDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.PackageMemberDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClassDiagramResultConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassDiagramResultConverter.class);
    private final SubGraphFactory subGraphFactory;

    ClassDiagramResultConverter(SubGraphFactory subGraphFactory) {
        this.subGraphFactory = subGraphFactory;
    }

    public ClassDiagramResult convert(Result<? extends ExecutableRule> result) throws ReportException {
        LinkedHashMap<PackageMemberDescriptor, Node> packageMembers = new LinkedHashMap<PackageMemberDescriptor, Node>();
        LinkedHashMap<MemberDescriptor, Node> typeMembers = new LinkedHashMap<MemberDescriptor, Node>();
        LinkedHashSet<Relationship> relations = new LinkedHashSet<Relationship>();
        List rows = result.getRows();
        for (Map row : rows) {
            for (Object value : row.values()) {
                this.convertValue(value, packageMembers, typeMembers, relations);
            }
        }
        Map<PackageMemberDescriptor, Set<PackageMemberDescriptor>> children = this.getPackageMemberTree(packageMembers);
        Map<TypeDescriptor, Set<MemberDescriptor>> membersPerType = this.aggregateMembersPerType(packageMembers.keySet(), typeMembers.keySet());
        return ClassDiagramResult.builder().packageMembers(packageMembers).packageMemberTree(children).membersPerType(membersPerType).relations(relations).build();
    }

    private void convertValue(Object value, Map<PackageMemberDescriptor, Node> packageMembers, Map<MemberDescriptor, Node> typeMembers, Set<Relationship> relations) throws ReportException {
        if (value instanceof Iterable) {
            for (Object element : (Iterable)value) {
                this.convertValue(element, packageMembers, typeMembers, relations);
            }
        } else {
            Identifiable identifiable = this.subGraphFactory.toIdentifiable(value);
            if (identifiable instanceof Node) {
                Node node = (Node)identifiable;
                if (value instanceof PackageMemberDescriptor) {
                    this.addMember(value, node, packageMembers);
                } else if (value instanceof MemberDescriptor) {
                    this.addMember(value, node, typeMembers);
                }
            } else if (identifiable instanceof Relationship) {
                Relationship relationship = (Relationship)identifiable;
                relations.add(relationship);
            }
        }
    }

    private Map<PackageMemberDescriptor, Set<PackageMemberDescriptor>> getPackageMemberTree(Map<PackageMemberDescriptor, Node> packageMembers) {
        LinkedHashMap<PackageMemberDescriptor, Set<PackageMemberDescriptor>> children = new LinkedHashMap<PackageMemberDescriptor, Set<PackageMemberDescriptor>>();
        for (Map.Entry<PackageMemberDescriptor, Node> entry : packageMembers.entrySet()) {
            PackageMemberDescriptor packageMember = entry.getKey();
            PackageMemberDescriptor enclosingParent = this.getEnclosingParent(packageMember, packageMembers.keySet());
            children.computeIfAbsent(enclosingParent, key -> new LinkedHashSet()).add(packageMember);
        }
        return children;
    }

    private PackageMemberDescriptor getEnclosingParent(PackageMemberDescriptor packageMember, Set<PackageMemberDescriptor> packageMembers) {
        if (packageMember instanceof FileDescriptor) {
            FileDescriptor current = (FileDescriptor)packageMember;
            do {
                Optional<FileDescriptor> parent;
                FileDescriptor fileDescriptor = current = (parent = current.getParents().stream().filter(p -> p instanceof PackageMemberDescriptor).findFirst()).isPresent() ? parent.get() : null;
            } while (current != null && !packageMembers.contains(current));
            return (PackageMemberDescriptor)current;
        }
        return null;
    }

    private <D extends Descriptor> void addMember(Object member, Node node, Map<D, Node> memberNodes) {
        if (!this.isSynthetic(member)) {
            memberNodes.put((Descriptor)member, node);
        }
    }

    private boolean isSynthetic(Object value) {
        if (value instanceof AccessModifierDescriptor) {
            AccessModifierDescriptor accessModifier = (AccessModifierDescriptor)value;
            return accessModifier.isSynthetic() != null && accessModifier.isSynthetic() != false;
        }
        return false;
    }

    private Map<TypeDescriptor, Set<MemberDescriptor>> aggregateMembersPerType(Set<PackageMemberDescriptor> packageMembers, Set<MemberDescriptor> members) {
        LinkedHashMap<TypeDescriptor, Set<MemberDescriptor>> membersPerType = new LinkedHashMap<TypeDescriptor, Set<MemberDescriptor>>();
        for (MemberDescriptor member : members) {
            TypeDescriptor declaringType = member.getDeclaringType();
            if (packageMembers.contains(declaringType)) {
                membersPerType.computeIfAbsent(declaringType, key -> new LinkedHashSet()).add(member);
                continue;
            }
            LOGGER.debug("Result contains '{}' but not the declaring type '{}', skipping.", (Object)member.getSignature(), (Object)declaringType.getFullQualifiedName());
        }
        return membersPerType;
    }
}

