/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.asciidocreport.plantuml;

import com.buschmais.jqassistant.core.report.api.ReportException;
import java.util.ArrayList;
import java.util.Arrays;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RenderMode {
    GRAPHVIZ(""),
    JDOT("!pragma graphviz_dot jdot\n");

    private static final Logger log;
    private String pragma;

    private RenderMode(String pragma) {
        this.pragma = pragma;
    }

    public String getPragma() {
        return this.pragma;
    }

    public static RenderMode getRenderMode(String value) throws ReportException {
        boolean graphvizAvailable = RenderMode.verifyGraphviz();
        if (value != null) {
            RenderMode renderMode = RenderMode.fromString(value);
            if (GRAPHVIZ == renderMode && !graphvizAvailable) {
                throw new ReportException("GraphViz is requested but installation could not be validated.");
            }
            return renderMode;
        }
        return graphvizAvailable ? GRAPHVIZ : JDOT;
    }

    private static RenderMode fromString(String renderMode) throws ReportException {
        for (RenderMode mode : RenderMode.values()) {
            if (!mode.name().equalsIgnoreCase(renderMode)) continue;
            return mode;
        }
        throw new ReportException(renderMode + " is not a valid, supported modes are " + Arrays.asList(RenderMode.values()));
    }

    private static boolean verifyGraphviz() {
        ArrayList results = new ArrayList();
        if (GraphvizUtils.addDotStatus(results, (boolean)false) != 0) {
            for (String result : results) {
                log.info(result);
            }
            return false;
        }
        return true;
    }

    static {
        log = LoggerFactory.getLogger(RenderMode.class);
    }
}

